/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client.itask;

import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.TaskManagerFactory;
import com.kingdee.eas.fi.gr.rptintegration.TaskManagerInfo;
import com.kingdee.eas.fi.gr.rptintegration.TaskState;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.TaskManager;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.TriggerBatchDownLoadPush;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SynCustomTask
extends TaskManager {
    TaskManagerInfo task;
    String[] ctxString;
    WebServiceClient webServiceClient;
    WebServiceInfo xbangServiceInfo;
    List<WebServiceInfo> webServiceList;

    public SynCustomTask(String string, CoreBaseInfo info, Component cc) throws Exception {
        this.task = (TaskManagerInfo)info;
        this.ctxString = string.split(CoreUtils.splitStr);
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(null);
        if (datacenterInfo == null) {
            MsgBox.warn(null, (String)CoreUtils.getResourceStr(null, "NotCurrentDataCenter"), (Component)cc);
            SysUtil.abort();
        }
        this.webServiceList = DataCenterUtil.getWebserviceList(null, "parent.id='" + datacenterInfo.getId().toString() + "'");
        if (this.webServiceList == null || this.webServiceList.size() <= 0) {
            MsgBox.warn(null, (String)CoreUtils.getResourceStr(null, "notSubDataCenter"), (Component)cc);
            SysUtil.abort();
        }
    }

    @Override
    public ResultInfo executeTask(int step) throws Exception {
        if (this.webServiceClient == null) {
            this.webServiceClient = WebServiceClient.getInstance();
        }
        if (step == this.getTaskStepCount() - 1) {
            this.task.setTaskState(TaskState.execSuccess);
            TaskManagerFactory.getRemoteInstance().save((CoreBaseInfo)this.task);
            TaskManagerFactory.getRemoteInstance().dispenseDataBaseLog(this.task);
            return null;
        }
        int mod = step % (this.ctxString.length + 1);
        int count = step / (this.ctxString.length + 1);
        if (mod == 0) {
            this.xbangServiceInfo = this.webServiceList.get(count);
            boolean islogin = this.webServiceClient.login(this.xbangServiceInfo);
            if (!islogin) {
                throw new NullPointerException(CoreUtils.getResourceStr(null, "DataCenter") + "[" + this.xbangServiceInfo.getDataCenterName() + "]" + CoreUtils.getResourceStr(null, "ConnectFail"));
            }
            return null;
        }
        count = mod;
        if (count > 0) {
            --count;
        }
        ArrayList<String> synTypeList = new ArrayList<String>();
        if ("orgunit".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getFullOrgUnitInfo);
            synTypeList.add(SynchronizeType.oUPartUnionGroup);
        } else if ("orgtree".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getOrgTreeTask);
        } else if ("currency".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.synCurrency);
        } else if ("asstactType".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.asstacttype);
            synTypeList.add(SynchronizeType.generalasstacttypegroup);
        } else if ("dataelement".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getDataElementTask);
        } else if ("reportclass".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getReportClassTask);
        } else if ("rptitem".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getRptItems);
            synTypeList.add(SynchronizeType.itemRelationShip);
            synTypeList.add(SynchronizeType.itemRelationShipEntry);
        } else if ("elimType".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.synElimType);
        } else if ("adjustmode".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getAdjustModes);
        } else if ("adjusttemplet".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getAdjustTemplets);
            synTypeList.add(SynchronizeType.getAdjustTempletEntrys);
            synTypeList.add(SynchronizeType.AdjustDispense);
        } else if ("elimtempletgroup".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getElimTempletGroup);
            synTypeList.add(SynchronizeType.elimGroupDispense);
        } else if ("elimtemplet".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getElimTemplets);
            synTypeList.add(SynchronizeType.getElimTempletEntrys);
            synTypeList.add(SynchronizeType.getInvestTemplets);
            synTypeList.add(SynchronizeType.getInvestTempletEntrys);
            synTypeList.add(SynchronizeType.elimDispense);
            synTypeList.add(SynchronizeType.getElimItemMap);
        } else if ("rptitemcheckformula".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getCheckFormulas);
            synTypeList.add(SynchronizeType.checkFormulaItems);
        } else if ("rptitemfenpei".equals(this.ctxString[count])) {
            synTypeList.add(SynchronizeType.getFormulaDispenses);
        }
        if (!synTypeList.isEmpty()) {
            SynchronizeHandle triggerDownLoadObj = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerBatchDownLoadPush);
            this.result = ((TriggerBatchDownLoadPush)triggerDownLoadObj).triggerDownLoadHandle(null, synTypeList, this.webServiceClient, this.xbangServiceInfo);
        }
        return this.result;
    }

    @Override
    public String getSubTaskTitle(int step) {
        if (step == this.getTaskStepCount() - 1) {
            return CoreUtils.getResourceStr(null, "taskEnd");
        }
        int mod = step % (this.ctxString.length + 1);
        int count = step / (this.ctxString.length + 1);
        if (mod == 0) {
            return CoreUtils.getResourceStr(null, "ConnectDataCenter") + "[" + this.webServiceList.get(count).getDataCenterName() + "]...";
        }
        if (mod > 0) {
            --mod;
        }
        if ("orgunit".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynOrgUnit");
        }
        if ("orgtree".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynOrgTree");
        }
        if ("asstactType".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynAsstType");
        }
        if ("currency".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynCurrency");
        }
        if ("elimType".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "synElimType");
        }
        if ("dataelement".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynDataElement");
        }
        if ("reportclass".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynRptClass");
        }
        if ("adjustmode".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynAdjustMode");
        }
        if ("rptitem".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynRptItem");
        }
        if ("elimtempletgroup".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynElimTempletGroup");
        }
        if ("elimtemplet".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynElimTemplet");
        }
        if ("adjusttemplet".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynAdjustTemplet");
        }
        if ("rptitemcheckformula".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynArticulation");
        }
        if ("rptitemfenpei".equals(this.ctxString[mod])) {
            return "   " + CoreUtils.getResourceStr(null, "SynArticulationDisp");
        }
        return null;
    }

    @Override
    public String getTaskContextString() {
        return null;
    }

    @Override
    public String getTaskName() {
        return CoreUtils.getResourceStr(null, "SynCslRptBaseData");
    }

    @Override
    public String getTaskNumber() {
        return null;
    }

    @Override
    public int getTaskStepCount() {
        return this.ctxString.length * this.webServiceList.size() + this.webServiceList.size() + 1;
    }
}

