/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client.itask;

import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterFactory;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.TaskManager;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SynDataCenterTask
extends TaskManager {
    private List<String> taskName = new ArrayList<String>();
    private List taskHandType = new ArrayList();
    private WebServiceClient webServiceClient;
    private WebServiceInfo xbangServiceInfo;

    public SynDataCenterTask(Component cc) throws Exception {
        List<WebServiceInfo> webServices = DataCenterUtil.getAllChildWebServiceList(null);
        if (webServices != null && webServices.size() > 0) {
            for (WebServiceInfo webService : webServices) {
                this.taskName.add(CoreUtils.getResourceStr(null, "ConnectDataCenter") + "[" + webService.getDataCenterName() + "]");
                this.taskHandType.add(webService);
                this.taskName.add("  " + CoreUtils.getResourceStr(null, "SynDataCenter"));
                this.taskHandType.add(SynchronizeType.getDataCenter);
            }
        } else {
            MsgBox.warn(null, (String)CoreUtils.getResourceStr(null, "notSubDataCenter"), (Component)cc);
            SysUtil.abort();
        }
    }

    @Override
    public ResultInfo executeTask(int step) throws Exception {
        Object curObject;
        if (this.webServiceClient == null) {
            this.webServiceClient = WebServiceClient.getInstance();
        }
        if ((curObject = this.taskHandType.get(step)) instanceof WebServiceInfo) {
            this.xbangServiceInfo = (WebServiceInfo)curObject;
            boolean islogin = this.webServiceClient.login(this.xbangServiceInfo);
            if (!islogin) {
                throw new RuntimeException(CoreUtils.getResourceStr(null, "DataCenter") + "[" + this.xbangServiceInfo.getDataCenterName() + "]" + CoreUtils.getResourceStr(null, "ConnectFail"));
            }
            this.result = null;
        } else {
            SynchronizeHandle synHandle = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.getDataCenter);
            this.result = synHandle.sourceDataCenterHandle(null, null, this.webServiceClient, this.xbangServiceInfo);
        }
        if (step == this.getTaskStepCount() - 1) {
            DataCenterFactory.getRemoteInstance().dispenseDataCenterLog();
        }
        return this.result;
    }

    @Override
    public String getSubTaskTitle(int step) {
        return this.taskName.get(step);
    }

    @Override
    public String getTaskContextString() {
        return null;
    }

    @Override
    public String getTaskName() {
        return CoreUtils.getResourceStr(null, "SynDataCenter");
    }

    @Override
    public String getTaskNumber() {
        return "syn_datacenter";
    }

    @Override
    public int getTaskStepCount() {
        return this.taskName.size();
    }
}

