/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.rptintegration.ISubmitLog;
import com.kingdee.eas.fi.gr.rptintegration.ISynLog;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.SynLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SynLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.CoverDeleteSynOperateByPush;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.TriggerCslRptReceived;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CslRptReceiveOperate {
    private static Logger logger = Logger.getLogger(CslRptReceiveOperate.class);

    public static void setSubDataCenterRptToReceived(Context ctx, List ids, String userId) throws BOSException, EASBizException {
        CslRptReceiveOperate.updateSubDataCenter(ctx, TriggerCslRptReceived.HandleType.receive, ids, userId);
    }

    public static void setSubDataCenterRptToUnReceived(Context ctx, List ids, String userId) throws BOSException, EASBizException {
        CslRptReceiveOperate.updateSubDataCenter(ctx, TriggerCslRptReceived.HandleType.unReceive, ids, userId);
    }

    public static void setSubDataCenterRptToSendBack(Context ctx, List ids, String message) throws BOSException, EASBizException {
        CslRptReceiveOperate.updateSubDataCenter(ctx, TriggerCslRptReceived.HandleType.sendBack, ids, message);
    }

    public static void updateSubDataCenter(Context ctx, TriggerCslRptReceived.HandleType handleType2, List ids, String extParam) throws BOSException, EASBizException {
        try {
            Object startMultiDataCenterValue = CslRptUtil.getParamValue(ctx, null, "GR_CSL_StartMultiDataCenterIntegration");
            if (startMultiDataCenterValue != null && startMultiDataCenterValue.toString().toUpperCase(Locale.ENGLISH).equals("TRUE")) {
                Map<WebServiceInfo, List<String>> cslRpt_webService = CslRptReceiveOperate.getsubDataCenterMap(ctx, ids);
                CslRptReceiveOperate.getParentDataCenterMap(ctx, ids, cslRpt_webService);
                String curDateCenterId = null;
                if (cslRpt_webService.size() > 0) {
                    WebServiceClient webServiceClient = WebServiceClient.getInstance();
                    SynchronizeHandle cslRptReceivedHandle = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerCslRptReceived);
                    for (WebServiceInfo webServiceInfo : cslRpt_webService.keySet()) {
                        if (((TriggerCslRptReceived)cslRptReceivedHandle).doHandle(ctx, handleType2, extParam, cslRpt_webService.get(webServiceInfo), webServiceClient, webServiceInfo)) {
                            logger.error((Object)("updateSubDataCenter success:" + webServiceInfo.toString() + " " + cslRpt_webService.get(webServiceInfo).toArray()));
                            if (!handleType2.equals((Object)TriggerCslRptReceived.HandleType.sendBack)) continue;
                            if (curDateCenterId == null) {
                                curDateCenterId = DataCenterUtil.getCurrentDatacenter(ctx).getId().toString();
                            }
                            String where = "freportid in(" + CslRptUtil.list2String(cslRpt_webService.get(webServiceInfo), ",", true) + ")";
                            DbUtil.execute((Context)ctx, (String)("update t_csl_submitlog set fsubmitstate=1 where " + where));
                            ((CoverDeleteSynOperateByPush)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSynByPush)).coverSynTableByWhere(ctx, "*", where, "T_Csl_SubmitLog", curDateCenterId, webServiceClient, webServiceInfo);
                            continue;
                        }
                        logger.error((Object)("updateSubDataCenter error:" + webServiceInfo.toString()));
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static Map<WebServiceInfo, List<String>> getsubDataCenterMap(Context ctx, List ids) throws BOSException, EASBizException {
        Map<String, WebServiceInfo> dataCenterMap;
        HashMap<WebServiceInfo, List<String>> webService_cslRpts = new HashMap<WebServiceInfo, List<String>>();
        ISynLog iSynLog = ctx == null ? SynLogFactory.getRemoteInstance() : SynLogFactory.getLocalInstance(ctx);
        SynLogCollection colls = iSynLog.getSynLogCollection(" where synEntityId in (" + CslRptUtil.changeIdList2String(ids) + ") and synType='" + new CslReportInfo().getBOSType().toString() + "'");
        ArrayList<String> dataCenterIds = new ArrayList<String>();
        for (int i = 0; i < colls.size(); ++i) {
            if (StringUtils.isEmpty((String)colls.get(i).getFromDataCenterId())) continue;
            dataCenterIds.add(colls.get(i).getFromDataCenterId());
        }
        if (dataCenterIds.size() > 0 && (dataCenterMap = DataCenterUtil.getWebservicesMapById(ctx, dataCenterIds)) != null && dataCenterMap.size() > 0) {
            WebServiceInfo webserviceInfo = null;
            ArrayList<String> cslRptIds = null;
            for (int i = 0; i < colls.size(); ++i) {
                if (StringUtils.isEmpty((String)colls.get(i).getFromDataCenterId()) || (webserviceInfo = dataCenterMap.get(colls.get(i).getFromDataCenterId())) == null) continue;
                cslRptIds = (ArrayList<String>)webService_cslRpts.get(webserviceInfo);
                if (cslRptIds == null) {
                    cslRptIds = new ArrayList<String>();
                }
                if (!cslRptIds.contains(colls.get(i).getSynEntityId())) {
                    cslRptIds.add(colls.get(i).getSynEntityId());
                }
                webService_cslRpts.put(webserviceInfo, cslRptIds);
            }
        }
        return webService_cslRpts;
    }

    public static void getParentDataCenterMap(Context ctx, List ids, Map<WebServiceInfo, List<String>> cslRpt_webService) throws BOSException, EASBizException {
        HashSet<String> subRpts = new HashSet<String>();
        for (List<String> rpts : cslRpt_webService.values()) {
            subRpts.addAll(rpts);
        }
        StringBuffer idStr = new StringBuffer();
        for (int i = ids.size() - 1; i >= 0; --i) {
            if (subRpts.contains(ids.get(i))) continue;
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append("'").append(ids.get(i)).append("'");
        }
        subRpts.clear();
        if (idStr.length() > 0) {
            SubmitLogCollection coll = (ctx == null ? SubmitLogFactory.getRemoteInstance() : SubmitLogFactory.getLocalInstance(ctx)).getSubmitLogCollection("select reportId where reportId in(" + idStr + ")");
            ArrayList<String> cslRptIds = new ArrayList<String>();
            for (int i = 0; i < coll.size(); ++i) {
                if (cslRptIds.contains(coll.get(i).getReportId())) continue;
                cslRptIds.add(coll.get(i).getReportId());
            }
            if (!cslRptIds.isEmpty()) {
                logger.error((Object)(" cslrpt cslRptIds:" + cslRptIds.toArray() + "---------------------"));
                cslRpt_webService.put(DataCenterUtil.getParentServiceInfo(ctx), cslRptIds);
            }
        }
    }

    public static void setParentDataCenterRptToSendBack(Context ctx, List ids, String message) {
        try {
            ISubmitLog iSubmitLog;
            SubmitLogCollection coll;
            Object startMultiDataCenterValue = CslRptUtil.getParamValue(ctx, null, "GR_CSL_StartMultiDataCenterIntegration");
            if (startMultiDataCenterValue != null && startMultiDataCenterValue.toString().toUpperCase(Locale.ENGLISH).equals("TRUE") && (coll = (iSubmitLog = ctx == null ? SubmitLogFactory.getRemoteInstance() : SubmitLogFactory.getLocalInstance(ctx)).getSubmitLogCollection("select reportid where reportid in(" + CslRptUtil.collection2String(ids, ",", true) + ")")) != null && coll.size() > 0) {
                ids.clear();
                for (int i = 0; i < coll.size(); ++i) {
                    ids.add(coll.get(i).getReportId());
                }
                WebServiceClient webServiceClient = WebServiceClient.getInstance();
                WebServiceInfo parentSerInfo = DataCenterUtil.getParentServiceInfo(ctx);
                SynchronizeHandle cslRptReceivedHandle = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerCslRptReceived);
                ((TriggerCslRptReceived)cslRptReceivedHandle).doHandle(ctx, TriggerCslRptReceived.HandleType.sendBack, message, ids, webServiceClient, parentSerInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"setParentDataCenterRptToSendBack error", (Throwable)e);
        }
    }

    public static Map<WebServiceInfo, List<String>> getDataCenterMap(Context ctx, List ids) throws BOSException, EASBizException {
        Map<String, WebServiceInfo> dataCenterMap;
        HashMap<WebServiceInfo, List<String>> webService_cslRpts = new HashMap<WebServiceInfo, List<String>>();
        ISynLog iSynLog = ctx == null ? SynLogFactory.getRemoteInstance() : SynLogFactory.getLocalInstance(ctx);
        SynLogCollection colls = iSynLog.getSynLogCollection(" where synEntityId in (" + CslRptUtil.changeIdList2String(ids) + ") and synType='" + new CslReportInfo().getBOSType().toString() + "'");
        ArrayList<String> dataCenterIds = new ArrayList<String>();
        for (int i = 0; i < colls.size(); ++i) {
            if (StringUtils.isEmpty((String)colls.get(i).getFromDataCenterId())) continue;
            dataCenterIds.add(colls.get(i).getFromDataCenterId());
        }
        if (dataCenterIds.size() > 0 && (dataCenterMap = DataCenterUtil.getWebservicesMapById(ctx, dataCenterIds)) != null && dataCenterMap.size() > 0) {
            WebServiceInfo webserviceInfo = null;
            ArrayList<String> cslRptIds = null;
            for (int i = 0; i < colls.size(); ++i) {
                if (StringUtils.isEmpty((String)colls.get(i).getFromDataCenterId()) || (webserviceInfo = dataCenterMap.get(colls.get(i).getFromDataCenterId())) == null) continue;
                cslRptIds = (ArrayList<String>)webService_cslRpts.get(webserviceInfo);
                if (cslRptIds == null) {
                    cslRptIds = new ArrayList<String>();
                }
                cslRptIds.add(colls.get(i).getSynEntityId());
                webService_cslRpts.put(webserviceInfo, cslRptIds);
            }
        }
        return webService_cslRpts;
    }

    public static void deleteParentDataReport(Context ctx, String id, boolean isReport) throws BOSException, EASBizException {
        try {
            Object startMultiDataCenterValue = CslRptUtil.getParamValue(ctx, null, "GR_CSL_StartMultiDataCenterIntegration");
            if (startMultiDataCenterValue != null && startMultiDataCenterValue.toString().toUpperCase(Locale.ENGLISH).equals("TRUE")) {
                ResultInfo reslut;
                WebServiceClient webServiceClient = WebServiceClient.getInstance();
                WebServiceInfo xbangServiceInfo = DataCenterUtil.getParentServiceInfo(ctx);
                if (xbangServiceInfo != null && (reslut = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.deleteReport).sourceDataCenterHandle(ctx, new String[]{isReport ? "1" : "0", id}, webServiceClient, xbangServiceInfo)) != null && reslut.getStatus() != 0) {
                    logger.error((Object)("deleteParentDataReport error:" + reslut.getMsgInfo()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"deleteParentDataReport error.", (Throwable)e);
        }
    }
}

