/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.GenerateIdInterface;
import com.kingdee.eas.fi.gr.rptintegration.util.GenerateIdRelateMapImpl;
import com.kingdee.eas.fi.gr.rptintegration.util.NormalGenerateIdImpl;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.RptIntegrationUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.BookDataSynOperate;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.CoverDeleteSynOperate;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CslReportSynOperate
extends CoreUtils
implements SynchronizeHandle {
    private static Logger logger = Logger.getLogger(CslReportSynOperate.class);
    private BOSObjectType bosType;
    private NormalGenerateIdImpl normalIntf = null;
    private GenerateIdRelateMapImpl relateMapIntf = null;

    @Override
    public ResultInfo sourceDataCenterHandle(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        ResultInfo result = new ResultInfo();
        String cslRptId = null;
        boolean isRptSyn = false;
        try {
            if (args != null && args.length > 0) {
                this.normalIntf = new NormalGenerateIdImpl();
                this.relateMapIntf = new GenerateIdRelateMapImpl();
                cslRptId = args[0];
                if (args.length > 1) {
                    isRptSyn = "1".equals(args[1]);
                }
                String subDataCenterId = null;
                if (args.length > 2) {
                    subDataCenterId = args[2];
                }
                xbangServiceInfo.setOperationName("invoke");
                CslReportInfo subCslRptInfo = this.getSubReportInfo(ctx, cslRptId, subDataCenterId, webServiceClient, xbangServiceInfo);
                if (isRptSyn || this.check(ctx, subCslRptInfo, result)) {
                    String cols = "id,lastupdatetime,commitTime,committedStatus,auditedStatus";
                    CslReportInfo parentInfo = this.getCslReportInfo(ctx, cslRptId, cols);
                    if (isRptSyn || parentInfo == null) {
                        if (this.chechSameReport(ctx, subCslRptInfo, result)) {
                            this.handleSave(ctx, HandleType.AddNew, cslRptId, subDataCenterId, webServiceClient, xbangServiceInfo);
                            CslReportSynOperate.addNewSynLog(ctx, cslRptId, this.getBosType().toString(), xbangServiceInfo.getDataCenterId());
                        }
                    } else {
                        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.cslRptSyn, new String[]{cslRptId, cols}});
                        String subInfoStr = (String)webServiceClient.callMethod(xbangServiceInfo);
                        CslReportInfo subInfo = (CslReportInfo)this.jsonStringToObject(ctx, subInfoStr, this.getBosType());
                        if (subInfo.getLastUpdateTime().compareTo(parentInfo.getLastUpdateTime()) != 0) {
                            this.handleSave(ctx, HandleType.Update, cslRptId, subDataCenterId, webServiceClient, xbangServiceInfo);
                        } else if (!subInfo.getCommittedStatus().equals((Object)parentInfo.getCommittedStatus())) {
                            this.updateCslRptStatus(ctx, cslRptId, subInfo.getCommittedStatus().getValue(), subInfo.getAuditedStatus().getValue());
                            this.updateItemdataStatus(ctx, cslRptId, true, subInfo.getCommittedStatus().getValue());
                        } else {
                            logger.debug((Object)("cslReport:" + cslRptId + " is commited."));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"CslReportSynOperate error.", (Throwable)e);
            result.setStatus(1);
            throw e;
        }
        finally {
            if (this.relateMapIntf != null) {
                this.relateMapIntf.getIdMap().clear();
            }
        }
        return result;
    }

    private boolean chechSameReport(Context ctx, CslReportInfo cslRptInfo, ResultInfo result) throws Exception {
        String rptId;
        cslRptInfo.put("isRptIntegration", true);
        if (CslReportFactory.getLocalInstance(ctx).isExistsSameReport((IObjectPK)new ObjectUuidPK(cslRptInfo.getId()), (IObjectValue)cslRptInfo)) {
            result.setMsgInfo(CslReportSynOperate.getResourceStr(ctx, "existSameReport"));
            return false;
        }
        RptSrcTypeEnum srcType = cslRptInfo.getSourceType();
        if (srcType.equals((Object)RptSrcTypeEnum.SUM) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("treeID", cslRptInfo.getOrgTree().getId().toString());
            params.put("companyID", cslRptInfo.getOrgUnit().getId().toString());
            params.put("periodType", new Integer(cslRptInfo.getPeriodType().getValue()));
            params.put("year", new Integer(cslRptInfo.getYear()));
            params.put("period", new Integer(cslRptInfo.getPeriod()));
            params.put("currencyID", cslRptInfo.getCurrency().getId().toString());
            params.put("templateGroupNumber", cslRptInfo.getTemplate().getGroup());
            params.put("reportType", new Integer(cslRptInfo.getSourceType().getValue()));
            params.put("reportId", cslRptInfo.getId().toString());
            params.put("dataCollectNumber", cslRptInfo.getDataCollectNumber());
            params.put("isSupportGroupReport", true);
            if (TempletDispenseFactory.getLocalInstance(ctx).isHasSameSumRpt(params)) {
                result.setMsgInfo(CslReportSynOperate.getResourceStr(ctx, "existSameReport"));
                return false;
            }
        } else if ((srcType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) && !StringUtils.isEmpty((String)(rptId = TempletDispenseFactory.getLocalInstance(ctx).getReportByTmpVersion(cslRptInfo.getOrgTree().getId().toString(), cslRptInfo.getOrgUnit().getId().toString(), cslRptInfo.getCurrency().getId().toString(), cslRptInfo.getTemplate().getId().toString(), cslRptInfo.getSourceType().getValue(), cslRptInfo.getPeriodType().getValue(), cslRptInfo.getYear(), cslRptInfo.getPeriod(), cslRptInfo.getId().toString(), cslRptInfo.getDataCollectNumber())))) {
            result.setMsgInfo(CslReportSynOperate.getResourceStr(ctx, "existSameReport"));
            return false;
        }
        return true;
    }

    private boolean check(Context ctx, CslReportInfo cslRptInfo, ResultInfo result) throws Exception {
        if (!TemplateFactory.getLocalInstance((Context)ctx).exists(" where id='" + cslRptInfo.getTemplate().getId().toString() + "'")) {
            result.setMsgInfo(CslReportSynOperate.getResourceStr(ctx, "notExistTemplate"));
            return false;
        }
        return true;
    }

    private CslReportInfo getSubReportInfo(Context ctx, String cslRptId, String subDataCenterId, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        StringBuffer selectCol = new StringBuffer("template.id,number,orgTree,orgUnit,currency,sourceCurrency,template.group,periodType,");
        selectCol.append("year,period,sourceType,isSaveAs,adjustStatus,dataCollectNumber,adjustStatus,id");
        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.cslRptSyn, new String[]{cslRptId, selectCol.toString()}});
        String subInfoStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        CslReportInfo cslRptInfo = (CslReportInfo)this.jsonStringToObject(ctx, subInfoStr, this.getBosType());
        this.handleInfoMap(ctx, (CoreBaseInfo)cslRptInfo, subDataCenterId, this.getBosType().toString(), false);
        return cslRptInfo;
    }

    private void handleSave(Context ctx, HandleType type, String cslRptId, String subDataCenterId, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        if (type.equals((Object)HandleType.AddNew)) {
            this.normalIntf.setNewId(true);
            this.normalIntf.setBosId(new RptReceivedInfo().getBOSType().toString());
            this.getCoverSynInterface().coverSynTableByWhere(ctx, "*", "freportid='" + cslRptId + "'", "t_csl_rptreceived", new GenerateIdInterface[]{this.normalIntf}, webServiceClient, xbangServiceInfo, false);
            this.normalIntf.setBosId(new SumRptAddedPerportyInfo().getBOSType().toString());
            this.getCoverSynInterface().coverSynTableByWhere(ctx, "*", "FReport='" + cslRptId + "'", "T_Csl_SumRptAddedPerporty", new GenerateIdInterface[]{this.normalIntf}, webServiceClient, xbangServiceInfo, false);
        }
        this.getCoverSynInterface().coverSynTableByWhere(ctx, "*", "freportid='" + cslRptId + "'", "T_RPT_RptSheetPara", null, webServiceClient, xbangServiceInfo, false);
        CslReportInfo subCslRptInfo = this.getSubCslRptInfo(ctx, cslRptId, subDataCenterId, webServiceClient, xbangServiceInfo);
        CoreBaseCollection baseCol = new CoreBaseCollection();
        baseCol.add((CoreBaseInfo)subCslRptInfo);
        ICslReport iCslRpt = CslReportFactory.getLocalInstance(ctx);
        if (type.equals((Object)HandleType.AddNew)) {
            iCslRpt.addnewBatchData(baseCol);
        } else {
            iCslRpt.updateBatchData(baseCol);
        }
        String where = " fid ='" + cslRptId + "'";
        RptIntegrationUtils.updateUser(ctx, "t_csl_cslreport", "FLastUpdateUserID", where);
        RptIntegrationUtils.updateUser(ctx, "t_csl_cslreport", "FCREATORID", where);
        baseCol.clear();
        if (this.isSaveItemData(subCslRptInfo.getSourceType())) {
            subCslRptInfo.getSheetParam().addCollection(this.getSubSheetParamCollection(ctx, cslRptId, webServiceClient, xbangServiceInfo));
            this.handleElimMap(ctx, subCslRptInfo, subDataCenterId);
            iCslRpt.saveItemData((IObjectValue)subCslRptInfo);
            this.updateItemdataStatus(ctx, subCslRptInfo.getId().toString(), false, subCslRptInfo.getCommittedStatus().getValue());
        }
        if (this.isSaveDyItemData(subCslRptInfo.getSourceType())) {
            this.saveDyItemData(ctx, cslRptId, webServiceClient, xbangServiceInfo);
        }
    }

    private void updateCslRptStatus(Context ctx, String reportId, int commitStatus, int auditStatus) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_csl_cslreport \r\n");
        sql.append("SET fcommittedstatus = ");
        sql.append(commitStatus);
        sql.append(", fauditedstatus = ");
        sql.append(auditStatus);
        sql.append("WHERE ");
        sql.append("fid='" + reportId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateItemdataStatus(Context ctx, String reportId, boolean isUpdataDynaItemData, int commitStatus) throws Exception {
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_CSL_ITEMDATA \r\n");
        sql.append("SET FCommitStatus = ");
        sql.append(commitStatus);
        sql.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
        sql.append("WHERE ");
        sql.append("FReportID='" + reportId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE T_CSL_ITEMDATAENTRY \r\n");
        sql.append("SET FCommitStatus = ");
        sql.append(commitStatus);
        sql.append(" WHERE ");
        sql.append("FReportID='" + reportId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE t_csl_multidynaitemdata \r\n");
        sql.append("SET FCommitStatus = ");
        sql.append(commitStatus);
        sql.append("WHERE ");
        sql.append("FReportID='" + reportId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (isUpdataDynaItemData) {
            sql.setLength(0);
            sql.append("UPDATE t_csl_dynaitemdata \r\n");
            sql.append("SET FCommitStatus = ");
            sql.append(commitStatus);
            sql.append("WHERE ");
            sql.append("FReportID='" + reportId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void saveDyItemData(Context ctx, String cslRptId, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        this.relateMapIntf.getIdMap().clear();
        this.relateMapIntf.setNewId(true);
        this.relateMapIntf.setBosId(new DynaItemDataInfo().getBOSType().toString());
        this.relateMapIntf.setCreateCol("FITEMDATAID");
        this.normalIntf.setNewId(true);
        this.normalIntf.setBosId(new DynaItemDataEntryInfo().getBOSType().toString());
        this.normalIntf.setCreateCol("FID");
        this.getCoverSynInterface().coverSynTableByWhere(ctx, "*", "fitemdataid in(select fid from T_CSL_DynaItemData where freportid='" + cslRptId + "')", "T_CSL_DynaItemDataEntry", new GenerateIdInterface[]{this.normalIntf, this.relateMapIntf}, webServiceClient, xbangServiceInfo, false);
        this.relateMapIntf.setCreateCol("FID");
        this.getCoverSynInterface().coverSynTableByWhere(ctx, "*", "freportid='" + cslRptId + "'", "T_CSL_DynaItemData", new GenerateIdInterface[]{this.relateMapIntf}, webServiceClient, xbangServiceInfo, false);
    }

    private boolean isSaveDyItemData(RptSrcTypeEnum rptType) {
        boolean isSave = false;
        if (rptType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            isSave = true;
        }
        return isSave;
    }

    private boolean isSaveItemData(RptSrcTypeEnum rptType) {
        boolean isSave = false;
        if (rptType.equals((Object)RptSrcTypeEnum.MANUSCRIPT) || rptType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptType.equals((Object)RptSrcTypeEnum.SUM) || rptType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || rptType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) || rptType.equals((Object)RptSrcTypeEnum.COMMITREPORT) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || rptType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) || rptType.equals((Object)RptSrcTypeEnum.NORMAL)) {
            isSave = true;
        }
        return isSave;
    }

    private CoverDeleteSynOperate getCoverSynInterface() throws Exception {
        return (CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn);
    }

    private CslReportInfo getSubCslRptInfo(Context ctx, String cslRptId, String subDataCenterId, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        String propertiesStr = this.getInfoPropertiesStr(ctx, this.getBosType());
        propertiesStr = propertiesStr.replace("data,", "");
        propertiesStr = propertiesStr + ",auditor.number,commitor.number,creator.number,lastupdateuser.number";
        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.cslRptSyn, new String[]{cslRptId, propertiesStr}});
        String subInfoStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        CslReportInfo cslRptInfo = (CslReportInfo)this.jsonStringToObject(ctx, subInfoStr, this.getBosType());
        RptIntegrationUtils.updateUser(ctx, new String[]{"auditor", "commitor", "creator", "lastUpdateUser"}, (CoreBaseInfo)cslRptInfo, xbangServiceInfo.getDataCenterId());
        this.handleInfoMap(ctx, (CoreBaseInfo)cslRptInfo, subDataCenterId, this.getBosType().toString(), false);
        BookDataSynOperate bookDataSyn = (BookDataSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.bookDataSyn);
        byte[] data = bookDataSyn.getTargetBookData(ctx, cslRptId, "1", webServiceClient, xbangServiceInfo);
        cslRptInfo.setData(data);
        this.handleBookItemMap(ctx, (VirtualSheetParamInfo)cslRptInfo, subDataCenterId, xbangServiceInfo.getDataCenterId(), false);
        return cslRptInfo;
    }

    private RptSheetParamCollection getSubSheetParamCollection(Context ctx, String cslRptId, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        String cols = "sheetID,reportClass,id";
        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.cslRptSyn, new String[]{"1", cslRptId, cols}});
        String subInfoStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        JSONArray jsonArray = new JSONArray(subInfoStr);
        BOSObjectType bosType = new RptSheetParamInfo().getBOSType();
        RptSheetParamCollection coll = new RptSheetParamCollection();
        for (int i = 0; i < jsonArray.length(); ++i) {
            coll.add((RptSheetParamInfo)CslReportSynOperate.jsonObjectToObject(ctx, jsonArray.getJSONObject(i), bosType));
        }
        return coll;
    }

    private BOSObjectType getBosType() {
        if (this.bosType == null) {
            return new CslReportInfo().getBOSType();
        }
        return this.bosType;
    }

    @Override
    public String targetDataCenterHandle(Context ctx, String[] args) throws Exception {
        if (args != null && args.length > 1) {
            if (!args[0].equals("1")) {
                String cslrptId = args[0];
                String cols = args[1];
                CslReportInfo cslRptInfo = this.getCslReportInfo(ctx, cslrptId, cols);
                return CslReportSynOperate.objectToJsonString((IObjectValue)cslRptInfo, null, cols.split(","));
            }
            String cslrptId = args[1];
            String cols = args[2];
            CoreBaseCollection collection = RptSheetParamFactory.getLocalInstance((Context)ctx).getCollection("select " + cols + " where report='" + cslrptId + "'");
            JSONArray jsonArray = new JSONArray();
            CoreBaseInfo info = null;
            for (int i = 0; i < collection.size(); ++i) {
                info = (CoreBaseInfo)collection.getObject(i);
                if (StringUtils.isEmpty((String)cols)) {
                    jsonArray.put((Object)CslReportSynOperate.objectToJsonObj((IObjectValue)info));
                    continue;
                }
                jsonArray.put((Object)CslReportSynOperate.objectToJson((IObjectValue)info, null, cols.split(",")));
            }
            return jsonArray.toString();
        }
        return "param args is not right.";
    }

    private void handleElimMap(Context ctx, CslReportInfo subCslRptInfo, String subDataCenterId) throws Exception {
        Map<String, String> companyIdMap;
        RptSheetParamCollection sheetParams = subCslRptInfo.getSheetParam();
        HashSet<String> elimSheetIds = new HashSet<String>();
        for (int i = 0; i < sheetParams.size(); ++i) {
            if (sheetParams.get(i).getReportClass() == null || !sheetParams.get(i).getReportClass().equals((Object)CSLReportGroupEnum.ELIMINATION) || !sheetParams.get(i).getReportClass().equals((Object)CSLReportGroupEnum.INTERIOR_EXCHANGE) || !sheetParams.get(i).getReportClass().equals(30) || !sheetParams.get(i).getReportClass().equals(40)) continue;
            elimSheetIds.add(sheetParams.get(i).getSheetID());
        }
        if (!elimSheetIds.isEmpty() && !(companyIdMap = this.getDataMap(ctx, subDataCenterId, new OrgUnitInfo().getBOSType().toString())).isEmpty()) {
            Book book = subCslRptInfo.getBook();
            boolean isExistsMap = false;
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                if (!elimSheetIds.contains(sheet.getID())) continue;
                int left = CslRptUtil.getBasePosition_Left(sheet);
                int top = CslRptUtil.getBasePosition_Top(sheet);
                if (left < 0 || top < 0) continue;
                int rowCount = sheet.getRows().getMaxIntMark() + 1;
                for (int row = top + 1; row < rowCount; ++row) {
                    String subCompanyId;
                    String parentCompanyId;
                    ItemFormula fv = (ItemFormula)sheet.getRange(row, left).getUserObject("ITEM");
                    if (fv == null || fv.getExt("16") == null || StringUtils.isEmpty((String)(parentCompanyId = companyIdMap.get(subCompanyId = fv.getExt("16").toString())))) continue;
                    fv.putExt("16", parentCompanyId);
                    sheet.getRange(row, left).setUserObject("ITEM", (Object)fv);
                    isExistsMap = true;
                }
            }
            if (isExistsMap) {
                subCslRptInfo.setBook(book);
            }
        }
    }

    private CslReportInfo getCslReportInfo(Context ctx, String cslrptId, String selectCol) throws Exception {
        CslReportInfo cslRptInfo = null;
        CslReportCollection colls = CslReportFactory.getLocalInstance(ctx).getCslReportCollection((!StringUtils.isEmpty((String)selectCol) ? "select " + selectCol : "") + " where id='" + cslrptId + "'");
        if (colls != null && colls.size() > 0) {
            cslRptInfo = colls.get(0);
        }
        return cslRptInfo;
    }

    static enum HandleType {
        AddNew,
        Update;

    }
}

