/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.webservice.login;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.bos.webservice.login.EASLoginProxy;
import com.kingdee.bos.webservice.login.WSContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslRptLoginEASProxy {
    private static final Logger logger = Logger.getLogger(EASLoginProxy.class);
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";
    private static Map userSessionCache = Collections.synchronizedMap(new HashMap());
    private static Map userPwCache = Collections.synchronizedMap(new HashMap());

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType) {
        return this.login(userName, password, slnName, dcName, language, dbType, EAS_DEFAULT_AUTH_PATTERN);
    }

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType, String authPattern) {
        return this.login(userName, password, slnName, dcName, language, dbType, authPattern, 0);
    }

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType, String authPattern, int isEncodePwd) {
        WSContext wsctx = new WSContext();
        wsctx.setUserName(userName);
        wsctx.setPassword(password);
        wsctx.setSlnName(slnName);
        wsctx.setDcName(dcName);
        wsctx.setDbType(dbType);
        String encodePwd = null;
        encodePwd = isEncodePwd == 1 ? password : password;
        String key = userName + "_" + slnName + "_" + dcName + "_" + language;
        ILoginModule loginModule = null;
        String loginUrl = null;
        try {
            loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            loginModule = this.getLoginModule(loginUrl);
        }
        catch (BOSException e) {
            logger.error((Object)"WebService login fail:", (Throwable)e);
            wsctx.setSessionId(null);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService login fail:", e);
            wsctx.setSessionId(null);
        }
        try {
            if (loginModule == null) {
                return null;
            }
            String sessionId = null;
            try {
                if (userSessionCache.containsKey(key)) {
                    String pwd = (String)userPwCache.get(key);
                    if (encodePwd.equals(pwd)) {
                        sessionId = (String)userSessionCache.get(key);
                        if (sessionId != null && sessionId.trim().length() > 0) {
                            boolean flag = loginModule.isOnline(sessionId);
                            if (!flag) {
                                sessionId = null;
                            }
                        } else {
                            sessionId = null;
                        }
                    } else {
                        sessionId = null;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"isOnline error:", (Throwable)ex);
                sessionId = null;
            }
            if (sessionId == null) {
                Locale locale = new Locale(language);
                LoginContext ctx = new LoginContext(userName, encodePwd, slnName, dcName, locale);
                ctx.put("dbType", (Object)CslRptLoginEASProxy.getDbType(dbType));
                ctx.put("UserAuthPattern", (Object)authPattern);
                ctx.put("ClientIP", (Object)"127.0.0.1");
                ctx.put("SwitchToNewLoginFlow", (Object)"true");
                try {
                    sessionId = loginModule.login(ctx);
                }
                catch (Throwable rpce) {
                    logger.error((Object)"WebService relogin:", rpce);
                    RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                    loginModule = this.getLoginModule(loginUrl);
                    sessionId = loginModule.login(ctx);
                }
                userSessionCache.put(key, sessionId);
                userPwCache.put(key, encodePwd);
            }
            wsctx.setSessionId(sessionId);
            ORMRPCServiceLocator.setCurrentServiceURL((String)loginUrl);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService login fail:", e);
            wsctx.setSessionId(null);
        }
        return wsctx;
    }

    private ILoginModule getLoginModule(String url) throws BOSException {
        try {
            RPCService.inServiceInvoke.set("aaaaaaaaaaa");
            if (WSConfig.getRomoteLocate() == null || WSConfig.getRomoteLocate().equals("true")) {
                ILoginModule iLoginModule = LoginModuleFactory.getRemoteInstance((String)url);
                return iLoginModule;
            }
            ILoginModule iLoginModule = LoginModuleFactory.getLocalInstance(null);
            return iLoginModule;
        }
        finally {
            RPCService.inServiceInvoke.set(null);
        }
    }

    public boolean logout(String userName, String slnName, String dcName, String language) {
        boolean flag = true;
        String key = userName + "_" + slnName + "_" + dcName + "_" + language;
        try {
            String loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            ILoginModule loginModule = this.getLoginModule(loginUrl);
            if (userSessionCache.containsKey(key) && loginModule != null) {
                String sessionId = (String)userSessionCache.get(key);
                if (sessionId != null && sessionId.trim().length() > 0 && (flag = loginModule.isOnline(sessionId))) {
                    flag = loginModule.logout(sessionId);
                }
                userSessionCache.remove(key);
                userPwCache.remove(key);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"WebService logout fail:", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService logout fail:", e);
        }
        return flag;
    }

    private static String getDbType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }
}

