/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt;

import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.EASCommonResource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FormatJobProcessSettingAction {
    private static final Logger log = Logger.getLogger(FormatJobProcessSettingAction.class);
    private static Locale locale;

    public FormatJobProcessSettingAction() {
    }

    public FormatJobProcessSettingAction(Locale locale) {
        FormatJobProcessSettingAction.locale = locale;
    }

    public String action(ScheduleDef schedule) {
        schedule.getBeginTime();
        schedule.getDefine();
        schedule.getEndTime();
        schedule.getOrgUnitId();
        schedule.getRetryTime();
        String rsKey = "TEXT_DISPATCH_SETTING_" + schedule.getType().getName();
        String typeName = FormatJobProcessSettingAction.getRs(rsKey);
        if (ScheduleType.USERDEFINE.equals((Object)schedule.getType())) {
            return typeName + "\t" + schedule.getDefine();
        }
        String content = FormatJobProcessSettingAction.convertSixParam(schedule.getDefine());
        if (content == null && (content = FormatJobProcessSettingAction.convertSevenParam(schedule.getDefine())) == null) {
            content = schedule.getDefine();
        }
        return typeName + " " + FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_DISPATCH_TIME") + ":" + content;
    }

    private static String getRs(String rsKey) {
        if (locale == null) {
            locale = SysContext.getSysContext().getOriginLocale();
        }
        return EASCommonResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)rsKey, (Locale)locale);
    }

    public static void main(String[] args) {
    }

    private static String convertSixParam(String define) {
        MessageFormat mf = new MessageFormat("{0} {1} {2} {3} {4} {5}");
        Object[] params = null;
        try {
            params = mf.parse(define);
        }
        catch (ParseException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
        if (params == null || params.length != 6) {
            return null;
        }
        String plStr = null;
        String lastFlag = params[3] + " " + params[4] + " " + params[5];
        String time = params[2] + ":" + params[1] + ":" + params[0];
        if ("* * ?".equals(lastFlag)) {
            plStr = FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_EVERYDAY") + " " + time;
        } else if ("? * 2-6".equals(lastFlag)) {
            plStr = FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_WORKDAY_OF_WEEK") + " " + time;
        } else if (lastFlag.matches("1/[0-9]+ \\* \\?")) {
            plStr = FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_SOMEDAY", new Object[]{((String)params[3]).split("/")[1]}) + time;
        } else if (lastFlag.matches("\\? \\* ([0-9][,]?)+")) {
            String[] weekIndex = ((String)params[5]).split(",");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < weekIndex.length; ++i) {
                sb.append(FormatJobProcessSettingAction.getWeekName(weekIndex[i], true));
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            plStr = sb.toString() + " " + time;
        } else {
            if (lastFlag.matches("[0-9]+ ([0-9][,]?)+ \\?")) {
                String[] weekIndex = ((String)params[4]).split(",");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < weekIndex.length; ++i) {
                    sb.append(FormatJobProcessSettingAction.getMonthName(weekIndex[i]));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString() + " " + FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_SOMEDAY_START", new Object[]{params[3]}) + " " + time;
            }
            if (lastFlag.matches("L ([0-9][,]?)+ \\?")) {
                String[] weekIndex = ((String)params[4]).split(",");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < weekIndex.length; ++i) {
                    sb.append(FormatJobProcessSettingAction.getMonthName(weekIndex[i]));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString() + " " + FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_LASTDAY") + " " + time;
            }
            if (lastFlag.matches("\\? ([0-9][,]?)+ [0-9]\\#[0-9]")) {
                String[] weekIndex = ((String)params[4]).split(",");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < weekIndex.length; ++i) {
                    sb.append(FormatJobProcessSettingAction.getMonthName(weekIndex[i]));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString() + " " + FormatJobProcessSettingAction.getWeekDay(((String)params[5]).split("\\#")) + " " + time;
            }
        }
        return plStr;
    }

    private static String convertSevenParam(String define) {
        MessageFormat mf = new MessageFormat("{0} {1} {2} {3} {4} {5} {6}");
        Object[] params = null;
        try {
            params = mf.parse(define);
        }
        catch (ParseException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
        if (params == null || params.length != 7) {
            return null;
        }
        Object plStr = null;
        String lastFlag = params[3] + " " + params[4] + " " + params[5] + " " + params[6];
        String time = params[2] + ":" + params[1] + ":" + params[0];
        if (lastFlag.matches("[0-9]+ [0-9]+ \\? [0-9]+")) {
            return FormatJobProcessSettingAction.getRs("TEXT_DISPATCH_SETTING_DATE", new Object[]{params[6], params[4], params[3]}) + " " + time;
        }
        return define;
    }

    private static String getWeekDay(String[] weekDays) {
        return FormatJobProcessSettingAction.getWeekIndexOfMonth(weekDays[1]) + FormatJobProcessSettingAction.getWeekName(Integer.parseInt(weekDays[0]), true);
    }

    private static String getWeekIndexOfMonth(String weekIndexOfMonth) {
        return FormatJobProcessSettingAction.getArrayRs("TEXT_DISPATCH_SETTING_WEEKNUM_STR", Integer.parseInt(weekIndexOfMonth) - 1);
    }

    private static Object getMonthName(String monthIndex) {
        return FormatJobProcessSettingAction.getArrayRs("TEXT_DISPATCH_SETTING_MONTH_STR", Integer.parseInt(monthIndex) - 1);
    }

    private static String getWeekName(String weekIndex, boolean sundayIsFirst) {
        int weekIndexInt = Integer.parseInt(weekIndex);
        return FormatJobProcessSettingAction.getWeekName(weekIndexInt, sundayIsFirst);
    }

    private static String getWeekName(int weekIndex, boolean sundayIsFirst) {
        if (sundayIsFirst && --weekIndex == 0) {
            weekIndex = 7;
        }
        return FormatJobProcessSettingAction.getArrayRs("TEXT_DISPATCH_SETTING_WEEK_STR", weekIndex - 1);
    }

    protected static String getArrayRs(String key, int arrayIndex) {
        String arrayStr = FormatJobProcessSettingAction.getRs(key);
        if (arrayStr == null || arrayStr.split(",").length <= arrayIndex) {
            return "";
        }
        return arrayStr.split(",")[arrayIndex];
    }

    protected static String getRs(String key, Object[] params) {
        String rs = FormatJobProcessSettingAction.getRs(key);
        try {
            return MessageFormat.format(rs, params);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return "";
        }
    }
}

