/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChooseTplDialog
extends KDCommonPromptDialog {
    private static final long serialVersionUID = -3277939213827189984L;
    private static final Logger log = Logger.getLogger(ChooseTplDialog.class);
    private IProcessor commonQueryProcessor;
    protected KDTable protectedTable;
    protected Map columnHiddenSetting = this.buildColumnHiddenSetting();

    public ChooseTplDialog(Dialog owner, IProcessor filterProcessor) {
        super(owner);
        this.commonQueryProcessor = filterProcessor;
        this.initProtectedTable();
    }

    public ChooseTplDialog(Frame owner, IProcessor filterProcessor) {
        super(owner);
        this.commonQueryProcessor = filterProcessor;
        this.initProtectedTable();
    }

    private void initProtectedTable() {
        try {
            Field tableField = KDCommonPromptDialog.class.getDeclaredField("table");
            NewRptUtil.makeAccessible((Field)tableField);
            this.protectedTable = (KDTable)tableField.get((Object)this);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.protectedTable = new KDTable();
        }
    }

    public void refresh() {
        super.refresh();
        this.executeHiddenSetting();
    }

    private void executeHiddenSetting() {
        Iterator it = this.columnHiddenSetting.keySet().iterator();
        Object columnName = null;
        while (it.hasNext()) {
            columnName = it.next();
            if (!(columnName instanceof String) || !(this.columnHiddenSetting.get(columnName) instanceof Boolean) || this.protectedTable.getColumn((String)columnName) == null) continue;
            this.protectedTable.getColumn((String)columnName).getStyleAttributes().setHided(((Boolean)this.columnHiddenSetting.get(columnName)).booleanValue());
        }
    }

    protected void dataFilter() {
        QueryInfo queryInfo = this.getQueryInfo();
        if (queryInfo == null) {
            return;
        }
        CommonQueryDialog cqd = new CommonQueryDialog();
        if (this.commonQueryProcessor != null) {
            cqd.setProcessor(this.commonQueryProcessor);
        }
        cqd.setOwner((Component)((Object)this));
        cqd.setQueryObjectPK((IMetaDataPK)new MetaDataPK(queryInfo.getPackage(), queryInfo.getName()));
        cqd.setShowToolbar(false);
        cqd.setWidth(640);
        cqd.setParentUIClassName("CommonF7_" + queryInfo.getFullName());
        cqd.setTitle(this.getQueryInfo().getAlias());
        if (this.innerFilter != null) {
            cqd.setEntityViewInfo(this.innerFilter);
        }
        if (cqd.show()) {
            this.innerFilter = cqd.getEntityViewInfoResult();
            this.putRowSet(null);
            this.refreshData(true);
        }
    }

    private HashMap buildColumnHiddenSetting() {
        return new HashMap();
    }

    public void setColumnHiddenSetting(Map columnHiddenSetting) {
        this.columnHiddenSetting = columnHiddenSetting;
    }
}

