/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.client.AbstractQuickDeleteReportFilterUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveReportUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class QuickDeleteReportFilterUI
extends AbstractQuickDeleteReportFilterUI {
    private static final long serialVersionUID = -1823889615127997213L;
    private static final Logger logger = CoreUIObject.getLogger(QuickDeleteReportFilterUI.class);
    private String isCancel = null;
    private boolean isDel = false;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSolution();
        this.initCurrency();
        this.initDate();
    }

    private void initDate() throws ParseException {
        Date date = (Date)this.getUIContext().get("date");
        this.dpkRptDate.setValue((Object)this.dateFormat.parse(this.dateFormat.format(date)), false);
        String year = (String)this.getUIContext().get("year");
        this.txtYear.setText(year);
        String period = (String)this.getUIContext().get("period");
        this.txtPeriod.setText(period);
    }

    private void initCurrency() {
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.cmbSolution.getSelectedItem();
        if (schmRptInfo.getCurrency() != null) {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.cmbCurrency, schmRptInfo.getCurrency().getId().toString(), false);
        } else {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.cmbCurrency, true, false);
        }
        this.cmbCurrency.doLayout();
    }

    private void initSolution() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("currency");
        view.getSelector().add("lastCalculateTime");
        view.getSelector().add("lastCalculateYear");
        view.getSelector().add("lastCalculatePeriod");
        view.getSelector().add("lastCalculateCurrency");
        view.getSelector().add("organizationUnit.id");
        view.getSelector().add("templateEtries.template.id");
        view.getSelector().add("templateEtries.template.number");
        view.getSelector().add("templateEtries.template.periodType");
        view.getSelector().add("companyEntries.company.id");
        view.getSelector().add("companyEntries.company.number");
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        FilterInfo filter = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int index = 0;
        filter.getFilterItems().add(new FilterItemInfo("isReceive", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSendBack", (Object)new Integer(0)));
        maskStr.append(" (#").append(index++).append(")");
        maskStr.append(" and (#").append(index++).append(")");
        OrgType orgType = (OrgType)this.getUIContext().get("orgType");
        Object companyInfo = null;
        companyInfo = OrgType.ProfitCenter.equals((Object)orgType) ? SysContext.getSysContext().getCurrentOrgUnit() : SysContext.getSysContext().getCurrentFIUnit();
        String currComp = "";
        if (companyInfo != null) {
            currComp = companyInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("organizationUnit", (Object)currComp));
            if (index > 0) {
                maskStr.append(" and ");
            }
            maskStr.append(" #").append(index++);
        }
        if (maskStr.length() > 0) {
            filter.setMaskString(maskStr.toString());
        }
        view.setFilter(filter);
        RptAutoWeaveSchmRptCollection coll = RptAutoWeaveSchmRptFactory.getRemoteInstance().getRptAutoWeaveSchmRptCollection(view);
        if (coll != null && !coll.isEmpty()) {
            this.cmbSolution.addItems(coll.toArray());
            RptAutoWeaveSchmBaseInfo selectedInfo = (RptAutoWeaveSchmBaseInfo)this.getUIContext().get("solution");
            String id = selectedInfo.getId().toString();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)it.next();
                String schmRptId = schmRptInfo.getId().toString();
                if (!id.equals(schmRptId)) continue;
                this.cmbSolution.setSelectedItem((Object)schmRptInfo, false);
                RptPeriodTypeEnum periodType = schmRptInfo.getTemplateEtries().get(0).getTemplate().getPeriodType();
                this.cmbRptPeriodType.setSelectedItem((Object)periodType);
            }
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (!this.confirmRemove()) {
            SysUtil.abort();
        }
        RptProperties condition = new RptProperties();
        String schmId = ((RptAutoWeaveSchmRptInfo)this.cmbSolution.getSelectedItem()).getId().toString();
        String currencyId = ((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString();
        int year = Integer.valueOf(this.txtYear.getText());
        int period = Integer.valueOf(this.txtPeriod.getText());
        int periodType = ((RptPeriodTypeEnum)this.cmbRptPeriodType.getSelectedItem()).getValue();
        int status = 0;
        if (this.ckAudit.isSelected() && !this.ckCommit.isSelected()) {
            status = 1;
        } else if (!this.ckAudit.isSelected() && this.ckCommit.isSelected()) {
            status = 2;
        } else if (this.ckAudit.isSelected() && this.ckCommit.isSelected()) {
            status = 3;
        }
        condition.setString("schmId", schmId);
        condition.setInt("periodType", periodType);
        condition.setInt("year", year);
        condition.setInt("period", period);
        condition.setString("currencyId", currencyId);
        condition.setInt("status", status);
        this.isDel = RptAutoWeaveSchmBaseFactory.getRemoteInstance().qucikDeleteRptBySchm(condition);
        this.isCancel = "false";
        this.destroyWindow();
    }

    protected boolean confirmRemove() {
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"confirmQuickDelete") + "\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"confirmDesc");
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = "true";
        this.destroyWindow();
    }

    @Override
    protected void cmbSolution_actionPerformed(ActionEvent e) throws Exception {
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.cmbSolution.getSelectedItem();
        String currencyId = schmRptInfo.getLastCalculateCurrency();
        Timestamp lastCalTime = schmRptInfo.getLastCalculateTime();
        RptPeriodTypeEnum periodType = schmRptInfo.getTemplateEtries().get(0).getTemplate().getPeriodType();
        this.cmbRptPeriodType.setSelectedItem((Object)periodType);
        this.changeCurrencyBySchmRpt(currencyId);
        if (lastCalTime != null) {
            this.dpkRptDate.setValue((Object)this.dateFormat.parse(this.dateFormat.format(lastCalTime)));
        }
    }

    @Override
    protected void dpkRptDate_dataChanged(DataChangeEvent e) throws Exception {
        this.changeDate();
    }

    private void changeDate() throws ParseException {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbRptPeriodType.getSelectedItem();
        Date date = (Date)this.dpkRptDate.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        if (1 != periodType.getValue()) {
            int year = calendar.get(1);
            int period = calendar.get(2) + 1;
            if (2 == periodType.getValue()) {
                period = calendar.get(3);
            } else if (4 == periodType.getValue()) {
                period = period < 4 ? 1 : (period > 3 && period < 7 ? 2 : (period > 6 && period < 10 ? 3 : 4));
            } else if (5 == periodType.getValue()) {
                period = period < 7 ? 1 : 2;
            }
            Date lastDayByDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            this.dpkRptDate.setValue((Object)this.dateFormat.parse(this.dateFormat.format(lastDayByDate)), false);
            this.txtYear.setText(String.valueOf(year));
            this.txtPeriod.setText(String.valueOf(period));
        } else {
            int year = calendar.get(1);
            int period = calendar.get(6);
            this.txtYear.setText(String.valueOf(year));
            this.txtPeriod.setText(String.valueOf(period));
        }
    }

    private void changeCurrencyBySchmRpt(String currencyId) {
        if (currencyId != null) {
            int itemCount = this.cmbCurrency.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getItemAt(i);
                String curcyId = currency.getId().toString();
                if (!currencyId.equals(curcyId)) continue;
                this.cmbCurrency.setSelectedItem((Object)currency);
            }
        }
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.isCancel != null && this.isCancel.equals("false") && (owner = this.getUIContext().get("Owner")) instanceof RptAutoWeaveReportUI) {
            try {
                ((RptAutoWeaveReportUI)((Object)owner)).isForceFresh = true;
                ((RptAutoWeaveReportUI)((Object)owner)).refresh();
                if (this.isDel) {
                    ((RptAutoWeaveReportUI)((Object)owner)).showSuccessMsg();
                } else {
                    ((RptAutoWeaveReportUI)((Object)owner)).showEmptyMsg();
                }
            }
            catch (Exception e1) {
                super.handUIException((Throwable)e1);
            }
        }
        return super.destroyWindow();
    }
}

