/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DiffTableProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.dynamic.client.GroupMultiRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.client.MultiSumRptProcessUI;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmDimInfo;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmRpt;
import com.kingdee.eas.fi.gr.weaverpt.LogTrace;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveFacadeFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.client.AbstractRptAutoWeaveReportUI;
import com.kingdee.eas.fi.gr.weaverpt.client.DefineTreeBase;
import com.kingdee.eas.fi.gr.weaverpt.client.DefineTreeBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.client.IFilterable;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveDetailLogUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptPermissionAction;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.IntegerConvert;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.KDTableUtilForRpt;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.EditUIKDComboBoxDataBinder;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.ObjectValueIDComparator;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.TableColorUIAction;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ProfReportProcessUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.RegisterWindowKeyListenerHelper;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptAutoWeaveReportUI
extends AbstractRptAutoWeaveReportUI {
    private static final long serialVersionUID = 8398415405127553713L;
    private static final Logger logger = CoreUIObject.getLogger(RptAutoWeaveReportUI.class);
    protected DefineTreeBase treeBase = this.createDefaultDefineTreeBase();
    private TableColorUIAction colorUIAction;
    private RptProperties condition = new RptProperties();
    private String preConditionSerial;
    private boolean isReceiveSchm = false;
    private Map schmInfoLastCalPeriodMap = new HashMap();
    private boolean isPeriodContolEnabled = false;
    public boolean isForceFresh = false;

    public RptAutoWeaveReportUI() throws Exception {
        HashMap<String, KDTextField> colorCtrls = new HashMap<String, KDTextField>();
        colorCtrls.put(RptWeaveLogSuccEnum.SUCCESS.getName(), this.txtSuccessNum);
        colorCtrls.put(RptWeaveLogSuccEnum.FAILED.getName(), this.txtFailureNum);
        colorCtrls.put(RptWeaveLogSuccEnum.EXCEUTING.getName(), this.txtExecutingNum);
        colorCtrls.put(RptWeaveLogSuccEnum.NOSTART.getName(), this.txtNoExecuteNum);
        this.colorUIAction = new TableColorUIAction(this.tblMain, colorCtrls, "ResultType");
        this.initEventListener();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setPageRowCount(100);
    }

    private void initEventListener() {
        ActionListener detailLogAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptAutoWeaveReportUI.this.showDetailLogUI();
            }
        };
        this.btnDetailLog.addActionListener(detailLogAction);
        this.menuItemDetailLog.addActionListener(detailLogAction);
        ActionListener typeRadioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptAutoWeaveReportUI.this.refresh();
            }
        };
        this.radioTreeDisplayByCompany.addActionListener(typeRadioActionListener);
        this.radioTreeDisplayByTpl.addActionListener(typeRadioActionListener);
        this.dpRptDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                RptAutoWeaveReportUI.this.schmInfoLastCalPeriodMap.clear();
                RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)RptAutoWeaveReportUI.this.comboPeriodType.getSelectedItem();
                if (1 != periodType.getValue()) {
                    Date date = (Date)RptAutoWeaveReportUI.this.dpRptDate.getValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.setTime(date);
                    int year = calendar.get(1);
                    int period = calendar.get(2) + 1;
                    if (2 == periodType.getValue()) {
                        period = calendar.get(3);
                    } else if (4 == periodType.getValue()) {
                        period = period < 4 ? 1 : (period > 3 && period < 7 ? 2 : (period > 6 && period < 10 ? 3 : 4));
                    } else if (5 == periodType.getValue()) {
                        period = period < 7 ? 1 : 2;
                    }
                    Date lastDayByDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
                    RptAutoWeaveReportUI.this.dpRptDate.setValue((Object)lastDayByDate, false);
                    RptAutoWeaveReportUI.this.dpRptDate.setUserObject((Object)lastDayByDate);
                }
                RptAutoWeaveReportUI.this.refresh();
            }
        });
        this.txtPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAutoWeaveReportUI.this.periodChanged(e);
            }
        });
        final TreeSelectionListener[] treeListeners = this.treeMain.getTreeSelectionListeners();
        int size = treeListeners.length;
        for (int i = 0; i < size; ++i) {
            this.treeMain.removeTreeSelectionListener(treeListeners[i]);
        }
        this.treeMain.putClientProperty((Object)"StopTreeSelectionListener", (Object)Boolean.TRUE);
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (RptAutoWeaveReportUI.this.treeMain.getClientProperty((Object)"StopTreeSelectionListener") == Boolean.TRUE) {
                    return;
                }
                int size = treeListeners.length;
                for (int i = 0; i < size; ++i) {
                    treeListeners[i].valueChanged(e);
                }
            }
        });
        RegisterWindowKeyListenerHelper.registerDebugLoggerKeyListener((CoreUI)this);
        RegisterWindowKeyListenerHelper.registerSQLWindowListener((CoreUI)this);
    }

    protected void periodChanged(ChangeEvent e) {
        try {
            this.refreshList();
        }
        catch (Exception e1) {
            logger.error((Object)"periodChanged_error", (Throwable)e1);
        }
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.removeMultiListener();
    }

    private void removeMultiListener() {
        EventListener[] fillListeners = this.tblMain.getListeners(KDTDataFillListener.class);
        if (fillListeners != null && fillListeners.length > 1) {
            for (int i = 1; i < fillListeners.length; ++i) {
                this.tblMain.removeKDTDataFillListener((KDTDataFillListener)fillListeners[i]);
            }
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.txtRptTotal.setOpaque(true);
        this.txtRptTotal.setCustomBackgroundColor(Color.WHITE);
        this.txtExecutingNum.setOpaque(true);
        this.txtNoExecuteNum.setOpaque(true);
        this.txtFailureNum.setOpaque(true);
        this.txtSuccessNum.setOpaque(true);
        this.txtRptTotal.setHorizontalAlignment(4);
        this.txtExecutingNum.setHorizontalAlignment(4);
        this.txtNoExecuteNum.setHorizontalAlignment(4);
        this.txtFailureNum.setHorizontalAlignment(4);
        this.txtSuccessNum.setHorizontalAlignment(4);
        this.btnGroupView.setVisible(false);
        this.btnGroupView.setEnabled(false);
        this.btnDetailLog.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.menuItemDetailLog.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.btnEdit.setVisible(true);
        this.actionEdit.setEnabled(true);
        this.menuEdit.setVisible(true);
        this.menuEdit.setEnabled(true);
        this.menuItemRemove.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
        this.menuItemGroupEdit.setVisible(false);
        this.menuItemGroupRemove.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.isReceiveSchm) {
            this.tblMain.getColumn("SchmType").getStyleAttributes().setHided(true);
        }
    }

    public void onLoad() throws Exception {
        this.onloadForSchmPeriodTypeCombo();
        this.onloadForSchmCombo();
        super.onLoad();
        this.tblMain.getColumn("TplVersionNum").getStyleAttributes().setHided(true);
        this.treeMain.putClientProperty((Object)"StopTreeSelectionListener", (Object)Boolean.FALSE);
        if (this.getUIContext().get("isReceiveSchm") != null) {
            this.isReceiveSchm = (Boolean)this.getUIContext().get("isReceiveSchm");
            if (this.isReceiveSchm) {
                this.btnEdit.setVisible(false);
                this.menuItemEdit.setVisible(false);
                this.actionQuickDeleteRpt.setVisible(false);
            }
        }
    }

    private void setdpRptDateValueByTheLastCalculateTime() {
        block8: {
            RptAutoWeaveSchmRptInfo currSchm = (RptAutoWeaveSchmRptInfo)this.cbxMain.getSelectedItem();
            if (currSchm != null && currSchm.getId() != null) {
                String schmId = currSchm.getId().toString();
                try {
                    RptAutoWeaveSchmRptInfo info = RptAutoWeaveSchmRptFactory.getRemoteInstance().getRptAutoWeaveSchmRptInfo("select lastCalculateTime,lastCalculateYear,lastCalculatePeriod where id = '" + schmId + "'");
                    if (info.getLastCalculateTime() != null) {
                        this.dpRptDate.setUserObject((Object)info.getLastCalculateTime());
                        RptPeriodTypeEnum periodType = currSchm.getTemplateEtries().get(0).getTemplate().getPeriodType();
                        this.comboPeriodType.setSelectedItem((Object)periodType);
                        this.dpRptDate.setValue((Object)info.getLastCalculateTime());
                        int year = info.getLastCalculateYear();
                        int period = info.getLastCalculatePeriod();
                        if (year != 0) {
                            this.txtYear.setText("" + year);
                            this.txtYear.setUserObject((Object)new Integer(year));
                            this.txtPeriod.setValue((Object)period, false);
                            if (3 == periodType.getValue()) {
                                this.schmInfoLastCalPeriodMap.put(schmId, period);
                            }
                        }
                        this.refresh();
                        break block8;
                    }
                    this.refresh();
                }
                catch (EASBizException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            } else {
                this.refresh();
            }
        }
    }

    private void onloadForSchmPeriodTypeCombo() {
        List periodTypes = RptPeriodTypeEnum.getEnumList();
        int size = periodTypes.size();
        for (int i = 0; i < size; ++i) {
            this.comboPeriodType.addItem(periodTypes.get(i));
        }
    }

    private void onloadForSchmCombo() throws BOSException {
        RptAutoWeaveSchmBaseCollection schmInfos = this.queryAllSchmInfo();
        this.cbxMain.removeAllItems();
        RptAutoWeaveSchmBaseInfo schmInfo = null;
        int size = schmInfos.size();
        for (int i = 0; i < size; ++i) {
            schmInfo = schmInfos.get(i);
            this.cbxMain.addItem((Object)schmInfo);
        }
        this.cbxMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptAutoWeaveReportUI.this.setdpRptDateValueByTheLastCalculateTime();
            }
        });
        String schmId = (String)this.getUIContext().get("SchmId");
        if (schmId != null) {
            RptAutoWeaveSchmBaseInfo info = new RptAutoWeaveSchmBaseInfo();
            info.setId(BOSUuid.read((String)schmId));
            new EditUIKDComboBoxDataBinder(this.cbxMain, new ObjectValueIDComparator()).setSelectedValue(info);
        }
    }

    private RptAutoWeaveSchmBaseCollection queryAllSchmInfo() throws BOSException {
        EntityViewInfo schmQuery = new EntityViewInfo();
        schmQuery.getSelector().add("id");
        schmQuery.getSelector().add("name");
        schmQuery.getSelector().add("periodType");
        schmQuery.getSelector().add("year");
        schmQuery.getSelector().add("period");
        schmQuery.getSelector().add("rptAutoWeaveSchmType");
        schmQuery.getSelector().add("currency");
        schmQuery.getSelector().add("organizationUnit.id");
        schmQuery.getSelector().add("templateEtries.template.id");
        schmQuery.getSelector().add("templateEtries.template.number");
        schmQuery.getSelector().add("templateEtries.template.name");
        schmQuery.getSelector().add("templateEtries.template.periodType");
        schmQuery.getSelector().add("templateEtries.template.templateType");
        schmQuery.getSelector().add("companyEntries.company.id");
        schmQuery.getSelector().add("companyEntries.company.number");
        schmQuery.getSelector().add("companyEntries.company.name");
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        schmQuery.setSorter(sort);
        FilterInfo filter = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int index = 0;
        if (this.getUIContext().get("isReceiveSchm") != null && ((Boolean)this.getUIContext().get("isReceiveSchm")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("isReceive", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("isSendBack", (Object)new Integer(1)));
            maskStr.append(" (#").append(index++).append(" or #").append(index++).append(")");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isReceive", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isSendBack", (Object)new Integer(0)));
            maskStr.append(" (#").append(index++).append(")");
            maskStr.append(" and (#").append(index++).append(")");
        }
        schmQuery.setFilter(filter);
        OrgType orgType = (OrgType)this.getUIContext().get("orgType");
        Object companyInfo = null;
        companyInfo = OrgType.ProfitCenter.equals((Object)orgType) ? SysContext.getSysContext().getCurrentOrgUnit() : SysContext.getSysContext().getCurrentFIUnit();
        String currComp = "";
        if (companyInfo != null) {
            currComp = companyInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("organizationUnit", (Object)currComp));
            if (index > 0) {
                maskStr.append(" and ");
            }
            maskStr.append(" #").append(index++);
        }
        if (maskStr.length() > 0) {
            filter.setMaskString(maskStr.toString());
        }
        RptAutoWeaveSchmBaseCollection schms = RptAutoWeaveSchmBaseFactory.getRemoteInstance().getCollectionForDimStyle(schmQuery);
        return schms;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return this.treeBase;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "RptId";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void buildTreeFilter() {
    }

    protected String getKeyFieldName() {
        return "TplNumber";
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        int from = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - from + 1;
        boolean isFirst = from <= 0;
        try {
            this.constructCondition();
            this.condition.setInt("from", from);
            this.condition.setInt("length", length);
            KDTreeNode treeNode = this.getSelectedTreeNode();
            if (treeNode != null && treeNode.getUserObject() instanceof IFilterable && ((IFilterable)treeNode.getUserObject()).createFilterInfo() == null) {
                this.tblMain.removeRows(false);
                return;
            }
            Map rstMap = RptAutoWeaveSchmBaseFactory.getRemoteInstance().queryReportNew(this.condition);
            this.condition = (RptProperties)rstMap.get("condition");
            if (isFirst) {
                this.setStatistic((int[])rstMap.get("statistic"));
            }
            RptRowSet rs = (RptRowSet)rstMap.get("result");
            KDTableUtil.insertRows((Object[][])this.wrappedCorrectData(rs), null, null, (int)from, (KDTable)this.tblMain);
            if (isFirst) {
                this.treeMain.expandAllNodes(true, (TreeNode)this.treeMain.getModel().getRoot());
            }
        }
        catch (Exception ex) {
            this.tblMain.setRowCount(0);
            this.handUIExceptionAndAbort(ex);
        }
    }

    private Object[][] wrappedCorrectData(RptRowSet rst) {
        Object[][] result = new Object[rst.getRowCount()][rst.getColumnCount()];
        if (result.length <= 0) {
            return result;
        }
        KDTColumns columns = this.tblMain.getColumns();
        int cols = Math.min(result[0].length, this.tblMain.getColumnCount());
        rst.reset();
        int row = 0;
        while (rst.next()) {
            for (int j = 0; j < cols; ++j) {
                String key = columns.getColumn(j).getKey();
                result[row][j] = rst.getObject(key);
            }
            ++row;
        }
        return result;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        LogTrace.recordTime();
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        IRow row = null;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            row = this.tblMain.getRow(i);
            Integer tplType = IntegerConvert.action(row.getCell("TplType").getValue());
            Integer rptCommittedStatus = IntegerConvert.action(row.getCell("RptCommittedStatus").getValue());
            Integer rptAuditedStatus = IntegerConvert.action(row.getCell("rptAuditedStatus").getValue());
            Integer resultType = IntegerConvert.action(row.getCell("ResultType").getValue());
            Integer tplPeriodType = IntegerConvert.action(row.getCell("TplPeriodType").getValue());
            Integer schmType = IntegerConvert.action(row.getCell("SchmType").getValue());
            if (tplType != null) {
                if (resultType != null && RptWeaveLogSuccEnum.NOSTART.getValue() == resultType.intValue()) {
                    row.getCell("TplType").setValue((Object)RptTmpTypeEnum.getEnum((int)tplType));
                    row.getCell("TplType").setUserObject((Object)RptTmpTypeEnum.getEnum((int)tplType));
                } else {
                    row.getCell("TplType").setValue((Object)RptSrcTypeEnum.getEnum((int)tplType));
                    row.getCell("TplType").setUserObject((Object)RptSrcTypeEnum.getEnum((int)tplType));
                }
            }
            if (rptCommittedStatus != null) {
                row.getCell("RptCommittedStatus").setValue((Object)CommittedStatusEnum.getEnum((int)rptCommittedStatus));
                row.getCell("RptCommittedStatus").setUserObject((Object)CommittedStatusEnum.getEnum((int)rptCommittedStatus));
            }
            if (rptAuditedStatus != null) {
                row.getCell("rptAuditedStatus").setValue((Object)AuditedStatusEnum.getEnum((int)rptAuditedStatus));
                row.getCell("rptAuditedStatus").setUserObject((Object)AuditedStatusEnum.getEnum((int)rptAuditedStatus));
            }
            if (resultType == null) {
                row.getCell("ResultType").setValue((Object)RptWeaveLogSuccEnum.NOSTART);
                row.getCell("ResultType").setUserObject((Object)RptWeaveLogSuccEnum.NOSTART);
            } else {
                row.getCell("ResultType").setValue((Object)RptWeaveLogSuccEnum.getEnum(resultType));
                row.getCell("ResultType").setUserObject((Object)RptWeaveLogSuccEnum.getEnum(resultType));
            }
            if (tplPeriodType != null) {
                row.getCell("TplPeriodType").setValue((Object)RptPeriodTypeEnum.getEnum((int)tplPeriodType));
                row.getCell("TplPeriodType").setUserObject((Object)RptPeriodTypeEnum.getEnum((int)tplPeriodType));
            }
            if (schmType == null) continue;
            row.getCell("SchmType").setValue((Object)RptWeaveSchmTypeEnum.getEnum(schmType));
            row.getCell("SchmType").setUserObject((Object)RptWeaveSchmTypeEnum.getEnum(schmType));
        }
        this.colorUIAction.color(null, firstIndex, lastIndex);
        LogTrace.printRecordTime("table fill time");
    }

    private void setStatistic(int[] statistic) {
        if (statistic == null) {
            return;
        }
        this.txtRptTotal.setText("" + statistic[4]);
        this.txtNoExecuteNum.setText("" + statistic[3]);
        this.txtExecutingNum.setText("" + statistic[2]);
        this.txtFailureNum.setText("" + statistic[0]);
        this.txtSuccessNum.setText("" + statistic[1]);
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        Object[] objs = new Object[]{new Integer(statistic[4])};
        String nexts = MessageFormat.format(msg, objs);
        this.setMessageBarText(nexts);
        this.setNextMessageText(nexts);
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(true);
    }

    protected RptWeaveSchmTypeEnum getSelectSchmType() {
        Object currSchm = this.cbxMain.getSelectedItem();
        if (currSchm instanceof RptAutoWeaveSchmBaseInfo) {
            return ((RptAutoWeaveSchmBaseInfo)currSchm).getRptAutoWeaveSchmType();
        }
        return null;
    }

    public boolean isIgnoreRowCount() {
        return true;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isForceFresh = true;
        super.actionRefresh_actionPerformed(e);
        this.isForceFresh = false;
    }

    protected boolean constructCondition() {
        Object currSchm = this.cbxMain.getSelectedItem();
        KDTreeNode treeNode = this.getSelectedTreeNode();
        FilterInfo treeNodeFilterInfo = null;
        if ((currSchm instanceof RptAutoWeaveSchmRptInfo || this.radioTreeDisplayByTpl.isSelected()) && treeNode != null && treeNode.getUserObject() instanceof IFilterable && (treeNodeFilterInfo = ((IFilterable)treeNode.getUserObject()).createFilterInfo()) != null) {
            this.condition.setString("KEY_VIEW", this.radioTreeDisplayByTpl.isSelected() ? "KEY_VIEW_TMPL" : "KEY_VIEW_ORG");
            FilterItemCollection filtercol = treeNodeFilterInfo.getFilterItems();
            for (int k = 0; k < filtercol.size(); ++k) {
                FilterItemInfo filterItem = filtercol.get(k);
                this.condition.setString(filterItem.getPropertyName(), filterItem.getCompareValue().toString());
            }
            if (filtercol.size() == 1) {
                if (this.radioTreeDisplayByTpl.isSelected()) {
                    this.condition.setString("SchmTplID", "ALL");
                } else {
                    this.condition.setString("CompID", "ALL");
                }
            }
        }
        if (treeNodeFilterInfo == null && this.getUIContext().get("SchmId") instanceof String) {
            this.condition.setString("SchmId", (String)this.getUIContext().get("SchmId"));
        }
        if (!(this.txtYear.getUserObject() instanceof Integer) || !(this.txtPeriod.getValue() instanceof Integer)) {
            return false;
        }
        this.condition.setInt("year", (Integer)this.txtYear.getUserObject());
        this.condition.setInt("period", (Integer)this.txtPeriod.getValue());
        this.condition.setInt("periodType", ((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()).getValue());
        String currencyId = "";
        try {
            if (this.getUIContext().get("SchmId") instanceof String) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("lastCalculateCurrency"));
                sic.add(new SelectorItemInfo("companyEntries.id"));
                sic.add(new SelectorItemInfo("companyEntries.company.id"));
                sic.add(new SelectorItemInfo("companyEntries.company.number"));
                IRptAutoWeaveSchmRpt iSchmRpt = RptAutoWeaveSchmRptFactory.getRemoteInstance();
                ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)((String)this.getUIContext().get("SchmId"))));
                RptAutoWeaveSchmRptInfo info = iSchmRpt.getRptAutoWeaveSchmRptInfo((IObjectPK)objectPK, sic);
                if (info.getLastCalculateCurrency() == null) {
                    if (info.getCompanyEntries() == null || info.getCompanyEntries().size() == 0) {
                        currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
                    } else {
                        String id = info.getCompanyEntries().get(0).getCompany().getId().toString();
                        currencyId = this.getBaseCurrency(id).getId().toString();
                    }
                } else {
                    currencyId = info.getLastCalculateCurrency();
                }
            } else {
                currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
            }
        }
        catch (Exception e) {
            logger.error((Object)"buildFilterFromUI", (Throwable)e);
        }
        this.condition.setString("currencyId", currencyId);
        if (this.getUIContext().get("isReceiveSchm") != null) {
            this.condition.setBoolean("isReceiveSchm", (Boolean)this.getUIContext().get("isReceiveSchm"));
        }
        this.needNewQuery();
        return true;
    }

    private void needNewQuery() {
        if (this.builterQueryConditionKey().equals(this.preConditionSerial) && !this.isForceFresh) {
            this.condition.setBoolean("KEY_IS_NEWQUERY", false);
        } else {
            this.condition.setBoolean("KEY_IS_NEWQUERY", true);
            this.preConditionSerial = this.builterQueryConditionKey();
        }
    }

    private String builterQueryConditionKey() {
        StringBuffer sb = new StringBuffer();
        this.warpeKey(sb, "SchmId", this.condition.getString("SchmId"));
        this.warpeKey(sb, "currencyId", this.condition.getString("currencyId"));
        this.warpeKey(sb, "year", "" + this.condition.getInt("year"));
        this.warpeKey(sb, "period", "" + this.condition.getInt("period"));
        this.warpeKey(sb, "periodType", "" + this.condition.getInt("periodType"));
        return sb.toString();
    }

    private void warpeKey(StringBuffer sb, String key, String val) {
        sb.append("[").append(key).append("=").append(val).append("]");
    }

    private CurrencyInfo getBaseCurrency(String companyId) {
        FullOrgUnitInfo fullOrgUnitInfo = null;
        ObjectStringPK pk = new ObjectStringPK(companyId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("partFI.id"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.id"));
        try {
            fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk, selector);
        }
        catch (Exception e) {
            return CslClientHelper.getCUNaturalCurrency();
        }
        return fullOrgUnitInfo.getPartFI().getBaseCurrency();
    }

    protected String getRootName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        return new CommonQueryDialog(){

            public boolean show() {
                return true;
            }

            public EntityViewInfo getEntityViewInfoResult() {
                return new EntityViewInfo();
            }
        };
    }

    public boolean showDetailLogUI() {
        UIContext uiContext = new UIContext((Object)this);
        List[] tplAndCompIds = KDTableUtilForRpt.getSelectedFieldsValueBy(this.tblMain, new String[]{"LogTplId", "CompId"});
        if (tplAndCompIds.length > 0) {
            int size = tplAndCompIds.length;
            for (int i = 0; i < size; ++i) {
                if (tplAndCompIds[i].size() == 2) continue;
                return false;
            }
        } else {
            return false;
        }
        RptAutoWeaveSchmBaseInfo currSchm = (RptAutoWeaveSchmBaseInfo)this.cbxMain.getSelectedItem();
        uiContext.put((Object)"ID", (Object)currSchm.getId());
        uiContext.put(RptAutoWeaveSchmBaseInfo.class, (Object)currSchm);
        uiContext.put((Object)"tplAndCompIds", (Object)tplAndCompIds);
        uiContext.put((Object)"year", this.txtYear.getUserObject());
        uiContext.put((Object)"period", this.txtPeriod.getValue());
        uiContext.put((Object)"isOnlyDisplayError", (Object)this.menuItemIsOnlyDisplayError.isSelected());
        uiContext.put((Object)"SchmType", (Object)currSchm.getRptAutoWeaveSchmType());
        uiContext.put((Object)"canResize", (Object)"true");
        int winStyle = 66;
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptAutoWeaveDetailLogUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, winStyle);
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
        uiWindow.show();
        return true;
    }

    private DefineTreeBase createDefaultDefineTreeBase() {
        return new DefineTreeBase(new DefineTreeBaseInfo("", 0, "", null, null));
    }

    protected void refreshBySchm(RptAutoWeaveSchmBaseInfo currSchm, Object[] currRptYearAndPeriodType) {
        this.getUIContext().put("SchmId", currSchm.getId().toString());
        try {
            if (currRptYearAndPeriodType == null) {
                return;
            }
            int year = (Integer)currRptYearAndPeriodType[0];
            int period = (Integer)currRptYearAndPeriodType[1];
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)currRptYearAndPeriodType[2];
            if (periodType != null) {
                currSchm.setPeriodType(periodType);
                if (3 == periodType.getValue()) {
                    if (period >= 12 && CslRptUtil.isSupport13Period(null)) {
                        this.txtPeriod.setEnabled(true);
                        CslRptUIUtil.setSpineRange(this.txtPeriod, 12, 13, false, true);
                        this.isPeriodContolEnabled = true;
                    } else {
                        this.periodContolUnEnabled();
                    }
                } else {
                    this.periodContolUnEnabled();
                }
            } else {
                this.periodContolUnEnabled();
            }
            Date rptDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            this.dpRptDate.setValue((Object)rptDate, false);
            this.dpRptDate.setUserObject((Object)rptDate);
            this.txtYear.setText("" + year);
            this.txtYear.setUserObject((Object)new Integer(year));
            this.txtPeriod.setValue(this.schmInfoLastCalPeriodMap.containsKey(currSchm.getId().toString()) ? this.schmInfoLastCalPeriodMap.get(currSchm.getId().toString()) : Integer.valueOf(period), false);
            this.comboPeriodType.setSelectedItem((Object)periodType);
            DefineTreeBaseInfo rootNode = new DefineTreeBaseInfo(currSchm.getName(), 0, "L", null, new FilterItemInfo("SchmId", (Object)currSchm.getId()));
            List childs = rootNode.getChilds();
            if (this.radioTreeDisplayByCompany.isSelected()) {
                if (currSchm instanceof IRptAutoWeaveSchmDimInfo) {
                    IObjectCollection orgUnits = ((IRptAutoWeaveSchmDimInfo)((Object)currSchm)).getOrgUnit();
                    if (currSchm instanceof RptWeaveSchmSumInfo) {
                        HashSet<Object> companyIds = new HashSet<Object>();
                        int size = orgUnits.size();
                        for (int i = 0; i < size; ++i) {
                            companyIds.add(orgUnits.getObject(i).get("id"));
                        }
                        IRowSet rs = RptAutoWeaveFacadeFactory.getRemoteInstance().queryOrgUnits(companyIds, ((RptWeaveSchmSumInfo)currSchm).getOrgBound().getNumber(), rptDate);
                        String compOrUnitId = null;
                        String compOrUnitName = null;
                        String structureLongNumber = null;
                        ArrayList<DefineTreeBaseInfo> treeNode = new ArrayList<DefineTreeBaseInfo>();
                        treeNode.add(rootNode);
                        FilterInfo filterInfo = null;
                        while (rs.next()) {
                            int checkIndex;
                            compOrUnitId = rs.getString("compOrUnitId");
                            compOrUnitName = rs.getString("compOrUnitName");
                            structureLongNumber = rs.getString("structureLongNumber");
                            LogTrace.trace("hebingdanyuanzu be find", compOrUnitName + "(" + compOrUnitId + "," + structureLongNumber + ")");
                            filterInfo = new FilterInfo();
                            filterInfo.getFilterItems().add(new FilterItemInfo("CompID", (Object)compOrUnitId));
                            filterInfo.getFilterItems().add(new FilterItemInfo("SchmId", (Object)currSchm.getId()));
                            for (checkIndex = treeNode.size() - 1; checkIndex >= 0 && !("L!" + structureLongNumber).startsWith(((DefineTreeBaseInfo)treeNode.get(checkIndex)).getLongNumber()); --checkIndex) {
                                treeNode.remove(checkIndex);
                            }
                            if (checkIndex < 0) continue;
                            DefineTreeBaseInfo currTreeInfo = new DefineTreeBaseInfo(compOrUnitName, ((DefineTreeBaseInfo)treeNode.get(checkIndex)).getLevel() + 1, "L!" + structureLongNumber, BOSUuid.read((String)compOrUnitId), filterInfo);
                            ((DefineTreeBaseInfo)treeNode.get(checkIndex)).getChilds().add(currTreeInfo);
                            treeNode.add(currTreeInfo);
                        }
                    } else {
                        this.injectChildByOrgUnits(currSchm, childs, orgUnits);
                    }
                }
            } else {
                RptWeaveSchmTempEntryCollection tpls = currSchm.getTemplateEtries();
                TemplateInfo template = null;
                BOSUuid bosUuid = null;
                FilterInfo filterInfo = null;
                if (this.isReceiveSchm) {
                    ArrayList<TemplateInfo> normalList = new ArrayList<TemplateInfo>();
                    ArrayList<TemplateInfo> sumList = new ArrayList<TemplateInfo>();
                    ArrayList<TemplateInfo> consolList = new ArrayList<TemplateInfo>();
                    int size = tpls.size();
                    for (int i = 0; i < size; ++i) {
                        template = tpls.get(i).getTemplate();
                        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                            normalList.add(template);
                            continue;
                        }
                        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.SUMREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICSUMREPORT)) {
                            sumList.add(template);
                            continue;
                        }
                        if (!template.getTemplateType().equals((Object)RptTmpTypeEnum.CSLREPORT) && !template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT) && !template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLPORT)) continue;
                        consolList.add(template);
                    }
                    this.addChildsByRptType(rootNode, normalList, RptSrcTypeEnum.NORMAL.getAlias(), "L!NORMAL", currSchm.getId());
                    this.addChildsByRptType(rootNode, sumList, RptSrcTypeEnum.SUM.getAlias(), "L!SUM", currSchm.getId());
                    this.addChildsByRptType(rootNode, consolList, RptSrcTypeEnum.CONSOLIDATION.getAlias(), "L!CONSOLIDATION", currSchm.getId());
                } else {
                    int size = tpls.size();
                    for (int i = 0; i < size; ++i) {
                        template = tpls.get(i).getTemplate();
                        bosUuid = template.getId();
                        filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("SchmTplID", (Object)bosUuid));
                        filterInfo.getFilterItems().add(new FilterItemInfo("SchmId", (Object)currSchm.getId()));
                        childs.add(new DefineTreeBaseInfo(template.getName(), rootNode.getLevel() + 1, "L!" + i, bosUuid, filterInfo));
                    }
                }
            }
            this.treeBase.setRootNodeInfo(rootNode);
            this.initTree();
            this.treeMain.expandAllNodes(true, (TreeNode)this.treeMain.getModel().getRoot());
            this.treeMain.putClientProperty((Object)"StopTreeSelectionListener", (Object)Boolean.TRUE);
            this.treeMain.setSelectionRow(0);
            this.treeMain.putClientProperty((Object)"StopTreeSelectionListener", (Object)Boolean.FALSE);
            this.actionQuery_actionPerformed(null);
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
    }

    private void periodContolUnEnabled() {
        if (this.isPeriodContolEnabled) {
            this.txtPeriod.setEnabled(false);
            this.schmInfoLastCalPeriodMap.clear();
            CslRptUIUtil.setSpineRange(this.txtPeriod, 1, 366, false, true);
            this.isPeriodContolEnabled = false;
        }
    }

    private void injectChildByOrgUnits(RptAutoWeaveSchmBaseInfo currSchm, List childs, IObjectCollection orgUnits) {
        DefineTreeBaseInfo currTreeInfo = null;
        int size = orgUnits.size();
        for (int i = 0; i < size; ++i) {
            BOSUuid bosUuid = orgUnits.getObject(i).getBOSUuid("id");
            boolean containTreeChild = orgUnits.getObject(i).containsKey("treeChilds");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CompID", (Object)bosUuid));
            filterInfo.getFilterItems().add(new FilterItemInfo("SchmId", (Object)currSchm.getId()));
            currTreeInfo = new DefineTreeBaseInfo(orgUnits.getObject(i).getString("name"), 1, "L!" + i, bosUuid, filterInfo);
            childs.add(currTreeInfo);
            if (!containTreeChild) continue;
            IObjectCollection treeChilds = (IObjectCollection)orgUnits.getObject(i).get("treeChilds");
            this.injectChildByOrgUnits(currSchm, currTreeInfo.getChilds(), treeChilds);
        }
    }

    private Object[] createCurrRptDate(RptAutoWeaveSchmBaseInfo currSchm, Date rptDate) {
        if (currSchm.getTemplateEtries().isEmpty()) {
            return null;
        }
        RptPeriodTypeEnum periodType = currSchm.getTemplateEtries().get(0).getTemplate().getPeriodType();
        if (periodType == null) {
            return null;
        }
        if (rptDate != null) {
            int[] yearAndPeriod = RPTDateUtil.getPeriod(rptDate, periodType);
            return new Object[]{new Integer(yearAndPeriod[0]), new Integer(yearAndPeriod[1]), periodType, rptDate};
        }
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        if (currSchm.getPeriod() == 13) {
            boolean isSupport13Period = CSLParamUtil.isSupport13Period(null);
            times = RPTDate13Util.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), currSchm.getYear(), currSchm.getPeriod(), isSupport13Period);
        } else {
            times = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), currSchm.getYear(), currSchm.getPeriod());
        }
        Integer weaveYear = (Integer)times.get(0);
        Integer weavePeriod = (Integer)times.get(1);
        Date date = (Date)times.get(2);
        return new Object[]{new Integer(weaveYear), new Integer(weavePeriod), periodType, date};
    }

    public void refresh() {
        logger.info((Object)"execute refresh");
        RptAutoWeaveSchmBaseInfo currSchm = (RptAutoWeaveSchmBaseInfo)this.cbxMain.getSelectedItem();
        if (currSchm == null) {
            return;
        }
        Date rptDate = null;
        if (this.dpRptDate.getUserObject() != null) {
            rptDate = (Date)this.dpRptDate.getValue();
        }
        if (currSchm.getTemplateEtries().isEmpty()) {
            // empty if block
        }
        Object[] currRptYear = this.createCurrRptDate(currSchm, rptDate);
        this.refreshBySchm(currSchm, currRptYear);
        String dateTime = CslRptUIUtil.getNationalTimeFormatString();
        if (dateTime != null) {
            this.tblMain.getColumn("LogStartTime").getStyleAttributes().setNumberFormat(dateTime);
        }
    }

    protected void setQueryResultLines() {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String checkError;
        this.checkSelected();
        Object[] rpt = this.getSelectRpt();
        String rptId = (String)rpt[0];
        boolean isCslRpt = (Boolean)rpt[1];
        ReportBaseInfo report = this.getReportInfo(rptId, isCslRpt);
        ObjectUuidPK orgUnitPK = null;
        FullOrgUnitInfo orgUnit = null;
        if (report instanceof ReportInfo) {
            orgUnit = ((ReportInfo)report).getCompany();
            orgUnitPK = new ObjectUuidPK(orgUnit.getId());
        } else {
            orgUnit = ((CslReportInfo)report).getOrgUnit();
            orgUnitPK = new ObjectUuidPK(orgUnit.getId());
        }
        if (orgUnit != null && this.getUIContext().get("orgType") != null) {
            WktbContextFactory.getInstance().getRptContext((OrgType)this.getUIContext().get("orgType")).setCurrOrgUnitInfo((OrgUnitInfo)orgUnit);
        }
        if ((checkError = new RptPermissionAction().check(report.getSourceType(), (IObjectPK)orgUnitPK, report.getOrgType(), (ItemAction)this.actionView, "", "actionView")).length() > 0) {
            MsgBox.showError((String)checkError);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)rptId);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"isView", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)(this.isReceiveSchm ? Boolean.FALSE : Boolean.TRUE));
        String processUI = RptReportProcessUI.class.getName();
        OrgType orgType = report.getOrgType();
        if (orgType.equals((Object)OrgType.ProfitCenter)) {
            processUI = ProfReportProcessUI.class.getName();
        }
        if (this.isReceiveSchm && report instanceof CslReportInfo) {
            processUI = report.getSourceType() == RptSrcTypeEnum.NORMAL || report.getSourceType() == RptSrcTypeEnum.COMMITREPORT || report.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT ? GroupRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.SUM || report.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? SumRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.DIFFTABLE ? DiffTableProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT ? GroupMultiRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT ? MultiSumRptProcessUI.class.getName() : CslRptProcessUI.class.getName()))));
        }
        this.prepareUIContext(uiContext, e);
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(processUI, (Map)uiContext, null, OprtState.VIEW);
        window2.show();
    }

    private void addChildsByRptType(DefineTreeBaseInfo rootNode, List<TemplateInfo> tmeplates, String nodeName, String longNumber, BOSUuid schmId) {
        if (!tmeplates.isEmpty()) {
            DefineTreeBaseInfo normalNode = new DefineTreeBaseInfo(nodeName, rootNode.getLevel() + 1, longNumber, null, null);
            rootNode.getChilds().add(normalNode);
            int i = 0;
            List curChilds = normalNode.getChilds();
            FilterInfo filterInfo = null;
            BOSUuid bosUuid = null;
            for (TemplateInfo curTemplateInfo : tmeplates) {
                bosUuid = curTemplateInfo.getId();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("SchmTplID", (Object)bosUuid));
                filterInfo.getFilterItems().add(new FilterItemInfo("SchmId", (Object)schmId));
                curChilds.add(new DefineTreeBaseInfo(curTemplateInfo.getName(), rootNode.getLevel() + 2, longNumber + "!" + i, bosUuid, filterInfo));
                ++i;
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Object[] rpt = this.getSelectRpt();
        String rptId = (String)rpt[0];
        boolean isCslRpt = (Boolean)rpt[1];
        ReportBaseInfo report = this.getReportInfo(rptId, isCslRpt);
        ObjectUuidPK orgUnitPK = null;
        orgUnitPK = new ObjectUuidPK(report.getCompany().getId());
        String checkError = new RptPermissionAction().check(report.getSourceType(), (IObjectPK)orgUnitPK, report.getOrgType(), (ItemAction)this.actionEdit, "", "actionEdit");
        if (checkError.length() > 0) {
            MsgBox.showError((String)checkError);
            return;
        }
        super.requestObjectLock(rptId);
        if (AuditedStatusEnum.AUDITED.equals((Object)report.getAuditedStatus()) || CommittedStatusEnum.COMMITTED.equals((Object)report.getCommittedStatus())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"RPT_ISAuditOrCommit"));
            return;
        }
        FullOrgUnitInfo orgUnit = null;
        orgUnit = report instanceof ReportInfo ? ((ReportInfo)report).getCompany() : ((CslReportInfo)report).getOrgUnit();
        if (orgUnit != null && this.getUIContext().get("orgType") != null) {
            WktbContextFactory.getInstance().getRptContext((OrgType)this.getUIContext().get("orgType")).setCurrOrgUnitInfo((OrgUnitInfo)orgUnit);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)rptId);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"isView", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        String processUI = null;
        processUI = OrgType.ProfitCenter.equals((Object)report.getOrgType()) ? ProfReportProcessUI.class.getName() : RptReportProcessUI.class.getName();
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(processUI, (Map)uiContext, null, OprtState.EDIT);
        window2.show();
    }

    protected ReportBaseInfo getReportInfo(String reportID, boolean isCslRpt) throws Exception {
        if (StringUtils.isEmpty((String)reportID)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_NoReport")));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("orgType"));
        if (isCslRpt) {
            sic.add(new SelectorItemInfo("orunit.id"));
            sic.add(new SelectorItemInfo("orunit.number"));
            sic.add(new SelectorItemInfo("orunit.name"));
        }
        ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)reportID));
        if (isCslRpt) {
            return CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)objectPK);
        }
        IReport iReport = ReportFactory.getRemoteInstance();
        return iReport.getReportInfo((IObjectPK)objectPK, sic);
    }

    public int getRowCountFromDB() {
        return this.tblMain.getRowCount();
    }

    protected int getTreeInitialLevel() {
        return 10;
    }

    protected void initPopmenu() {
    }

    protected void initTree() throws Exception {
        super.initTree();
        this.treeMain.setShowPopMenuDefaultItem(false);
    }

    private Object[] getSelectRpt() throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow irow = this.tblMain.getRow(selectRows[0]);
        if (irow.getCell("RptId").getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_NoReport")));
        }
        String rptId = irow.getCell("RptId").getValue().toString();
        boolean isCslRpt = false;
        if (rptId != null) {
            try {
                BOSUuid id = BOSUuid.read((String)rptId);
                if (new CslReportInfo().getBOSType().equals((Object)id.getType())) {
                    isCslRpt = true;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"get report type error", (Throwable)ex);
            }
        }
        return new Object[]{rptId, isCslRpt};
    }

    @Override
    public void actionQuickDeleteRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuickDeleteRpt_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        Date date = (Date)this.dpRptDate.getValue();
        String year = this.txtYear.getText();
        String period = String.valueOf(this.txtPeriod.getValue());
        OrgType orgType = (OrgType)this.getUIContext().get("orgType");
        RptAutoWeaveSchmRptInfo currSchm = (RptAutoWeaveSchmRptInfo)this.cbxMain.getSelectedItem();
        uiContext.put((Object)"solution", (Object)currSchm);
        uiContext.put((Object)"date", (Object)date);
        uiContext.put((Object)"year", (Object)year);
        uiContext.put((Object)"period", (Object)period);
        uiContext.put((Object)"orgType", (Object)orgType);
        String ui = "com.kingdee.eas.fi.gr.weaverpt.client.QuickDeleteReportFilterUI";
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ui, (Map)uiContext, null, OprtState.EDIT);
        window2.show();
    }

    public void showSuccessMsg() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"successMsg"));
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.showMessage();
    }

    public void showEmptyMsg() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"emptyMsg"));
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.showMessage();
    }
}

