/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.weaverpt.DispatchCycleEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmCompEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmCompEntryInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.client.AbstractRptAutoWeaveRptSchmEditUI;
import com.kingdee.eas.fi.gr.weaverpt.client.ChooseTemplate;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveReportUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveSchmExcuteImmediatelyUI;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.EditUIKDButtonGroupDataBinder;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.EditUIKDComboBoxDataBinder;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.JobProcessDefDataBindImp;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.ObjectValueIDComparator;
import com.kingdee.eas.fi.gr.weaverpt.client.listener.DispatchPeriodSettingActionListener;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.ShowUIMessageAction;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAutoWeaveRptSchmEditUI
extends AbstractRptAutoWeaveRptSchmEditUI {
    private static final long serialVersionUID = -2691580393146887727L;
    private static final Logger logger = CoreUIObject.getLogger(RptAutoWeaveRptSchmEditUI.class);
    private Set netLocks = new HashSet();
    protected transient ShowUIMessageAction showMessageHandler = new ShowUIMessageAction((CoreUI)this);
    public boolean isErrorVerifyInput = false;
    private RptAutoWeaveSchmRptInfo old_editData = null;
    JobProcessDefDataBindImp jobProcessDefDataBindImp = null;

    public RptAutoWeaveRptSchmEditUI() throws Exception {
        this.kdtTemplateEntries.checkParsed(false);
        this.kdtCompanyEntries.checkParsed(false);
        this.kdtTemplateEntries.getStyleAttributes().setLocked(true);
        this.kdtCompanyEntries.getStyleAttributes().setLocked(true);
        this.kdtTemplateEntries.getSelectManager().setSelectMode(10);
        this.kdtCompanyEntries.getSelectManager().setSelectMode(10);
        this.radioOptionAutoFillAndCalc.setUserObject((Object)RptWeaveCalcTypeEnum.AUTOFILLANDCALC);
        this.radioOptionOnlyCalc.setUserObject((Object)RptWeaveCalcTypeEnum.ONLYCALC);
        this.dataBinder.registerBinding("calcType", (Component)new EditUIKDButtonGroupDataBinder(this.bgOptionCalcType), "selectedValue");
        this.dataBinder.registerBinding("currency", (Component)new EditUIKDComboBoxDataBinder(this.comboCurrency, new ObjectValueIDComparator()), "selectedValue");
        this.jobProcessDefDataBindImp = new JobProcessDefDataBindImp(this.taDispatchPeriod, (IUIObject)this, "RptAutoWeave", 0);
        this.dataBinder.registerBinding("jobProcessDef", (Component)this.jobProcessDefDataBindImp, "jobProcessDef");
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
    }

    public void onLoad() throws Exception {
        this.onLoadForCurrency();
        this.bindBtnAction();
        super.onLoad();
        this.registerListener();
        this.chkIsReceive.setVisible(false);
        this.btnDispatchPeriodSetting.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.btnMoveBegin.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveEnd.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAddTpl.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelTpl.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnStartExecute.setIcon(EASResource.getIcon((String)"imgTbtn_datatask_execute"));
        this.menuItemStartExecute.setIcon(EASResource.getIcon((String)"imgTbtn_datatask_execute"));
        this.btnExecuteReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuItemExecuteReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnChooseCompany.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDPanel1.setBounds(new Rectangle(13, 9, 577, 180));
        if (this.editData != null && "EDIT".equals(this.getOprtState())) {
            Uuid editLock = MutexUtil.setMutex("SchmEdit", this.editData.getId(), "ActionEdit");
            this.netLocks.add(editLock);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
    }

    protected void setOrgUnit() throws BOSException, EASBizException {
        try {
            if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
                this.editData.setOrganizationUnit(FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk));
            } else {
                this.editData.setOrganizationUnit(FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
            }
        }
        catch (Exception e) {
            this.editData.setOrganizationUnit(FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        }
    }

    private void registerListener() {
        this.chkIsAddNew.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAutoWeaveRptSchmEditUI.this.setMutualSelect(e);
            }
        });
        this.chkIsCopyPre.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAutoWeaveRptSchmEditUI.this.setMutualSelect(e);
            }
        });
    }

    private void setMutualSelect(ChangeEvent e) {
        if ("chkIsCopyPre".equals(((KDCheckBox)e.getSource()).getName())) {
            if (this.chkIsCopyPre.isSelected()) {
                this.chkIsAddNew.setSelected(false);
            }
        } else if (this.chkIsAddNew.isSelected()) {
            this.chkIsCopyPre.setSelected(false);
        }
    }

    private void bindBtnAction() {
        this.btnAddTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List tpls = new ChooseTemplate().open((Component)((Object)RptAutoWeaveRptSchmEditUI.this), true, RptAutoWeaveRptSchmEditUI.this.getChooseTemplateEntityView(), RptAutoWeaveRptSchmEditUI.this.btnAddTpl.getText(), RptAutoWeaveRptSchmEditUI.this.getChooseTemplateFilterProceccor(), RptAutoWeaveRptSchmEditUI.this.getChooseTemplateHiddenColumnSetting());
                RptAutoWeaveRptSchmEditUI.this.addTemplate(tpls);
            }
        });
        this.btnDelTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries);
                RptWeaveSchmTempEntryCollection entrys = (RptWeaveSchmTempEntryCollection)((Object)RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries.getUserObject());
                HashSet rowIdSet = (HashSet)RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                RptWeaveSchmTempEntryInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (RptWeaveSchmTempEntryInfo)RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getTemplate().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    RptAutoWeaveRptSchmEditUI.this.kdtTemplateEntries.removeRow(rowIndex);
                }
            }
        });
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.kdtTemplateEntries);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToTail();
            }
        });
        this.btnChooseCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewCompanyF7 f7 = CompanyF7Helper.getFICompanyF7ByOrgType((IUIObject)RptAutoWeaveRptSchmEditUI.this);
                RptAutoWeaveRptSchmEditUI.this.addCompany(f7);
            }
        });
        this.btnDelCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RptAutoWeaveRptSchmEditUI.this.canEdit()) {
                    return;
                }
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries);
                RptWeaveSchmCompEntryCollection entrys = (RptWeaveSchmCompEntryCollection)((Object)RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries.getUserObject());
                HashSet rowIdSet = (HashSet)RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                RptWeaveSchmCompEntryInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (RptWeaveSchmCompEntryInfo)RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getCompany().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    RptAutoWeaveRptSchmEditUI.this.kdtCompanyEntries.removeRow(rowIndex);
                }
            }
        });
        this.btnDispatchPeriodSetting.addActionListener((ActionListener)new DispatchPeriodSettingActionListener((Object)this, this.taDispatchPeriod, logger));
    }

    protected void addTemplate(List tpls) {
        int i;
        if (!this.canEdit() || tpls.isEmpty()) {
            return;
        }
        RptAutoWeaveSchmBaseCollection baseSchms = new RptAutoWeaveSchmBaseCollection();
        RptAutoWeaveSchmBaseInfo baseSchm = new RptAutoWeaveSchmBaseInfo();
        baseSchms.add(baseSchm);
        TemplateInfo tpl = null;
        RptWeaveSchmTempEntryInfo tempEntry = null;
        IRow row = null;
        HashSet<String> rowIdSet = new HashSet<String>();
        RptWeaveSchmTempEntryCollection entrys = (RptWeaveSchmTempEntryCollection)((Object)this.kdtTemplateEntries.getUserObject());
        for (i = 0; entrys != null && i < entrys.size(); ++i) {
            rowIdSet.add(entrys.get(i).getTemplate().getId().toString());
        }
        for (i = 0; i < tpls.size(); ++i) {
            tpl = (TemplateInfo)tpls.get(i);
            tempEntry = new RptWeaveSchmTempEntryInfo();
            tempEntry.setTemplate(tpl);
            if (rowIdSet.contains(tpl.getId().toString())) continue;
            row = this.kdtTemplateEntries.addRow();
            row.setUserObject((Object)tempEntry);
            BindingUtility.loadDataToTableLine((int)row.getRowIndex(), (IObjectValue)tempEntry, (KDTable)this.kdtTemplateEntries, null, (DataComponentMap)this.getDataBinder().getDataComponentMap());
            rowIdSet.add(tpl.getId().toString());
            entrys = (RptWeaveSchmTempEntryCollection)((Object)this.kdtTemplateEntries.getUserObject());
            entrys.add(tempEntry);
        }
    }

    protected Map getChooseTemplateHiddenColumnSetting() {
        HashMap<String, Boolean> hiddenColumns = new HashMap<String, Boolean>();
        hiddenColumns.put("sumType", Boolean.TRUE);
        hiddenColumns.put("auditedStatus", Boolean.TRUE);
        hiddenColumns.put("isK3Tpl", Boolean.TRUE);
        return hiddenColumns;
    }

    private void onLoadForCurrency() {
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        this.comboCurrency.doLayout();
    }

    protected IProcessor getChooseTemplateFilterProceccor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (fieldProperty.equalsIgnoreCase("templateType")) {
                    KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                    for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                        RptTmpTypeEnum rptSrcType = (RptTmpTypeEnum)cmbxSourceType.getItemAt(i);
                        if (rptSrcType.getValue() == 6 || rptSrcType.getValue() == 10 || rptSrcType.getValue() == 15) continue;
                        cmbxSourceType.removeItemAt(i);
                    }
                } else if (fieldProperty.equalsIgnoreCase("sumType")) {
                    // empty if block
                }
            }
        };
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData == null) {
            this.actionStartExecute.setEnabled(false);
            this.actionRemoveSchedule.setEnabled(false);
            return;
        }
        int dispatchPeriod = this.editData.getDispatchPeriod();
        this.combTimeDispatch.setSelectedItem((Object)DispatchCycleEnum.getEnum(dispatchPeriod));
        try {
            if (this.editData.getOrganizationUnit() == null) {
                this.setOrgUnit();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.actionRemove.setEnabled(!"VIEW".equals(this.getOprtState()));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionRemove.setEnabled(false);
            this.actionRemoveSchedule.setEnabled(false);
        }
        this.actionCancelCancel.setEnabled(this.editData.isIsFreezed());
        this.actionCancel.setEnabled(!this.editData.isIsFreezed());
        if (this.editData.getJobProcessDef() != null) {
            this.actionRemoveSchedule.setEnabled(true);
        } else {
            this.actionRemoveSchedule.setEnabled(false);
        }
        this.actionStartExecute.setEnabled(!this.editData.isIsFreezed() && this.editData.getId() != null && "VIEW".equals(this.getOprtState()));
        this.actionEdit.setEnabled(this.editData.isIsFreezed() && "VIEW".equals(this.getOprtState()));
        this.txtName.setRequired(true);
        if ("EDIT".equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.taDispatchPeriod.setDirty(false);
    }

    protected void setTempEntryOrder() {
        RptWeaveSchmTempEntryCollection tpls = (RptWeaveSchmTempEntryCollection)((Object)this.kdtTemplateEntries.getUserObject());
        tpls.clear();
        IRow row = null;
        RptWeaveSchmTempEntryInfo tpl = null;
        int rowCount = this.kdtTemplateEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtTemplateEntries.getRow(i);
            if (!(row.getUserObject() instanceof RptWeaveSchmTempEntryInfo)) continue;
            tpl = (RptWeaveSchmTempEntryInfo)row.getUserObject();
            tpl.setSeq(i);
            row.getCell("tplSeq").setValue((Object)new Integer(i));
            tpls.add(tpl);
            this.editData.getTemplateEtries().add(tpl);
        }
    }

    protected void setCompEntryOrder() {
        RptWeaveSchmCompEntryCollection compEntry = (RptWeaveSchmCompEntryCollection)((Object)this.kdtCompanyEntries.getUserObject());
        compEntry.clear();
        RptWeaveSchmCompEntryInfo compInfo = null;
        for (int i = 0; i < this.kdtCompanyEntries.getRowCount(); ++i) {
            IRow row = this.kdtCompanyEntries.getRow(i);
            if (!(row.getUserObject() instanceof RptWeaveSchmCompEntryInfo)) continue;
            compInfo = (RptWeaveSchmCompEntryInfo)row.getUserObject();
            compEntry.add(compInfo);
            this.editData.getCompanyEntries().add(compInfo);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setEditDataBeforeSubmit();
        super.actionSubmit_actionPerformed(e);
    }

    protected void setEditDataBeforeSubmit() {
        this.setTempEntryOrder();
        this.setCompEntryOrder();
        int dispatchPeriod = ((DispatchCycleEnum)((Object)this.combTimeDispatch.getSelectedItem())).getValue();
        this.editData.setDispatchPeriod(dispatchPeriod);
        this.editData.setIsReceive(false);
        if ("EDIT".equals(this.getOprtState())) {
            String currencyName = EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"CURRENCY_NATIVE_CURRENCY");
            if (this.editData.getCurrency() != null && currencyName.equals(this.editData.getCurrency().getName())) {
                this.editData.setCurrency(null);
            }
        }
        try {
            if (this.editData.getOrganizationUnit() == null) {
                this.setOrgUnit();
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        StringBuffer errorMsg = this.verifyInput(this.editData);
        if (errorMsg.length() != 0) {
            this.isErrorVerifyInput = true;
            MsgBox.showWarning((Component)((Object)this), (String)errorMsg.toString());
            SysUtil.abort();
        } else {
            this.isErrorVerifyInput = false;
        }
        if (this.editData.get("name_l1") != null && this.editData.get("name_l2") == null && this.editData.get("name_l3") == null) {
            this.editData.put("name_l2", this.editData.get("name_l1"));
            this.editData.put("name_l3", this.editData.get("name_l1"));
        }
    }

    public StringBuffer verifyInput(RptAutoWeaveSchmRptInfo editData) {
        RptWeaveSchmTempEntryCollection tpls;
        boolean isReceiveSchm;
        StringBuffer errorMsg = new StringBuffer();
        if (StringUtils.isEmpty((String)editData.getNumber())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_SET_NOT_NULL_FOR_NUMBER"));
            errorMsg.append("\n");
        }
        if (StringUtils.isEmpty((String)editData.getName())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_SET_NOT_NULL_FOR_NAME"));
            errorMsg.append("\n");
        }
        if (!StringUtils.isEmpty((String)editData.getNumber()) && this.getStringLength(editData.getNumber()) > 80) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Number_LengthIsTooLong"));
            errorMsg.append("\n");
        }
        if (!StringUtils.isEmpty((String)editData.getName()) && this.getStringLength(editData.getName()) > 255) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Name_LengthIsTooLong"));
            errorMsg.append("\n");
        }
        boolean bl = isReceiveSchm = this.getUIContext().containsKey("isReceiveSchm") && (Boolean)this.getUIContext().get("isReceiveSchm") != false;
        if (!((isReceiveSchm || editData.isIsAddNew() || editData.isIsAduit() || editData.isIsCalc() || editData.isIsCommit() || editData.isIsCopyPre()) && (!isReceiveSchm || editData.isIsReceive() || editData.isIsSendBack()))) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_CHOOSE_AUTO_WEAVE_OPERATE"));
            errorMsg.append("\n");
        }
        if ((tpls = editData.getTemplateEtries()) == null || tpls.isEmpty()) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_CHOOSE_TEMPLATE"));
            errorMsg.append("\n");
        } else {
            RptPeriodTypeEnum samePeriodType = null;
            try {
                if (!tpls.isEmpty()) {
                    samePeriodType = tpls.get(0).getTemplate().getPeriodType();
                }
                int size = tpls.size();
                for (int i = 1; i < size; ++i) {
                    if (tpls.get(i).getTemplate().getPeriodType() == samePeriodType) continue;
                    errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_CHOOSE_TEMPLATE_SHOULD_SAME_PERIODTYPE"));
                    errorMsg.append("\n");
                    break;
                }
            }
            catch (NullPointerException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        RptWeaveSchmCompEntryCollection cmps = editData.getCompanyEntries();
        if (cmps == null || cmps.isEmpty()) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_CHOOSE_COMPANY"));
            errorMsg.append("\n");
        }
        return errorMsg;
    }

    private int getStringLength(String str) {
        int length = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < str.length(); ++i) {
            String temp = str.substring(i, i + 1);
            if (temp.matches(chinese)) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.taDispatchPeriod.setDirty(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsFreezed()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.WARN_ONLY_CANCEL_CAN_EDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        if (this.editData != null && "EDIT".equals(this.getOprtState())) {
            Uuid editLock = MutexUtil.setMutex("SchmEdit", this.editData.getId(), "ActionEdit");
            this.netLocks.add(editLock);
        }
    }

    @Override
    public void actionStartExecute_actionPerformed(ActionEvent ev) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        BOSUuid bosUuid = this.editData.getId();
        try {
            MutexUtil.checkMutex("SchmEdit", bosUuid, "ActionEdit");
        }
        catch (MutexException ex) {
            logger.warn((Object)"", (Throwable)((Object)ex));
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"NET_MUTEX_CANNOT_EXE_WHEN_EDIT"), true, true);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.editData.getId().toString());
        uiContext.put((Object)"SchmId", (Object)this.editData.getId().toString());
        uiContext.put((Object)"isFromReportSystem", (Object)String.valueOf(true));
        uiContext.put((Object)"showMessageHandler", (Object)this.showMessageHandler);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RptAutoWeaveSchmExcuteImmediatelyUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionExecuteReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExecuteReport_actionPerformed(e);
        if (!"VIEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState()) || this.editData.getId() == null) {
            return;
        }
        String schmId = this.editData.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)schmId);
        String schmName = this.editData.getName();
        uiContext.put((Object)"SchmName", (Object)schmName);
        uiContext.put((Object)"SchmId", (Object)schmId);
        if (this.getUIContext().containsKey("isReceiveSchm")) {
            uiContext.put((Object)"isReceiveSchm", this.getUIContext().get("isReceiveSchm"));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptAutoWeaveReportUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected IObjectValue createNewData() {
        RptAutoWeaveSchmRptInfo rptSchm = new RptAutoWeaveSchmRptInfo();
        rptSchm.setRptAutoWeaveSchmType(RptWeaveSchmTypeEnum.RPTSCHM);
        rptSchm.setIsFreezed(false);
        rptSchm.setIsAddNew(true);
        rptSchm.setIsAduit(true);
        rptSchm.setIsCalc(true);
        rptSchm.setIsCommit(true);
        rptSchm.setIsReceive(false);
        rptSchm.setCalcType(RptWeaveCalcTypeEnum.AUTOFILLANDCALC);
        return rptSchm;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptAutoWeaveSchmRptFactory.getRemoteInstance();
    }

    protected EntityViewInfo getChooseTemplateEntityView() {
        FilterInfo filter = new FilterInfo();
        StringBuffer debars = new StringBuffer();
        debars.append(6).append(",");
        debars.append(10).append(",");
        debars.append(15);
        StringBuffer maskString = new StringBuffer();
        int maskIndex = 0;
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)debars.toString(), CompareType.INNER));
        maskString.append(" #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        int orgTypeValue = 1;
        filter.getFilterItems().add(new FilterItemInfo("orgType", (Object)new Integer(orgTypeValue), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        Set<String> selectIds = this.getSelectTmpIds();
        if (!selectIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.NOTINCLUDE));
            maskString.append(" and #" + maskIndex++);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("number0");
        selector.add("templateType");
        selector.add("periodType");
        selector.add("orgType");
        view.setSelector(selector);
        logger.debug((Object)("[Weave]view:" + view));
        return view;
    }

    private Set<String> getSelectTmpIds() {
        HashSet<String> tmpIds = new HashSet<String>();
        Object id = null;
        for (int i = 0; i < this.kdtTemplateEntries.getRowCount(); ++i) {
            id = this.kdtTemplateEntries.getRow(i).getCell("tplId").getValue();
            if (id == null) continue;
            tmpIds.add(id.toString());
        }
        return tmpIds;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("id");
        selector.add("calcType");
        selector.add("isFreezed");
        selector.add("rptAutoWeaveSchmType");
        selector.add("jobProcessDef");
        selector.add("organizationUnit.id");
        selector.add("dispatchPeriod");
        return selector;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sqlSortInfo = new SorterItemInfo("templateEtries.seq");
        sqlSortInfo.setSortType(SortType.ASCEND);
        sorter.add(sqlSortInfo);
        return this.getBizInterface().getValue(pk, this.getSelectors(), sorter);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("VIEW".equals(this.oprtState)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionStartExecute.setEnabled(true);
            this.actionExecuteReport.setEnabled(true);
        } else if ("EDIT".equals(this.oprtState)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionStartExecute.setEnabled(false);
            this.actionExecuteReport.setEnabled(true);
        } else if ("ADDNEW".equals(this.oprtState)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionStartExecute.setEnabled(false);
            this.actionExecuteReport.setEnabled(false);
        }
        boolean canEdit = this.canEdit();
        this.radioOptionAutoFillAndCalc.setEnabled(canEdit);
        this.radioOptionOnlyCalc.setEnabled(canEdit);
    }

    protected void disposeUIWindow() {
        Object lock2 = null;
        for (Object lock2 : this.netLocks) {
            if (!(lock2 instanceof Uuid)) continue;
            MutexUtil.releaseMutex(lock2);
        }
        super.disposeUIWindow();
    }

    protected boolean canEdit() {
        return !"VIEW".equals(this.getOprtState());
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        try {
            this.getBizInterface().cancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        }
        catch (RptWeaveException e1) {
            logger.error((Object)"", (Throwable)((Object)e1));
            this.showMessageHandler.showMessage(e1.getMessage(), true, true);
            return;
        }
        this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"), true, true);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        try {
            this.getBizInterface().cancelCancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        }
        catch (RptWeaveException e1) {
            logger.error((Object)"", (Throwable)((Object)e1));
            this.showMessageHandler.showMessage(e1.getMessage(), true, true);
            return;
        }
        this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"), true, true);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.actionSubmit.setEnabled(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)this.getUIWindow();
            uiFrame.setResizable(false);
        }
    }

    protected void addCompany(NewCompanyF7 f7) {
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setMultiSelect(true);
        f7.setPermissionItem(null);
        RptWeaveSchmCompEntryCollection entrys = (RptWeaveSchmCompEntryCollection)((Object)this.kdtCompanyEntries.getUserObject());
        if (entrys != null) {
            HashSet<String> checkedOrgIds = new HashSet<String>();
            for (int i = 0; i < entrys.size(); ++i) {
                checkedOrgIds.add(entrys.get(i).getCompany().getId().toString());
            }
            f7.setSelectedOrgIds(checkedOrgIds);
        }
        f7.show();
        Object[] orgs = (Object[])f7.getData();
        if (!this.canEdit() || orgs == null) {
            return;
        }
        FullOrgUnitInfo org = null;
        RptWeaveSchmCompEntryInfo compEntry = null;
        for (int i = 0; i < orgs.length; ++i) {
            org = (FullOrgUnitInfo)orgs[i];
            compEntry = new RptWeaveSchmCompEntryInfo();
            compEntry.setCompany(org);
            entrys.add(compEntry);
        }
        this.deleteOldCompanyEntriesData();
        this.getDataBinder().bindDataToTable(this.kdtCompanyEntries, (IObjectCollection)entrys);
    }

    private void deleteOldCompanyEntriesData() {
        RptWeaveSchmCompEntryCollection entrys = (RptWeaveSchmCompEntryCollection)((Object)this.kdtCompanyEntries.getUserObject());
        HashSet rowIdSet = (HashSet)this.kdtCompanyEntries.getClientProperty((Object)"ROW_ID_SET");
        if (rowIdSet == null) {
            rowIdSet = new HashSet();
            this.kdtCompanyEntries.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
        }
        RptWeaveSchmCompEntryInfo entryInfo = null;
        for (int i = this.kdtCompanyEntries.getRowCount() - 1; i >= 0; --i) {
            entryInfo = (RptWeaveSchmCompEntryInfo)this.kdtCompanyEntries.getRow(i).getUserObject();
            rowIdSet.remove(entryInfo.getCompany().getId().toString());
            entrys.removeObject((IObjectValue)entryInfo);
            this.kdtCompanyEntries.removeRow(i);
        }
    }

    public boolean isModify() {
        boolean isModify = false;
        if (this.editData == null || this.getOprtState() == OprtState.VIEW) {
            return isModify;
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            return super.isModify();
        }
        this.storeFields();
        if (this.getOprtState() == OprtState.EDIT) {
            this.initOldEditData();
            isModify = this.compareEditData(this.old_editData, this.editData);
            if (isModify) {
                return isModify;
            }
            isModify = this.compareOrgUnitEntries(this.old_editData.getCompanyEntries(), this.editData.getCompanyEntries());
            if (isModify) {
                return isModify;
            }
            isModify = this.compareTemplateEntries(this.old_editData.getTemplateEtries(), this.editData.getTemplateEtries());
            if (isModify) {
                return isModify;
            }
            if (this.old_editData.getConvertSolution() != null && this.editData.getConvertSolution() != null && !this.old_editData.getConvertSolution().getId().toString().equals(this.editData.getConvertSolution().getId().toString())) {
                return true;
            }
        }
        return isModify;
    }

    private boolean compareTemplateEntries(RptWeaveSchmTempEntryCollection old_col, RptWeaveSchmTempEntryCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            int newSize = new_col.size();
            ArrayList<Boolean> isSameids = new ArrayList<Boolean>();
            block0: for (int i = 0; i < size; ++i) {
                RptWeaveSchmTempEntryInfo oldInfo = old_col.get(i);
                String oldid = oldInfo.getTemplate().getId().toString();
                for (int j = 0; j < newSize; ++j) {
                    RptWeaveSchmTempEntryInfo newInfo = new_col.get(j);
                    String newid = newInfo.getTemplate().getId().toString();
                    if (!newid.equals(oldid)) continue;
                    isSameids.add(Boolean.TRUE);
                    continue block0;
                }
            }
            if (isSameids.size() != size) {
                return true;
            }
        }
        return false;
    }

    private boolean compareEditData(RptAutoWeaveSchmRptInfo old_editData, RptAutoWeaveSchmRptInfo new_editData) {
        if (old_editData == null && new_editData == null) {
            return false;
        }
        if (!this.compareValue(old_editData.getNumber(), new_editData.getNumber())) {
            return true;
        }
        if (!this.compareValue(old_editData.getName(), new_editData.getName())) {
            return true;
        }
        if (!this.compareValue(old_editData.getDispatchPeriod(), new_editData.getDispatchPeriod())) {
            return true;
        }
        if (!this.compareValue(old_editData.getCurrency().getId().toString(), new_editData.getCurrency().getId().toString())) {
            return true;
        }
        if (!this.compareValue(old_editData.getDescription(), new_editData.getDescription())) {
            return true;
        }
        if (!this.compareValue(old_editData.getJobProcessDef(), new_editData.getJobProcessDef())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsAddNew(), new_editData.isIsAddNew())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsAduit(), new_editData.isIsAduit())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsCalc(), new_editData.isIsCalc())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsCommit(), new_editData.isIsCommit())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsCopyPre(), new_editData.isIsCopyPre())) {
            return true;
        }
        if (!this.compareValue(old_editData.isIsFreezed(), new_editData.isIsFreezed())) {
            return true;
        }
        if (!this.compareValue(old_editData.getPeriodType(), new_editData.getPeriodType())) {
            return true;
        }
        return !this.compareValue(old_editData.getOrgType(), new_editData.getOrgType());
    }

    private boolean compareOrgUnitEntries(RptWeaveSchmCompEntryCollection old_col, RptWeaveSchmCompEntryCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            for (int i = 0; i < size; ++i) {
                RptWeaveSchmCompEntryInfo oldInfo = old_col.get(i);
                RptWeaveSchmCompEntryInfo newInfo = new_col.get(oldInfo.getId());
                if (this.compareValue(oldInfo.getCompany().getId(), newInfo.getCompany().getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void initOldEditData() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.old_editData = RptAutoWeaveSchmRptFactory.getRemoteInstance().getRptAutoWeaveSchmRptInfo((IObjectPK)pk, this.getSelectors());
        }
        catch (Exception err) {
            super.handleException(err);
        }
    }

    protected boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (RptAutoWeaveRptSchmEditUI.isEmptyObject(value1) && RptAutoWeaveRptSchmEditUI.isEmptyObject(value2)) {
            return true;
        }
        if (RptAutoWeaveRptSchmEditUI.isEmptyObject(value1) || RptAutoWeaveRptSchmEditUI.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = this.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return this.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    @Override
    public void actionRemoveSchedule_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String jobProcessDefid = this.editData.getJobProcessDef();
        if (!StringUtils.isEmpty((String)jobProcessDefid)) {
            EnactmentServiceFactory.createRemoteEnactService().removeJobProcessDef(jobProcessDefid);
            this.editData.setJobProcessDef(null);
            this.editData.setIsAutoDispatch(false);
            SelectorItemCollection itemColl = new SelectorItemCollection();
            itemColl.add(new SelectorItemInfo("jobProcessDef"));
            itemColl.add(new SelectorItemInfo("isAutoDispatch"));
            RptAutoWeaveSchmRptFactory.getRemoteInstance().updatePartial((CoreBaseInfo)this.editData, itemColl);
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"removeScheduleSuccess"), true, true);
            if (this.jobProcessDefDataBindImp != null) {
                this.jobProcessDefDataBindImp.setJobProcessDef(null);
            }
            this.actionRemoveSchedule.setEnabled(false);
        } else {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"noSchedule"), true, true);
        }
    }
}

