/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmBase;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveFacadeFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.client.AbstractRptAutoWeaveSchmListUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveReportUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveRptSchmEditUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveSchmExcuteImmediatelyUI;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveSumSchmEditUI;
import com.kingdee.eas.fi.gr.weaverpt.client.UnionQueryEnumConvert;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.KDTableUtilForRpt;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.ShowUIMessageAction;
import com.kingdee.eas.fi.newrpt.client.util.CslRptLicenseUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RptAutoWeaveSchmListUI
extends AbstractRptAutoWeaveSchmListUI {
    private static final long serialVersionUID = -2492111768931712791L;
    private static final Logger logger = CoreUIObject.getLogger(RptAutoWeaveSchmListUI.class);
    private String currEditUIName = null;
    protected transient ShowUIMessageAction showMessageHandler = new ShowUIMessageAction((CoreUI)this);
    public final transient Object messageLock = new Object();
    private static final String ACTION_TRANSATIONSTATUSREPAIR_WINDOW = "transactionStatusRepair_window";

    public RptAutoWeaveSchmListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.gr.weaverpt", "RptAutoWeaveSchmRptNewQuery");
        this.tblMain.checkParsed(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){
            private UnionQueryEnumConvert enumConvert = new UnionQueryEnumConvert();

            public void afterDataFill(KDTDataRequestEvent e) {
                this.enumConvert.execute(RptAutoWeaveSchmListUI.this.tblMain, RptWeaveSchmTypeEnum.class, "rptAutoWeaveSchmType");
            }
        });
        this.tblMain.getSelectManager().setSelectMode(2);
        this.menuItemAddNewRptSchm.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnStartExecute.setIcon(EASResource.getIcon((String)"imgTbtn_datatask_execute"));
        this.menuItemStartExecute.setIcon(EASResource.getIcon((String)"imgTbtn_datatask_execute"));
        this.btnStopExecute.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
        this.menuItemStopExecute.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
        this.btnExecuteReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuItemExecuteReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.tblMain.getColumn("isAutoDispatch").getStyleAttributes().setHided(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
    }

    public void onLoad() throws Exception {
        CslRptLicenseUtils.reSetLicenseModuleNameByMenuParam((Map)this.getUIContext());
        super.onLoad();
        final IRptAutoWeaveSchmBase schmDao = RptAutoWeaveSchmBaseFactory.getRemoteInstance();
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                List[] rows = KDTableUtilForRpt.getSelectedFieldsValueBy(RptAutoWeaveSchmListUI.this.tblMain, new String[]{"isFreezed", "id"});
                if (rows.length == 1 && Boolean.TRUE.toString().equals(rows[0].get(0))) {
                    RptAutoWeaveSchmListUI.this.actionEdit.setEnabled(true);
                } else {
                    RptAutoWeaveSchmListUI.this.actionEdit.setEnabled(false);
                }
                boolean existFreezedRow = false;
                boolean allFreezedRow = true;
                int size = rows.length;
                for (int i = 0; i < size; ++i) {
                    if (Boolean.TRUE.toString().equals(rows[i].get(0))) {
                        existFreezedRow = true;
                        continue;
                    }
                    allFreezedRow = false;
                }
                RptAutoWeaveSchmListUI.this.actionStartExecute.setEnabled(!existFreezedRow);
                RptAutoWeaveSchmListUI.this.actionStopExecute.setEnabled(!existFreezedRow);
                RptAutoWeaveSchmListUI.this.actionRemove.setEnabled(allFreezedRow);
                RptAutoWeaveSchmListUI.this.actionCancel.setEnabled(!existFreezedRow);
                RptAutoWeaveSchmListUI.this.actionCancelCancel.setEnabled(allFreezedRow);
                try {
                    if (rows.length == 1 && schmDao.isRunningScheme((String)rows[0].get(1))) {
                        RptAutoWeaveSchmListUI.this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.SHOW_MSG_EXECUTING"), false, true);
                    } else {
                        RptAutoWeaveSchmListUI.this.showMessageHandler.showMessage("", false, false);
                    }
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.tblMain.getSelectManager().setSelectMode(2);
        String dateTime = CslRptUIUtil.getNationalTimeFormatString();
        if (dateTime != null) {
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("updateTime").getStyleAttributes().setNumberFormat(dateTime);
        }
        this.addDataRepairWindowKeyListener();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String isFreezed = KDTableUtilForRpt.getSelectedFieldValueBy(this.tblMain, "isFreezed");
        if (!Boolean.TRUE.toString().equals(isFreezed)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.WARN_ONLY_CANCEL_CAN_EDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List[] rows = KDTableUtilForRpt.getSelectedFieldsValueBy(this.tblMain, new String[]{"id", "name", "isFreezed"});
        StringBuffer errorSchmNames = new StringBuffer();
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE.toString().equals(rows[i].get(2))) continue;
            errorSchmNames.append(',');
            errorSchmNames.append(rows[i].get(1));
        }
        if (errorSchmNames.length() != 0) {
            errorSchmNames.deleteCharAt(0);
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.WARN_ONLY_ALL_CANCEL_CAN_EDIT"), errorSchmNames.toString());
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        BOSUuid bosUuid = BOSUuid.read((String)this.getSelectedKeyValue());
        try {
            MutexUtil.checkMutex("SchmEdit", bosUuid, "ActionEdit");
        }
        catch (MutexException e1) {
            logger.warn((Object)"", (Throwable)((Object)e1));
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.NET_MUTEX_CANNOT_DELETE_WHEN_EDIT"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() throws Exception {
        RealModeIDList selectIDs = new RealModeIDList();
        ArrayList ids = null;
        ids = this.getSelectedIdValues();
        String removeID = null;
        for (int i = 0; i < ids.size(); ++i) {
            selectIDs.add((String)ids.get(i));
        }
        StringBuffer errorDetailMSG = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        for (int i = selectIDs.size() - 1; i >= 0; --i) {
            errorDetailMSG.delete(0, errorDetailMSG.length());
            try {
                this.setOprtState("CANCEL");
                this.pubFireVOChangeListener(selectIDs.getLastID());
            }
            catch (Throwable ex) {
                logger.error((Object)"", ex);
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                errorDetailMSG.append("\n");
                continue;
            }
            try {
                removeID = selectIDs.getLastID();
                this.runCancel((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectIDs.getLastID())));
                this.pubFireVOChangeListener(selectIDs.getLastID());
                continue;
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)"", (Throwable)onfe);
                EASBizException ex = new EASBizException(EASBizException.CHECKEXIST);
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                errorDetailMSG.append("\n");
                continue;
            }
            catch (Throwable e1) {
                logger.error((Object)"", e1);
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)e1));
                errorDetailMSG.append("\n");
                continue;
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(selectIDs.getLastID());
                    selectIDs.remove(removeID, true);
                }
                catch (Throwable e1) {
                    logger.error((Object)"", e1);
                }
                if (errorDetailMSG.length() > 0) {
                    stack.push(errorDetailMSG.toString());
                }
            }
        }
        errorDetailMSG.delete(0, errorDetailMSG.length());
        while (!stack.isEmpty()) {
            errorDetailMSG.append(stack.pop());
        }
        if (errorDetailMSG.length() > 0) {
            this.showMessageHandler.showMessage(errorDetailMSG.toString(), true, true);
        } else {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANCEL_SUCCESS"), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelCancel() throws Exception {
        if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
            this.prepareCancelCancel(null).callHandler();
        }
        RealModeIDList selectIDs = new RealModeIDList();
        ArrayList ids = null;
        ids = this.getSelectedIdValues();
        String removeID = null;
        for (int i = 0; i < ids.size(); ++i) {
            selectIDs.add((String)ids.get(i));
        }
        StringBuffer errorDetailMSG = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        for (int i = selectIDs.size() - 1; i >= 0; --i) {
            errorDetailMSG.delete(0, errorDetailMSG.length());
            try {
                this.setOprtState("CANCELCANCEL");
                this.pubFireVOChangeListener(selectIDs.getLastID());
            }
            catch (Throwable ex) {
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                errorDetailMSG.append("\n");
                continue;
            }
            try {
                removeID = selectIDs.getLastID();
                this.runCancelCancel((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectIDs.getLastID())));
                this.pubFireVOChangeListener(selectIDs.getLastID());
                continue;
            }
            catch (ObjectNotFoundException onfe) {
                onfe.printStackTrace();
                EASBizException ex = new EASBizException(EASBizException.CHECKEXIST);
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                errorDetailMSG.append("\n");
                continue;
            }
            catch (Throwable e1) {
                e1.printStackTrace();
                errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)e1));
                errorDetailMSG.append("\n");
                continue;
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(selectIDs.getLastID());
                    selectIDs.remove(removeID, true);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
                if (errorDetailMSG.length() > 0) {
                    stack.push(errorDetailMSG.toString());
                }
            }
        }
        while (!stack.isEmpty()) {
            errorDetailMSG.append(stack.pop());
        }
        if (errorDetailMSG.length() > 0) {
            this.showMessageHandler.showMessage(errorDetailMSG.toString(), true, true);
        } else {
            String msg = "";
            try {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_ENABLE_SUCCESS");
            }
            catch (Exception e) {
                logger.error((Object)"cancelCancel---------", (Throwable)e);
            }
            this.showMessageHandler.showMessage(msg, true, true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
            this.prepareCancelCancel(null).callHandler();
        }
        this.cancelCancel();
        this.refresh(e);
    }

    @Override
    public void actionStartExecute_actionPerformed(ActionEvent ev) throws Exception {
        this.checkSelected();
        String schmId = this.getSelectedKeyValue();
        BOSUuid bosUuid = BOSUuid.read((String)schmId);
        try {
            MutexUtil.checkMutex("SchmEdit", bosUuid, "ActionEdit");
        }
        catch (MutexException ex) {
            logger.warn((Object)"", (Throwable)((Object)ex));
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"NET_MUTEX_CANNOT_EXE_WHEN_EDIT"), true, true);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)schmId);
        uiContext.put((Object)"SchmId", (Object)schmId);
        uiContext.put((Object)"isFromReportSystem", (Object)String.valueOf(true));
        uiContext.put((Object)"showMessageHandler", (Object)this.showMessageHandler);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RptAutoWeaveSchmExcuteImmediatelyUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionStopExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionStopExecute_actionPerformed(e);
        this.checkSelected();
        String isFreezed = KDTableUtilForRpt.getSelectedFieldValueBy(this.tblMain, "isFreezed");
        if (Boolean.TRUE.toString().equals(isFreezed)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.WARN_CANNOT_STOP_FOR_CANCEL"));
            return;
        }
        String schemeId = this.getSelectedKeyValue();
        Map resutlMap = RptAutoWeaveSchmBaseFactory.getRemoteInstance().abortSchemeTask(schemeId);
        if ("IsNoExceute".equals(resutlMap.get("IsSuccess"))) {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Rpt_Weave_Scheme_NoRun"), true, true);
        } else if ("true".equals(resutlMap.get("IsSuccess"))) {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_IsSuccess"), true, true);
        } else {
            List cannotAbortJobList = (List)resutlMap.get("cannotAbortJobList");
            List canAbortJobList = (List)resutlMap.get("canAbortJobList");
            int cannotAbortSize = 0;
            int canAbortSize = 0;
            if (cannotAbortJobList != null && cannotAbortJobList.size() > 0) {
                cannotAbortSize = cannotAbortJobList.size();
            }
            if (canAbortJobList != null && canAbortJobList.size() > 0) {
                canAbortSize = canAbortJobList.size();
            }
            int totle = cannotAbortSize + canAbortSize;
            if (canAbortSize > 0) {
                this.showMessageHandler.showMessage(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_Msg"), new Integer(totle), new Integer(canAbortSize)), true, true);
            } else {
                this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_IsError"), true, true);
            }
        }
    }

    @Override
    public void actionExecuteReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionExecuteReport_actionPerformed(e);
        String schmId = this.getSelectedKeyForAll();
        UIContext uiContext = this.getNewUIContext();
        uiContext.put((Object)"ID", (Object)schmId);
        String schmName = KDTableUtilForRpt.getSelectedFieldValueBy(this.tblMain, "name");
        uiContext.put((Object)"SchmId", (Object)schmId);
        uiContext.put((Object)"SchmName", (Object)schmName);
        uiContext.put((Object)"orgType", (Object)OrgType.Company);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptAutoWeaveReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected UIContext getNewUIContext() {
        return new UIContext((Object)this);
    }

    protected String getEditUIName() {
        String currId = this.getSelectedKeyValue();
        if (currId == null) {
            return RptAutoWeaveRptSchmEditUI.class.getName();
        }
        BOSUuid id = BOSUuid.read((String)currId);
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            return RptAutoWeaveRptSchmEditUI.class.getName();
        }
        return RptAutoWeaveSumSchmEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptAutoWeaveSchmBaseFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = this.getCUFilter(this.isIgnoreCUFilter());
        if (filter == null) {
            filter = new FilterInfo();
        }
        filter = this.getUIFilterForQuery(filter);
        return filter;
    }

    protected FilterInfo getUIFilterForQuery(FilterInfo filter) {
        StringBuffer filterMastStr = new StringBuffer();
        int index = 0;
        if (filter == null) {
            filter = new FilterInfo();
        } else {
            int filterItemCount = filter.getFilterItems().size();
            if (!StringUtils.isEmpty((String)filter.getMaskString())) {
                filterMastStr.append(filter.getMaskString());
            } else {
                for (int i = 0; i < filterItemCount; ++i) {
                    if (i > 0) {
                        filterMastStr.append(" and ");
                    }
                    filterMastStr.append("#").append(i);
                }
            }
            index = filterItemCount;
        }
        filter.getFilterItems().add(new FilterItemInfo("RPTSCHM.isReceive", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("RPTSCHM.isReceive", null, CompareType.IS));
        filter.getFilterItems().add(new FilterItemInfo("RPTSCHM.isSendBack", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("RPTSCHM.isSendBack", null, CompareType.IS));
        for (int i = 0; i < 2; ++i) {
            if (index > 0) {
                filterMastStr.append(" and ");
            }
            filterMastStr.append(" (#").append(index++).append(" or #").append(index++).append(")");
            filter.setMaskString(filterMastStr.toString());
        }
        return filter;
    }

    protected FilterInfo getCUFilter(boolean isIgnore) {
        FilterInfo filter = new FilterInfo();
        if (isIgnore) {
            return filter;
        }
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void actionAddNewRptSchm_actionPerformed(ActionEvent e) throws Exception {
        this.currEditUIName = RptAutoWeaveRptSchmEditUI.class.getName();
        super.actionAddNewRptSchm_actionPerformed(e);
        this.currEditUIName = RptAutoWeaveRptSchmEditUI.class.getName();
        super.actionAddNew_actionPerformed(e);
        this.currEditUIName = null;
    }

    @Override
    public void actionAddNewSumSchm_actionPerformed(ActionEvent e) throws Exception {
        this.currEditUIName = RptAutoWeaveSumSchmEditUI.class.getName();
        super.actionAddNewSumSchm_actionPerformed(e);
        this.currEditUIName = RptAutoWeaveRptSchmEditUI.class.getName();
        super.actionAddNew_actionPerformed(e);
        this.currEditUIName = null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            rowSet.beforeFirst();
            RptAutoWeaveSchmBaseCollection schmInfos = new RptAutoWeaveSchmBaseCollection();
            RptAutoWeaveSchmBaseInfo schmInfo = null;
            RptWeaveSchmTypeEnum rptWeaveSchmTypeEnum = RptWeaveSchmTypeEnum.RPTSCHM;
            while (rowSet.next()) {
                try {
                    if (rowSet.getString("rptAutoWeaveSchmType").equals(RptWeaveSchmTypeEnum.RPTSCHM.getAlias())) {
                        schmInfo = new RptAutoWeaveSchmRptInfo();
                        rptWeaveSchmTypeEnum = RptWeaveSchmTypeEnum.RPTSCHM;
                    } else if (rowSet.getString("rptAutoWeaveSchmType").equals(RptWeaveSchmTypeEnum.SUMRPTSCHM.getAlias())) {
                        schmInfo = new RptWeaveSchmSumInfo();
                        rptWeaveSchmTypeEnum = RptWeaveSchmTypeEnum.SUMRPTSCHM;
                    } else {
                        schmInfo = new RptAutoWeaveSchmBaseInfo();
                    }
                    schmInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    schmInfo.setNumber(rowSet.getString("number0"));
                    schmInfo.setName(rowSet.getString("name"));
                    schmInfo.setRptAutoWeaveSchmType(rptWeaveSchmTypeEnum);
                    schmInfo.setIsFreezed(rowSet.getBoolean("isFreezed"));
                    schmInfo.setIsAutoDispatch(rowSet.getBoolean("isAutoDispatch"));
                    schmInfo.setDescription(rowSet.getString("description"));
                    if (rowSet.getString("rptAutoWeaveSchmType").equals(RptWeaveSchmTypeEnum.SUMRPTSCHM.getAlias())) {
                        ((RptWeaveSchmSumInfo)schmInfo).setDependSchm(rowSet.getString("dependSchm.id"));
                    }
                    schmInfos.add(schmInfo);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            if (!schmInfos.isEmpty()) {
                this.tblMain.setUserObject((Object)schmInfos);
            }
            rowSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean destroyWindow() {
        CslRptLicenseUtils.reSetLicenseModuleNameByMenuParam((Map)this.getUIContext());
        return super.destroyWindow();
    }

    private void addDataRepairWindowKeyListener() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(84, 11);
            inputMap.put(keyStroke, ACTION_TRANSATIONSTATUSREPAIR_WINDOW);
            actionMap.remove(ACTION_TRANSATIONSTATUSREPAIR_WINDOW);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RptAutoWeaveSchmListUI.this.transationStatusRepair();
                }
            };
            actionMap.put(ACTION_TRANSATIONSTATUSREPAIR_WINDOW, action);
        }
    }

    private void transationStatusRepair() {
        this.checkSelected();
        String schmId = this.getSelectedKeyForAll();
        try {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.confirmRepairTransationStatus"));
            if (result == 0) {
                boolean isSuccess = RptAutoWeaveFacadeFactory.getRemoteInstance().transationStatusRepair(schmId);
                if (isSuccess) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.repairSuccess"));
                    return;
                }
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.repairFail"));
                return;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"transationStatusRepair---------", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"transationStatusRepair---------", (Throwable)e);
        }
    }
}

