/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import java.awt.event.ActionEvent;

public class RptAutoWeaveTableRowMoveAction {
    public static final int MOVE_STYLE_BEGIN = 1;
    public static final int MOVE_STYLE_UP = 2;
    public static final int MOVE_STYLE_DOWN = 3;
    public static final int MOVE_STYLE_END = 4;

    public void actionPerformed(ActionEvent e, KDTable table, int moveStyle) {
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)table);
        int rowIndex = 0;
        IRow row = null;
        int maxRowIndex = table.getRowCount() - 1;
        int canChangeRow = 0;
        if (this.isUp(moveStyle)) {
            canChangeRow = 0;
        } else if (this.isDown(moveStyle)) {
            canChangeRow = table.getRowCount() - 1;
        }
        boolean isNotCanChangeRow = true;
        int i = -1;
        while ((i = this.circle(i, maxRowIndex, moveStyle)) != -1) {
            rowIndex = selectRowIndexes[i];
            row = table.getRow(rowIndex);
            isNotCanChangeRow = rowIndex >= canChangeRow;
            --canChangeRow;
            if (isNotCanChangeRow) continue;
            table.moveRow(rowIndex, this.createMoveToRowIndex(rowIndex, maxRowIndex, moveStyle));
        }
    }

    private int circle(int i, int maxRowIndex, int moveStyle) {
        if (this.isUp(moveStyle)) {
            i = i == -1 ? 0 : ++i;
            if (i < maxRowIndex) {
                return i;
            }
        } else if (this.isDown(moveStyle)) {
            i = i == -1 ? maxRowIndex : --i;
            if (i >= maxRowIndex) {
                return i;
            }
        }
        return -1;
    }

    private boolean isDown(int moveStyle) {
        return moveStyle == 4 || moveStyle == 3;
    }

    private boolean isUp(int moveStyle) {
        return moveStyle == 1 || moveStyle == 2;
    }

    private int createMoveToRowIndex(int rowIndex, int maxRowIndex, int moveStyle) {
        switch (moveStyle) {
            case 1: {
                return 0;
            }
            case 4: {
                return maxRowIndex;
            }
            case 2: {
                return rowIndex - 1;
            }
            case 3: {
                return rowIndex + 1;
            }
        }
        return 0;
    }

    private int getFirstSelectRow(int[] selectRowIndexes) {
        return selectRowIndexes.length - 1;
    }

    private int getCanChangeRowIndex(KDTable table) {
        return table.getRowCount() - 1;
    }
}

