/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.weaverpt.LogTrace;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class RptPermissionAction {
    private static final Logger log = Logger.getLogger(RptPermissionAction.class);

    public String check(RptSrcTypeEnum sourceType, IObjectPK orgPK, OrgType rptOrgType, ItemAction action, String orgTreeId, String permItemAction) throws BOSException, EASBizException {
        String permItem_RptQuery;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        String perItem = null;
        IObjectPK CurOrgPK = null;
        boolean isProfitOrg = OrgType.ProfitCenter.equals((Object)rptOrgType);
        String permItem_CommView = "csl_indirpt_view";
        String string = permItem_RptQuery = isProfitOrg ? "prof_rpt_view" : "rpt_report_view";
        if ("actionEdit".equalsIgnoreCase(permItemAction)) {
            permItem_CommView = "csl_indirpt_update";
            String string2 = permItem_RptQuery = isProfitOrg ? "prof_rpt_update" : "rpt_report_update";
        }
        if (sourceType == RptSrcTypeEnum.NORMAL || sourceType == RptSrcTypeEnum.COMMITREPORT || sourceType == RptSrcTypeEnum.DYNAMICNORMALREPORT) {
            perItem = permItem_CommView;
            try {
                IPermission permission = PermissionFactory.getRemoteInstance();
                if (!isProfitOrg && permission.hasFunctionPermission((IObjectPK)userPK, orgPK, perItem) || permission.hasFunctionPermission((IObjectPK)userPK, orgPK, permItem_RptQuery)) {
                    LogTrace.trace("pass org's permission check when open rpt on report ui", "orgPK=" + orgPK);
                    return "";
                }
                if ("actionEdit".equalsIgnoreCase(permItemAction)) {
                    return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Permission_NoHas");
                }
                return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cbx_Null");
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                SysUtil.abort();
            }
        }
        try {
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, (String)perItem);
        }
        catch (Exception e) {
            if (CurOrgPK != null) {
                try {
                    PermissionHelper.checkFunctionPermission((IObjectPK)userPK, CurOrgPK, (String)perItem);
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            return e.getMessage();
        }
        return "";
    }
}

