/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.eas.fi.gr.cslrpt.RptReciveQueryStatusEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.rpt.ColorSchemeFactory;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableColorUIAction {
    private static final Logger log = Logger.getLogger(TableColorUIAction.class);
    private Map defaultColors;
    private KDTable table;
    private String statusColumnName;
    private Map colorCtrls;

    public TableColorUIAction(KDTable table, Map colorCtrls, String statusColumnName) {
        this.table = table;
        this.colorCtrls = colorCtrls;
        this.statusColumnName = statusColumnName;
        String uiClassName = "com.kingdee.eas.fi.gr.cslrpt.client.ReceiveListUI";
        try {
            this.defaultColors = new HashMap();
            Map receiveDefaultColors = ColorSchemeFactory.getRemoteInstance().getColorSchemesMap(uiClassName);
            this.defaultColors.put(RptWeaveLogSuccEnum.SUCCESS.getName(), receiveDefaultColors.get(RptReciveQueryStatusEnum.CONFIRMED.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.FAILED.getName(), receiveDefaultColors.get(RptReciveQueryStatusEnum.COMMITTED.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.EXCEUTING.getName(), receiveDefaultColors.get(RptReciveQueryStatusEnum.WEAVING.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.NOSTART.getName(), receiveDefaultColors.get(RptReciveQueryStatusEnum.UNWEAVE.getName()));
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public Map color(Map newColors) {
        if (newColors != null && !newColors.isEmpty()) {
            this.defaultColors = newColors;
        }
        HashMap<String, Integer> colorNums = new HashMap<String, Integer>();
        int noStartNum = 0;
        int executingNum = 0;
        int successNum = 0;
        int failureNum = 0;
        Iterator it = this.colorCtrls.keySet().iterator();
        RptWeaveLogSuccEnum colorType = null;
        KDTextField colorCtrl = null;
        while (it.hasNext()) {
            try {
                colorType = RptWeaveLogSuccEnum.getEnum((String)it.next());
                colorCtrl = (KDTextField)this.colorCtrls.get(colorType.getName());
                colorCtrl.setCustomBackgroundColor((Color)this.defaultColors.get(colorType.getName()));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        IRow row = null;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            row = this.table.getRow(i);
            ICell cell = row.getCell(this.statusColumnName);
            int reportStatus = -99;
            Object value = cell.getValue();
            Color color = null;
            if (value instanceof RptWeaveLogSuccEnum) {
                reportStatus = ((RptWeaveLogSuccEnum)((Object)value)).getValue();
            } else if (value instanceof Number) {
                reportStatus = ((Number)value).intValue();
            } else if (value instanceof BizEnumValueDTO) {
                reportStatus = Integer.parseInt((String)((BizEnumValueDTO)value).getValue());
            }
            if (reportStatus == 2) {
                color = (Color)this.defaultColors.get(RptWeaveLogSuccEnum.EXCEUTING.getName());
                ++executingNum;
            } else if (reportStatus == 0) {
                color = (Color)this.defaultColors.get(RptWeaveLogSuccEnum.FAILED.getName());
                ++failureNum;
            } else if (reportStatus == 1) {
                color = (Color)this.defaultColors.get(RptWeaveLogSuccEnum.SUCCESS.getName());
                ++successNum;
            } else {
                color = (Color)this.defaultColors.get(RptWeaveLogSuccEnum.NOSTART.getName());
                ++noStartNum;
            }
            row.getStyleAttributes().setBackground(color);
        }
        colorNums.put(RptWeaveLogSuccEnum.EXCEUTING.getName(), new Integer(executingNum));
        colorNums.put(RptWeaveLogSuccEnum.FAILED.getName(), new Integer(failureNum));
        colorNums.put(RptWeaveLogSuccEnum.SUCCESS.getName(), new Integer(successNum));
        colorNums.put(RptWeaveLogSuccEnum.NOSTART.getName(), new Integer(noStartNum));
        return colorNums;
    }
}

