/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client.assist;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.util.List;
import org.apache.log4j.Logger;

public class MutexUtil {
    private static final Logger log = Logger.getLogger(MutexUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMutex(String mutexHead, BOSUuid bosUuid, String actionName) throws MutexException {
        Uuid uuid = Uuid.create();
        try {
            MutexUtil.setMutex(uuid, mutexHead + bosUuid, actionName);
        }
        catch (MutexException e) {
            throw e;
        }
        catch (EASBizException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            MutexUtil.releaseMutex(uuid);
        }
    }

    public static Uuid setMutex(String mutexName, BOSUuid bosUuid, String actionName) throws MutexException {
        Uuid uuid = Uuid.create();
        if (bosUuid == null) {
            return uuid;
        }
        try {
            MutexUtil.setMutex(uuid, mutexName + bosUuid, actionName);
            return uuid;
        }
        catch (MutexException e) {
            throw e;
        }
        catch (EASBizException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (UuidException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
        return uuid;
    }

    public static Uuid setMutex(String mutexName, String actionName) throws EASBizException, BOSException {
        Uuid uuid = Uuid.create();
        MutexUtil.setMutex(uuid, mutexName, actionName);
        return uuid;
    }

    public static void setMutex(CoreUI ui, String id) {
        try {
            ui.pubFireVOChangeListener(id);
        }
        catch (Throwable ex) {
            ui.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static void releaseMutex(CoreUI ui) {
        try {
            ui.pubFireVOChangeListener(null);
        }
        catch (Throwable ex) {
            ui.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutexName, String actionName) {
        MutexParameter param = new MutexParameter();
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        param.setDcName(dcName);
        param.setRequestId(uuid);
        param.setMutexName(mutexName);
        param.setActionName(actionName);
        param.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        return param;
    }

    public static void requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        boolean isSuccess = mutexService.requestMutex(param);
        if (!isSuccess) {
            throw new MutexException();
        }
    }

    public static void setMutex(Uuid uuid, String mutexName, String actionName) throws EASBizException, BOSException {
        MutexParameter param = MutexUtil.setMutexParameter(uuid, mutexName, actionName);
        MutexUtil.requestMutex(param);
    }

    public static void releaseMutex(Uuid id) {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static void requestMutex(CoreUI ui, String id) {
        MutexUtil.setMutex(ui, id);
    }

    public static void requestMutex(CoreUI ui, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            MutexUtil.setMutex(ui, ids[i]);
        }
    }

    public static void requestMutex(CoreUI ui, List ids) {
        for (String id : ids) {
            MutexUtil.setMutex(ui, id);
        }
    }

    public static void releaseMutex(String id) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.releaseObjIDForUpdate(id);
    }

    public static void releaseMutex(List ids) {
        for (String id : ids) {
            MutexUtil.releaseMutex(id);
        }
    }

    public static void releaseMutex(String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            MutexUtil.releaseMutex(ids[i]);
        }
    }
}

