/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractDynaGradeSettingUI;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviser;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviserImpl;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.AsstGroupChooserPromptForOneRow;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DynaGradeSettingUI
extends AbstractDynaGradeSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(DynaGradeSettingUI.class);
    private static final String NEW = "NEW";
    private static final String SAVE = "SAVE";
    private static final String DELETE = "DELETE";
    private static final String PREVIEW = "PREVIEW";
    private static final String FILL = "FILL";
    private static final String IMPORT = "IMPORT";
    private static final String EXPORT = "EXPORT";
    private DynaGradeSettingAdviser adviser;
    private DItemGradeInfo info;
    private DynaParameters parameters;
    private boolean Modified = false;
    private Sheet sheet = null;

    public DynaGradeSettingUI() throws Exception {
        this.cmbIsDetail.addItems(IsCitedByLaterEnum.getEnumList().toArray());
        this.cmbIncludeUnknowDetail.addItems(IsCitedByLaterEnum.getEnumList().toArray());
        SpinnerNumberModel nm = (SpinnerNumberModel)this.cmbDetailCount.getModel();
        nm.setMinimum(new Integer(0));
        nm.setMaximum(new Integer(2048));
        nm = (SpinnerNumberModel)this.cmbIndent.getModel();
        nm.setMinimum(new Integer(0));
        nm.setMaximum(new Integer(2048));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initActions();
        this.initComboxs();
        this.tblMain.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblMain.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview2"));
        this.btnFill.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.txtNumber.setEditable(false);
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.txtParent.setEnabled(false);
        this.txtLevel.setEnabled(false);
        this.cmbBaseData.setEnabled(false);
        this.cmbBaseData.setSelectedIndex(-1);
        this.promptBaseData.setEnabled(false);
        this.promptBaseData.setData(null);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int top;
                if (e.getPrevSelectBlock() != null && e.getPrevSelectBlock().getMode() != 8) {
                    IRow row = DynaGradeSettingUI.this.tblMain.getRow(e.getPrevSelectBlock().getTop());
                    DynaGradeSettingUI.this.saveEntry(DynaGradeSettingUI.this.buildEntry((DItemGradeEntryInfo)row.getUserObject()), row);
                }
                if ((top = e.getSelectBlock().getTop()) > -1) {
                    DItemGradeEntryInfo entry = (DItemGradeEntryInfo)DynaGradeSettingUI.this.tblMain.getRow(top).getUserObject();
                    DynaGradeSettingUI.this.fillEntry2Detail(entry);
                } else {
                    DynaGradeSettingUI.this.clearDetail();
                }
            }
        });
        this.adviser = (DynaGradeSettingAdviser)this.getUIContext().get("ADVISER");
        this.info = this.adviser.fetch();
        this.parameters = this.adviser.fetchParameter();
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void hideAssistantSubType() {
        this.lbConAssistantSubType.setVisible(false);
    }

    private DItemGradeEntryInfo buildEntry(DItemGradeEntryInfo entry) {
        if (entry == null) {
            entry = new DItemGradeEntryInfo();
        }
        entry.setName(this.txtName.getText());
        String text = this.txtNumber.getText();
        entry.setNumber(text);
        entry.setGrade(text);
        entry.setLevel(StringUtils.isEmpty((String)text) ? 0 : text.split("\\.").length);
        entry.setLeaf((IsCitedByLaterEnum)this.cmbIsDetail.getSelectedItem() == IsCitedByLaterEnum.ISTRUE);
        entry.setIncludeUnknowDetail((IsCitedByLaterEnum)this.cmbIncludeUnknowDetail.getSelectedItem() == IsCitedByLaterEnum.ISTRUE);
        entry.setIndent(this.cmbIndent.getIntegerVlaue());
        entry.setDetailSource(this.cmbSource.getSelectedIndex());
        entry.setDetailCount(this.cmbDetailCount.getIntegerVlaue());
        AsstActTypeInfo element = (AsstActTypeInfo)this.cmbBaseData.getSelectedItem();
        if (element != null) {
            AsstActTypeUtils aatUtils = new AsstActTypeUtils(element.getNumber(), element.getName(), element.getAsstHGAttribute());
            entry.setDetailAsstType(aatUtils);
            this.setAssistantTypeSubTypeParameter(element, entry);
        }
        return entry;
    }

    private void setAssistantTypeSubTypeParameter(AsstActTypeInfo element, DItemGradeEntryInfo entry) {
        String attribute = element.getAsstHGAttribute();
        if (DynamicTemplateUtility.isBaseAsstActType(attribute) && this.promtAssistantSubType.getValue() != null) {
            if (!this.promtAssistantSubType.getValue().toString().equals("")) {
                entry.setAsstActSubTypeString(this.promtAssistantSubType.getValue().toString());
            } else {
                entry.setAsstActSubTypeString("all");
            }
        } else {
            entry.setAsstActSubTypeString("all");
        }
    }

    private DItemGradeInfo buildGradeInfo() {
        return this.info;
    }

    @Override
    public void loadFields() {
        if (this.info != null) {
            this.info = this.info.copy();
            this.info.reform();
            this.refresh(null);
        } else {
            this.info = new DItemGradeInfo();
            this.hideAssistantSubType();
        }
    }

    private void refresh(DItemGradeEntryInfo selected) {
        this.tblMain.removeRows();
        this.info.sort();
        List entries = this.info.getEntries();
        int pos = -1;
        for (int i = 0; i < entries.size(); ++i) {
            DItemGradeEntryInfo entry = (DItemGradeEntryInfo)entries.get(i);
            IRow row = this.tblMain.addRow();
            row.setUserObject((Object)entry);
            this.fillEntry2Table(entry, row);
            if (pos >= 0 || !entry.equals(selected)) continue;
            pos = i;
        }
        if (pos < 0) {
            pos = 0;
        }
        this.tblMain.scrollToVisible(pos, 0);
        this.tblMain.getSelectManager().select(pos, 0);
    }

    private void saveEntry(DItemGradeEntryInfo entry, IRow row) {
        row.setUserObject((Object)entry);
        this.fillEntry2Table(entry, row);
    }

    private void fillEntry2Detail(DItemGradeEntryInfo entry) {
        this.txtName.setText(entry.getName());
        this.txtNumber.setText(entry.getNumber());
        this.txtLevel.setText(String.valueOf(entry.getLevel()));
        this.txtParent.setText(entry.getParentGrade() == null ? "" : entry.getParentGrade().toString());
        this.cmbIsDetail.setSelectedItem((Object)(entry.isLeaf() ? IsCitedByLaterEnum.ISTRUE : IsCitedByLaterEnum.ISFALSE));
        this.cmbIndent.setValue((Object)new Integer(entry.getIndent()));
        this.cmbSource.setSelectedIndex(entry.getDetailSource());
        this.cmbDetailCount.setValue((Object)new Integer(entry.getDetailCount()));
        this.cmbIncludeUnknowDetail.setSelectedItem((Object)(entry.isIncludeUnknowDetail() ? IsCitedByLaterEnum.ISTRUE : IsCitedByLaterEnum.ISFALSE));
        this.setIncludeUnknowDetail(entry.isIncludeUnknowDetail());
        if (entry.getDetailSource() == 0) {
            this.cmbBaseData.setEnabled(false);
            this.promptBaseData.setEnabled(false);
            this.hideAssistantSubType();
        } else {
            if (entry.getDetailAsstType() == null) {
                return;
            }
            this.cmbBaseData.setEnabled(true);
            int i = 0;
            for (i = 0; i < this.cmbBaseData.getItemCount(); ++i) {
                AsstActTypeInfo info = (AsstActTypeInfo)this.cmbBaseData.getItemAt(i);
                if (entry.getDetailAsstType() == null) break;
                if (!info.getAsstHGAttribute().equals(entry.getDetailAsstType().getAsstHGAttribute())) continue;
                this.cmbBaseData.setSelectedIndex(i);
                break;
            }
            if (i == this.cmbBaseData.getItemCount()) {
                this.cmbBaseData.setSelectedIndex(-1);
            }
            this.promptBaseData.setEnabled(true);
            this.showAssistantSubTypeByCondition();
            this.setAssistantSubTypePromptByCondition(entry);
        }
    }

    private void setAssistantSubTypePromptByCondition(DItemGradeEntryInfo entry) {
        String attribute = entry.getDetailAsstType().getAsstHGAttribute();
        if (!StringUtils.isEmpty((String)attribute) && DynamicTemplateUtility.isBaseAsstActType(attribute)) {
            this.showAssistantSubType();
            this.setValueForAssisttantSubTypePrompt(entry);
        }
    }

    private void setValueForAssisttantSubTypePrompt(DItemGradeEntryInfo entry) {
        if (!entry.getAsstActSubTypeString().equals("all")) {
            if (this.promtAssistantSubType.getSelector() != null) {
                ((AsstGroupChooserPromptForOneRow)this.promtAssistantSubType.getSelector()).setInitData((Object)entry.getAsstActSubTypeString());
            }
            this.promtAssistantSubType.setValue((Object)entry.getAsstActSubTypeString());
        }
    }

    private void fillEntry2Table(DItemGradeEntryInfo entry, IRow row) {
        row.getCell("number").setValue((Object)entry.getNumber());
        row.getCell("name").setValue((Object)entry.getName());
        row.getCell("level").setValue((Object)new Integer(entry.getLevel()));
        row.getCell("parent").setValue((Object)entry.getParentGrade());
        row.getCell("isDetail").setValue((Object)new Boolean(entry.isLeaf()));
        row.getCell("includeUnknowDetail").setValue((Object)new Boolean(entry.isIncludeUnknowDetail()));
        row.getCell("subgradeCount").setValue((Object)new Integer(entry.getDetailCount()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initActions() {
        this.btnAddNew.addAssistMenuItem((Action)((Object)this.actionAddSubItem));
        this.actionAddSubItem.putValue("Name", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"12_DynaGradeSettingUI"));
        this.actionAddSubItem.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.btnAddNew.setActionCommand(NEW);
        this.btnSave.setActionCommand(SAVE);
        this.btnRemove.setActionCommand(DELETE);
        this.btnPreview.setActionCommand(PREVIEW);
        this.btnFill.setActionCommand(FILL);
        this.btnExport.setActionCommand(EXPORT);
        this.btnImport.setActionCommand(IMPORT);
        MainAction mainAction = new MainAction();
        this.btnAddNew.addActionListener((ActionListener)mainAction);
        this.btnSave.addActionListener((ActionListener)mainAction);
        this.btnRemove.addActionListener((ActionListener)mainAction);
        this.btnPreview.addActionListener((ActionListener)mainAction);
        this.btnFill.addActionListener((ActionListener)mainAction);
        this.btnExport.addActionListener((ActionListener)mainAction);
        this.btnImport.addActionListener((ActionListener)mainAction);
    }

    private void initComboxs() throws BOSException, EASBizException {
        this.cmbBaseData.removeAllItems();
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        FilterInfo filter = DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        viewInfo.setFilter(filter);
        CoreBaseCollection typeCollection = iAsstActType.getCollection(viewInfo);
        boolean hasAsstActPermssion = false;
        try {
            hasAsstActPermssion = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), "bd_accaux_asstActType_view");
        }
        catch (EASBizException e1) {
            hasAsstActPermssion = false;
        }
        if (hasAsstActPermssion) {
            for (AsstActTypeInfo element : typeCollection) {
                this.cmbBaseData.addItem((Object)element);
            }
        }
        this.cmbIsDetail.setSelectedItem((Object)IsCitedByLaterEnum.ISFALSE);
        this.cmbIsDetail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    boolean isDetail = e.getItem() == IsCitedByLaterEnum.ISTRUE;
                    DynaGradeSettingUI.this.ctrlStatus(isDetail);
                }
            }
        });
        this.cmbSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    boolean enable = DynaGradeSettingUI.this.cmbSource.getSelectedIndex() == 1;
                    DynaGradeSettingUI.this.cmbBaseData.setEnabled(enable);
                    DynaGradeSettingUI.this.promptBaseData.setEnabled(enable);
                    if (!enable) {
                        DynaGradeSettingUI.this.hideAssistantSubType();
                        DynaGradeSettingUI.this.promptBaseData.setData(null);
                    } else {
                        if (DynaGradeSettingUI.this.cmbBaseData.getSelectedIndex() < 0 && DynaGradeSettingUI.this.cmbBaseData.getItemCount() > 0) {
                            DynaGradeSettingUI.this.cmbBaseData.setSelectedIndex(0);
                        }
                        DynaGradeSettingUI.this.showAssistantSubTypeByCondition();
                    }
                }
            }
        });
        this.cmbIncludeUnknowDetail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    boolean isinclude = e.getItem() == IsCitedByLaterEnum.ISTRUE;
                    DynaGradeSettingUI.this.setIncludeUnknowDetail(isinclude);
                }
            }
        });
        this.promptBaseData.setEditable(false);
        this.promptBaseData.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstActTypeQuery");
        this.promptBaseData.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                return DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        this.promptBaseData.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                this.maybeDefaultValueSet(eventObj);
                this.setAssistantSubTypeVisibleBySeletData(eventObj);
            }

            private void setAssistantSubTypeVisibleBySeletData(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() != null) {
                    String asstHgAttribute = ((AsstActTypeInfo)eventObj.getNewValue()).getAsstHGAttribute();
                    DynaGradeSettingUI.this.decideAssistantSubTypeVisibleByAsstActTypeNumber(asstHgAttribute);
                    DynaGradeSettingUI.this.setAssistantSubTypeByNumberF7(asstHgAttribute);
                }
                this.clearAssistantSubType();
            }

            private String getAssistantSubTypeNumber(DataChangeEvent eventObj) {
                String number = "";
                if (eventObj == null) {
                    return number;
                }
                if (eventObj.getNewValue() == null) {
                    return number;
                }
                if (((AsstActTypeInfo)eventObj.getNewValue()).getNumber() == null) {
                    return number;
                }
                number = ((AsstActTypeInfo)eventObj.getNewValue()).getNumber();
                return number;
            }

            private void clearAssistantSubType() {
                DynaGradeSettingUI.this.promtAssistantSubType.setValue(null);
            }

            private void maybeDefaultValueSet(DataChangeEvent eventObj) {
                int count = DynaGradeSettingUI.this.cmbBaseData.getItemCount();
                if (eventObj.getNewValue() != null) {
                    AsstActTypeInfo element = (AsstActTypeInfo)eventObj.getNewValue();
                    BOSUuid promptId = element.getId();
                    for (int i = 0; i < count; ++i) {
                        AsstActTypeInfo comBoInfo = (AsstActTypeInfo)DynaGradeSettingUI.this.cmbBaseData.getItemAt(i);
                        if (!promptId.equals((Object)comBoInfo.getId())) continue;
                        DynaGradeSettingUI.this.cmbBaseData.setSelectedIndex(i);
                        break;
                    }
                } else {
                    DynaGradeSettingUI.this.cmbBaseData.setSelectedIndex(-1);
                }
            }
        });
        this.cmbBaseData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DynaGradeSettingUI.this.promptBaseData.setData(DynaGradeSettingUI.this.cmbBaseData.getSelectedItem());
            }
        });
    }

    private void showAssistantSubTypeByCondition() {
        AsstActTypeInfo info;
        if (this.cmbBaseData.getSelectedItem() != null && (info = (AsstActTypeInfo)this.cmbBaseData.getSelectedItem()) != null) {
            String asstHgAttribute = info.getAsstHGAttribute();
            this.decideAssistantSubTypeVisibleByAsstActTypeNumber(asstHgAttribute);
            this.setAssistantSubTypeByNumberF7(asstHgAttribute);
        }
    }

    private void setAssistantSubTypeByNumberF7(String asstHgAttribute) {
        if (DynamicTemplateUtility.isBaseAsstActType(asstHgAttribute)) {
            this.setAssistantSubTypeFormatF7();
            this.changeAssistantSubTypeByNumberF7(asstHgAttribute);
        }
    }

    private void setAssistantSubTypeFormatF7() {
        this.promtAssistantSubType.setEditFormat("$number$");
        this.promtAssistantSubType.setDisplayFormat("$number$ - $name$");
        this.promtAssistantSubType.setCommitFormat("$number$");
        this.promtAssistantSubType.setHistoryRecordName("groupPromptBox");
    }

    private void changeAssistantSubTypeByNumberF7(String asstHgAttribute) {
        AsstGroupChooserPromptForOneRow prompt = new AsstGroupChooserPromptForOneRow((IUIObject)this);
        if (asstHgAttribute.equals("customer")) {
            prompt.setGroupType(1);
        } else if (asstHgAttribute.equals("provider")) {
            prompt.setGroupType(2);
        } else if (asstHgAttribute.equals("material")) {
            prompt.setGroupType(3);
        }
        this.promtAssistantSubType.setSelector((KDPromptSelector)prompt);
    }

    private void showAssistantSubType() {
        this.lbConAssistantSubType.setVisible(true);
    }

    private void decideAssistantSubTypeVisibleByAsstActTypeNumber(String asstHgAttribute) {
        if (DynamicTemplateUtility.isBaseAsstActType(asstHgAttribute)) {
            this.showAssistantSubType();
        } else {
            this.hideAssistantSubType();
        }
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.Modified) {
            try {
                this.fill();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.checkBeforeWindowClosing();
    }

    protected void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        int idx = this.tblMain.getSelectManager().getActiveRowIndex();
        if (idx < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(idx);
        this.saveEntry(this.buildEntry((DItemGradeEntryInfo)row.getUserObject()), row);
        if (!EXPORT.equals(e.getActionCommand())) {
            this.Modified = true;
        }
    }

    private File chooseFile(String title) {
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)title));
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String n = f.getName();
                return n.length() >= 4 && n.substring(n.length() - 4).equalsIgnoreCase(".txt");
            }

            @Override
            public String getDescription() {
                return "*.txt(TXT)";
            }
        });
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile() {
        File file = this.chooseFile("ReportProcessUI_Import");
        if (file == null) {
            return;
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = r.readLine();
            DItemGradeInfo my = new DItemGradeInfo();
            my.fromSerialString(line);
            this.info = my;
            this.refresh(null);
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)("\n\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"13_DynaGradeSettingUI")));
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFile() {
        File file = this.chooseFile("ReportProcessUI_Export");
        if (file == null) {
            return;
        }
        BufferedWriter w = null;
        try {
            String name2 = file.getAbsolutePath();
            if (name2.length() < 4 || !name2.substring(name2.length() - 4).equalsIgnoreCase(".txt")) {
                name2 = name2 + ".txt";
            }
            if ((file = new File(name2)).exists()) {
                int showConfirm3 = MsgBox.showConfirm3((Component)((Object)this), (String)RptResourceHelper.getString((String)"file-overwrite-confirm"));
                if (showConfirm3 == 2) {
                    return;
                }
                if (showConfirm3 == 1) {
                    return;
                }
            }
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            w.write(this.info.toSerialString());
            w.flush();
            MsgBox.showInfo((Component)((Object)this), (String)RptResourceHelper.getString((String)"lable8"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addnew() {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        int activeRowIndex = block == null ? -1 : block.getBottom();
        String nextNumber = null;
        IRow activeRow = activeRowIndex < 0 ? null : this.tblMain.getRow(activeRowIndex);
        DItemGradeEntryInfo entry = null;
        if (activeRow != null) {
            DItemGradeEntryInfo userObject2 = (DItemGradeEntryInfo)activeRow.getUserObject();
            entry = userObject2.copy();
            nextNumber = entry.getNumber();
            nextNumber = this.increase(nextNumber);
        } else {
            nextNumber = "1";
            entry = this.buildEntry(null);
            entry.setLevel(1);
            entry.setDetailCount(5);
            entry.setDetailSource(0);
        }
        IRow row = this.tblMain.addRow();
        row.getCell("number").setValue((Object)nextNumber);
        entry.setNumber(nextNumber);
        entry.setGrade(nextNumber);
        row.setUserObject((Object)entry);
        this.info.getEntries().add(entry);
        this.refresh(entry);
    }

    @Override
    public void actionAddSubItem_actionPerformed(ActionEvent e) throws Exception {
        int activeRowIndex;
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        int n = activeRowIndex = block == null ? -1 : block.getBottom();
        if (activeRowIndex == -1) {
            this.addnew();
            return;
        }
        String nextNumber = null;
        IRow activeRow = activeRowIndex < 0 ? null : this.tblMain.getRow(activeRowIndex);
        DItemGradeEntryInfo entry = null;
        if (activeRow == null) {
            return;
        }
        DItemGradeEntryInfo prototype = (DItemGradeEntryInfo)activeRow.getUserObject();
        if (prototype.isLeaf()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"14_DynaGradeSettingUI"));
            return;
        }
        entry = this.info.findLastSubGrade(prototype);
        nextNumber = prototype.getNumber();
        if (entry != null) {
            entry = entry.copy();
            nextNumber = this.increase(entry.getNumber());
        } else {
            entry = prototype.copy();
            nextNumber = nextNumber + ".1";
        }
        entry.setParentGrade(prototype);
        IRow row = this.tblMain.addRow();
        row.getCell("number").setValue((Object)nextNumber);
        entry.setNumber(nextNumber);
        entry.setGrade(nextNumber);
        entry.setLevel(nextNumber.split("\\.").length);
        row.setUserObject((Object)entry);
        this.info.getEntries().add(entry);
        this.refresh(entry);
    }

    private String increase(String nextNumber) {
        int pos = nextNumber.lastIndexOf(46);
        String last = null;
        last = pos < 0 ? nextNumber : nextNumber.substring(pos + 1);
        int lastest = Integer.parseInt(last) + 1;
        String string = nextNumber = pos < 0 ? String.valueOf(lastest) : nextNumber.substring(0, pos + 1) + lastest;
        while (this.info.find(nextNumber) != null) {
            nextNumber = pos < 0 ? String.valueOf(lastest) : nextNumber.substring(0, pos + 1) + ++lastest;
        }
        return nextNumber;
    }

    public void fill() {
        boolean isListener = DynaItemListener.getisListener();
        if (isListener) {
            DynaItemListener.setListener(false);
        }
        DItemGradeInfo info = this.buildGradeInfo();
        info.reform();
        this.check(info);
        if (this.adviser instanceof DynaGradeSettingAdviserImpl) {
            ((DynaGradeSettingAdviserImpl)this.adviser).setTemplateGradeInfo(info);
        }
        this.adviser.setType("template");
        this.adviser.save(info);
        this.adviser.fill(info);
        this.Modified = false;
        if (isListener) {
            DynaItemListener.setListener(isListener);
        }
    }

    public void preview() {
        PreviewDialog d = new PreviewDialog((Dialog)this.getUIWindow());
        d.show();
        DItemGradeInfo info = this.buildGradeInfo();
        info.reform();
        d.fill(info, this.parameters);
    }

    public void save() {
        DItemGradeInfo buildGradeInfo = this.buildGradeInfo();
        this.check(buildGradeInfo);
        this.adviser.save(buildGradeInfo);
    }

    private void check(DItemGradeInfo info) {
        if (info == null) {
            return;
        }
        List entries = info.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            DItemGradeEntryInfo en = (DItemGradeEntryInfo)entries.get(i);
            if (StringUtils.isEmpty((String)en.getName())) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"55_DynaGradeSettingUI");
                MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(msg, en.getNumber()));
                SysUtil.abort();
                return;
            }
            if (en.getDetailSource() != 1 || en.getDetailAsstType() != null) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"56_DynaGradeSettingUI");
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(msg, en.getNumber()));
            SysUtil.abort();
            return;
        }
    }

    public void delete() {
        KDTSelectManager mng = this.tblMain.getSelectManager();
        DItemGradeEntryInfo ent = null;
        for (int i = 0; i < mng.size(); ++i) {
            int bottom;
            KDTSelectBlock block = mng.get(i);
            int top = block.getTop();
            for (int j = bottom = block.getBottom(); j >= 0 && j >= top; --j) {
                ent = (DItemGradeEntryInfo)this.tblMain.getRow(j).getUserObject();
            }
        }
        if (ent != null && this.info.existsChildren(ent) != null) {
            int choose = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"18_DynaGradeSettingUI"));
            if (choose == 0) {
                this.info.removeChildren(ent);
            } else {
                return;
            }
        }
        this.info.getEntries().remove(ent);
        int active = this.tblMain.getSelectManager().getActiveRowIndex();
        if (active > 0) {
            --active;
        }
        if (active > -1) {
            DItemGradeEntryInfo entry = (DItemGradeEntryInfo)this.tblMain.getRow(active).getUserObject();
            this.refresh(entry);
        } else {
            this.clearDetail();
        }
    }

    private void clearDetail() {
        this.txtName.setText("");
        this.txtNumber.setText("");
        this.txtLevel.setText("");
        this.txtParent.setText("");
    }

    public DynaGradeSettingAdviser getAdviser() {
        return this.adviser;
    }

    public void setAdviser(DynaGradeSettingAdviser adviser) {
        this.adviser = adviser;
    }

    private void ctrlStatus(boolean isDetail) {
        if (isDetail) {
            this.cmbIncludeUnknowDetail.setSelectedItem((Object)IsCitedByLaterEnum.ISFALSE);
        }
        if (this.cmbIsDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISTRUE) || this.cmbIsDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISFALSE) && this.cmbIncludeUnknowDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISFALSE)) {
            this.cmbDetailCount.setValue((Object)new Integer(0));
            this.cmbDetailCount.setEnabled(false);
            this.promptBaseData.setEnabled(false);
            this.cmbIndent.setEnabled(false);
            this.cmbSource.setSelectedIndex(0);
            this.cmbSource.setEnabled(false);
        } else {
            this.cmbDetailCount.setEnabled(true);
            this.promptBaseData.setEnabled(true);
            this.cmbIndent.setEnabled(true);
            this.cmbSource.setEnabled(true);
        }
    }

    private void setIncludeUnknowDetail(boolean isinclude) {
        if (this.cmbIsDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISTRUE) || this.cmbIsDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISFALSE) && this.cmbIncludeUnknowDetail.getSelectedItem().equals(IsCitedByLaterEnum.ISFALSE)) {
            this.cmbDetailCount.setValue((Object)new Integer(0));
            this.cmbDetailCount.setEnabled(false);
            this.promptBaseData.setEnabled(false);
            this.cmbIndent.setEnabled(false);
            this.cmbSource.setSelectedIndex(0);
            this.cmbSource.setEnabled(false);
        } else {
            this.cmbDetailCount.setEnabled(true);
            this.promptBaseData.setEnabled(true);
            this.cmbIndent.setEnabled(true);
            this.cmbSource.setEnabled(true);
        }
    }

    class PreviewDialog
    extends KDDialog {
        DynaGradeSettingAdviser ad;
        DynaParameters parameters;

        PreviewDialog(Dialog d) {
            super(d);
            this.ad = null;
            this.parameters = null;
        }

        void fill(DItemGradeInfo info, DynaParameters parameters) {
            this.parameters = parameters;
            this.initControls();
            if (this.ad instanceof DynaGradeSettingAdviserImpl) {
                ((DynaGradeSettingAdviserImpl)this.ad).setTemplateGradeInfo(info);
            }
            this.ad.setType("template");
            this.ad.fill(info);
            if (DynaGradeSettingUI.this.sheet != null && DynaGradeSettingUI.this.sheet.getSheetRange() != null) {
                StyleAttributes protectStyle = Styles.getEmptySA();
                protectStyle.setLocked(true);
                Range r = DynaGradeSettingUI.this.sheet.getRange(0, 0, DynaGradeSettingUI.this.sheet.getMaxRowIndex(), DynaGradeSettingUI.this.sheet.getMaxColIndex());
                r.getStyle(Styles.getEmptySA(), protectStyle);
                r.setCellLocked(true);
                DynaGradeSettingUI.this.sheet.getSheetOption().getProtection(true).start("auto^Protection");
            }
        }

        void initControls() {
            this.getRootPane().setLayout(new BorderLayout());
            SpreadContext spread = new SpreadContext();
            this.getRootPane().add((Component)spread, "Center");
            DynaGradeSettingUI.this.sheet = spread.getBook().getActiveSheet();
            ItemFormula item = new ItemFormula();
            Range range = DynaGradeSettingUI.this.sheet.getRange(0, 0);
            UserObjectHelper.setItemFormula((Range)range, (ItemFormula)item);
            DynaParameters param = DynaParameters.getInstanceFromString(this.parameters.toString());
            DynamicTemplateUtility.saveParametersToCell(range, param);
            this.ad = new DynaGradeSettingAdviserImpl(DynaGradeSettingUI.this.sheet);
            this.setSize(800, 600);
            this.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)DynaGradeSettingUI.PREVIEW));
        }
    }

    class MainAction
    extends AbstractAction {
        MainAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DynaGradeSettingUI.this.beforeActionPerformed(e);
            if (DynaGradeSettingUI.NEW.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.addnew();
            } else if (DynaGradeSettingUI.DELETE.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.delete();
            } else if (DynaGradeSettingUI.SAVE.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.save();
            } else if (DynaGradeSettingUI.PREVIEW.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.preview();
            } else if (DynaGradeSettingUI.FILL.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.fill();
            } else if (DynaGradeSettingUI.EXPORT.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.exportFile();
            } else if (DynaGradeSettingUI.IMPORT.equals(e.getActionCommand())) {
                DynaGradeSettingUI.this.importFile();
            }
            DynaGradeSettingUI.this.afterActionPerformed(e);
        }
    }
}

