/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import java.io.Serializable;
import java.util.ArrayList;

public class DynaHeadItem
implements Serializable {
    public int sequence = 0;
    public RPTItemInfo rptItem = null;
    public String dynaName = "";
    public int year = 0;
    public int period = 0;
    public ValueTypeEnum valueType = null;
    public DataElementInfo dataElement = null;

    public DynaHeadItem(RPTItemInfo rptItem, String dynaName, int year, int period, DataElementInfo dataElement, ValueTypeEnum valueType) {
        this.rptItem = rptItem;
        this.dynaName = dynaName;
        this.year = year;
        this.period = period;
        this.dataElement = dataElement;
        this.valueType = valueType;
    }

    public String getDisplayName() {
        return this.rptItem.getName() + "/" + this.dataElement.getName() + "/" + this.valueType.getAlias();
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(this.rptItem.getNumber() + "\",");
        strBuffer.append("\"\",");
        strBuffer.append(this.year + ",");
        strBuffer.append(this.period + ",\"");
        strBuffer.append(this.dataElement.getNumber() + "\",\"");
        strBuffer.append(this.valueType.getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    public static DynaHeadItem getInstanceFromFormula(ItemFormula formula) throws EASBizException, BOSException {
        DynaHeadItem dynaItem = new DynaHeadItem();
        dynaItem.setRptItem(RPTItemFactory.getRemoteInstance().getRPTItemInfo("where number = '" + formula.getItemNumber() + "'"));
        dynaItem.setDataElement(DataElementProvider.getDataElementInfo((String)formula.getDataElementNumber()));
        dynaItem.setValueType(ValueTypeEnum.getEnum((int)formula.getValueType()));
        dynaItem.setYear(formula.getYearOffSet());
        dynaItem.setPeriod(formula.getPeriodOffSet());
        return dynaItem;
    }

    public static boolean checkDuplicate(ArrayList dynaHeadItemList) {
        for (int i = 0; i < dynaHeadItemList.size(); ++i) {
            for (int j = i + 1; j < dynaHeadItemList.size(); ++j) {
                if (!((DynaHeadItem)dynaHeadItemList.get(i)).equals((DynaHeadItem)dynaHeadItemList.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DynaHeadItem) {
            DynaHeadItem dynaItem = (DynaHeadItem)obj;
            return this.rptItem.getNumber().equals(dynaItem.rptItem.getNumber()) && this.dataElement.getNumber().equals(dynaItem.dataElement.getNumber()) && this.valueType.getValue() == dynaItem.valueType.getValue() && this.year == dynaItem.year && this.period == dynaItem.year;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 47 + this.year;
        result = result * 47 + this.period;
        return result;
    }

    public DynaHeadItem() {
    }

    public DataElementInfo getDataElement() {
        return this.dataElement;
    }

    public void setDataElement(DataElementInfo dataElement) {
        this.dataElement = dataElement;
    }

    public String getDynaName() {
        return this.dynaName;
    }

    public void setDynaName(String dynaName) {
        this.dynaName = dynaName;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public RPTItemInfo getRptItem() {
        return this.rptItem;
    }

    public void setRptItem(RPTItemInfo rptItem) {
        this.rptItem = rptItem;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }
}

