/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptItemF7;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractDynaItemDataFilterUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DynaItemDataFilterUI
extends AbstractDynaItemDataFilterUI {
    private static final long serialVersionUID = -5854943563245112866L;
    private static final Logger logger = CoreUIObject.getLogger(DynaItemDataFilterUI.class);
    ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    private CslRptItemF7 cslRptItemF7UI = new CslRptItemF7((IUIObject)this);
    private String selectAll = CslRptUtil.getString((String)"CslRptItemDataNameAll");
    private String selectItem = CslRptUtil.getString((String)"CslRptItemDataNameItem");
    private String selectElim = CslRptUtil.getString((String)"CslRptItemDataNameElim");
    private String selectAdju = CslRptUtil.getString((String)"CslRptItemDataNameAdjust");
    private boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private PeriodCollection periodCollection = null;

    public DynaItemDataFilterUI() throws Exception {
        this.initUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isMergeByFiscalPeriod) {
            try {
                if (this.periodCollection == null) {
                    this.periodCollection = FiscalPeriodHelper.getPeriodCollection(null, (OrgTreeInfo)this.cslCtx.getCurOrgBound());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        this.clearUI();
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)DynaItemDataFilterUI.this.comboPeriodType.getSelectedItem();
                        if (periodType == null) {
                            periodType = DynaItemDataFilterUI.this.cslCtx.getCurRptPeriodType();
                        }
                        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)DynaItemDataFilterUI.this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodType)) {
                            return;
                        }
                        Date date = DynaItemDataFilterUI.this.dpkDateTo.getSqlDate();
                        if (date == null) {
                            date = new Date();
                        }
                        List timesList = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
                        DynaItemDataFilterUI.this.dpkDateTo.setValue(timesList.get(2));
                        int year = (Integer)timesList.get(0);
                        int period = (Integer)timesList.get(1);
                        Date firstDate = RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
                        DynaItemDataFilterUI.this.dpkDate.setValue((Object)firstDate);
                    }
                    catch (BOSException e1) {
                        DynaItemDataFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initUI() throws EASBizException, BOSException {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setTreeID(this.cslCtx.getCurOrgBound().getId().toString());
        f7.setRootUnitID(this.cslCtx.getCurOrgGroup().getId().toString());
        f7.setCtrlUnitPK(this.cslCtx.getCurOrgBound().getCU());
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.bizCompany.setSelector((KDPromptSelector)f7);
        this.comboItemType.addItem((Object)this.selectAll);
        try {
            this.comboItemType.addItems(ReportClassFactory.getRemoteInstance().getReportClassCollection(CslGradeManageUtil.filterRptItemTypeGradeManage(null, null)).toArray());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.dpkDate.setValue((Object)this.cslCtx.getCurReportDate());
        this.dpkDateTo.setValue((Object)this.cslCtx.getCurReportDate());
        CurrencyCollection currencyColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.comboSourceCurrency.addItem((Object)this.selectAll);
        this.comboSourceCurrency.addItems(currencyColl.toArray());
        this.comboCurrency.addItem((Object)this.selectAll);
        this.comboCurrency.addItems(currencyColl.toArray());
        this.bizItem.setSelector((KDPromptSelector)this.cslRptItemF7UI);
        this.bizItemTo.setSelector((KDPromptSelector)this.cslRptItemF7UI);
        this.spnLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Integer level = (Integer)DynaItemDataFilterUI.this.spnLevel.getValue();
                if (level < 1) {
                    DynaItemDataFilterUI.this.spnLevel.setValue((Object)new Integer(1));
                }
            }
        });
        this.spnLevelTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Integer level = (Integer)DynaItemDataFilterUI.this.spnLevelTo.getValue();
                if (level < 1) {
                    DynaItemDataFilterUI.this.spnLevelTo.setValue((Object)new Integer(1));
                }
            }
        });
        this.cmbxType.addItem((Object)this.selectAll);
        this.cmbxType.addItem((Object)this.selectItem);
        this.cmbxType.addItem((Object)this.selectElim);
        this.cmbxType.addItem((Object)this.selectAdju);
        this.cmbxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DynaItemDataFilterUI.this.actionTypeChanged();
                }
            }
        });
        this.cmbxAdjustStatus.addItem((Object)this.selectAll);
        this.cmbxAdjustStatus.addItems(AdjustStatusEnum.getEnumList().toArray());
        this.cmbxAdjustStatus.removeItem((Object)AdjustStatusEnum.CALIADJUSTED);
        this.comboElim.removeAllItems();
        this.comboElim.addItem((Object)this.selectAll);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.SINGLE);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.bizDataType.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataType.setEditFormat("$number$");
        this.bizDataType.setDisplayFormat("$name$");
        this.bizDataType.setEditable(true);
        this.bizDataType.setRequired(false);
        this.bizDataType.setCommitFormat("$number$");
        this.txtDynaItem.setRequired(false);
        try {
            CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.bizDataType, null, (boolean)true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void actionTypeChanged() {
        this.comboElim.removeAllItems();
        this.comboElim.addItem((Object)this.selectAll);
        if (this.cmbxType.getSelectedItem().equals(this.selectElim)) {
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
        } else {
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.SINGLE);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        }
    }

    public FilterInfo getFilterInfo() {
        Calendar calendar;
        FilterItemInfo filterCurrency;
        CurrencyInfo currency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
            this.filterInfo.setMaskString(null);
        }
        StringBuffer strMask = new StringBuffer();
        int iIndex = 0;
        try {
            FilterItemInfo filterOrgTree = new FilterItemInfo("orgTreeId", (Object)this.cslCtx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterOrgTree);
            strMask.append("#").append(iIndex++);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.bizCompany.getData() != null) {
            OrgUnitInfo company = (OrgUnitInfo)this.bizCompany.getData();
            FilterItemInfo filterCompany = new FilterItemInfo("orgUnitId", (Object)company.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            strMask.append(" and #").append(iIndex++);
        } else {
            FilterItemInfo filterCompany = new FilterItemInfo("defaultOrgBound", (Object)"defaultOrgBound", CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboItemType.getSelectedItem() != null && !this.comboItemType.getSelectedItem().equals(this.selectAll)) {
            ReportClassInfo itemType = (ReportClassInfo)this.comboItemType.getSelectedItem();
            FilterItemInfo filterItemType = new FilterItemInfo("reportClass", (Object)itemType.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemType);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboSourceCurrency.getSelectedItem() != null && !this.comboSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            currency = (CurrencyInfo)this.comboSourceCurrency.getSelectedItem();
            filterCurrency = new FilterItemInfo("currency", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrency);
            strMask.append(" and #").append(iIndex++);
            FilterItemInfo filterCurrencyName = new FilterItemInfo("currencyName", (Object)currency.getName(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrencyName);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(this.selectAll)) {
            currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            filterCurrency = new FilterItemInfo("targetCurrency", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrency);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.dpkDate.getValue() != null) {
            Date startDate = (Date)this.dpkDate.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterStartDate = new FilterItemInfo("rptDate", (Object)startTime, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterStartDate);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.dpkDateTo.getValue() != null) {
            Date endDate = (Date)this.dpkDateTo.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp endTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterEndDate = new FilterItemInfo("rptDateTo", (Object)endTime, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterEndDate);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizItem.getData() != null) {
            RPTItemInfo item = (RPTItemInfo)this.bizItem.getData();
            FilterItemInfo filterItem = new FilterItemInfo("item", (Object)item.getNumber(), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizItemTo.getData() != null) {
            RPTItemInfo itemTo = (RPTItemInfo)this.bizItemTo.getData();
            FilterItemInfo filterItemTo = new FilterItemInfo("itemTo", (Object)itemTo.getNumber(), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            strMask.append(" and #").append(iIndex++);
        }
        Integer level = (Integer)this.spnLevel.getValue();
        FilterItemInfo filterItemLevel = new FilterItemInfo("itemLevel", (Object)level, CompareType.GREATER_EQUALS);
        this.filterInfo.getFilterItems().add(filterItemLevel);
        strMask.append(" and #").append(iIndex++);
        Integer levelTo = (Integer)this.spnLevelTo.getValue();
        FilterItemInfo filterItemLevelTo = new FilterItemInfo("itemLevelTo", (Object)levelTo, CompareType.LESS_EQUALS);
        this.filterInfo.getFilterItems().add(filterItemLevelTo);
        strMask.append(" and #").append(iIndex++);
        Integer type = new Integer(this.cmbxType.getSelectedIndex() + 1);
        FilterItemInfo filterType = new FilterItemInfo("type", (Object)type);
        this.filterInfo.getFilterItems().add(filterType);
        strMask.append(" and #").append(iIndex++);
        if (this.comboPeriodType.getSelectedItem() != null && !this.comboPeriodType.getSelectedItem().equals(this.selectAll)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriodType);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.cmbxAdjustStatus.getSelectedIndex() > 0) {
            AdjustStatusEnum isAdjusted = (AdjustStatusEnum)this.cmbxAdjustStatus.getSelectedItem();
            FilterItemInfo filterAdjust = new FilterItemInfo("AdjustStatus", (Object)new Integer(isAdjusted.getValue()));
            this.filterInfo.getFilterItems().add(filterAdjust);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboElim.getSelectedIndex() > 0) {
            int iDataSrc = ((CslDataSrcTypeEnum)this.comboElim.getSelectedItem()).getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataSource", (Object)new Integer(iDataSrc)));
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizDataType.getValue() != null) {
            DataElementInfo dataElement = (DataElementInfo)this.bizDataType.getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(dataElement.getInterSeq()), CompareType.EQUALS));
            strMask.append(" and #").append(iIndex++);
        }
        int valueType = this.btnMoney.isSelected() ? 1 : (this.btnQuantity.isSelected() ? 2 : 3);
        this.filterInfo.getFilterItems().add(new FilterItemInfo("valueType", (Object)new Integer(valueType)));
        strMask.append(" and #").append(iIndex++);
        if (!StringUtils.isEmpty((String)this.txtDynaItem.getText())) {
            String dynaItem = this.txtDynaItem.getText().trim();
            if (dynaItem.indexOf("'") >= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"93_existSpecialChar"));
                SysUtil.abort();
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("keyName", (Object)dynaItem, CompareType.EQUALS));
            strMask.append(" and #").append(iIndex++);
        }
        if (!this.isShowFreezeItem.isSelected()) {
            FilterItemInfo item = new FilterItemInfo("isShowFreezeItem", (Object)new Boolean(this.isShowFreezeItem.isSelected()));
            this.filterInfo.getFilterItems().add(item);
            strMask.append(" and #").append(iIndex++);
        }
        this.filterInfo.setMaskString(strMask.toString());
        return this.filterInfo;
    }

    public Object getParam() {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (this.dpkDate.getValue() != null) {
            Date startDate = (Date)this.dpkDate.getValue();
            map.put("startDate", startDate);
        }
        if (this.dpkDateTo.getValue() != null) {
            Date endDate = (Date)this.dpkDateTo.getValue();
            map.put("endDate", endDate);
        }
        if (map.size() > 0) {
            return map;
        }
        return null;
    }

    public void setParam(Object param) {
        try {
            this.dpkDate.setValue((Object)this.cslCtx.getCurReportDate());
            this.dpkDateTo.setValue((Object)this.cslCtx.getCurReportDate());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (param != null) {
            Map map = (Map)param;
            if (map.containsKey("startDate")) {
                this.dpkDate.setValue(map.get("startDate"));
            }
            if (map.containsKey("endDate")) {
                this.dpkDateTo.setValue(map.get("endDate"));
            }
        }
    }

    public void clear() {
        super.clear();
        try {
            this.clearUI();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    private void clearUI() throws BOSException {
        this.bizCompany.setData(null);
        this.bizItem.setData(null);
        this.bizItemTo.setData(null);
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboSourceCurrency.setSelectedItem((Object)this.selectAll);
        this.dpkDate.setValue((Object)FiscalPeriodHelper.getPeriodFirstDate((int)this.cslCtx.getCurRptYear(), (int)this.cslCtx.getCurRptPeriod(), (RptPeriodTypeEnum)this.cslCtx.getCurRptPeriodType(), (PeriodCollection)this.periodCollection, (boolean)this.isMergeByFiscalPeriod));
        this.dpkDateTo.setValue((Object)this.cslCtx.getCurReportDate());
        if (this.isMergeByFiscalPeriod) {
            this.comboPeriodType.setEnabled(false);
            this.dpkDate.setEnabled(false);
            this.dpkDateTo.setEnabled(false);
        }
        this.comboElim.setSelectedItem((Object)this.selectAll);
        this.comboItemType.setSelectedItem((Object)this.selectAll);
        this.comboPeriodType.setSelectedItem((Object)this.cslCtx.getCurRptPeriodType());
        this.spnLevel.setValue((Object)new Integer(1));
        this.spnLevelTo.setValue((Object)new Integer(1));
        this.cmbxType.setSelectedIndex(0);
        this.btnMoney.setSelected(true);
        this.txtDynaItem.setText(null);
    }

    public CustomerParams getCustomerParams() {
        ItemDataCondition condition = new ItemDataCondition();
        CurrencyInfo tmpCurrency = null;
        HashMap<String, Object> extCondition = new HashMap<String, Object>();
        try {
            OrgTreeInfo orgBound = this.cslCtx.getCurOrgBound();
            condition.setOrgTreeNumber(orgBound.getId().toString());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.bizCompany.getData() != null) {
            OrgUnitInfo company = (OrgUnitInfo)this.bizCompany.getData();
            ArrayList<String> companys = new ArrayList<String>();
            companys.add(company.getId().toString());
            condition.setOrgUnit(companys);
        }
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        Date date = (Date)this.dpkDate.getValue();
        Date dateTo = (Date)this.dpkDateTo.getValue();
        if (this.comboPeriodType.getSelectedIndex() > 0) {
            periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            condition.setRptPeriodType(periodType.getValue());
            if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodType)) {
                try {
                    condition.setRptYearStart(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                    condition.setRptYearEnd(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                }
                catch (BOSException e) {
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                }
            } else {
                int[] yearAndPeriodStart = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)periodType);
                int[] yearAndPeriodEnd = RPTDateUtil.getPeriod((Date)dateTo, (RptPeriodTypeEnum)periodType);
                condition.setRptYearStart(yearAndPeriodStart[0]);
                condition.setRptPeriodStart(yearAndPeriodStart[1]);
                condition.setRptYearEnd(yearAndPeriodEnd[0]);
                condition.setRptPeriodStart(yearAndPeriodEnd[1]);
            }
        }
        if (this.comboCurrency.getSelectedIndex() > 0) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            condition.setCurrency(currency.getId().toString());
            tmpCurrency = currency;
        }
        if (this.comboSourceCurrency.getSelectedIndex() > 0) {
            CurrencyInfo targetCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            condition.setTargetCurrency(targetCurrency.getNumber());
        }
        if (this.bizItem.getData() != null) {
            RPTItemInfo itemStart = (RPTItemInfo)this.bizItem.getData();
            condition.setItemNumberStart(itemStart.getNumber());
        }
        if (this.bizItemTo.getData() != null) {
            RPTItemInfo itemEnd = (RPTItemInfo)this.bizItemTo.getData();
            condition.setItemNumberEnd(itemEnd.getNumber());
        }
        int itemStartLevel = Integer.parseInt(this.spnLevel.getValue().toString());
        int itemEndLevel = Integer.parseInt(this.spnLevelTo.getValue().toString());
        condition.setItemNumberLevelStart(itemStartLevel);
        condition.setItemNumberLevelEnd(itemEndLevel);
        if (!this.cmbxAdjustStatus.getSelectedItem().equals(this.selectAll)) {
            AdjustStatusEnum adjustStatus = (AdjustStatusEnum)this.cmbxAdjustStatus.getSelectedItem();
            condition.setIsAdjusted(adjustStatus.getValue() == 1);
        }
        if (!this.comboElim.getSelectedItem().equals(this.selectAll)) {
            CslDataSrcTypeEnum dataSrc = (CslDataSrcTypeEnum)this.comboElim.getSelectedItem();
            condition.setDataSource(dataSrc.getValue());
        }
        if (this.bizDataType.getValue() != null) {
            DataElementInfo dataElement = (DataElementInfo)this.bizDataType.getValue();
            condition.setDataElement(dataElement.getInterSeq());
        }
        int valueType = 0;
        if (this.btnMoney.isSelected()) {
            valueType = 1;
        } else if (this.btnQuantity.isSelected()) {
            valueType = 2;
        }
        condition.setValueType(valueType);
        String selectType = (String)this.cmbxType.getSelectedItem();
        Integer iSelectType = null;
        if (selectType.equals(this.selectAll)) {
            iSelectType = new Integer(1);
        } else if (selectType.equals(this.selectItem)) {
            iSelectType = new Integer(2);
        } else if (selectType.equals(this.selectElim)) {
            iSelectType = new Integer(3);
        } else if (selectType.equals(this.selectAdju)) {
            iSelectType = new Integer(4);
        }
        if (!StringUtils.isEmpty((String)this.txtDynaItem.getText())) {
            extCondition.put("keyName", this.txtDynaItem.getText());
        }
        extCondition.put("dataType", iSelectType);
        if (tmpCurrency != null) {
            extCondition.put("currencyName", tmpCurrency.getName());
        } else {
            extCondition.put("currencyName", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"369_CslRptItemDataFilterUI"));
        }
        condition.setIsShowFreezeItem(this.isShowFreezeItem.isSelected());
        this.getUIContext().put("condition", condition);
        this.getUIContext().put("extCondition", extCondition);
        return super.getCustomerParams();
    }

    public boolean destroyWindow() {
        this.getCustomerParams();
        return super.destroyWindow();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        try {
            this.clearUI();
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        super.loadData(entityViewInfo);
        boolean isDataAll = true;
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        boolean isShowFreezedItem = true;
        block9: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            Integer level;
            RPTItemCollection itemCollection;
            FilterInfo filter;
            String itemNumber;
            String currencyID;
            Date time;
            ReportClassInfo tmpInfo;
            int j;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            if (propertyName.equalsIgnoreCase("orgUnitId")) {
                if (filterItemInfo.getCompareValue() instanceof LinkedHashSet) {
                    this.bizCompany.setData(null);
                    continue;
                }
                String companyID = (String)filterItemInfo.getCompareValue();
                ObjectUuidPK pk = new ObjectUuidPK(companyID);
                try {
                    OrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    if (company == null) continue;
                    this.bizCompany.setData((Object)company);
                }
                catch (EASBizException e) {
                    super.handUIException((Throwable)e);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("reportClass")) {
                String reportClassID = (String)filterItemInfo.getCompareValue();
                for (j = 1; j < this.comboItemType.getItemCount(); ++j) {
                    tmpInfo = (ReportClassInfo)this.comboItemType.getItemAt(j);
                    if (!tmpInfo.getId().toString().equals(reportClassID)) continue;
                    this.comboItemType.setSelectedItem((Object)tmpInfo);
                    continue block9;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("rptDate")) {
                time = (Date)filterItemInfo.getCompareValue();
                this.dpkDate.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (propertyName.equalsIgnoreCase("rptDateTo")) {
                time = (Date)filterItemInfo.getCompareValue();
                this.dpkDateTo.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (propertyName.equalsIgnoreCase("targetCurrency")) {
                currencyID = (String)filterItemInfo.getCompareValue();
                for (j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                    tmpInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                    if (!tmpInfo.getId().toString().equalsIgnoreCase(currencyID)) continue;
                    this.comboCurrency.setSelectedItem((Object)tmpInfo);
                    continue block9;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("currency")) {
                currencyID = (String)filterItemInfo.getCompareValue();
                for (j = 1; j < this.comboSourceCurrency.getItemCount(); ++j) {
                    tmpInfo = (CurrencyInfo)this.comboSourceCurrency.getItemAt(j);
                    if (!tmpInfo.getId().toString().equalsIgnoreCase(currencyID)) continue;
                    this.comboSourceCurrency.setSelectedItem((Object)tmpInfo);
                    continue block9;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("item")) {
                itemNumber = (String)filterItemInfo.getCompareValue();
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.getSelector().add(new SelectorItemInfo("id"));
                entityView.getSelector().add(new SelectorItemInfo("number"));
                entityView.getSelector().add(new SelectorItemInfo("name"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber));
                entityView.setFilter(filter);
                try {
                    itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(entityView);
                    if (itemCollection.size() <= 0) continue;
                    this.bizItem.setData((Object)itemCollection.get(0));
                }
                catch (BOSException bOSException) {}
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemTo")) {
                itemNumber = (String)filterItemInfo.getCompareValue();
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.getSelector().add(new SelectorItemInfo("id"));
                entityView.getSelector().add(new SelectorItemInfo("number"));
                entityView.getSelector().add(new SelectorItemInfo("name"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber));
                entityView.setFilter(filter);
                try {
                    itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(entityView);
                    if (itemCollection.size() <= 0) continue;
                    this.bizItemTo.setData((Object)itemCollection.get(0));
                }
                catch (BOSException bOSException) {}
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemLevel")) {
                level = (Integer)filterItemInfo.getCompareValue();
                this.spnLevel.setValue((Object)level);
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemLevelTo")) {
                level = (Integer)filterItemInfo.getCompareValue();
                this.spnLevelTo.setValue((Object)level);
                continue;
            }
            if (propertyName.equalsIgnoreCase("type")) {
                Integer iSelectType = (Integer)filterItemInfo.getCompareValue();
                if (iSelectType == 1) {
                    this.cmbxType.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                if (iSelectType == 2) {
                    this.cmbxType.setSelectedItem((Object)this.selectItem);
                    continue;
                }
                if (iSelectType == 3) {
                    this.cmbxType.setSelectedItem((Object)this.selectElim);
                    continue;
                }
                if (iSelectType != 4) continue;
                this.cmbxType.setSelectedItem((Object)this.selectAdju);
                continue;
            }
            if (propertyName.equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodType));
                continue;
            }
            if (propertyName.equalsIgnoreCase("AdjustStatus")) {
                Integer adjust = (Integer)filterItemInfo.getCompareValue();
                this.cmbxAdjustStatus.setSelectedItem((Object)AdjustStatusEnum.getEnum((int)adjust));
                continue;
            }
            if (propertyName.equalsIgnoreCase("dataSource")) {
                Integer dataSrc = (Integer)filterItemInfo.getCompareValue();
                if (dataSrc + 9 == 10) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.SINGLE);
                    continue;
                }
                if (dataSrc + 9 == 11) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.SUMMARY);
                    continue;
                }
                if (dataSrc + 9 == 12) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.COMBINE);
                    continue;
                }
                if (dataSrc == 4) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
                    continue;
                }
                if (dataSrc != 5) continue;
                this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
                continue;
            }
            if (propertyName.equalsIgnoreCase("dataElement")) {
                Integer dataElement = (Integer)filterItemInfo.getCompareValue();
                this.bizDataType.setValue((Object)DataElementProvider.getDataElementInfo((int)dataElement));
                isDataAll = false;
                continue;
            }
            if (propertyName.equalsIgnoreCase("valueType")) {
                Integer valueType = (Integer)filterItemInfo.getCompareValue();
                if (valueType == 1) {
                    this.btnMoney.setSelected(true);
                    continue;
                }
                if (valueType == 2) {
                    this.btnQuantity.setSelected(true);
                    continue;
                }
                this.btnTxt.setSelected(true);
                continue;
            }
            if (propertyName.equalsIgnoreCase("keyName")) {
                this.txtDynaItem.setText((String)filterItemInfo.getCompareValue());
                continue;
            }
            if (!propertyName.equalsIgnoreCase("isShowFreezeItem")) continue;
            isShowFreezedItem = false;
        }
        this.isShowFreezeItem.setSelected(isShowFreezedItem);
    }
}

