/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataFactory;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.client.DynaRangeUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Point;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DynaRangeProvider {
    public void setRangeProp(VirtualSheetParamInfo info, Book book, ReportDesignerUI currentUI) throws Exception {
        TemplateInfo tmpInfo;
        Sheet activeSheet = book.getActiveSheet();
        Cell cell = activeSheet.getActiveCell();
        boolean isDyna = false;
        if (info instanceof ReportBaseInfo) {
            ReportBaseInfo rpt = (ReportBaseInfo)info;
            int sourceType = rpt.getSourceType().getValue();
            if (sourceType == 10 || sourceType == 42 || sourceType == 43 || sourceType == 11 || sourceType == 12 || sourceType == 35 || sourceType == 8 && rpt.getTemplate().getTemplateType().getValue() == 11) {
                isDyna = true;
            }
        } else if (info instanceof TemplateInfo && RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)(tmpInfo = (TemplateInfo)info).getTemplateType())) {
            isDyna = true;
        }
        if (isDyna) {
            HashMap map = this.getDynaRange(activeSheet, cell);
            this.setResult(map, activeSheet, currentUI);
        }
    }

    private HashMap getDynaRange(Sheet sheet, Cell cell) throws BOSException, SQLException, EASBizException {
        ArrayList pointList = DynamicTemplateUtility.getBasePointList(sheet);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNotBasePoint = true;
        for (int i = 0; i < pointList.size(); ++i) {
            Point point;
            Point basePoint = (Point)pointList.get(i);
            int x = basePoint.y;
            int y = basePoint.x;
            if (cell == null || x != cell.getRow() || y != cell.getCol()) continue;
            isNotBasePoint = false;
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
            int colSize = param.getDefaultCounter();
            map.put("basePoint", basePoint);
            if (param.getDynaItemSource() == 0) {
                map.put("dynaSource", (Object)DynaItemTypeEnum.ManualImport);
            } else {
                DynaItemTypeEnum dynaSource = null;
                String itemName = param.getAssistantType().properityName;
                String asstType = (String)DynaItemDataFactory.getRemoteInstance().getDynaItemType(itemName);
                if (asstType.equals("companyOrg")) {
                    dynaSource = DynaItemTypeEnum.Company;
                } else if (asstType.equals("customer")) {
                    dynaSource = DynaItemTypeEnum.Custom;
                } else if (asstType.equals("provider")) {
                    dynaSource = DynaItemTypeEnum.Provider;
                } else {
                    dynaSource = DynaItemTypeEnum.Other;
                    map.put("dynaSource_Alias", param.getAssistantType().properityAlias);
                }
                map.put("dynaSource", (Object)dynaSource);
            }
            if (param.getSpreadStyle() == 0) {
                int x1 = x + colSize + indexHandle.getSumRangeCount();
                int y1 = this.getColCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeRow", point);
            } else if (param.getSpreadStyle() == 1) {
                int y1 = y + colSize + indexHandle.getSumRangeCount();
                int x1 = this.getRowCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeCol", point);
            }
            boolean isGrade = param.isGrade();
            map.put("isGrade", new Boolean(isGrade));
            if (param.isIncludeSum()) {
                map.put("isHaveSumItem", new Boolean(true));
                if (param.getPosition() == 1) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + 1, 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + 1));
                    }
                } else if (param.getPosition() == 2) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + colSize + indexHandle.getSumRangeCount(), 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + colSize + indexHandle.getSumRangeCount()));
                    }
                }
            } else {
                map.put("isHaveSumItem", null);
            }
            if (param.getOrderBy().getValue() == 1) {
                map.put("orderBy", OrderByEnum.NONE);
            } else {
                map.put("orderBy", param.getOrderBy());
                if (param.getSpreadStyle() == 0) {
                    String row = Location.getCellName((int)0, (int)(y + param.getOrderRow()));
                    map.put("orderRow", row);
                } else if (param.getSpreadStyle() == 1) {
                    map.put("orderCol", new Integer(x + param.getOrderRow() + 1));
                }
            }
            map.put("isOnlyListHasDataItem", param.getOnlyListHasDataItem());
        }
        if (isNotBasePoint) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"21_DynaRangeProvider"));
            SysUtil.abort();
        }
        return map;
    }

    public Point getDynaRange(Sheet sheet, Point basePoint) {
        Point point = null;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
        int colSize = param.getDefaultCounter();
        int x = basePoint.y;
        int y = basePoint.x;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        if (param.getSpreadStyle() == 0) {
            int x1 = x + colSize + indexHandle.getSumRangeCount();
            point = new Point(this.getColCount(sheet, x, y), x1);
        } else if (param.getSpreadStyle() == 1) {
            int y1 = y + colSize + indexHandle.getSumRangeCount();
            point = new Point(y1, this.getRowCount(sheet, x, y));
        }
        return point;
    }

    public int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    public int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private void setResult(HashMap map, Sheet activeSheet, ReportDesignerUI currentUI) throws Exception {
        UIContext uiContext = new UIContext((Object)currentUI);
        if (map == null || map.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"22_DynaRangeProvider"));
        } else {
            uiContext.put((Object)"map", (Object)map);
            uiContext.put((Object)"sheet", (Object)activeSheet);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynaRangeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }
}

