/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractDynaRangeUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DynaRangeUI
extends AbstractDynaRangeUI {
    private static final Logger logger = CoreUIObject.getLogger(DynaRangeUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap map = (HashMap)this.getUIContext().get("map");
        this.setResult(map);
    }

    private void setResult(HashMap map) throws Exception {
        String s;
        String msg;
        Point basePoint = null;
        Point dynaRangeRow = null;
        Point dynaRangeCol = null;
        boolean isGrade = true;
        Point sumItemRow = null;
        Point sumItemCol = null;
        String dynaSource = null;
        String orderBy = null;
        String orderRow = null;
        int orderCol = -1;
        if (map.get("basePoint") != null) {
            basePoint = (Point)map.get("basePoint");
        }
        if (map.get("dynaRangeRow") != null) {
            dynaRangeRow = (Point)map.get("dynaRangeRow");
        }
        if (map.get("dynaRangeCol") != null) {
            dynaRangeCol = (Point)map.get("dynaRangeCol");
        }
        if (map.get("isGrade") != null) {
            isGrade = (Boolean)map.get("isGrade");
        }
        if (map.get("sumItemRow") != null) {
            sumItemRow = (Point)map.get("sumItemRow");
        }
        if (map.get("sumItemCol") != null) {
            sumItemCol = (Point)map.get("sumItemCol");
        }
        if (map.get("dynaSource") != null) {
            DynaItemTypeEnum typeEnum = (DynaItemTypeEnum)((Object)map.get("dynaSource"));
            dynaSource = DynaItemTypeEnum.Other.equals((Object)typeEnum) ? map.get("dynaSource_Alias").toString() : typeEnum.getAlias();
        }
        if (basePoint != null) {
            String s2;
            if (dynaRangeRow != null) {
                s2 = TableToolkit.xy2range((int)basePoint.x, (int)basePoint.y) + ":" + TableToolkit.xy2range((int)dynaRangeRow.y, (int)dynaRangeRow.x);
                this.txtDynaRange.setText(s2);
            } else if (dynaRangeCol != null) {
                s2 = TableToolkit.xy2range((int)basePoint.x, (int)basePoint.y) + ":" + TableToolkit.xy2range((int)dynaRangeCol.y, (int)dynaRangeCol.x);
                this.txtDynaRange.setText(s2);
            }
        }
        if (dynaSource != null && !dynaSource.equalsIgnoreCase("")) {
            this.txtDynaSource.setText(dynaSource);
        }
        if (isGrade) {
            this.txtGradeSum.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"86_DynaRangeUI"));
        } else {
            this.txtGradeSum.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"87_DynaRangeUI"));
        }
        if (map.get("isHaveSumItem") != null) {
            if (sumItemRow != null) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"100_DynaRangeUI");
                s = MessageFormat.format(msg, sumItemRow.x + 1);
                this.txtSumRow.setText(s);
            } else if (sumItemCol != null) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"101_DynaRangeUI");
                s = MessageFormat.format(msg, this.getCellName(0, sumItemCol.y));
                this.txtSumRow.setText(s);
            }
        } else {
            this.txtSumRow.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"23_DynaRangeUI"));
        }
        if ((OrderByEnum)map.get("orderBy") == OrderByEnum.NONE) {
            orderBy = OrderByEnum.NONE.getAlias();
            this.txtSort.setText(orderBy);
        } else {
            orderBy = ((OrderByEnum)map.get("orderBy")).getAlias();
            if (map.get("orderRow") != null) {
                orderRow = (String)map.get("orderRow");
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"102_DynaRangeUI");
                s = MessageFormat.format(msg, Character.valueOf(orderRow.charAt(0)), orderBy);
                this.txtSort.setText(s);
            }
            if (map.get("orderCol") != null) {
                orderCol = (Integer)map.get("orderCol");
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"103_DynaRangeUI");
                s = MessageFormat.format(msg, orderCol, orderBy);
                this.txtSort.setText(s);
            }
        }
        Object isOnlyListHasDataItem = map.get("isOnlyListHasDataItem");
        if (isOnlyListHasDataItem != null && !StringUtils.isEmpty((String)isOnlyListHasDataItem.toString())) {
            this.kdOnlyFillData.setSelectedItem((Object)isOnlyListHasDataItem.toString().trim());
        } else {
            this.kdOnlyFillData.setSelectedIndex(0);
        }
    }

    public String getCellName(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return null;
        }
        int[] series = DynaRangeUI.getBaseSeries(colIndex, 26);
        StringBuffer colName = new StringBuffer();
        int n = series.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0 && n > 1) {
                colName.append((char)(64 + series[i]));
                continue;
            }
            colName.append((char)(65 + series[i]));
        }
        return colName.toString();
    }

    public static int[] getBaseSeries(int number, int base) {
        if (number < 0 || base < 1) {
            return new int[0];
        }
        int n = number;
        ArrayList<Integer> result = new ArrayList<Integer>();
        do {
            result.add(0, new Integer(n - n / base * base));
        } while ((n /= base) > 0);
        int[] ret = new int[result.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)result.get(i);
        }
        return ret;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        HashMap map = (HashMap)this.getUIContext().get("map");
        Object sheet = this.getUIContext().get("sheet");
        Object basePoint = map.get("basePoint");
        if (basePoint != null && basePoint instanceof Point) {
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            param.setOnlyListHasDataItem((String)this.kdOnlyFillData.getSelectedItem());
            Range range = ((Sheet)sheet).getRange(((Point)basePoint).y, ((Point)basePoint).x);
            DynamicTemplateUtility.saveParametersToCell(range, param);
        }
        super.actionOk_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtDynaRange.setEnabled(false);
        this.txtDynaSource.setEnabled(false);
        this.txtGradeSum.setEnabled(false);
        this.txtSumRow.setEnabled(false);
        this.txtSort.setEnabled(false);
        this.btnClose.setEnabled(true);
    }
}

