/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DynaRptItemDataFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.IDynaRptItemDataFacade;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractDynamicItemDataListUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaItemDataFilterUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class DynamicItemDataListUI
extends AbstractDynamicItemDataListUI
implements ICSLContextUI {
    private static final Logger logger = Logger.getLogger(DynamicItemDataListUI.class);
    private ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    private CommonQueryDialog conditionDialog = null;
    private DynaItemDataFilterUI conditionPanel = null;
    private ItemDataCondition condition = null;
    private HashMap extCondition = null;
    private EntityViewInfo ev;
    private boolean isFirstLoad = true;
    private boolean isFirstDefaultQuery = true;
    Map mapParams = null;
    private boolean isSupportOtherDS;
    private boolean isMergeByFiscalPeriod;
    private Map mapCurrency = new HashMap();

    public DynamicItemDataListUI() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupportOtherDS = values[1];
    }

    public void onLoad() throws Exception {
        if (!CSLContextHelper.isInitialized((Map)this.getUIContext())) {
            SysUtil.abort();
        }
        this.tblMain.checkParsed();
        this.tblMain.getColumn("keyNumber").getStyleAttributes().setHided(false);
        super.onLoad();
        CSLContextHelper.registUIObject((ICSLContextUI)this);
        this.actionRefresh_actionPerformed(null);
        this.popFilterDialog();
        if (this.isSupportOtherDS) {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.initData();
    }

    private void initData() throws BOSException {
        OrgTreeInfo orgBound = this.cslCtx.getCurOrgBound();
        this.txtOrgTree.setText(orgBound.getName());
        this.txtOrgTree.setEnabled(false);
        this.txtPeriodType.setText(this.cslCtx.getCurRptPeriodType().getAlias());
        this.txtPeriodType.setEnabled(false);
        this.txtCurrency.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject((ICSLContextUI)this);
        super.disposeUIWindow();
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.gr.dynamic.app", "DynaItemDataQuery");
            ICSLContext ctx = CSLContextHelper.getCSLContext();
            if (ctx.isQueryBudget()) {
                mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
            }
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(510);
            this.conditionDialog.setHeight(264);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.dynamic.client.DynamicItemDataListUI");
        }
        return this.conditionDialog;
    }

    public DynaItemDataFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new DynaItemDataFilterUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.cslCtx.getCurReportDate());
        Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
        FilterItemInfo filterStartDate = new FilterItemInfo("startDate", (Object)startTime, CompareType.GREATER_EQUALS);
        filterInfo.getFilterItems().add(filterStartDate);
        FilterItemInfo filterEndDate = new FilterItemInfo("endDate", (Object)startTime, CompareType.LESS_EQUALS);
        filterInfo.getFilterItems().add(filterEndDate);
        FilterItemInfo filterItemLevel = new FilterItemInfo("itemLevel", (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItemLevel);
        FilterItemInfo filterItemLevelTo = new FilterItemInfo("itemLevelTo", (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItemLevelTo);
        FilterItemInfo filterType = new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterType);
        FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterPeriodType);
        FilterItemInfo filterAdjust = new FilterItemInfo("isAdjusted", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterAdjust);
        FilterItemInfo filterShowFreeze = new FilterItemInfo("isShowFreezeItem", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterShowFreeze);
        FilterItemInfo defaultOrgBound = new FilterItemInfo("defaultOrgBound", (Object)"defaultOrgBound", CompareType.EQUALS);
        filterInfo.getFilterItems().add(defaultOrgBound);
        return filterInfo;
    }

    private void queryData(boolean refresh) throws BOSException, EASBizException {
        if (!refresh || this.ev == null) {
            this.ev = this.conditionDialog.getEntityViewInfoResult();
        }
        HashMap result = this.constructCondition(this.ev);
        this.condition = (ItemDataCondition)result.get("condition");
        this.extCondition = (HashMap)result.get("extCondition");
        this.extCondition.put("maxReturnRowCount", new Integer(this.conditionDialog.getMaxReturnRowCount()));
        if (this.condition != null && this.extCondition != null) {
            if (this.condition.getRptPeriodType() != -1) {
                this.txtPeriodType.setText(RptPeriodTypeEnum.getEnum((int)this.condition.getRptPeriodType()).getAlias());
            } else {
                this.txtPeriodType.setText(CslRptUtil.getString((String)"CslRptItemDataNameAll"));
            }
            this.txtPeriodType.setEnabled(false);
            if (this.extCondition.get("currencyName") != null) {
                String currencyName = (String)this.extCondition.get("currencyName");
                this.txtCurrency.setText(currencyName);
                this.txtCurrency.setEnabled(false);
            }
            this.refreshTable(this.condition, this.extCondition);
        }
    }

    protected void refreshTable(ItemDataCondition condition, HashMap extCondition) throws EASBizException, BOSException {
        try {
            long counter = System.currentTimeMillis();
            if (!this.isFirstLoad) {
                super.setMessageText(CslRptUtil.getString((String)"CslRptItemDataQuerying"));
                super.showMessage();
            }
            IDynaRptItemDataFacade dataService = DynaRptItemDataFacadeFactory.getRemoteInstance();
            condition.setQueryHisBudget(this.cslCtx.isQueryBudget());
            List result = dataService.getDynamicItemData(condition, extCondition);
            this.loadTable(result);
            if (!this.isFirstLoad) {
                this.showFinalCaclMessage(counter);
            }
            this.isFirstLoad = false;
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"20_DynamicItemDataListUI"));
            try {
                this.actionQuery_actionPerformed(null);
            }
            catch (Exception e1) {
                this.handleException(e1);
                this.abort();
            }
        }
    }

    private void loadTable(List data) {
        this.tblMain.removeRows(false);
        String[] colNames = new String[]{"orgTree.number", "orgTree.name", "orgUnit.number", "orgUnit.name", "currency.name", "targetCurrency.name", "dataSource", "periodType", "year", "period", "valueType", "item.number", "item.name", "dataElement.number", "dataElemnet.name", "dyItemNumber", "dyItemName", "attribute", "dataCollect", "keyNumber", "keyName", "debit", "credit", "text"};
        if (data != null && data.size() > 0) {
            int iSize = data.size();
            for (int i = 0; i < iSize; ++i) {
                Object[] row = (Object[])data.get(i);
                IRow tmpRow = this.tblMain.addRow();
                for (int j = 0; j < colNames.length; ++j) {
                    if (row[j] == null || tmpRow.getCell(colNames[j]) == null) continue;
                    tmpRow.getCell(colNames[j]).setValue(row[j]);
                }
                if (!row[10].toString().trim().equals(ValueTypeEnum.MONEY.getAlias().trim())) continue;
                String currNumber = row[24].toString();
                String formatStr = this.getFormatString(currNumber, tmpRow);
                tmpRow.getCell("debit").getStyleAttributes().setNumberFormat(formatStr);
                tmpRow.getCell("credit").getStyleAttributes().setNumberFormat(formatStr);
                if (tmpRow.getCell("debit").getValue() != null && tmpRow.getCell("debit").getValue().toString().equals(String.valueOf(0))) {
                    tmpRow.getCell("debit").setValue(null);
                }
                if (tmpRow.getCell("credit").getValue() == null || !tmpRow.getCell("credit").getValue().toString().equals(String.valueOf(0))) continue;
                tmpRow.getCell("credit").setValue(null);
            }
        }
    }

    private String getFormatString(String currNumber, IRow tmpRow) {
        CurrencyInfo info = null;
        int precision = 2;
        if (this.mapCurrency.containsKey(currNumber)) {
            return (String)this.mapCurrency.get(currNumber);
        }
        try {
            info = CurrencyFactory.getRemoteInstance().getCurrencyCollection(" where number = '" + currNumber + "'").get(0);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (info != null) {
            precision = info.getPrecision();
        }
        String numberFmt = CslRptUIUtil.getNumberFtm((int)precision);
        this.mapCurrency.put(currNumber, numberFmt);
        return numberFmt;
    }

    protected void popFilterDialog() throws Exception {
        this.conditionDialog = this.getConditionDialog();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "com.kingdee.eas.fi.gr.dynamic.app.DynaItemDataQuery";
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if (ctx.isQueryBudget()) {
            queryName = "com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery";
        }
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, companyID, currUserID)) {
            this.isFirstDefaultQuery = false;
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, companyID, currUserID);
            if (solution.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION) || solution.getName().equals(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonQueryPanel", (String)"sysDefaultRule"))) {
                this.ev = new EntityViewInfo();
                this.ev.setFilter(this.getDefaultFilterForQuery());
            } else {
                this.ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName, companyID, currUserID);
            }
            if (this.ev == null) {
                this.ev = new EntityViewInfo();
            }
            if (this.ev.getFilter() == null) {
                this.ev.setFilter(new FilterInfo());
            }
            this.conditionPanel.onLoad();
            this.conditionPanel.loadData(this.ev);
            this.conditionPanel.verify();
            this.queryData(true);
        } else {
            if (this.isFirstDefaultQuery) {
                this.isFirstDefaultQuery = false;
            }
            if (this.conditionDialog.show()) {
                this.tHelper.setDialog(this.conditionDialog);
                this.queryData(false);
            } else {
                SysUtil.abort();
            }
        }
    }

    private void showFinalCaclMessage(long startTime) {
        long counter = System.currentTimeMillis() - startTime;
        BigDecimal time = new BigDecimal(String.valueOf((double)counter / 1000.0)).setScale(2, 4);
        super.setMessageText(CslRptUtil.getStringWithFormat((String)"CslRptItemDataQueryOK", (Object[])new Object[]{time.toString()}));
        super.showMessage();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.popFilterDialog();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.condition == null) {
            return;
        }
        this.refreshTable(this.condition, this.extCondition);
    }

    public void update(Observable o, Object arg) {
        CSLContextHelper.update((Observable)o, (CoreUI)this);
    }

    private HashMap constructCondition(EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        ItemDataCondition condition = new ItemDataCondition();
        condition.setOrgTreeNumber(this.cslCtx.getCurOrgBound().getId().toString());
        condition.setCommitStatus(3);
        FilterItemCollection filterItemCollection = entityViewInfo.getFilter().getFilterItems();
        int periodType = -1;
        Date startDate = this.cslCtx.getCurReportDate();
        Date endDate = this.cslCtx.getCurReportDate();
        Integer type = new Integer(0);
        String keyName = "";
        String currencyName = "";
        for (int i = 0; i < filterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnitId")) {
                String companyID = (String)filterItemInfo.getCompareValue();
                ArrayList<String> companys = new ArrayList<String>();
                companys.add(companyID);
                condition.setOrgUnit(companys);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("defaultOrgBound")) {
                ArrayList orgUnitList = CslRptUtil.getCslOrgs(null, (OrgTreeInfo)this.cslCtx.getCurOrgBound(), (OrgUnitInfo)this.cslCtx.getCurOrgGroup());
                orgUnitList.add(this.cslCtx.getCurOrgGroup().getId().toString());
                condition.setOrgUnit(orgUnitList);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportClass")) {
                String reportClassID = (String)filterItemInfo.getCompareValue();
                condition.setReportClass(reportClassID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("rptDate")) {
                Timestamp time = (Timestamp)filterItemInfo.getCompareValue();
                startDate = new Date(time.getTime());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("rptDateTo")) {
                Timestamp time = (Timestamp)filterItemInfo.getCompareValue();
                endDate = new Date(time.getTime());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency")) {
                String currencyID = (String)filterItemInfo.getCompareValue();
                condition.setCurrency(currencyID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCurrency")) {
                String targetCurrencyID = (String)filterItemInfo.getCompareValue();
                condition.setTargetCurrency(targetCurrencyID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item")) {
                String itemID = (String)filterItemInfo.getCompareValue();
                condition.setItemNumberStart(itemID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemTo")) {
                String itemID = (String)filterItemInfo.getCompareValue();
                condition.setItemNumberEnd(itemID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevel")) {
                Integer level = (Integer)filterItemInfo.getCompareValue();
                condition.setItemNumberLevelStart(level.intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevelTo")) {
                Integer levelTo = (Integer)filterItemInfo.getCompareValue();
                condition.setItemNumberLevelEnd(levelTo.intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("type")) {
                type = (Integer)filterItemInfo.getCompareValue();
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                periodType = (Integer)filterItemInfo.getCompareValue();
                condition.setRptPeriodType(periodType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("AdjustStatus")) {
                Integer adjust = (Integer)filterItemInfo.getCompareValue();
                condition.setIsAdjusted(adjust == 1);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataSource")) {
                Integer dataSrc = (Integer)filterItemInfo.getCompareValue();
                condition.setDataSource(dataSrc.intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElement")) {
                Integer dataElement = (Integer)filterItemInfo.getCompareValue();
                condition.setDataElement(dataElement.intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("valueType")) {
                Integer valueType = (Integer)filterItemInfo.getCompareValue();
                condition.setValueType(valueType.intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("keyName")) {
                keyName = (String)filterItemInfo.getCompareValue();
                if (!"TTttt".equals(keyName)) continue;
                condition.setForBiReport(true);
                keyName = null;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isShowFreezeItem")) {
                boolean isShowFreezeItem = false;
                isShowFreezeItem = filterItemInfo.getCompareValue() instanceof Boolean ? (Boolean)filterItemInfo.getCompareValue() : (Integer)filterItemInfo.getCompareValue() == 1;
                condition.setIsShowFreezeItem(isShowFreezeItem);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("currencyName")) continue;
            currencyName = (String)filterItemInfo.getCompareValue();
        }
        if (periodType != -1) {
            if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType))) {
                try {
                    condition.setRptYearStart(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                    condition.setRptYearEnd(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodEnd(this.cslCtx.getCurRptPeriod());
                }
                catch (BOSException e) {
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                }
            } else {
                int[] yearAndPeriodStart = RPTDateUtil.getPeriod((Date)startDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                int[] yearAndPeriodEnd = RPTDateUtil.getPeriod((Date)endDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                condition.setRptYearStart(yearAndPeriodStart[0]);
                condition.setRptPeriodStart(yearAndPeriodStart[1]);
                condition.setRptYearEnd(yearAndPeriodEnd[0]);
                condition.setRptPeriodEnd(yearAndPeriodEnd[1]);
            }
        } else {
            condition.setStartDate(startDate);
            condition.setEndDate(endDate);
        }
        if (condition.getOrgUnit() == null || condition.getOrgUnit().isEmpty()) {
            ArrayList orgUnitList = new ArrayList();
            try {
                orgUnitList = CslRptUtil.getCslOrgs(null, (OrgTreeInfo)this.cslCtx.getCurOrgBound(), (OrgUnitInfo)this.cslCtx.getCurOrgGroup());
                orgUnitList.add(this.cslCtx.getCurOrgGroup().getId().toString());
            }
            catch (EASBizException yearAndPeriodEnd) {
            }
            catch (BOSException yearAndPeriodEnd) {
                // empty catch block
            }
            condition.setOrgUnit(orgUnitList);
        }
        if (this.isSupportOtherDS) {
            condition.setDataCollectNumber(this.cslCtx.getCurDataCollect().getNumber());
        } else {
            condition.setDataCollectNumber("ACTUALDATA");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> extCondition = new HashMap<String, Object>();
        extCondition.put("dataType", type);
        extCondition.put("keyName", keyName);
        if (!currencyName.equals("")) {
            extCondition.put("currencyName", currencyName);
        } else {
            extCondition.put("currencyName", CslRptUtil.getString((String)"CslRptItemDataNameAll"));
        }
        boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
        if (isSupport13Period) {
            if (periodType == 3 && startDate != null && endDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startDate);
                int startMonth = calendar.get(2) + 1;
                int startYear = calendar.get(1);
                calendar.setTime(endDate);
                int endMonth = calendar.get(2) + 1;
                int endYear = calendar.get(1);
                int curPeiod = this.cslCtx.getCurRptPeriod();
                Date curReportDate = this.cslCtx.getCurReportDate();
                calendar.setTime(curReportDate);
                int cslCtxMonth = calendar.get(2) + 1;
                if (cslCtxMonth == 12) {
                    if (startYear == endYear && startMonth == 12 && endMonth == 12) {
                        extCondition.put("period", new Integer(curPeiod));
                    } else if (startDate.compareTo(endDate) <= 0 && (startMonth == 12 || endMonth == 12 || startYear < endYear)) {
                        if (curPeiod == 13) {
                            extCondition.put("query13Period", "Y");
                            extCondition.put("query12Period", "N");
                        } else {
                            extCondition.put("query13Period", "N");
                            extCondition.put("query12Period", "Y");
                        }
                    } else {
                        extCondition.put("query13Period", "N");
                        extCondition.put("query12Period", "N");
                    }
                } else if (startDate.compareTo(endDate) <= 0 && (startMonth == 12 || endMonth == 12 || startYear < endYear)) {
                    extCondition.put("query13Period", "Y");
                    extCondition.put("query12Period", "Y");
                } else {
                    extCondition.put("query13Period", "N");
                    extCondition.put("query12Period", "N");
                }
            }
            extCondition.put("isItemData", "Y");
        } else {
            extCondition.put("isItemData", "N");
            if (periodType == 3 && startDate != null && endDate != null) {
                extCondition.put("query13Period", "N");
            }
        }
        extCondition.put("ORG_TREE_NUMBER", this.cslCtx.getCurOrgBound().getNumber());
        result.put("condition", condition);
        result.put("extCondition", extCondition);
        return result;
    }
}

