/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMulMnsTmpGuide_ChooseItemsUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.dynamic.client.MulMnsTmpGuide_ChooseAsstTypeUI;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MulMnsTmpGuide_ChooseItemsUI
extends AbstractMulMnsTmpGuide_ChooseItemsUI {
    protected static final int COL_ID = 0;
    protected static final int COL_ITEM_NUMBER = 1;
    protected static final int COL_ITEM_NAME = 2;
    protected static final int COL_DATAELEMENT = 3;
    protected static final int COL_VALUETYPE = 4;
    protected static final int COL_YEAR = 5;
    protected static final int COL_PERIOD = 6;
    public Sheet curSheet;
    private int preSpreadStyle = -1;
    private ArrayList dynaItemList = new ArrayList();
    private ArrayList basePointList = null;
    private DynaParameters parameters = new DynaParameters();
    private Point basePoint;
    private boolean isModify;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCurSheet();
        this.initBasePointList();
        this.initParameters();
        this.initControl();
        this.initItemsTable();
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        MnsRptTmpGuideUIUtil.hmUIs.put(MulMnsTmpGuide_ChooseItemsUI.class.getName(), this);
        this.tblItems.checkParsed();
        this.tblItems.getSelectManager().setSelectMode(2);
        this.tblItems.getStyleAttributes().setLocked(true);
        this.btnCancel.setEnabled(true);
        this.btnPreStep.setEnabled(false);
        this.btnNextStep.setEnabled(true);
        this.btnFinished.setEnabled(false);
        this.btnAddNew.setEnabled(true);
        this.btnMoveUp.setEnabled(true);
        this.btnMoveDown.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnHelp.setVisible(false);
        this.kdrVertical.setEnabled(false);
        this.kdrAppend.setEnabled(false);
    }

    private void initCurSheet() {
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        if (this.curSheet == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TableIsNull"));
            SysUtil.abort();
        }
    }

    private void initBasePointList() {
        this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
    }

    private void initParameters() {
        this.setModify(this.getUIContext().get("isModify") != null);
        if (this.isModify()) {
            this.parameters = this.getPreDynaParam();
            this.setPreSpreadStyle(this.parameters.getSpreadStyle());
        } else {
            this.parameters = new DynaParameters();
        }
    }

    public void setPreSpreadStyle(int preSpreadStyle) {
        this.preSpreadStyle = preSpreadStyle;
    }

    @Override
    protected void btnNextStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnNextStep_actionPerformed(e);
        if (this.tblItems.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ItemNull"));
            SysUtil.abort();
        }
        this.getUIWindow().hide();
        if (MnsRptTmpGuideUIUtil.hmUIs.get(this.getNextUIName()) == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"isModify", (Object)this.isModify());
            uiContext.put((Object)"parameters", (Object)this.parameters);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getNextUIName(), (Map)uiContext, null, this.getOprtState());
            window.show();
        } else {
            Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(this.getNextUIName());
            if (obj instanceof CoreUI) {
                CoreUI nextUI = (CoreUI)obj;
                nextUI.getUIWindow().show();
            }
        }
    }

    private List getTableItems() {
        ArrayList<Object> itemList = new ArrayList<Object>();
        int rowCount = this.tblItems.getRowCount();
        int colCount = this.tblItems.getColumnCount();
        if (rowCount != 0) {
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    itemList.add(this.tblItems.getRow(i).getCell(j).getValue());
                }
            }
        }
        return itemList;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        if (MnsRptTmpGuideUIUtil.isCloseWindow((Component)((Object)this))) {
            MnsRptTmpGuideUIUtil.closeAllUI();
        }
    }

    private Point getBasePoint() {
        if (this.basePoint != null) {
            return this.basePoint;
        }
        if (this.isModify()) {
            Point point = new Point(this.curSheet.getActiveCol(), this.curSheet.getActiveRow());
            this.basePoint = DynamicTemplateUtility.getBasePoint(this.curSheet, point, this.basePointList);
            if (this.basePoint == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"46_MulMnsTmpGuide_ChooseItemsUI"));
                SysUtil.abort();
            }
        } else {
            this.basePoint = this.getBasePointList() == null || this.getBasePointList().size() == 0 ? this.initBasePoint(this.curSheet) : (Point)this.getBasePointList().get(0);
        }
        return this.basePoint;
    }

    private Point initBasePoint(Sheet table) {
        Point point = new Point(0, 0);
        point.y = table.getActiveRow();
        point.x = table.getActiveCol();
        return point;
    }

    private ArrayList getBasePointList() {
        return this.basePointList;
    }

    private DynaParameters getPreDynaParam() {
        Point basePoint = this.getBasePoint();
        DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, basePoint.y, basePoint.x);
        return param;
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnPreStep_actionPerformed(e);
    }

    @Override
    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        this.bindingDynaItemListFromTable(this.tblItems);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"DynaHeadItemList", (Object)this.getDynaItemList());
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.dynamic.client.AddDynaItemUI", (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.bindingDynaItemListToTable(this.tblItems);
    }

    @Override
    public void actionUpItem_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.moveUpTableRows(this.tblItems);
    }

    @Override
    public void actionDownItem_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.moveDownTableRows(this.tblItems);
    }

    @Override
    public void actionRemoveItem_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.removeTableRows(this.tblItems);
    }

    private String getNextUIName() {
        return MulMnsTmpGuide_ChooseAsstTypeUI.class.getName();
    }

    private void bindingDynaItemListFromTable(KDTable table) {
        table.getDataRequestManager().setDataRequestMode(0);
        int count = table.getRowCount();
        this.clearDynaHeadItem();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = new DynaHeadItem();
            r = table.getRow(i);
            this.bindInfoFromRow(dyna, r);
            this.addDynaHeadItem(dyna);
        }
    }

    private void bindInfoFromRow(DynaHeadItem dyna, IRow iRow) {
        dyna.rptItem = (RPTItemInfo)iRow.getCell(1).getUserObject();
        dyna.dataElement = (DataElementInfo)iRow.getCell(3).getUserObject();
        dyna.valueType = (ValueTypeEnum)iRow.getCell(4).getValue();
        dyna.year = (Integer)iRow.getCell(5).getValue();
        dyna.period = (Integer)iRow.getCell(6).getValue();
    }

    private void bindingDynaItemListToTable(KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        table.getDataRequestManager().setDataRequestMode(0);
        int count = this.getDynaItemList().size();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = (DynaHeadItem)this.getDynaItemList().get(i);
            r = table.addRow();
            this.bindInfoToRow(dyna, r);
        }
    }

    private void bindInfoToRow(DynaHeadItem dyna, IRow iRow) {
        iRow.getCell(1).setValue((Object)dyna.rptItem.getNumber());
        iRow.getCell(1).setUserObject((Object)dyna.rptItem);
        iRow.getCell(2).setValue((Object)dyna.rptItem.getName());
        iRow.getCell(3).setValue((Object)dyna.dataElement.getName());
        iRow.getCell(3).setUserObject((Object)dyna.dataElement);
        iRow.getCell(4).setValue((Object)dyna.valueType);
        iRow.getCell(5).setValue((Object)new Integer(dyna.year));
        iRow.getCell(6).setValue((Object)new Integer(dyna.period));
    }

    public ArrayList getDynaItemList() {
        return this.dynaItemList;
    }

    private void clearDynaHeadItem() {
        this.dynaItemList.clear();
    }

    private void addDynaHeadItem(DynaHeadItem item) {
        this.dynaItemList.add(item);
    }

    public int getSpreadStyle() {
        if (this.kdrVertical.isSelected()) {
            return 0;
        }
        if (this.kdrAppend.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    private void initItemsTable() throws BOSException, EASBizException {
        AsstActTypeCollection typeCollection = null;
        if (this.isModify()) {
            AsstAccountUtils asstAccount = this.parameters.getAsstAccount();
            HashSet<String> attSet = new HashSet<String>();
            for (AsstActTypeUtils asstActType : asstAccount.getAsstActTypeList()) {
                attSet.add(asstActType.getAsstHGAttribute());
            }
            IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
            viewInfo.getSelector().add(new SelectorItemInfo("defaultQueryName"));
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attSet, CompareType.INCLUDE));
            typeCollection = iAsstActType.getAsstActTypeCollection(viewInfo);
            HashMap<String, AsstActTypeInfo> asstmap = new HashMap<String, AsstActTypeInfo>();
            for (int i = 0; i < typeCollection.size(); ++i) {
                asstmap.put(typeCollection.get(i).getAsstHGAttribute(), typeCollection.get(i));
            }
            this.bindingDynaItemListFromTable(this.tblItems);
        }
    }

    private IRow addAsstActTypeRow() {
        this.tblItems.checkParsed();
        IRow row = this.tblItems.addRow();
        ICell cell = row.getCell("itemName");
        cell.getStyleAttributes().setLocked(false);
        return row;
    }

    private void initControl() throws BOSException {
        if (this.isModify()) {
            this.kdrVertical.setEnabled(false);
            this.kdrAppend.setEnabled(false);
            this.kdrVertical.setSelected(true);
            this.initItemTable();
        } else if (this.getBasePointList().size() == 0) {
            this.kdrAppend.setEnabled(false);
            this.kdrVertical.setSelected(true);
        } else {
            Point point = (Point)this.getBasePointList().get(0);
            DynaParameters tempPara = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet.getRange(point.y, point.x));
            this.setPreSpreadStyle(tempPara.getSpreadStyle());
            this.kdrAppend.setSelected(true);
        }
    }

    private void initItemTable() throws BOSException {
        int i;
        Point basePoint = this.getBasePoint();
        int colCount = this.getColCount(this.curSheet, basePoint.y, basePoint.x);
        HashSet<String> itemNumberSet = new HashSet<String>();
        ArrayList<ItemFormula> formulaList = new ArrayList<ItemFormula>();
        for (int i2 = basePoint.x + 1; i2 <= colCount; ++i2) {
            ItemFormula itemCellObj = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(basePoint.y, i2, false));
            if (itemCellObj == null || itemCellObj.getItemNumber() == null || itemCellObj.getItemNumber().length() == 0) continue;
            formulaList.add(itemCellObj);
            itemNumberSet.add(itemCellObj.getItemNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", itemNumberSet, CompareType.INCLUDE));
        RPTItemCollection itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(view);
        HashMap<String, RPTItemInfo> number2InfoMap = new HashMap<String, RPTItemInfo>();
        for (i = 0; i < itemCollection.size(); ++i) {
            number2InfoMap.put(itemCollection.get(i).getNumber(), itemCollection.get(i));
        }
        for (i = 0; i < formulaList.size(); ++i) {
            ItemFormula dItem = (ItemFormula)formulaList.get(i);
            RPTItemInfo rptItemInfo = (RPTItemInfo)number2InfoMap.get(dItem.getItemNumber());
            DataElementInfo dataElement = DataElementProvider.getDataElementInfo((String)dItem.getDataElementNumber());
            ValueTypeEnum valueType = ValueTypeEnum.getEnum((int)dItem.getValueType());
            int year = dItem.getYearOffSet();
            int period = dItem.getPeriodOffSet();
            this.bindInfoToTable(rptItemInfo, dataElement, valueType, year, period);
        }
    }

    private int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private void bindInfoToTable(RPTItemInfo rptInfo, DataElementInfo dataElem, ValueTypeEnum valueType, int year, int period) {
        this.tblItems.checkParsed();
        IRow row = this.tblItems.addRow();
        row.getCell(0).setUserObject((Object)rptInfo.getId().toString());
        row.getCell(1).setUserObject((Object)rptInfo);
        row.getCell(2).setUserObject((Object)rptInfo.getName());
        row.getCell(3).setUserObject((Object)dataElem);
        row.getCell(4).setUserObject((Object)valueType);
        row.getCell(5).setUserObject((Object)new Integer(year));
        row.getCell(6).setUserObject((Object)new Integer(period));
        row.getCell(0).setValue((Object)rptInfo.getId().toString());
        row.getCell(1).setValue((Object)rptInfo);
        row.getCell(2).setValue((Object)rptInfo.getName());
        row.getCell(3).setValue((Object)dataElem);
        row.getCell(4).setValue((Object)valueType);
        row.getCell(5).setValue((Object)new Integer(year));
        row.getCell(6).setValue((Object)new Integer(period));
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }
}

