/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMulMnsTmpGuide_ShowResultUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.dynamic.client.MulMnsTmpGuide_ChooseAsstTypeUI;
import com.kingdee.eas.fi.gr.dynamic.client.MulMnsTmpGuide_ChooseItemsUI;
import com.kingdee.eas.fi.gr.dynamic.client.MulMnsTmpGuide_ChooseSumUI;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaProperty;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class MulMnsTmpGuide_ShowResultUI
extends AbstractMulMnsTmpGuide_ShowResultUI {
    private boolean hasSum = false;
    private boolean hasDebit = false;
    private boolean hasCredit = false;
    private boolean hasCsl = false;
    private int year = 0;
    private int period = 0;
    private ArrayList dynaItemList;
    private Point basePoint;
    private Sheet curSheet;
    private DynaParameters parameters = new DynaParameters();
    private boolean isModify = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("isModify") != null) {
            boolean bl = this.isModify = this.getUIContext().get("isModify").toString().equals("true");
        }
        if (this.getUIContext().get("parameters") != null) {
            this.parameters = (DynaParameters)this.getUIContext().get("parameters");
        }
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        if (!this.isModify) {
            this.initParam();
        }
        this.initTable();
        this.btnCancel.setEnabled(true);
        this.btnPreStep.setEnabled(true);
        this.btnNextStep.setEnabled(false);
        this.btnFinished.setEnabled(true);
        this.btnHelp.setVisible(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        if (MnsRptTmpGuideUIUtil.isCloseWindow((Component)((Object)this))) {
            MnsRptTmpGuideUIUtil.closeAllUI();
            MnsRptTmpGuideUIUtil.hmUIs.clear();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinished_actionPerformed(ActionEvent e) throws Exception {
        super.btnFinished_actionPerformed(e);
        if (this.isModify) {
            this.curSheet.clearEmptyCells();
        }
        this.fillData(this.curSheet);
        MnsRptTmpGuideUIUtil.hmUIs.clear();
        MnsRptTmpGuideUIUtil.closeAllUI();
        this.getUIWindow().close();
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnPreStep_actionPerformed(e);
        this.getUIWindow().hide();
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MulMnsTmpGuide_ChooseSumUI.class.getName());
        if (obj != null && obj instanceof CoreUI) {
            CoreUI preUI = (CoreUI)obj;
            preUI.getUIWindow().show();
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnNextStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnNextStep_actionPerformed(e);
    }

    private void initTable() {
        this.tblResult.checkParsed();
        this.tblResult.getStyleAttributes().setLocked(true);
        this.tblResult.getSelectManager().setSelectMode(4);
        this.loadTable(this.tblResult);
        this.tblResult.setFocusable(false);
    }

    private void initParam() {
        this.initItemParam();
        this.initAsstParam();
        this.initSumParam();
    }

    private void initItemParam() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MulMnsTmpGuide_ChooseItemsUI.class.getName());
        if (obj != null && obj instanceof MulMnsTmpGuide_ChooseItemsUI) {
            MulMnsTmpGuide_ChooseItemsUI itemUI = (MulMnsTmpGuide_ChooseItemsUI)((Object)obj);
            this.curSheet = itemUI.curSheet;
            int top = this.curSheet.getActiveRow();
            int left = this.curSheet.getActiveCol();
            this.basePoint = new Point(left, top);
            this.dynaItemList = itemUI.getDynaItemList();
            this.parameters.setSpreadStyle(itemUI.getSpreadStyle());
        }
    }

    private void initAsstParam() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MulMnsTmpGuide_ChooseAsstTypeUI.class.getName());
        if (obj != null && obj instanceof MulMnsTmpGuide_ChooseAsstTypeUI) {
            MulMnsTmpGuide_ChooseAsstTypeUI itemUI = (MulMnsTmpGuide_ChooseAsstTypeUI)((Object)obj);
            int defaultCounter = (Integer)itemUI.kDSDefaultCounter.getValue();
            this.parameters.setMaxCounter(defaultCounter > this.parameters.getDefaultCounter() ? defaultCounter : this.parameters.getDefaultCounter());
            this.parameters.setDefaultCounter((Integer)itemUI.kDSDefaultCounter.getValue());
            List asstActTypeList = itemUI.getAsstActTypeList();
            ArrayList<AsstActTypeUtils> asstActTypeUtilList = new ArrayList<AsstActTypeUtils>();
            for (AsstActTypeInfo element : asstActTypeList) {
                DynaProperty dy = (DynaProperty)element.get("fillAttribute");
                if (dy == null) {
                    asstActTypeUtilList.add(new AsstActTypeUtils(element.getNumber(), element.getName(), element.getAsstHGAttribute()));
                    continue;
                }
                asstActTypeUtilList.add(new AsstActTypeUtils(element.getNumber(), element.getName(), element.getAsstHGAttribute(), dy.getProperty(), dy.getName()));
            }
            this.parameters.setAsstAccount(new AsstAccountUtils(asstActTypeUtilList));
        }
    }

    private void initSumParam() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MulMnsTmpGuide_ChooseSumUI.class.getName());
        if (obj != null && obj instanceof MulMnsTmpGuide_ChooseSumUI) {
            MulMnsTmpGuide_ChooseSumUI headUI = (MulMnsTmpGuide_ChooseSumUI)((Object)obj);
            if (headUI.chkSum.isSelected()) {
                this.hasSum = true;
            }
            if (headUI.chkElimDebitSum.isSelected()) {
                this.hasDebit = true;
            }
            if (headUI.chkElimCreditSum.isSelected()) {
                this.hasCredit = true;
            }
            if (headUI.chkGourp.isSelected()) {
                this.hasCsl = true;
            }
        }
    }

    private void fillData(Sheet table) {
        if (this.dynaItemList != null && this.dynaItemList.size() > 0 && this.parameters != null) {
            this.curSheet.getSheetRange().clear(true, true, false, true, new String[0]);
            int asstColCount = this.constructAsstAccount(this.curSheet, this.basePoint);
            this.constructDynaHead(this.curSheet, this.basePoint, asstColCount);
            this.saveBasePointCell(this.curSheet, this.basePoint);
            int sumRowCount = 0;
            if (this.hasSum) {
                this.constructSumLine(this.curSheet, this.basePoint, asstColCount, sumRowCount++, EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"47_MulMnsTmpGuide_ShowResultUI"), 2);
            }
            if (this.hasDebit) {
                this.constructSumLine(this.curSheet, this.basePoint, asstColCount, sumRowCount++, EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"48_MulMnsTmpGuide_ShowResultUI"), 4);
            }
            if (this.hasCredit) {
                this.constructSumLine(this.curSheet, this.basePoint, asstColCount, sumRowCount++, EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"49_MulMnsTmpGuide_ShowResultUI"), 5);
            }
            if (this.hasSum) {
                this.constructSumLine(this.curSheet, this.basePoint, asstColCount, sumRowCount, EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"50_MulMnsTmpGuide_ShowResultUI"), 3);
            }
        }
    }

    private void saveBasePointCell(Sheet table, Point basePoint) {
        Range range = table.getRange(basePoint.y, basePoint.x);
        range.setUserObject("isSum", this.getUIContext().get("isSum"));
        range.setUserObject("isElimDebitSum", this.getUIContext().get("isElimDebitSum"));
        range.setUserObject("isElimCreditSum", this.getUIContext().get("isElimCreditSum"));
        range.setUserObject("isGroup", this.getUIContext().get("isGroup"));
        DynamicTemplateUtility.saveParametersToCell(range, this.parameters);
    }

    private int constructAsstAccount(Sheet curSheet, Point basePoint) {
        int actTypeColCount = this.parameters.getAsstAccount().getAsstActTypeList().size();
        int dv = 0;
        for (int i = 0; i < actTypeColCount; ++i) {
            AsstActTypeUtils acctType = (AsstActTypeUtils)this.parameters.getAsstAccount().getAsstActTypeList().get(i);
            if (StringUtils.isEmpty((String)acctType.dynapropertyName)) continue;
            Range cell = curSheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private void constructDynaHead(Sheet table, Point basePoint, int asstColCount) {
        int Count = this.dynaItemList.size();
        for (int i = 0; i < Count; ++i) {
            Range range = table.getRange(basePoint.y, i + basePoint.x + asstColCount);
            DynaHeadItem dynaItem = (DynaHeadItem)this.dynaItemList.get(i);
            this.constructHeadCell(range, dynaItem);
        }
    }

    private void constructHeadCell(Range curCell, DynaHeadItem dynaItem) {
        if (dynaItem == null) {
            return;
        }
        curCell.setIgnoreProtected(true);
        curCell.setValue(new Variant((Object)dynaItem.getDisplayName()));
        curCell.setUserObject("ITEM", (Object)new ItemFormula(dynaItem.toString()));
    }

    private void constructSumLine(Sheet table, Point basePoint, int asstCount, int sumRowCount, String sumName, int dataSrc) {
        Point sumPoint = new Point();
        int offset = 0;
        if (this.parameters.getPosition() == 1) {
            offset = 0;
        } else if (this.parameters.getPosition() == 2) {
            offset = this.parameters.getDefaultCounter();
        }
        if (this.parameters.getSpreadStyle() == 0) {
            sumPoint.x = basePoint.x;
            sumPoint.y = basePoint.y + 1 + offset + sumRowCount;
        }
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        range.setValue(new Variant((Object)sumName));
        range.setUserObject("DataSrc", (Object)new Integer(dataSrc));
        for (int i = 0; i < asstCount - 1; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setValue(new Variant((Object)"--"));
        }
    }

    private void loadTable(KDTable table) {
        int top = this.curSheet.getActiveRow();
        int left = this.curSheet.getActiveCol();
        table.removeColumns();
        table.setRowCount(-1);
        table.setHeadDisplayMode(1);
        table.setCellDisplayMode(1);
        if (this.dynaItemList == null || this.dynaItemList.size() == 0 || this.parameters == null || this.parameters.getAsstAccount() == null) {
            return;
        }
        int rptItemCount = this.dynaItemList.size();
        int actTypeCount = this.parameters.getAsstAccount().getAsstActTypeList().size();
        boolean[] sumBool = new boolean[4];
        String[] sumString = new String[4];
        sumBool[0] = this.hasSum;
        sumString[0] = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"47_MulMnsTmpGuide_ShowResultUI");
        sumBool[1] = this.hasDebit;
        sumString[1] = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"51_MulMnsTmpGuide_ShowResultUI");
        sumBool[2] = this.hasCredit;
        sumString[2] = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"52_MulMnsTmpGuide_ShowResultUI");
        sumBool[3] = this.hasCsl;
        sumString[3] = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"50_MulMnsTmpGuide_ShowResultUI");
        int sumCount = this.hasCredit ? 1 : 0;
        sumCount += this.hasCsl ? 1 : 0;
        sumCount += this.hasDebit ? 1 : 0;
        int rowCount = (sumCount += this.hasSum ? 1 : 0) + top;
        int columnCount = actTypeCount + rptItemCount + left;
        table.addColumns(columnCount);
        table.addRows(rowCount + 1);
        ArrayList asstTypeList = this.parameters.getAsstAccount().getAsstActTypeList();
        int sumIndex = 0;
        for (int i = top; i <= rowCount; ++i) {
            for (int j = left; j <= columnCount; ++j) {
                ICell curCell = table.getRow(i).getCell(j);
                if (i == top) {
                    if (j == left) {
                        // empty if block
                    }
                    if (j < left + actTypeCount) {
                        AsstActTypeUtils acctType = (AsstActTypeUtils)asstTypeList.get(j - left);
                        curCell.setValue((Object)acctType.getDynapropertyName());
                        continue;
                    }
                    if (j >= left + actTypeCount + rptItemCount) continue;
                    DynaHeadItem item = (DynaHeadItem)this.dynaItemList.get(j - left - actTypeCount);
                    curCell.setValue((Object)item.getDisplayName());
                    continue;
                }
                if (j == left) {
                    while (sumIndex < 4 && !sumBool[sumIndex]) {
                        ++sumIndex;
                    }
                    if (sumIndex >= 4) continue;
                    curCell.setValue((Object)sumString[sumIndex++]);
                    continue;
                }
                if (j >= left + actTypeCount) continue;
                curCell.setValue((Object)"--");
            }
        }
        CslRptUtil.saveBasePosition((KDTable)table, (int)left, (int)top);
    }

    class SrcAndElement {
        CslDataSrcTypeEnum dataSrc;
        DataElementInfo dataElement;
        ValueTypeEnum vType;

        SrcAndElement(CslDataSrcTypeEnum src, DataElementInfo element, ValueTypeEnum value) {
            this.dataSrc = src;
            this.dataElement = element;
            this.vType = value;
        }
    }
}

