/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaKeyAndValue;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumCalculateMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiCslRptSumRptCalculateGuideUI;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.SortHelper;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviserImpl;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.newrpt.util.SheetColumMergeHelper;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class MultiCslRptSumRptCalculateGuideUI
extends AbstractMultiCslRptSumRptCalculateGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiCslRptSumRptCalculateGuideUI.class);
    private static final Pattern patternType = Pattern.compile(";");
    private static final Pattern patternItem = Pattern.compile("\\|");
    private static final Pattern pattern2Name = Pattern.compile("@!@");
    private Map basePointListMap = new HashMap();
    private Map sheet2AsstRowMap = new OneToManyMap();
    private KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
    private Map asstActTypeUtilsCache;
    private Map dynaKeyCache;
    private Map viewAttributeMap = new HashMap();
    private boolean isDynaSum = false;
    private static final Color lightblue = new Color(153, 204, 255);
    private static final Color lightGray = Color.LIGHT_GRAY;
    private Map asstActTypeMap = new HashMap();
    private Object selectAllObj = null;

    public void initUI() throws Exception {
        this.basePointListMap.clear();
        this.initSheetComboBox();
        this.cacheDynaKey();
        this.cbkOnlyListCompany.setVisible(true);
        this.cbkOnlyListCompany.setEditable(true);
        this.cbkOnlyListCompany.setSelected(true);
        ReportDesignerUI processUI = (ReportDesignerUI)this.getUIContext().get("Owner");
        CslReportInfo report = (CslReportInfo)processUI.getBookProvider().getEditValue();
        if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.FIXED)) {
            this.cmbSumType.setSelectedItem((Object)MultiDynaSumTypeEnum.BYASSTACCOUNT);
            this.cmbSumType.setEnabled(false);
        }
        this.cmbSumType.setSelectedItem((Object)MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT);
        this.cmbSumType.removeItem((Object)MultiDynaSumTypeEnum.BYCSLACCOUNT);
        this.cmbSumType.setEnabled(true);
        this.dealWithBasePoint(this.curSheets);
        this.controllerTblComapny();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (this.getUIContext().get("isShowGuide") != null && !((Boolean)this.getUIContext().get("isShowGuide")).booleanValue()) {
            this.btnComfirm_actionPerformed(null);
            this.destroyWindow();
            return;
        }
    }

    protected void doComfirm() throws Exception {
    }

    private void controllerTblComapny() {
        int rowCount = this.tblCompany.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblCompany.getRow(i);
            row.getCell("select").setValue((Object)Boolean.TRUE);
        }
        this.tblCompany.getStyleAttributes().setBackground(lightGray);
        this.tblCompany.getStyleAttributes().setLocked(true);
    }

    private void cacheDynaKey() {
        this.dynaKeyCache = (Map)this.getUIContext().get("dynaKeyCache");
        if (this.dynaKeyCache == null) {
            this.dynaKeyCache = new HashMap();
        }
    }

    private List getDynaKeyList(String sheetName, Point basePoint) {
        Map sheetMap = (Map)this.dynaKeyCache.get(sheetName);
        if (sheetMap != null) {
            return (List)sheetMap.get(basePoint);
        }
        return null;
    }

    private void initSheetComboBox() {
        if (this.selectAllObj == null) {
            this.selectAllObj = this.cmbSheet.getItemAt(0);
        }
        this.cmbSheet.removeAllItems();
        if (this.isSingleCalculate()) {
            this.cmbSheet.addItem((Object)this.curSheets.getActiveSheet().getSheetName());
        } else {
            this.cmbSheet.addItem(this.selectAllObj);
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                this.cmbSheet.addItem((Object)sheet.getSheetName());
            }
        }
    }

    @Override
    public void actionAsstSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblAsst, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionAsstClear_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblAsst, (String)"select", (Boolean)Boolean.FALSE);
    }

    protected void dealWithBasePoint(Book book) throws BOSException {
        this.tblAsst.checkParsed();
        Map asstActTypeMap = this.queryAsstActType(book);
        this.tblAsst.removeRows();
        if (this.isSingleCalculate()) {
            Sheet sheet = book.getActiveSheet();
            this.addAsstTable(sheet, asstActTypeMap);
        } else {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                this.addAsstTable(sheet, asstActTypeMap);
            }
        }
    }

    private void addAsstTable(Sheet sheet, Map asstActTypeMap) {
        this.sheet2AsstRowMap.remove(sheet.getSheetName());
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeMap.get(asstActTypeUtil.asstHGAttribute);
                if (asstActTypeInfo == null) continue;
                IRow row = this.tblAsst.addRow();
                row.setUserObject((Object)asstActTypeInfo);
                ICell cell = row.getCell("sheetname");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)sheet.getSheetName());
                CellReference ref = new CellReference(point.y, point.x);
                cell = row.getCell("basepoint");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)ref.toString());
                cell = row.getCell("asstacttype");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)asstActTypeInfo.getName());
                cell = row.getCell("select");
                cell.getStyleAttributes().setLocked(false);
                cell.setEditor((ICellEditor)this.selectEditor);
                cell.setValue((Object)Boolean.TRUE);
                cell = row.getCell("fillAttribute");
                cell.setValue((Object)asstActTypeUtil.dynapropertyName);
                cell.setUserObject((Object)asstActTypeUtil);
                cell.getStyleAttributes().setLocked(true);
                this.sheet2AsstRowMap.put(sheet.getSheetName(), row);
            }
        }
    }

    private Map queryAsstActType(Book book) throws BOSException {
        if (!this.asstActTypeMap.isEmpty()) {
            return this.asstActTypeMap;
        }
        Set attributeSet = new HashSet();
        if (this.isSingleCalculate()) {
            Sheet sheet = book.getActiveSheet();
            attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
        } else {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attributeSet, CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            asstActTypeMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo);
        }
        return asstActTypeMap;
    }

    private Set collectAsstActTypeAttribute(Set attributeSet, Sheet sheet) {
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            if (asstAccount == null || asstAccount.getAsstActTypeList() == null) continue;
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                attributeSet.add(asstActTypeUtil.asstHGAttribute);
            }
        }
        return attributeSet;
    }

    private List getBasePointList(String sheetName) {
        if (this.basePointListMap.isEmpty()) {
            if (this.isSingleCalculate()) {
                Sheet sheet = this.curSheets.getActiveSheet();
                ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                this.basePointListMap.put(sheet.getSheetName(), list);
            } else {
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet sheet = this.curSheets.getSheet(i);
                    ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                    this.basePointListMap.put(sheet.getSheetName(), list);
                }
            }
        }
        return (List)this.basePointListMap.get(sheetName);
    }

    private boolean isSingleCalculate() {
        Map ownerContext = ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext();
        Boolean isCalcSinglePage = (Boolean)ownerContext.get("KEY_CALCULATESINGLEPAGE");
        return isCalcSinglePage == null ? false : isCalcSinglePage;
    }

    @Override
    public void actionSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFirstOnload()) {
            return;
        }
        if (this.isSingleCalculate()) {
            return;
        }
        this.tblAsst.removeRows();
        if (this.cmbSheet.getSelectedIndex() == 0) {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                this.addRow(sheet.getSheetName());
            }
        } else {
            String sheetName = (String)this.cmbSheet.getSelectedItem();
            this.addRow(sheetName);
        }
    }

    @Override
    public void actionSumTypeChange_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYASSTACCOUNT) {
            this.tblAsst.setEnabled(true);
            int rowCount = this.tblAsst.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAsst.getRow(i);
                row.getCell("select").setValue((Object)Boolean.TRUE);
            }
            this.btnAsstClear.setEnabled(false);
            this.btnAsstSelectAll.setEnabled(false);
            this.cbkOnlyListCompany.setEnabled(false);
        } else {
            this.tblAsst.setEnabled(true);
            this.btnAsstClear.setEnabled(true);
            this.btnAsstSelectAll.setEnabled(true);
            this.cbkOnlyListCompany.setEnabled(true);
        }
    }

    private void addRow(String sheetName) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList != null && rowList.size() > 0) {
            for (IRow row : rowList) {
                this.tblAsst.addRow(this.tblAsst.getRowCount(), row);
            }
        }
    }

    protected Map getTableMap(DynaSumMethodEnum selectedItem, boolean onlyList, boolean isShowTotal, boolean isOnlyListCompany, Sheet sheet) {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            return SumHelper.scanDynaTable((Sheet)sheet, (DynaSumMethodEnum)selectedItem, (boolean)onlyList, (boolean)isShowTotal, (boolean)isOnlyListCompany);
        }
        Map dynaTable = SumHelper.scanDynaTable((Sheet)sheet, (DynaSumMethodEnum)selectedItem, (boolean)onlyList, (boolean)isShowTotal, (boolean)isOnlyListCompany);
        return dynaTable;
    }

    protected Map calcMultiDynaSumRpt(String reportID, List companyList, Map tableValues) throws EASBizException, BOSException {
        Map result = null;
        try {
            this.dealWithBasePoint(this.curSheets);
            Map asstActTypeMap = this.collectAsstActTypeMap();
            MultiDynaSumTypeEnum sumType = this.getSumType();
            result = CSLReportCalculatorFactory.getRemoteInstance().calculateDynaCslRpt(reportID, companyList, asstActTypeMap, tableValues, sumType, this.cbkOnlyListCompany.isSelected());
        }
        catch (Exception e) {
            logger.error((Object)"calcMultiDynaSumRpt error.", (Throwable)e);
            this.handUIException(e);
        }
        return result;
    }

    private MultiDynaSumTypeEnum getSumType() {
        MultiDynaSumTypeEnum sumType = (MultiDynaSumTypeEnum)((Object)this.cmbSumType.getSelectedItem());
        return sumType;
    }

    private Map collectAsstActTypeMap() {
        Map result = this.getSelectedAsstActTypeList();
        HashMap asstActTypeResultMap = new HashMap();
        for (Map.Entry entry : result.entrySet()) {
            List list = (List)entry.getValue();
            AsstActTypeCollection asstActTypeCollection = new AsstActTypeCollection();
            for (AsstActTypeInfo info : list) {
                asstActTypeCollection.add(info);
            }
            asstActTypeResultMap.put(entry.getKey(), asstActTypeCollection);
        }
        return asstActTypeResultMap;
    }

    private Map getSelectedAsstActTypeList(String sheetName) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return new HashMap();
        }
        StringBuffer key = new StringBuffer();
        OneToManyMap result = new OneToManyMap();
        for (IRow row : rowList) {
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            key.setLength(0);
            Sheet sheet = this.curSheets.getSheet(sheetName);
            AsstActTypeInfo info = (AsstActTypeInfo)row.getUserObject();
            CellReference cellReference = new CellReference((String)row.getCell("basepoint").getValue());
            key.append(sheet.getID()).append("|").append(cellReference.getCol()).append("|").append(cellReference.getRow());
            result.put(key.toString(), info);
        }
        return result;
    }

    private List[] getSelectedAsstActTypeList(String sheetName, Point basePoint) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return null;
        }
        StringBuffer key = new StringBuffer();
        ArrayList<Object> result1 = new ArrayList<Object>();
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (IRow row : rowList) {
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            key.setLength(0);
            CellReference cellReference = new CellReference((String)row.getCell("basepoint").getValue());
            if (basePoint.x != cellReference.getCol() || basePoint.y != cellReference.getRow()) continue;
            result2.add(row.getCell("fillAttribute").getUserObject());
            result1.add(row.getUserObject());
        }
        return new List[]{result1, result2};
    }

    private Map getSelectedAsstActTypeList() {
        if (this.isSingleCalculate()) {
            return this.getSelectedAsstActTypeList(this.curSheets.getActiveSheet().getSheetName());
        }
        HashMap result = new HashMap();
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            result.putAll(this.getSelectedAsstActTypeList(this.curSheets.getSheet(i).getSheetName()));
        }
        return result;
    }

    protected void fillMultiSumData(DynaParameters param, Point basePoint, Sheet sheet, Map valueMap, int selectedSize) throws EASBizException, BOSException {
        List[] selectedAsstActTypeLists = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
        if (selectedAsstActTypeLists == null || selectedAsstActTypeLists.length != 2 || selectedAsstActTypeLists[0].size() == 0) {
            return;
        }
        int maxCol = this.getMaxColIndex(sheet, basePoint);
        List mapedItemList = this.getItemFormulaList(sheet, basePoint, maxCol);
        int asstColCount = 0;
        asstColCount = this.fillHeadAsstItem(sheet, param, basePoint, selectedAsstActTypeLists[1], maxCol);
        this.fillHeadItemFormula(sheet, basePoint, mapedItemList, asstColCount, maxCol);
        List itemList = this.getFormulaItemListFromMap(mapedItemList);
        if (valueMap == null || valueMap.size() == 0) {
            this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), 0);
            this.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1, asstColCount, maxCol);
            param.setDefaultCounter(0);
            this.saveBasePointCell(sheet, basePoint, param);
        } else {
            int rowCount = this.fillData(param, sheet, basePoint, itemList, valueMap, asstColCount, maxCol);
            this.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1 + rowCount, asstColCount, maxCol);
            param.setDefaultCounter(rowCount);
            this.saveBasePointCell(sheet, basePoint, param);
            int startRow = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
            int endRow = startRow + rowCount;
            this.mergeCell(sheet, basePoint.x, basePoint.x + asstColCount - 1, startRow, endRow);
            this.setStyle(param, sheet, basePoint, rowCount);
        }
    }

    private void setStyle(DynaParameters param, Sheet curSheet, Point curPoint, int fillRowCount) {
        StyleDecoratorFormula sytleInherit = new StyleDecoratorFormula(null);
        RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, curPoint, curSheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        styleParam.setStartRow(curPoint.y + 1 + boforeSumFormulaCount);
        styleParam.setStandardPoint(new Point(curPoint.x, curPoint.y + boforeSumFormulaCount));
        int endRow = curPoint.y + boforeSumFormulaCount + fillRowCount;
        this.setInsertColStyle(param, curSheet, curPoint, endRow);
        styleParam.setEndRow(endRow);
        styleParam.setStartColumn(curPoint.x);
        styleParam.setEndColumn(this.getMaxColIndex(curSheet, curPoint));
        styleParam.setVerticalInherit(true);
        styleParam.setGradeFill(false);
        styleParam.setInsertInherit(true);
        curSheet.setUserObject("isMulTbl", (Object)"true");
        sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
        sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
        sytleInherit.regionInheritStyleByDefaultPoint(curSheet, styleParam);
    }

    private void mergeCell(Sheet sheet, int startCol, int endCol, int startRow, int endRow) {
        new SheetColumMergeHelper(sheet, startCol, startRow, endCol, endRow).merge(this.chkMergeCell.isSelected());
    }

    private List getFormulaItemListFromMap(List mapedItemList) {
        ArrayList itemList = new ArrayList(mapedItemList.size());
        for (Map map : mapedItemList) {
            itemList.add(map.get("formulas"));
        }
        return itemList;
    }

    private int fillData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, Map valueMap, int asstColCount, int oldMaxCol) throws EASBizException, BOSException {
        List[] selectedAsstActTypes = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        int startRowIndex = basePoint.y + boforeSumFormulaCount + 1;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            List companyList = this.initCompanyList();
            OrgStructureInfo struct = this.getCurrentStructure();
            Set dynaKeySet = (Set)valueMap.get("KEY_ALL_MULTIDYNAKEY");
            List dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActTypes[0], dynaKeySet.iterator());
            valueMap.remove("KEY_ALL_MULTIDYNAKEY");
            int realRowCount = 0;
            for (Map orgMap : valueMap.values()) {
                realRowCount += orgMap.size();
            }
            String longNumber = struct.getLongNumber();
            int longNumSize = longNumber.split("!").length;
            this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
            if (this.cbkOnlyListCompany.isSelected() && this.cbkOnlyListCompany.isEnabled()) {
                Collections.sort(companyList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof FullOrgUnitInfo && o2 instanceof FullOrgUnitInfo) {
                            String o1LongNum = ((FullOrgUnitInfo)o1).getLongNumber();
                            String o2LongNum = ((FullOrgUnitInfo)o2).getLongNumber();
                            int o1Len = o1LongNum.split("!").length;
                            int o2Len = o2LongNum.split("!").length;
                            return o1Len - o2Len;
                        }
                        return 0;
                    }
                });
            }
            for (OrgUnitInfo orgUnit : companyList) {
                Map orgValueMap = (Map)valueMap.get(orgUnit.getId().toString());
                if (orgValueMap == null) continue;
                int filledCount = this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActTypes, orgUnit, orgValueMap, startRowIndex, asstColCount, oldMaxCol);
                Range range = sheet.getRange(startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1);
                if (this.cbkOnlyListCompany.isSelected() && this.cbkOnlyListCompany.isEnabled()) {
                    if (orgUnit.getLongNumber() != null && orgUnit.getLongNumber().startsWith(longNumber) && orgUnit.getLongNumber().split("!").length - longNumSize != 1) {
                        this.fillBackColor(sheet, startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1, SortHelper.INBOUND_COMPANY_COLOR);
                    } else {
                        this.fillBackColor(sheet, startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1, SortHelper.OUTBOUND_COMPANY_COLOR);
                    }
                } else {
                    this.fillBackColor(sheet, startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1, SortHelper.OUTBOUND_COMPANY_COLOR);
                }
                startRowIndex += filledCount;
            }
            this.fillCompanyIDsToSheet(sheet);
            return realRowCount;
        }
        List dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActTypes[0], valueMap.keySet().iterator());
        int realRowCount = dynaItemList.size();
        this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
        int filledCount = this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActTypes, null, valueMap, startRowIndex, asstColCount, oldMaxCol);
        this.fillBackColor(sheet, startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1, SortHelper.OUTBOUND_COMPANY_COLOR);
        this.fillCompanyIDsToSheet(sheet);
        return realRowCount;
    }

    private void fillBackColor(Sheet sheet, int startRowIndex, int startColIndex, int endRowIndex, int endColIndex, Color backColor) {
        Range range = sheet.getRange(startRowIndex, startColIndex, endRowIndex, endColIndex);
        StyleAttributes sa = Styles.getEmptySA();
        StyleAttributes saInner = Styles.getEmptySA();
        range.getStyle(sa, saInner);
        saInner.setBackground(backColor);
        range.setStyle(sa, saInner);
    }

    private OrgStructureInfo getCurrentStructure() throws EASBizException, BOSException {
        ReportDesignerUI processUI = (ReportDesignerUI)this.getUIContext().get("Owner");
        CslReportInfo report = (CslReportInfo)processUI.getBookProvider().getEditValue();
        return OrgStructureFactory.getRemoteInstance().getValue(report.getOrgTree(), (OrgUnitInfo)report.getOrgUnit());
    }

    private void fillCompanyIDsToSheet(Sheet sheet) {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            sheet.removeUserObject("COMPANY_NUMBER");
        } else {
            ArrayList<String> companyIDList = new ArrayList<String>();
            for (int i = 0; i < this.tblCompany.getRowCount(); ++i) {
                IRow row = this.tblCompany.getRow(i);
                if (!row.getCell(1).getValue().equals(Boolean.TRUE)) continue;
                OrgUnitInfo company = (OrgUnitInfo)row.getCell(4).getValue();
                companyIDList.add(company.getId().toString());
            }
            sheet.setUserObject("COMPANY_NUMBER", companyIDList);
        }
    }

    private void saveBasePointCell(Sheet sheet, Point basePoint, DynaParameters param) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell(range, param);
    }

    private int doFillItemAndData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, List dynaItemList, List[] asstActTypeList, OrgUnitInfo curCompany, Map values, int startRowIndex, int asstColCount, int oldMaxCol) {
        int startItemColIndex = basePoint.x + asstColCount;
        int curRowIndex = startRowIndex;
        int newMaxCol = startItemColIndex + itemList.size() - 1;
        int count = 0;
        Map itemValMap = this.getItemValMap(param, dynaItemList, asstActTypeList);
        for (int i = 0; i < dynaItemList.size(); ++i) {
            int asstIndex = 0;
            int itemIndex = 0;
            int startColIndex = basePoint.x;
            DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(i);
            String dItemKey = dynaKeyItem.toString();
            String dItem = dynaKeyItem.getDynaKey();
            if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                if (values.get(dItemKey) == null) continue;
                Range range = sheet.getRange(curRowIndex, startColIndex);
                range.setIgnoreProtected(true);
                range.setFormula(null);
                range.setUserObject("ITEM", null);
                range.setValue(new Variant((Object)curCompany.getName()));
                ++startColIndex;
                ++asstIndex;
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", (Object)curCompany.getId().toString());
                }
            } else {
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", null);
                }
            }
            int x = startColIndex;
            while (x <= newMaxCol) {
                if (x < startItemColIndex) {
                    int index = this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT ? asstIndex - 1 : asstIndex;
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList[0].get(index);
                    AsstActTypeUtils asstActType = (AsstActTypeUtils)asstActTypeList[1].get(index);
                    String asstActTypeNumber = asstActTypeInfo.getNumber();
                    String asstActTypeName = asstActTypeInfo.getName();
                    String itemNumber = dynaKeyItem.getItemNumber(asstActTypeNumber);
                    String key = asstActTypeInfo.getAsstHGAttribute() + "!" + dynaKeyItem.getItemNumber(asstActTypeNumber) + "!" + asstActType.dynaProperty;
                    String itemName = "";
                    if (itemValMap.containsKey(key)) {
                        itemName = itemValMap.get(key).toString();
                    }
                    if (StringUtils.isEmpty((String)itemName)) {
                        itemName = dynaKeyItem.getItemName(asstActTypeNumber);
                    }
                    int colCount = this.fillAsstItem(param, sheet, itemNumber, itemName, asstActTypeInfo, asstActType, x, curRowIndex);
                    x += colCount;
                    ++asstIndex;
                    continue;
                }
                ItemFormula itemFormula = (ItemFormula)itemList.get(itemIndex);
                this.fillItem(param, sheet, dItemKey, dItem, itemFormula, values, x, curRowIndex, itemIndex);
                ++x;
                ++itemIndex;
            }
            this.clearExtraRange(sheet, curRowIndex, oldMaxCol, newMaxCol);
            ++count;
            ++curRowIndex;
        }
        return count;
    }

    private Map getItemValMap(DynaParameters param, List dynaItemList, List[] asstActTypeList) {
        HashMap<String, String> itemValMap = new HashMap<String, String>();
        for (int i = 0; i < asstActTypeList[0].size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList[0].get(i);
            AsstActTypeUtils asstActType = (AsstActTypeUtils)asstActTypeList[1].get(i);
            MetaDataPK pk = new MetaDataPK(asstActTypeInfo.getDefaultQueryName());
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            if ("numberandname".equalsIgnoreCase(asstActType.dynaProperty)) {
                sic.add("name");
                sic.add("number");
            } else {
                sic.add(asstActType.dynaProperty);
            }
            ev.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < dynaItemList.size(); ++j) {
                DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(j);
                String dItemKey = dynaKeyItem.toString();
                String dItem = dynaKeyItem.getDynaKey();
                numberSet.add(dynaKeyItem.getItemNumber(asstActTypeInfo.getNumber()));
            }
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            if ("T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
                filter.getFilterItems().add(new FilterItemInfo("GROUP.number", (Object)asstActTypeInfo.getNumber(), CompareType.EQUALS));
            }
            ev.setFilter(filter);
            exec.setObjectView(ev);
            try {
                IRowSet rs = exec.executeQuery();
                while (rs.next()) {
                    String key = asstActTypeInfo.getAsstHGAttribute() + "!" + rs.getString("number") + "!" + asstActType.getDynaProperty();
                    String val = "";
                    val = "numberandname".equalsIgnoreCase(asstActType.dynaProperty) ? rs.getString("number") + "-" + rs.getString("name") : (rs.getString(asstActType.getDynaProperty()).equals("false") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"87_DynaRangeUI") : (rs.getString(asstActType.getDynaProperty()).equals("true") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"86_DynaRangeUI") : rs.getString(asstActType.getDynaProperty())));
                    itemValMap.put(key, val);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
            }
        }
        return itemValMap;
    }

    private int fillAsstItem(DynaParameters param, Sheet sheet, String itemNumber, String itemName, AsstActTypeInfo asstActTypeInfo, AsstActTypeUtils asstActType, int x, int y) {
        Range range;
        int count = 0;
        if (!StringUtils.isEmpty((String)asstActType.properityName)) {
            range = sheet.getRange(y, x++);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            if (!StringUtils.isEmpty((String)itemNumber) && itemNumber.contains("!")) {
                String[] number = itemNumber.split("!");
                itemNumber = number[number.length - 1];
            }
            range.setValue(new Variant((Object)itemNumber));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.properityAlias)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.dynaProperty)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        return count;
    }

    private void fillItem(DynaParameters param, Sheet sheet, String dItemKey, String dItem, ItemFormula itemFormula, Map values, int x, int y, int colIndex) {
        Range range = sheet.getRange(y, x);
        range.setIgnoreProtected(true);
        if (itemFormula != null) {
            range.setFormula(null);
            this.fillDItemFormula(range, itemFormula, dItem);
            this.fillValue(range, values, itemFormula, dItemKey);
        } else {
            range.setUserObject("ITEM", null);
            range.setValue(Variant.nullVariant);
            range.setFormula(null);
        }
    }

    private void fillDItemFormula(Range range, ItemFormula itemFormula, String dItemNumber) {
        String dItemFormula = this.constructDItemFormula(itemFormula, dItemNumber);
        range.setUserObject("ITEM", (Object)new ItemFormula(dItemFormula));
    }

    private String constructDItemFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void fillValue(Range range, Map valueMap, ItemFormula itemFormula, String dItemKey) {
        Map item2ValueMap;
        if (valueMap != null && (item2ValueMap = (Map)valueMap.get(dItemKey)) != null) {
            DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((String)itemFormula.getDataElementNumber());
            Object value = item2ValueMap.get(itemFormula.getItemNumber() + "@!@" + dataElementInfo.getInterSeq() + "@!@" + itemFormula.getValueType());
            if (value != null) {
                if (itemFormula.getValueType() != 3) {
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)"BigDecimal Cast Error: ", (Throwable)e);
                    }
                }
                range.setValue(new Variant(value));
                return;
            }
        }
        if (itemFormula.getValueType() == 3) {
            range.setValue(Variant.nullVariant);
        } else {
            range.setValue(Variant.zeroVariant);
        }
    }

    private AsstActTypeUtils getAsstActTypeUtils(DynaParameters param, AsstActTypeInfo asstActTypeInfo) {
        HashMap<String, AsstActTypeUtils> map;
        String paramKey = param.toString();
        if (this.asstActTypeUtilsCache == null) {
            this.asstActTypeUtilsCache = new HashMap();
        }
        if ((map = (HashMap<String, AsstActTypeUtils>)this.asstActTypeUtilsCache.get(paramKey)) == null) {
            map = new HashMap<String, AsstActTypeUtils>();
            this.asstActTypeUtilsCache.put(paramKey, map);
            for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
                map.put(asstutil.asstHGAttribute, asstutil);
            }
        }
        return (AsstActTypeUtils)map.get(asstActTypeInfo.getAsstHGAttribute());
    }

    private void adjustRowCount(DynaParameters param, Sheet sheet, Point basePoint, int asstColCount, int oldRowCount, int realRowCount) {
        if (realRowCount > oldRowCount) {
            this.addSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        } else if (realRowCount < oldRowCount) {
            this.removeSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        }
    }

    private StyleAttributes[] getRangeStyleAttributes(Color backgroudColor) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.TOP, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.LEFT, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.RIGHT, Color.LIGHT_GRAY);
        sa.setBackground(backgroudColor);
        StyleAttributes saInner = Styles.getEmptySA();
        saInner.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.TOP, Color.LIGHT_GRAY);
        saInner.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.LEFT, Color.LIGHT_GRAY);
        saInner.setBackground(backgroudColor);
        return new StyleAttributes[]{sa, saInner};
    }

    private int getFormulaColumns(DynaParameters param, Sheet sheet, Point basePoint) {
        int count = 0;
        if (param.getSpreadStyle() == 1) {
            int m = sheet.getRows().getMaxIntMark();
            for (int j = basePoint.y + 1; j <= m; ++j) {
                ItemFormula f = SumHelper.getFormula((Range)sheet.getRange(j, basePoint.x));
                if (f == null) continue;
                ++count;
            }
        } else {
            int m = sheet.getCols().getMaxIntMark();
            for (int j = basePoint.x + 1; j <= m; ++j) {
                ItemFormula f = SumHelper.getFormula((Range)sheet.getRange(basePoint.y, j));
                if (f == null) continue;
                ++count;
            }
        }
        return count;
    }

    private void addSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        int y1 = y + oldMaxRowCount + 1 + boforeSumFormulaCount;
        int y2 = y + rowCount + boforeSumFormulaCount;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.NOSTYLE);
    }

    private void removeSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int sumFormulaCount = indexHandle.getSumRangeCount();
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        int y1 = y + rowCount + 1 + boforeSumFormulaCount;
        int y2 = y + oldMaxRowCount + boforeSumFormulaCount;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.delete();
    }

    private List analyzeDynaKey(Sheet sheet, Point basePoint, List asstActTypeList, Iterator iterator) {
        ArrayList<DynaKeyItem> result = new ArrayList<DynaKeyItem>();
        while (iterator.hasNext()) {
            String dynaKey = (String)iterator.next();
            DynaKeyItem item = new DynaKeyItem(dynaKey);
            result.add(item);
        }
        MultiKeyComparator multiKeyComparator = new MultiKeyComparator();
        multiKeyComparator.setAsstActTypeList(asstActTypeList);
        Collections.sort(result, multiKeyComparator);
        return result;
    }

    private List initCompanyList() throws EASBizException, BOSException {
        Vector companys = this.getSelectedCompanys();
        List result = new ArrayList(companys);
        String orgTreeID = CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString();
        if (this.cbkOnlyListCompany.isSelected()) {
            ArrayList<String> companyIDList = new ArrayList<String>();
            for (OrgUnitInfo info : result) {
                companyIDList.add(info.getId().toString());
            }
            result = MultiInterCheckageFacadeFactory.getRemoteInstance().getOrgBoundLeafCompanys(companyIDList, orgTreeID);
        }
        ObjectValueComparator comparator = new ObjectValueComparator();
        comparator.setFieldName("longnumber");
        Collections.sort(result, comparator);
        return result;
    }

    private void fillSumLine(DynaParameters param, Sheet sheet, Point basePoint, List itemList, int row, int asstColCount, int oldMaxCol) {
        if (!param.isIncludeSum()) {
            return;
        }
        int sumCellRow = param.getPosition() == 2 ? row : basePoint.y + 1;
        this.fillSumTitle(param, sheet, basePoint, sumCellRow, asstColCount);
        int Count = itemList.size();
        int col = basePoint.x + asstColCount;
        if (row == basePoint.y + 1) {
            this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
            return;
        }
        int i = 0;
        while (i < Count) {
            ItemFormula itemFormula = (ItemFormula)itemList.get(i);
            if (itemFormula.getValueType() != 3) {
                String endCellName;
                String startCellName;
                Range sumCell;
                if (param.getPosition() == 1) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    sumCell.setIgnoreProtected(true);
                    startCellName = Location.getCellName((int)(basePoint.y + 1 + 1), (int)col);
                    endCellName = Location.getCellName((int)row, (int)col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                } else if (param.getPosition() == 2) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    sumCell.setIgnoreProtected(true);
                    startCellName = Location.getCellName((int)(basePoint.y + 1), (int)col);
                    endCellName = Location.getCellName((int)(row - 1), (int)col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                }
            }
            ++i;
            ++col;
        }
        Row sumRow = sheet.getRow(sumCellRow, false);
        if (sumRow != null) {
            sumRow.setUserObject("COMPANY_NUMBER", null);
        }
        this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
    }

    private void fillSumTitle(DynaParameters param, Sheet table, Point basePoint, int row, int asstCount) {
        if (!param.isIncludeSum()) {
            return;
        }
        Point sumPoint = new Point();
        sumPoint.x = basePoint.x;
        sumPoint.y = row;
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
        for (int i = 0; i < asstCount; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
            range.setFormula(null);
            range.setValue(new Variant((Object)"--"));
        }
    }

    private void fillHeadItemFormula(Sheet sheet, Point basePoint, List itemFormulaList, int asstColCount, int maxCol) {
        int col = basePoint.x + asstColCount;
        for (Map map : itemFormulaList) {
            ItemFormula itemFormula = (ItemFormula)map.get("formulas");
            Variant value = (Variant)map.get("KEY_DITEM_NAME");
            String formula = (String)map.get("funtion_formula");
            Range range = sheet.getRange(basePoint.y, col++);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setValue(value);
            range.setFormula(formula);
        }
        this.clearExtraRange(sheet, basePoint.y, maxCol, col - 1);
    }

    private void clearExtraRange(Sheet sheet, int row, int oldMaxCol, int curMaxCol) {
        if (curMaxCol < oldMaxCol) {
            for (int i = curMaxCol + 1; i <= oldMaxCol; ++i) {
                Range range = sheet.getRange(row, i);
                this.clearRange(range);
            }
        }
    }

    private void clearRange(Range range) {
        range.setIgnoreProtected(true);
        range.setValue(Variant.nullVariant);
        range.setUserObject("ITEM", null);
        range.setFormula(null);
    }

    private void setInsertColStyle(Sheet sheet, int getRow, int getCol, int setRow, int setCol) {
        StyleAttributes saInnerBorder;
        Style sa = sheet.getCell(getRow, getCol, true).getStyle();
        StyleAttributes saOuterBorder = saInnerBorder = Styles.getSA((ShareStyleAttributes)sa);
        saOuterBorder.setDirty(StyleAttributes.getAllBits());
        saInnerBorder.setDirty(StyleAttributes.getAllBits());
        sheet.getRange(setRow, setCol).setStyle(saOuterBorder, saInnerBorder);
    }

    private void setInsertColStyle(DynaParameters param, Sheet sheet, Point basePoint, int endRow) {
        if (sheet.getUserObject("needSetInsertStyle") == null) {
            return;
        }
        int colWidth = Sheet.getColWidth((Sheet)sheet, (int)basePoint.x);
        sheet.getColRange(basePoint.x + 1, basePoint.x + 1).setColumnWidth(colWidth);
        this.setInsertColStyle(sheet, basePoint.y, basePoint.x, basePoint.y, basePoint.x + 1);
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        int[] sumRangeIndex = indexHandle.getSumRangeIndex(true);
        for (int i = 0; i < sumRangeIndex.length; ++i) {
            if (sumRangeIndex[i] < 0) continue;
            this.setInsertColStyle(sheet, sumRangeIndex[i], basePoint.x, sumRangeIndex[i], basePoint.x + 1);
        }
        int firstRowIndex = basePoint.y + 1 + boforeSumFormulaCount;
        this.setInsertColStyle(sheet, firstRowIndex, basePoint.x, firstRowIndex, basePoint.x + 1);
    }

    private int fillHeadAsstItem(Sheet sheet, DynaParameters parameters, Point basePoint, List selectedAsstActTypeUtilsList, int maxCol) {
        if (selectedAsstActTypeUtilsList == null || selectedAsstActTypeUtilsList.size() == 0) {
            return 0;
        }
        int dv = 0;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            Range cell = sheet.getRange(basePoint.y, basePoint.x);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Company")));
            if (sheet.getUserObject("needSetInsertStyle") == null) {
                Range range = sheet.getColRange(basePoint.x + 1, basePoint.x + 1);
                range.setIgnoreProtected(true);
                range.insert(false, InsertType.FLLOW_UP_STYLE);
                sheet.setUserObject("needSetInsertStyle", (Object)"");
            }
            ++dv;
        } else if (sheet.getUserObject("needSetInsertStyle") != null) {
            Range range = sheet.getColRange(basePoint.x + 1, basePoint.x + 1);
            range.setIgnoreProtected(true);
            range.delete();
            sheet.removeUserObject("needSetInsertStyle");
        }
        for (AsstActTypeUtils acctType : selectedAsstActTypeUtilsList) {
            Range cell;
            if (acctType == null) continue;
            if (!StringUtils.isEmpty((String)acctType.properityName)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityName));
                ++dv;
            }
            if (!StringUtils.isEmpty((String)acctType.properityAlias)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityAlias));
                ++dv;
            }
            if (StringUtils.isEmpty((String)acctType.dynaProperty)) continue;
            cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setFormula(null);
            if (dv != 0) {
                cell.setUserObject("ITEM", null);
            }
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private List getItemFormulaList(Sheet sheet, Point basePoint, int maxCol) {
        ArrayList list = new ArrayList();
        for (int j = basePoint.x + 1; j <= maxCol; ++j) {
            Range range = sheet.getRange(basePoint.y, j);
            ItemFormula f = SumHelper.getFormula((Range)range);
            if (f == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formulas", f);
            map.put("KEY_DITEM_NAME", range.getValue());
            map.put("funtion_formula", range.getFormula());
            list.add(map);
        }
        return list;
    }

    private int getMaxColIndex(Sheet curSheet, Point basePoint) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > basePoint.x; --i) {
            Cell cell = curSheet.getCell(basePoint.y, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        try {
            Map ownerContext;
            Boolean isCalcSinglePage;
            this.basePointListMap.clear();
            this.isCancel = false;
            boolean isAutoCal = this.curSheets.isAutoCalculate();
            if (isAutoCal) {
                this.curSheets.setAutoCalculate(false);
            }
            int sumType = -1;
            if (this.curReport.getTemplate() != null && this.curReport.getTemplate().getSumType() != null) {
                sumType = this.curReport.getTemplate().getSumType().getValue();
                if (sumType == 2) {
                    this.btnByItems.setSelected(true);
                } else if (sumType == 1) {
                    this.btnBySheets.setSelected(true);
                }
            } else {
                throw new Exception("SumReport's template information is null!");
            }
            int precision = CslRptUIUtil.getPrecisionByCry((CurrencyInfo)this.curReport.getCurrency());
            Vector vecSelectedCompanys = this.getSelectedCompanys();
            ICslRptCalculator calculator = CslRptCalculatorFactory.getRemoteInstance();
            Vector<OrgUnitInfo> companys = new Vector<OrgUnitInfo>(0);
            Vector<String> companyIDs = new Vector<String>(0);
            for (OrgUnitInfo company : vecSelectedCompanys) {
                companyIDs.add(company.getNumber());
                companys.add(company);
            }
            if ((this.getUIContext().get("isShowGuide") == null || ((Boolean)this.getUIContext().get("isShowGuide")).booleanValue()) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("report", this.curReport);
                m.put("companys", companys);
                boolean isListCompany = this.cbkOnlyListCompany.isSelected() && this.cbkOnlyListCompany.isEnabled();
                m.put("isListCompany", isListCompany);
                m.put("bySumReport", false);
                HashMap ret = calculator.checkSumRptRule(m);
                if (ret != null && (Integer)ret.get("noConfirmCount") > 0) {
                    int companyCount = companyIDs.size();
                    if (isListCompany && ret.containsKey("companySize")) {
                        companyCount = (Integer)ret.get("companySize");
                    }
                    if (MsgBox.showConfirm3a((Component)((Object)this), (String)CslRptUtil.getStringWithFormatCR((String)"SumRpt_calculateHint", (Object[])new Object[]{new Integer(companyCount), ret.get("noConfirmCount")}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SumRpt_NoConfirmCompany") + (String)ret.get("detail"))) == 2) {
                        return;
                    }
                }
            }
            if ((isCalcSinglePage = (Boolean)(ownerContext = ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext()).get("KEY_CALCULATESINGLEPAGE")) != null && isCalcSinglePage.booleanValue()) {
                Map<String, Vector<OrgUnitInfo>> data = new HashMap();
                if (ownerContext.containsKey("singlePageCompanyIds")) {
                    data = (Map)ownerContext.get("singlePageCompanyIds");
                }
                String sheetName = this.curSheets.getActiveSheet().getSheetName();
                data.put(sheetName, companys);
                ownerContext.put("singlePageCompanyIds", data);
            } else {
                ownerContext.remove("singlePageCompanyIds");
                ownerContext.put("companyIds", companys);
            }
            boolean includeDiffTable = this.cbkIncludeDiffTable.isSelected();
            ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext().put("includeDiffTable", new Boolean(includeDiffTable));
            if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
                if (this.btnBySheets.isSelected()) {
                    CslRptUIUtil.clearSheetSumCellData((Book)this.curSheets);
                    if (this.isDynaSum) {
                        CslRptUIUtil.clearSheetDynaCellData((Book)this.curSheets);
                    }
                } else {
                    CslRptUIUtil.clearCellData((Book)this.curSheets, (boolean)true, (boolean)false);
                }
            }
            if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
                HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
                HashMap<String, Map> tableValues = new HashMap<String, Map>();
                DynaSumMethodEnum selectedItem = (DynaSumMethodEnum)this.comboSumMethod.getSelectedItem();
                if (selectedItem == null) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"54_MultiCslRptSumRptCalculateGuideUI"));
                    SysUtil.abort();
                }
                boolean onlyList = this.cbOnlyList.isSelected();
                boolean isShowTotal = this.cbkShowTotal.isSelected() && this.cbkShowTotal.isEnabled();
                boolean isOnlyListCompany = this.cbkOnlyListCompany.isSelected() && this.cbkOnlyListCompany.isEnabled();
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet table = this.curSheets.getSheet(i);
                    if (!table.isEnableCalculation()) continue;
                    Map tableMap = this.getTableMap(selectedItem, onlyList, isShowTotal, true, table);
                    DynamicTemplateUtility.setSheetSumMethod(table, selectedItem);
                    if (table == null) continue;
                    tables.put(table.getID(), table);
                    tableValues.put(table.getID(), tableMap);
                }
                ArrayList<String> companyList = new ArrayList<String>();
                for (OrgUnitInfo company : vecSelectedCompanys) {
                    companyList.add(company.getId().toString());
                }
                Map sumResult = null;
                sumResult = this.calcMultiDynaSumRpt(this.curReport.getId().toString(), companyList, tableValues);
                if (sumResult != null && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                    this.curSheets.setUserObject("sumResult", (Object)sumResult);
                }
                DynaItemListener.setExeFlag(false);
                if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                    DynamicTemplateUtility.clearDynaTableFirst(this.curSheets);
                }
                DynaItemListener.setExeFlag(false);
                Sheet curSheet = this.curSheets.getActiveSheet();
                Range selectRange = curSheet.getSelectionRange();
                try {
                    this.curSheets.getUndoManager().startGroup();
                    this.fillDynaData(this.curReport.getSourceType(), tables, tableValues, sumResult, precision);
                }
                finally {
                    this.curSheets.setActiveSheet(curSheet);
                    if (selectRange != null && selectRange.getBlock(0) != null) {
                        Selection sel = curSheet.getSheetOption().getSelection();
                        sel.changeSelection(CellBlock.getNewCellBlock((CellBlock)selectRange.getBlock(0)), 2);
                    }
                    this.curSheets.getUndoManager().endGroup();
                }
                ownerContext.put("DynaSumMethod", selectedItem);
                ownerContext.put("onlyList", onlyList);
                DynaItemListener.setExeFlag(true);
            } else if (this.btnByItems.isSelected()) {
                HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
                HashMap<String, HashMap> tableValues = new HashMap<String, HashMap>();
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet table = this.curSheets.getSheet(i);
                    if (!table.isEnableCalculation()) continue;
                    HashMap tableMap = this.constructTableMap(table);
                    if (table == null) continue;
                    tables.put(table.getID(), table);
                    tableValues.put(table.getID(), tableMap);
                }
                ICSLReportCalculator ie = CSLReportCalculatorFactory.getRemoteInstance();
                Map sumResult = ie.calculateSumRptByItem((IObjectPK)new ObjectUuidPK(this.curReport.getId()), companyIDs, tableValues, includeDiffTable, this.contCalculateMethod.isVisible() ? ((SumCalculateMethodEnum)this.comboSumCalculateMethod.getSelectedItem()).equals((Object)SumCalculateMethodEnum.BySumReport) : true, null);
                CslRptUIUtil.refreshTableData(tables, (Map)sumResult, (int)precision);
            } else if (this.btnBySheets.isSelected()) {
                List ids;
                HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
                HashMap<String, SumcalcRange> sheetIDs = new HashMap<String, SumcalcRange>();
                HashMap<String, DynaKeyAndValue> dynaSumRange = new HashMap<String, DynaKeyAndValue>();
                if (this.isDynaSum) {
                    this.replaceBookByTemplate(this.curReport);
                }
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet tmpSheet = this.curSheets.getSheet(i);
                    if (!tmpSheet.isEnableCalculation()) continue;
                    DynaKeyAndValue dynaObj = new DynaKeyAndValue();
                    dynaObj.dynaKeyRange = (SumcalcRange)tmpSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    dynaObj.allValueCol = (ArrayList)tmpSheet.getUserObjectValue("allValueCol");
                    dynaObj.leftKeyCol = (Integer)tmpSheet.getUserObjectValue("keyLeftCol");
                    String sheetName = tmpSheet.getSheetName();
                    if (!dynaSumRange.containsKey(sheetName)) {
                        dynaSumRange.put(sheetName, dynaObj);
                    }
                    sheetIDs.put(tmpSheet.getSheetName(), null);
                    tables.put(tmpSheet.getSheetName(), tmpSheet);
                }
                String templateId = this.curReport.getTemplate().getId().toString();
                TemplateInfo template = TemplateFactory.getRemoteInstance().getTemplateInfo("select id, data where id = '" + templateId + "'");
                Book book = template.getBook();
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (sheet == null) continue;
                    String sheetName = sheet.getSheetName();
                    SumcalcRange sumZone = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
                    if (!sheetIDs.containsKey(sheetName)) continue;
                    sheetIDs.put(sheetName, sumZone);
                }
                book = null;
                ArrayList reportIDs = this.getReportIDs(this.curReport, vecSelectedCompanys);
                if (includeDiffTable && (ids = CSLReportCalculatorFactory.getRemoteInstance().getDiffTableIDs(this.curReport)) != null) {
                    if (reportIDs == null) {
                        reportIDs = new ArrayList();
                    }
                    reportIDs.addAll(ids);
                    ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext().put("diffTableIDs", ids);
                }
                if (reportIDs == null || reportIDs.size() == 0) {
                    this.destroyWindow();
                    return;
                }
                String oql = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId <> 'empty_sheet'";
                String oql1 = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId = 'empty_sheet'";
                String oql2 = " where sumReportID = '" + this.curReport.getId().toString() + "'";
                ISumRptRela irela = SumRptRelaFactory.getRemoteInstance();
                if (irela.exists(oql)) {
                    if (!this.isDynaSum) {
                        HashMap result = calculator.incrementCalSumRptBySheets(reportIDs, this.curReport.getId().toString(), sheetIDs);
                        this.refreshTableData(tables, result, precision);
                    } else {
                        int count = 0;
                        ArrayList rptList = new ArrayList();
                        this.sumDynaData(reportIDs, count, calculator, rptList, sheetIDs, dynaSumRange, tables, precision);
                    }
                } else {
                    if (irela.exists(oql1)) {
                        irela.delete(oql2);
                    }
                    int count = 0;
                    ArrayList rptList = new ArrayList();
                    HashMap dynaKeyResult = new HashMap();
                    if (!this.isDynaSum) {
                        int n = reportIDs.size();
                        for (int i = 0; i < n; ++i) {
                            if (count < 2) {
                                rptList.add(reportIDs.get(i));
                                ++count;
                                continue;
                            }
                            HashMap result = calculator.calculateSumRptBySheets(rptList, sheetIDs);
                            this.refreshTableData(tables, result, precision);
                            rptList = new ArrayList();
                            rptList.add(reportIDs.get(i));
                            count = 0;
                        }
                        if (rptList.size() > 0) {
                            HashMap result = calculator.calculateSumRptBySheets(rptList, sheetIDs);
                            this.refreshTableData(tables, result, precision);
                        }
                    } else {
                        this.sumDynaData(reportIDs, count, calculator, rptList, sheetIDs, dynaSumRange, tables, precision);
                    }
                }
            }
            if (isAutoCal) {
                this.curSheets.setAutoCalculate(isAutoCal);
            }
            this.getUIContext().put("bySumReport", this.contCalculateMethod.isVisible() ? (((SumCalculateMethodEnum)this.comboSumCalculateMethod.getSelectedItem()).equals((Object)SumCalculateMethodEnum.BySumReport) ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE);
            this.destroyWindow();
        }
        catch (Throwable ex) {
            logger.error((Object)"calculate error.", ex);
            this.handUIException(ex);
        }
    }

    protected void fillDynaData(RptSrcTypeEnum rptSrcTypeEnum, Map tables, Map tableItem, Map sumResult, int precision) throws Exception {
        int selectedSize = (Integer)this.spnDisplayNumber.getValue();
        if (selectedSize <= 0) {
            selectedSize = 200;
        }
        if (!this.spnDisplayNumber.isEnabled()) {
            selectedSize = -1;
        }
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)this.comboSumMethod.getSelectedItem();
        Book book = null;
        if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
            TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(this.curReport.getTemplate().getId()));
            book = templateInfo.getBook();
        }
        Object templateTable = null;
        for (String sheetID : tables.keySet()) {
            if (sumResult == null) {
                sumResult = new HashMap();
            }
            if (!sumResult.containsKey(sheetID)) continue;
            Sheet table = (Sheet)tables.get(sheetID);
            Map sheetMap = (Map)sumResult.get(sheetID);
            HashMap templateFormulas = new HashMap();
            Object[] basePointArray = this.sortByPosistion(table, sheetMap.keySet());
            for (int n = basePointArray.length - 1; n >= 0; --n) {
                Point basePoint = (Point)basePointArray[n];
                boolean baseLine = false;
                DynaParameters param = DynamicTemplateUtility.getDynaParameters(table, basePoint);
                if (param == null) continue;
                this.fillMultiSumData(param, basePoint, table, (Map)sheetMap.get(basePoint), selectedSize);
            }
        }
    }

    private Object[] sortByPosistion(Sheet table, Set set) {
        Object[] basePointArray = set.toArray();
        if (basePointArray.length > 0) {
            Point basePoint = (Point)basePointArray[0];
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(table, basePoint.y, basePoint.x);
            if (param != null) {
                if (param.getSpreadStyle() == 1) {
                    Arrays.sort(basePointArray, new PointXComparator());
                } else {
                    Arrays.sort(basePointArray, new PointYComparator());
                }
            }
        }
        return basePointArray;
    }

    private void fillTextGradeData(Point basePoint, Sheet sheet, Map nameMap, int selectedSize, boolean byname, boolean isGenItemFormula, boolean isOnlyList) {
        DItemGradeInfo info = new DItemGradeInfo();
        for (Map.Entry entry : nameMap.entrySet()) {
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            en.setName((String)v.get("KEY_DITEM_NAME"));
            en.setNumber((String)entry.getKey());
            info.getEntries().add(en);
            String compName = (String)v.get("COMPANY_NAME");
            en.setCompany(compName);
        }
        info.reform2(true);
        DItemGradeInfo info2 = DynamicTemplateUtility.getGradeInfo(sheet.getRange(basePoint.y, basePoint.x));
        for (DItemGradeEntryInfo i : info.getEntries()) {
            DItemGradeEntryInfo find;
            if (info2 == null || (find = info2.find(i.getGrade())) == null || find.isLeaf()) continue;
            i.setLeaf(false);
            if (!isOnlyList) continue;
            String name = i.getName();
            i.setName(name.substring(name.lastIndexOf("]") + 1));
        }
        if (!byname) {
            info.removeDupBranch(info.getEntries());
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(byname);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(isGenItemFormula);
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)this.comboSumMethod.getSelectedItem();
        ad.setSumMethod(sumMethod.getValue());
        ad.fill(info);
    }

    private void fillTextCompany_Name(Point basePoint, Sheet sheet, Map nameMap, int selectedSize) {
        TreeMap<String, DItemGradeInfo> infos = new TreeMap<String, DItemGradeInfo>();
        for (Map.Entry entry : nameMap.entrySet()) {
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            String name2 = (String)v.get("KEY_DITEM_NAME");
            String compName = (String)v.get("COMPANY_NAME");
            DItemGradeInfo info = (DItemGradeInfo)infos.get(compName);
            if (info == null) {
                info = new DItemGradeInfo();
                infos.put(compName, info);
            }
            en.setName(name2);
            en.setNumber((String)entry.getKey());
            en.setCompany(compName);
            info.getEntries().add(en);
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(true);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(false);
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)this.comboSumMethod.getSelectedItem();
        ad.setSumMethod(sumMethod.getValue());
        ad.fill(infos);
    }

    private List getSortedMap(final Map nameMap, final Point sortedPoint, OrderByEnum orderBy, final boolean isHead) {
        Set keySet = nameMap.keySet();
        Object[] array = keySet.toArray();
        if (orderBy.equals((Object)OrderByEnum.DESC)) {
            class KeyComparatorDesc
            implements Comparator {
                KeyComparatorDesc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        return o2.toString().compareTo(o1.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return 1;
                    }
                    if (m2 == null) {
                        return -1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return 1;
                    }
                    if (obj2 == null) {
                        return -1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n2.compareTo(n1);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj2).compareTo((String)obj);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorDesc());
        } else {
            class KeyComparatorAsc
            implements Comparator {
                KeyComparatorAsc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.toString().compareTo(o2.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return -1;
                    }
                    if (m2 == null) {
                        return 1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return -1;
                    }
                    if (obj2 == null) {
                        return 1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n1.compareTo(n2);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj).compareTo((String)obj2);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorAsc());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private int getActualSize(Map areaMap, boolean isShowTotal) {
        if (!isShowTotal) {
            return areaMap.size();
        }
        int result = areaMap.size();
        ArrayList<String> list = new ArrayList<String>();
        for (Map map : areaMap.values()) {
            String companyName = (String)map.get("COMPANY_NAME");
            if (list.contains(companyName)) continue;
            list.add(companyName);
        }
        return result += list.size();
    }

    private Map getViewAttribute(Sheet curSheet, Point basePoint) {
        Map param = DynamicTemplateUtility.getDynaViewAttributeFromCell(curSheet, basePoint.y, basePoint.x);
        return param;
    }

    private void fillViewAttribute(Sheet curSheet, Point basePoint) {
        Map par = this.getViewAttribute(curSheet, basePoint);
        int row = this.tblAsst.getRowCount();
        for (int i = 0; i < row; ++i) {
            this.tblAsst.getRow(i).getCell("fillAttribute").getStyleAttributes().setLocked(false);
            if (par != null && par.get(this.tblAsst.getRow(i).getCell("asstacttype").getValue()) != null && !"null".equals(par.get(this.tblAsst.getRow(i).getCell("asstacttype").getValue()).toString().toLowerCase())) {
                this.tblAsst.getRow(i).getCell("fillAttribute").setValue(par.get(this.tblAsst.getRow(i).getCell("asstacttype").getValue()));
            }
            this.tblAsst.getRow(i).getCell("fillAttribute").getStyleAttributes().setLocked(true);
        }
    }

    private class DynaKeyItem {
        private Map typeNumberMap;
        private String[] itemNumber;
        private String[] itemName;

        DynaKeyItem(String dynaKey) {
            String[] typeItem = patternType.split(dynaKey);
            this.typeNumberMap = new HashMap();
            this.itemNumber = new String[typeItem.length];
            this.itemName = new String[typeItem.length];
            for (int j = 0; j < typeItem.length; ++j) {
                String[] eachItem = patternItem.split(typeItem[j]);
                this.typeNumberMap.put(eachItem[0], new Integer(j));
                String[] split = pattern2Name.split(eachItem[1]);
                this.itemNumber[j] = split[0];
                this.itemName[j] = split[1];
            }
        }

        String getItemNumber(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemNumber[seq];
            }
            return null;
        }

        String getItemName(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemName[seq];
            }
            return null;
        }

        String getDynaKey() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }

        public String toString() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq] + "@!@" + this.itemName[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }
    }

    private class MultiKeyComparator
    implements Comparator {
        private List asstActTypeNumberList = new ArrayList();

        private MultiKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            DynaKeyItem key1 = (DynaKeyItem)o1;
            DynaKeyItem key2 = (DynaKeyItem)o2;
            for (String typeNumber : this.asstActTypeNumberList) {
                String item2;
                String item1 = key1.getItemNumber(typeNumber);
                int compareTo = item1.compareTo(item2 = key2.getItemNumber(typeNumber));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 0;
        }

        public void setAsstActTypeList(List asstActTypeList) {
            this.asstActTypeNumberList.clear();
            for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
                this.asstActTypeNumberList.add(asstActTypeInfo.getNumber());
            }
        }
    }
}

