/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.client.GeneralAuxacctPromptBox;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiDynaItemSeletorUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AcctCommonPromptDialog;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.HashSet;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class MultiDynaItemSeletorUI
extends AbstractMultiDynaItemSeletorUI {
    private final Logger logger = CoreUIObject.getLogger(MultiDynaItemSeletorUI.class);
    private KDComboBox asstActTypeComboBox;
    private boolean isCompanySeparate = false;

    public void onShow() throws Exception {
        this.initData();
        String accountItemParam = this.getFormulaUI().getParam(this.getParamName());
        if (accountItemParam != null) {
            AcctountAsstItemParser.AccountAsstItem acct;
            if (!StringUtils.isEmpty((String)accountItemParam.toString())) {
                accountItemParam = "|" + accountItemParam.toString().replaceAll(";", "|");
            }
            if ((acct = TableToolkit.parseAcctItem((String)accountItemParam.toString())) != null) {
                String accountItem = acct.toString();
                this.txtAccounts.setText(accountItem);
                if (acct.accounts.length > 1) {
                    return;
                }
                if (acct.asstItems != null && acct.asstItems.length > 0) {
                    this.refreshItem(acct.asstItems);
                    this.needRefreshItem = false;
                } else {
                    this.refreshItem(null);
                    this.needRefreshItem = false;
                }
            }
        }
    }

    public String getData() {
        return super.getData();
    }

    public boolean isCanceled() {
        return super.isCanceled();
    }

    public void initData() throws Exception {
        this.kDTableAssiItem.checkParsed();
        this.kDTableAssiItem.getSelectManager().setSelectMode(2);
        this.kDTableAssiItem.getColumn("selected").getStyleAttributes().setHided(true);
        this.isCompanySeparate = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.getCompany().getId()), (String)"fi_rp_004"));
        this.kDTableAssiItem.getColumn("from").getStyleAttributes().setLocked(true);
        this.kDTableAssiItem.getColumn("to").getStyleAttributes().setLocked(true);
    }

    private void initAsstComboBox(KDTDefaultCellEditor asstComboCellEditor) {
        this.asstActTypeComboBox = (KDComboBox)asstComboCellEditor.getComponent();
        this.asstActTypeComboBox.removeAllItems();
        AsstActTypeCollection typeCollection = this.getAsstActTypeCollection();
        boolean hasAsstActPermssion = false;
        try {
            hasAsstActPermssion = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), "bd_accaux_asstActType_view");
        }
        catch (EASBizException e1) {
            hasAsstActPermssion = false;
        }
        catch (BOSException e) {
            hasAsstActPermssion = false;
        }
        if (hasAsstActPermssion && typeCollection != null && typeCollection.size() > 0) {
            this.asstActTypeComboBox.addItem((Object)"");
            for (AsstActTypeInfo element : typeCollection) {
                this.asstActTypeComboBox.addItem((Object)element);
            }
        }
        this.asstActTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiDynaItemSeletorUI.this.initItem();
                }
                catch (Exception e1) {
                    MultiDynaItemSeletorUI.this.logger.error((Object)"initItem", (Throwable)e1);
                }
                MultiDynaItemSeletorUI.this.needRefreshItem = false;
            }
        });
    }

    private void initItem() throws Exception {
        String item = this.asstActTypeComboBox.getSelectedItem().toString();
        if (!StringUtils.isEmpty((String)item)) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.asstActTypeComboBox.getSelectedItem();
            String tableName = asstActTypeInfo.getRealtionDataObject();
            KDBizPromptBox bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$ - $name$");
            bizPromptBox.setCommitFormat("$number$");
            this.setCommonItemFilter(bizPromptBox, tableName, asstActTypeInfo);
            this.setProjectItemFilter(bizPromptBox, tableName);
            this.setQueryInfo(bizPromptBox, tableName, asstActTypeInfo);
            EntityViewInfo view = new EntityViewInfo();
            this.setCompanyFilter(bizPromptBox, view, asstActTypeInfo);
            this.setProjectFilter(bizPromptBox, tableName);
            this.setCostObjectFilter(bizPromptBox, tableName);
            this.setOtherFilter(bizPromptBox, tableName, asstActTypeInfo);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            int activeRowIndex = this.kDTableAssiItem.getSelectManager().getActiveRowIndex();
            IRow row = this.kDTableAssiItem.getRow(activeRowIndex);
            Object preActTypeItem = row.getUserObject();
            if (preActTypeItem != null && !preActTypeItem.toString().equals(item)) {
                row.getCell("from").setValue(null);
                row.getCell("to").setValue(null);
            }
            row.getCell("from").setEditor((ICellEditor)editor);
            row.getCell("to").setEditor((ICellEditor)editor);
            row.setUserObject((Object)asstActTypeInfo);
            row.getCell("from").getStyleAttributes().setLocked(false);
            row.getCell("to").getStyleAttributes().setLocked(false);
        } else {
            int activeRowIndex = this.kDTableAssiItem.getSelectManager().getActiveRowIndex();
            IRow row = this.kDTableAssiItem.getRow(activeRowIndex);
            row.getCell("type").setValue(null);
            row.getCell("from").setValue(null);
            row.getCell("to").setValue(null);
            row.getCell("from").getStyleAttributes().setLocked(true);
            row.getCell("to").getStyleAttributes().setLocked(true);
        }
    }

    private void setCommonItemFilter(KDBizPromptBox bizPromptBox, final String tableName, final AsstActTypeInfo asstActTypeInfo) {
        if (!(tableName.equalsIgnoreCase("T_BD_CUSTOMER") || tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_Material"))) {
            bizPromptBox.setFilterInfoProducer(new IFilterInfoProducer(){

                public FilterInfo getFilterInfo() {
                    FilterInfo filter = new FilterInfo();
                    if (MultiDynaItemSeletorUI.this.isCompanySeparate) {
                        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)MultiDynaItemSeletorUI.this.company.getCU().getId().toString(), CompareType.EQUALS));
                        filter.setMaskString(" #0 or #1 or #2 ");
                    }
                    if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                        GeneralAsstActTypeGroupInfo asstGroupInfo = asstActTypeInfo.getGlAsstActTypeGrp();
                        String GeneralAsstActTypeGroup = asstGroupInfo.getId().toString();
                        try {
                            FilterInfo filterInfo = DynamicTemplateUtility.getFilterForGeneral(null, GeneralAsstActTypeGroup, MultiDynaItemSeletorUI.this.getCompany());
                            filter.mergeFilter(filterInfo, "AND");
                        }
                        catch (Exception e) {
                            MultiDynaItemSeletorUI.this.logger.error((Object)("setCommonItemFilter_getFilterForGeneral_error:" + e.getMessage()));
                        }
                    }
                    return filter;
                }

                public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
                }

                public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
                }
            });
        }
    }

    private void setProjectItemFilter(KDBizPromptBox bizPromptBox, String tableName) {
        if (tableName.equalsIgnoreCase("T_BD_Project")) {
            bizPromptBox.setFilterInfoProducer(new IFilterInfoProducer(){

                public FilterInfo getFilterInfo() {
                    FilterInfo filter = new FilterInfo();
                    if (MultiDynaItemSeletorUI.this.isCompanySeparate) {
                        try {
                            String longNumber = CtrlUnitFactory.getRemoteInstance().getOrgUnitInfo("select * where id = '" + MultiDynaItemSeletorUI.this.getCompany().getCU().getId().toString() + "'").getLongNumber();
                            String[] numbers = longNumber.split("!");
                            HashSet<String> lnUps = new HashSet<String>();
                            for (int i = 0; i < numbers.length; ++i) {
                                lnUps.add(numbers[i]);
                            }
                            filter.getFilterItems().add(new FilterItemInfo("cu.number", lnUps, CompareType.INCLUDE));
                            filter.setMaskString("#0");
                        }
                        catch (Exception e) {
                            try {
                                throw new Exception(e);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return filter;
                }

                public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
                }

                public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
                }
            });
        }
    }

    private void setQueryInfo(KDBizPromptBox bizPromptBox, String tableName, AsstActTypeInfo asstActTypeInfo) {
        if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Customer")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7CustomerQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Supplier")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7SupplierQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Material")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7MaterialQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Person")) {
            bizPromptBox.setSelector((KDPromptSelector)new AcctCommonPromptDialog());
            bizPromptBox.setQueryInfo(asstActTypeInfo.getDefaultQueryName());
        } else if (tableName.equalsIgnoreCase("T_ORG_Company")) {
            NewCompanyF7 promptOrgCompany = CompanyF7Helper.getCompanyBizUnitF7((IUIObject)this.getFormulaUI());
            promptOrgCompany.setMultiSelect(false);
            promptOrgCompany.setNeedAddOrgRange(false);
            promptOrgCompany.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            promptOrgCompany.setShowAssistantOrg(true);
            promptOrgCompany.setCheckedAssistantOrgChkBox(true);
            bizPromptBox.setSelector((KDPromptSelector)promptOrgCompany);
        } else {
            bizPromptBox.setQueryInfo(asstActTypeInfo.getDefaultQueryName());
        }
    }

    private void setCompanyFilter(KDBizPromptBox bizPromptBox, EntityViewInfo view, AsstActTypeInfo asstActTypeInfo) {
        if (asstActTypeInfo.isIsForCompany()) {
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            bizPromptBox.setEntityViewInfo(view);
            bizPromptBox.setHasCUDefaultFilter(false);
        }
    }

    private void setProjectFilter(KDBizPromptBox bizPromptBox, String tableName) {
        if ("T_FDC_CurProject".equalsIgnoreCase(tableName) && this.isCompanySeparate && !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.company.getId().toString())) {
            EntityViewInfo viewInfo = bizPromptBox.getEntityViewInfo();
            if (viewInfo == null) {
                viewInfo = new EntityViewInfo();
            }
            FilterInfo filter = viewInfo.getFilter() == null ? new FilterInfo() : viewInfo.getFilter();
            filter.getFilterItems().add(new FilterItemInfo("Fullorgunit.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        }
    }

    private void setCostObjectFilter(KDBizPromptBox bizPromptBox, String tableName) {
        if ("T_BD_CostObject".equalsIgnoreCase(tableName) && this.isCompanySeparate) {
            EntityViewInfo viewInfo = bizPromptBox.getEntityViewInfo();
            if (viewInfo == null) {
                viewInfo = new EntityViewInfo();
            }
            FilterInfo filter = viewInfo.getFilter() == null ? new FilterInfo() : viewInfo.getFilter();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        }
    }

    private void setOtherFilter(KDBizPromptBox bizPromptBox, String tableName, AsstActTypeInfo asstActTypeInfo) throws EASBizException, BOSException {
        if (tableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            GeneralAsstActTypeGroupInfo asstGroupInfo = asstActTypeInfo.getGlAsstActTypeGrp();
            String GeneralAsstActTypeGroup = asstGroupInfo.getId().toString();
            FilterInfo filterInfo = DynamicTemplateUtility.getFilterForGeneral(null, GeneralAsstActTypeGroup, this.getCompany());
            GeneralAuxacctPromptBox gapb = new GeneralAuxacctPromptBox((IUIObject)this, GeneralAsstActTypeGroup, filterInfo, this.company.getCU());
            bizPromptBox.setSelector((KDPromptSelector)gapb);
            bizPromptBox.setEditFormat("$longnumber$");
            bizPromptBox.setDisplayFormat("$longnumber$ - $name$");
            bizPromptBox.setCommitFormat("$longnumber$");
        } else if (forCompanyAsstactTypeMap.get(tableName.toUpperCase()) != null) {
            String fieldName = (String)forCompanyAsstactTypeMap.get(tableName.toUpperCase());
            FilterInfo filter = new FilterInfo();
            EntityViewInfo view = bizPromptBox.getEntityViewInfo();
            if (view == null) {
                view = new EntityViewInfo();
            }
            view.getSorter().clear();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            bizPromptBox.setEntityViewInfo(view);
            if (this.getMultiCompanys() != null && this.getMultiCompanys().size() > 1) {
                HashSet<String> idSet = new HashSet<String>();
                for (int j = 0; j < this.getMultiCompanys().size(); ++j) {
                    idSet.add(this.getMultiCompanys().get(j).getId().toString());
                }
                if (this.isAllCompanysNeedIsolated(idSet)) {
                    fic.add(new FilterItemInfo(fieldName, idSet, CompareType.INCLUDE));
                }
            } else if (this.isCompanySeparate) {
                if (tableName.equalsIgnoreCase("T_ORG_CostCenter")) {
                    boolean isBizUnit = this.company.isIsBizUnit();
                    String tempID = null;
                    String longNumber = null;
                    if (isBizUnit) {
                        tempID = this.company.getId().toString();
                        longNumber = this.company.getLongNumber();
                    } else {
                        tempID = this.company.getCU().getId().toString();
                        longNumber = this.company.getCU().getLongNumber();
                    }
                    HashSet<String> tempIDs = new HashSet<String>();
                    tempIDs.add(tempID);
                    this.getFromCostOrgs(tempID, tempIDs);
                    if (isBizUnit) {
                        filter.getFilterItems().add(new FilterItemInfo("id", tempIDs, CompareType.INCLUDE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("cu.id", tempIDs, CompareType.INCLUDE));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                    filter.setMaskString("( #0 OR #1 )");
                } else if (tableName.equalsIgnoreCase("T_BD_Person")) {
                    fic.add(new FilterItemInfo("CU2.id", (Object)this.company.getCU().getId().toString()));
                } else if ("T_Org_Admin".equalsIgnoreCase(tableName)) {
                    String longNumber = null;
                    boolean isBizUnit = this.company.isIsBizUnit();
                    if (isBizUnit) {
                        fic.add(new FilterItemInfo("id", (Object)this.company.getId().toString()));
                        longNumber = this.company.getLongNumber();
                    } else {
                        fic.add(new FilterItemInfo("CU.id", (Object)this.company.getCU().getId().toString()));
                        longNumber = this.company.getCU().getLongNumber();
                    }
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                    filter.setMaskString("( #0 OR #1 ) AND #2");
                } else {
                    fic.add(new FilterItemInfo(fieldName, (Object)this.company.getId().toString()));
                }
            } else if (tableName.equalsIgnoreCase("T_ORG_CostCenter")) {
                filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            }
        }
    }

    private AsstActTypeCollection getAsstActTypeCollection() {
        AsstActTypeCollection typeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultQueryName"));
        viewInfo.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        viewInfo.getSelector().add(new SelectorItemInfo("glAsstActTypeGrp"));
        viewInfo.getSelector().add(new SelectorItemInfo("groupTableName"));
        viewInfo.getSelector().add(new SelectorItemInfo("isForCompany"));
        viewInfo.getSelector().add(new SelectorItemInfo("groupMappingFieldName"));
        viewInfo.getSelector().add(new SelectorItemInfo("useLongNumber"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        try {
            IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
            typeCollection = iAsstActType.getAsstActTypeCollection(viewInfo);
        }
        catch (BOSException e) {
            this.logger.error((Object)"initAsstComboBox", (Throwable)e);
        }
        return typeCollection;
    }

    private void refreshItem(AcctountAsstItemParser.AsstItem[] items) throws Exception {
        AsstActTypeCollection typeCollection = this.getAsstActTypeCollection();
        if (typeCollection != null && typeCollection.size() > 0) {
            String asstActTypeNumber;
            AsstActTypeInfo asstActTypeInfo;
            KDTDefaultCellEditor asstComboCellEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox());
            this.initAsstComboBox(asstComboCellEditor);
            for (int i = 0; i < 8; ++i) {
                this.kDTableAssiItem.addRow();
                this.kDTableAssiItem.getRow(i).getCell("type").setEditor((ICellEditor)asstComboCellEditor);
            }
            String acctItem = this.txtAccounts.getText();
            AcctountAsstItemParser.AsstItem[] asstItems = null;
            AcctountAsstItemParser.AccountAsstItem asstitem = null;
            try {
                asstitem = AcctountAsstItemParser.parse((String)acctItem);
            }
            catch (ParseException e) {
                throw new ReportException(new NumericExceptionSubItem("007", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"54_AgeCalculator")));
            }
            asstItems = asstitem.asstItems;
            if (asstItems != null && asstItems.length > 0) {
                block3: for (int z = 0; z < asstItems.length; ++z) {
                    String asstTypeNumber = asstItems[z].asstTypeNumber;
                    for (int j = 0; j < typeCollection.size(); ++j) {
                        asstActTypeInfo = typeCollection.get(j);
                        asstActTypeNumber = asstActTypeInfo.getNumber();
                        if (!asstTypeNumber.equals(asstActTypeNumber)) continue;
                        this.kDTableAssiItem.getSelectManager().setActiveRowIndex(z);
                        KDComboBox comboBox = (KDComboBox)this.kDTableAssiItem.getRow(z).getCell("type").getEditor().getComponent();
                        comboBox.setSelectedItem((Object)asstActTypeInfo);
                        this.kDTableAssiItem.getRow(z).getCell("type").setValue((Object)asstActTypeInfo);
                        this.kDTableAssiItem.getRow(z).setUserObject((Object)asstActTypeInfo);
                        continue block3;
                    }
                }
            }
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    AcctountAsstItemParser.AsstItem itm = items[i];
                    IRow row = this.kDTableAssiItem.getRow(i);
                    asstActTypeInfo = (AsstActTypeInfo)row.getUserObject();
                    if (asstActTypeInfo == null) continue;
                    asstActTypeNumber = asstActTypeInfo.getNumber();
                    if (itm == null || !itm.asstTypeNumber.equals(asstActTypeNumber)) continue;
                    row.getCell("from").setValue((Object)itm.startNumber);
                    row.getCell("to").setValue((Object)itm.endNumber);
                }
            }
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.kDTableAssiItem.getEditManager().stopEditing();
        this.constructDataFromTable();
        this.disposeUIWindow();
    }

    protected void constructDataFromTable() throws Exception {
        String accItem = null;
        String accts = this.txtAccounts.getText();
        AcctountAsstItemParser.AccountAsstItem acct = TableToolkit.parseAcctItem((String)accts);
        if (!StringUtils.isEmpty((String)accts) && acct.accounts.length > 1) {
            accItem = accts;
        }
        if (accItem != null) {
            this.sbRetItem.append(accItem);
        }
        String assBin = "";
        String assEnd = "";
        boolean isFirst = true;
        for (int i = 0; i < this.kDTableAssiItem.getRowCount(); ++i) {
            Object endAssItem;
            assBin = null;
            assEnd = null;
            IRow row = this.kDTableAssiItem.getRow(i);
            if (row.getCell("type").getValue() == null) continue;
            AsstActTypeInfo item = (AsstActTypeInfo)row.getUserObject();
            String Ass = item.getNumber();
            if (!isFirst) {
                this.sbRetItem.append(";");
            } else {
                isFirst = false;
            }
            this.sbRetItem.append(Ass).append("|");
            Object startAssItem = row.getCell("from").getValue();
            String tableName = item.getRealtionDataObject();
            boolean isAsstActType = "T_BD_GeneralAsstActType".equals(tableName);
            if (startAssItem != null) {
                if (startAssItem instanceof IObjectValue) {
                    if (isAsstActType && ((IObjectValue)startAssItem).get("longnumber") != null) {
                        assBin = (String)((IObjectValue)startAssItem).get("longnumber");
                        assBin = assBin.replaceAll("\\!", "\\.");
                    } else {
                        assBin = (String)((IObjectValue)startAssItem).get("number");
                    }
                } else {
                    assBin = (String)startAssItem;
                }
            }
            if ((endAssItem = row.getCell("to").getValue()) != null) {
                if (endAssItem instanceof IObjectValue) {
                    if (isAsstActType && ((IObjectValue)endAssItem).get("longnumber") != null) {
                        assEnd = (String)((IObjectValue)endAssItem).get("longnumber");
                        assEnd = assEnd.replaceAll("\\!", "\\.");
                    } else {
                        assEnd = (String)((IObjectValue)endAssItem).get("number");
                    }
                } else {
                    assEnd = (String)endAssItem;
                }
            }
            if (assBin == null && assEnd == null) continue;
            if (assBin != null && assBin.trim().length() > 0 && assEnd != null && assEnd.trim().length() > 0) {
                if (assBin.trim().equals(assEnd.trim())) {
                    this.sbRetItem.append(assBin);
                } else {
                    this.sbRetItem.append(assBin + ":" + assEnd);
                }
            }
            if (assBin != null && assBin.trim().length() > 0 && (assEnd == null || assEnd.trim().length() == 0)) {
                this.sbRetItem.append(assBin + ":");
            }
            if (assBin != null && assBin.trim().length() != 0 || assEnd == null || assEnd.trim().length() <= 0) continue;
            this.sbRetItem.append(assEnd);
        }
    }
}

