/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.CslRptAsstAccountFactory;
import com.kingdee.eas.fi.gr.dynamic.DynamicEnumException;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiDynaItemWizardUI;
import com.kingdee.eas.fi.gr.dynamic.fill.MultiDynaItemFillHandle;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MultiDynaItemWizardUI
extends AbstractMultiDynaItemWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiDynaItemWizardUI.class);
    private static final int COLUMN_LENGTH = 120;
    private static final int BY_COMBOBOX = 0;
    private static final int BY_F7 = 1;
    private static final String INDEX_COL_KEY = "rowindex";
    private Sheet curSheet;
    private AsstItemComparator asstItemComparator;
    private IObjectValue tempValue;
    private Point basePoint;
    private ArrayList basePointList;
    private DynaParameters parameters;
    private int startIndex = -99;
    private Map preValueMap;
    private Map preFormulaMap;
    private Map asstActTypeNumber2AttribeMap;
    private Map asstActTypeAttribeMap2NumberMap;
    private Map attribute2AsstActTypeMap;
    private Map f7Controller;
    private Map comboBoxController = new HashMap();
    private Map asstItemMap = new HashMap();

    public MultiDynaItemWizardUI() throws Exception {
        this.f7Controller = new HashMap();
        this.preValueMap = new HashMap();
        this.preFormulaMap = new HashMap();
        this.asstActTypeNumber2AttribeMap = new HashMap();
        this.asstActTypeAttribeMap2NumberMap = new HashMap();
        this.attribute2AsstActTypeMap = new HashMap();
        this.asstItemComparator = new AsstItemComparator();
        this.tempValue = new AbstractBaseObjectValue(){

            public BOSObjectType getBOSType() {
                return null;
            }
        };
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCurSheet();
        this.initTable();
        boolean isHasData = this.scanData();
        if (!isHasData) {
            this.fillBlankLine();
        }
    }

    private boolean scanData() {
        int rowIndex = (this.getParameters().isIncludeSum() && this.getParameters().getPosition() == 1 ? 3 : 2) + this.getBasePoint().y;
        Sheet.ICellsIterator it = this.getCellsIterator(true);
        boolean isFilled = false;
        while (it.hasNext()) {
            Cell cell = it.next();
            ItemFormula itemFormula = this.getItemFormula(cell);
            if (itemFormula == null) continue;
            isFilled = true;
            MultiDynaItem dynaItem = new MultiDynaItem(itemFormula.getDItemNumber());
            if (itemFormula != null && cell.getCol() == this.getItemStartColIndex()) {
                IRow row = this.addDataToTable(dynaItem);
                ICell indexCell = row.getCell(this.getIndexColName());
                indexCell.getStyleAttributes().setLocked(true);
                indexCell.setValue((Object)new Integer(rowIndex++));
            }
            if (cell.hasFormula()) {
                this.cacheFormula(this.getItemFormulaKey(itemFormula), itemFormula.getDItemNumber(), cell.getFormula());
            }
            if (cell.getValue() == null || cell.getValue().isNull()) continue;
            this.cacheValue(this.getItemFormulaKey(itemFormula), itemFormula.getDItemNumber(), cell.getValue());
        }
        return isFilled;
    }

    private String getItemFormulaKey(ItemFormula itemFormula) {
        if (itemFormula == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(itemFormula.getItemNumber()).append(";");
        sb.append(itemFormula.getDataElementNumber()).append(";");
        sb.append(itemFormula.getValueType());
        return sb.toString();
    }

    private void refreshIndexRow() {
        int rowIndex = this.getBasePoint().y + (this.getParameters().getPosition() == 2 ? 2 : 3);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(this.getIndexColName()) == null) continue;
            row.getCell(this.getIndexColName()).setValue((Object)new Integer(rowIndex++));
        }
    }

    private void fillBlankLine() {
        DynaParameters parameters = this.getParameters();
        int defaultCountes = parameters.getDefaultCounter();
        for (int i = 0; i < defaultCountes; ++i) {
            this.addRow();
        }
    }

    private String getIndexColName() {
        return INDEX_COL_KEY;
    }

    private void cacheValue(String itemFormulaKey, String dItemNumber, Variant value) {
        HashMap<String, Variant> map = (HashMap<String, Variant>)this.preValueMap.get(itemFormulaKey);
        if (map == null) {
            map = new HashMap<String, Variant>();
            this.preValueMap.put(itemFormulaKey, map);
        }
        map.put(dItemNumber, value);
    }

    private void cacheFormula(String itemNumber, String dItemNumber, String formula) {
        HashMap<String, String> map = (HashMap<String, String>)this.preFormulaMap.get(itemNumber);
        if (map == null) {
            map = new HashMap<String, String>();
            this.preFormulaMap.put(itemNumber, map);
        }
        map.put(dItemNumber, formula);
    }

    private IRow addDataToTable(MultiDynaItem dynaItem) {
        IRow row = this.addRow();
        for (String asstActTypeNumber : dynaItem.getAsstActTypeList()) {
            String attribute = this.getCachedAttribute(asstActTypeNumber);
            if (attribute == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"60_MultiDynaItemWizardUI"));
                this.abort();
            }
            if (StringUtils.isEmpty((String)attribute)) continue;
            String fieldName = RptUtil.isUseLongNumber((AsstActTypeInfo)this.getCachedAsstActTypeInfo(attribute)) ? "longnumber" : "number";
            IObjectValue objectValue = this.searchAsstItem(attribute, fieldName, dynaItem.getAsstItemNumber(asstActTypeNumber));
            row.getCell(attribute).setValue((Object)objectValue);
        }
        return row;
    }

    private IObjectValue searchAsstItem(String attribute, String fieldName, Object fieldValue) {
        List asstItems = (List)this.asstItemMap.get(attribute);
        if (asstItems == null || asstItems.size() == 0) {
            return null;
        }
        Object lastSortField = this.asstItemMap.get("lastSortField");
        this.asstItemComparator.setFieldName(fieldName);
        if (lastSortField == null || !fieldName.equals(lastSortField)) {
            for (Object object : this.asstItemMap.values()) {
                if (!(object instanceof List)) continue;
                Collections.sort((List)object, this.asstItemComparator);
            }
            this.asstItemMap.put("lastSortField", fieldName);
        }
        this.tempValue.put(fieldName, fieldValue);
        int index = Collections.binarySearch(asstItems, this.tempValue, this.asstItemComparator);
        if (index >= 0) {
            return (IObjectValue)asstItems.get(index);
        }
        return null;
    }

    private Sheet.ICellsIterator getCellsIterator(boolean isFromItemFied) {
        int x0 = isFromItemFied ? this.getItemStartColIndex() : this.getBasePoint().x;
        int x1 = this.getMaxColIndex(this.curSheet, this.getBasePoint().y, this.getBasePoint().x);
        int y0 = (this.getParameters().isIncludeSum() && this.getParameters().getPosition() == 1 ? 2 : 1) + this.getBasePoint().y;
        int y1 = y0 + this.getParameters().getDefaultCounter() - 1;
        Sheet.ICellsIterator it = this.curSheet.getCellsIterator(y0, x0, y1, x1, false, true);
        return it;
    }

    private int getItemStartColIndex() {
        if (this.startIndex == -99) {
            this.startIndex = this.getBasePoint().x;
            AsstAccountUtils asstAccount = this.parameters.getAsstAccount();
            if (asstAccount == null) {
                return this.startIndex;
            }
            for (AsstActTypeUtils asstType : asstAccount.getAsstActTypeList()) {
                if (!StringUtils.isEmpty((String)asstType.properityAlias)) {
                    ++this.startIndex;
                }
                if (!StringUtils.isEmpty((String)asstType.properityName)) {
                    ++this.startIndex;
                }
                if (StringUtils.isEmpty((String)asstType.dynaProperty)) continue;
                ++this.startIndex;
            }
        }
        return this.startIndex;
    }

    private void initCurSheet() {
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        if (this.curSheet == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TableIsNull"));
            SysUtil.abort();
        }
    }

    private Point getBasePoint() {
        if (this.basePoint == null) {
            Point activePoint = new Point(this.curSheet.getActiveCol(), this.curSheet.getActiveRow());
            this.basePoint = new Point(2, 2);
            int col = activePoint.x;
            int row = activePoint.y;
            ArrayList list = this.getBasePointList();
            if (list == null || list.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange"));
                SysUtil.abort();
            }
            if (col >= 0 && row >= 0) {
                this.basePoint.x = col < 0 ? 0 : col;
                int n = this.basePoint.y = row < 0 ? 0 : row;
                if (list.size() > 0) {
                    this.basePoint = DynamicTemplateUtility.getBasePoint(this.curSheet, this.basePoint, list);
                    if (this.basePoint == null) {
                        if (list.size() == 1) {
                            this.basePoint = (Point)list.get(0);
                        } else {
                            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange"));
                            SysUtil.abort();
                        }
                    }
                }
            } else if (list.size() > 0) {
                this.basePoint = (Point)list.get(0);
            }
        }
        return this.basePoint;
    }

    private DynaParameters getParameters() {
        if (this.parameters == null) {
            Point basePoint = this.getBasePoint();
            this.parameters = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, basePoint.y, basePoint.x);
        }
        return this.parameters;
    }

    private void initTable() throws EASBizException, BOSException {
        Object editData;
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        DynaParameters parameters = this.getParameters();
        AsstAccountUtils asstAccount = parameters.getAsstAccount();
        if (asstAccount == null) {
            return;
        }
        ArrayList asstActTypes = asstAccount.getAsstActTypeList();
        ArrayList<String> attributeList = new ArrayList<String>();
        HashMap<String, String> attributeAndGroupMap = new HashMap<String, String>();
        for (int i = 0; i < asstActTypes.size(); ++i) {
            AsstActTypeUtils asstActType = (AsstActTypeUtils)asstActTypes.get(i);
            attributeList.add(asstActType.getAsstHGAttribute());
            attributeAndGroupMap.put(asstActType.getAsstHGAttribute(), asstActType.getAssistantSubType());
        }
        HashMap uiContext = new HashMap();
        Object companyInfo = this.getUIContext().get("Company");
        if (companyInfo == null && (editData = this.getUIContext().get("editData")) != null) {
            FullOrgUnitInfo curOrgUnitInfo = null;
            if (editData instanceof TemplateInfo) {
                curOrgUnitInfo = ((TemplateInfo)editData).getCompany();
                if (curOrgUnitInfo != null) {
                    companyInfo = (CompanyOrgUnitInfo)curOrgUnitInfo.cast(CompanyOrgUnitInfo.class);
                }
            } else if (editData instanceof ReportInfo && (curOrgUnitInfo = ((ReportInfo)editData).getCompany()) != null) {
                companyInfo = RptNewUIUtil.getDelegateCompanyNoOrgType(null, (OrgUnitInfo)curOrgUnitInfo);
            }
        }
        uiContext.put("Company", companyInfo);
        uiContext.put("asstActTypeAttribeAndGroupMap", attributeAndGroupMap);
        Map itemCollections = CslRptAsstAccountFactory.getRemoteInstance().getItemCollections(attributeList, uiContext);
        IRow headRow = this.tblMain.addHeadRow();
        IColumn rowIndexCol = this.tblMain.addColumn();
        rowIndexCol.setWidth(50);
        rowIndexCol.setKey(this.getIndexColName());
        headRow.getCell(this.getIndexColName()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_Row"));
        int perfectWidth = 0;
        for (int i = 0; i < attributeList.size(); ++i) {
            String attribute = (String)attributeList.get(i);
            Map.Entry entry = this.getAsstItemEntryByAttribute(attribute, itemCollections);
            if (entry == null) continue;
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)entry.getKey();
            IObjectCollection asstCollection = (IObjectCollection)entry.getValue();
            this.addColumn(asstActTypeInfo, asstCollection, headRow);
            perfectWidth += 120;
            this.addSelectController(asstActTypeInfo, asstCollection, attributeAndGroupMap);
            this.cacheAsstActAttribute(asstActTypeInfo);
        }
        if (perfectWidth > this.tblMain.getWidth()) {
            this.setSize(this.getWidth() + perfectWidth, this.getHeight());
        }
        this.initTableKeyStroke();
        this.initTableListener();
    }

    private void initTableListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                int startCol = selectBlock.getLeft();
                int startRow = selectBlock.getTop();
                int endCol = selectBlock.getEndCol();
                int endRow = selectBlock.getEndRow();
                if (startRow < 0 || startCol < 0 || endCol < 0 || endRow < 0) {
                    return;
                }
                Object tmpObject = MultiDynaItemWizardUI.this.tblMain.getCell(startRow, startCol).getValue();
                if (selectBlock.size() > 1 && startCol == endCol && tmpObject != null) {
                    int i;
                    int noNullCount = 0;
                    for (i = startRow; i <= endRow; ++i) {
                        if (MultiDynaItemWizardUI.this.tblMain.getCell(i, startCol).getValue() == null) continue;
                        ++noNullCount;
                    }
                    if (noNullCount == 1) {
                        for (i = startRow + 1; i <= endRow; ++i) {
                            MultiDynaItemWizardUI.this.tblMain.getCell(i, startCol).setValue(tmpObject);
                        }
                    }
                }
            }
        });
    }

    protected void initTableKeyStroke() {
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowCount = MultiDynaItemWizardUI.this.tblMain.getRowCount();
                IRow newRow = MultiDynaItemWizardUI.this.tblMain.getRow(rowCount - 1);
                IRow oldRow = MultiDynaItemWizardUI.this.tblMain.getRow(rowCount - 2);
                int colCount = MultiDynaItemWizardUI.this.tblMain.getColumnCount();
                for (int i = 0; i < colCount; ++i) {
                    ICell newCell = newRow.getCell(i);
                    ICell oldCell = oldRow.getCell(i);
                    String key = MultiDynaItemWizardUI.this.tblMain.getColumnKey(i);
                    if (MultiDynaItemWizardUI.this.getIndexColName().equals(key)) {
                        newCell.getStyleAttributes().setLocked(true);
                        Integer rowIndex = (Integer)oldCell.getValue();
                        if (rowIndex == null) continue;
                        newCell.setValue((Object)new Integer(rowIndex + 1));
                        continue;
                    }
                    newRow.getStyleAttributes().setLocked(oldCell.getStyleAttributes().isLocked());
                    newCell.setEditor(oldCell.getEditor());
                    newCell.setValue(oldCell.getValue());
                }
            }
        };
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)true, (Action)actionTable);
    }

    private void cacheAsstActAttribute(AsstActTypeInfo asstActTypeInfo) {
        this.asstActTypeNumber2AttribeMap.put(asstActTypeInfo.getNumber(), asstActTypeInfo.getAsstHGAttribute());
        this.asstActTypeAttribeMap2NumberMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo.getNumber());
        this.attribute2AsstActTypeMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo);
    }

    private String getCachedAttribute(String asstActTypeNumber) {
        return (String)this.asstActTypeNumber2AttribeMap.get(asstActTypeNumber);
    }

    private AsstActTypeInfo getCachedAsstActTypeInfo(String attribute) {
        return (AsstActTypeInfo)this.attribute2AsstActTypeMap.get(attribute);
    }

    private void addSelectController(AsstActTypeInfo asstActTypeInfo, IObjectCollection asstCollection, Map<String, String> attributeAndGroupMap) throws EASBizException, BOSException {
        if (asstCollection != null && asstCollection.size() > 0) {
            KDComboBox comboBox = new KDComboBox();
            KDTDefaultCellEditor comboBoxEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
            ArrayList<IObjectValue> itemList = new ArrayList<IObjectValue>();
            for (IObjectValue info : asstCollection) {
                comboBox.addItem((Object)info);
                itemList.add(info);
            }
            this.comboBoxController.put(asstActTypeInfo.getAsstHGAttribute(), comboBoxEditor);
            this.asstItemMap.put(asstActTypeInfo.getAsstHGAttribute(), itemList);
        }
        KDBizPromptBox f7 = new KDBizPromptBox();
        KDTDefaultCellEditor f7Editor = new KDTDefaultCellEditor((IKDEditor)f7);
        if (asstActTypeInfo.getAsstHGAttribute().equals("material")) {
            f7.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7MaterialQuery");
        } else if (asstActTypeInfo.getAsstHGAttribute().equals("customer")) {
            f7.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7CustomerQuery");
        } else if (asstActTypeInfo.getAsstHGAttribute().equals("provider")) {
            f7.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7SupplierQuery");
        } else if (asstActTypeInfo.getAsstHGAttribute().equals("person")) {
            f7.setQueryInfo("com.kingdee.eas.fi.gr.dynamic.app.AllPositionPersonQuery");
        } else {
            f7.setQueryInfo(asstActTypeInfo.getDefaultQueryName());
        }
        f7.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                FilterInfo filter = new FilterInfo();
                return filter;
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        HashMap uiContext = new HashMap();
        uiContext.put("Company", this.getUIContext().get("Company"));
        uiContext.put("asstActTypeAttribeAndGroupMap", attributeAndGroupMap);
        Map subTypeFilterMap = (Map)uiContext.get("subTypeFilterMap");
        uiContext.put("subTypeFilterMap", subTypeFilterMap);
        EntityViewInfo view = DynamicTemplateUtility.createAsstItemFilter(null, asstActTypeInfo, uiContext);
        f7.setEntityViewInfo(view);
        f7.setCommitFormat("$number$;$name$");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.getQueryAgent().getQueryExecutor().option().isIgnorePermissionCheck = true;
        this.f7Controller.put(asstActTypeInfo.getAsstHGAttribute(), f7Editor);
    }

    private void addColumn(AsstActTypeInfo asstActTypeInfo, IObjectCollection asstCollection, IRow headRow) {
        IColumn addColumn = this.tblMain.addColumn();
        addColumn.setWidth(120);
        addColumn.setKey(asstActTypeInfo.getAsstHGAttribute());
        headRow.getCell(asstActTypeInfo.getAsstHGAttribute()).setValue((Object)asstActTypeInfo.getName());
    }

    private Map.Entry getAsstItemEntryByAttribute(String attribute, Map itemCollections) {
        if (itemCollections != null) {
            for (Map.Entry entry : itemCollections.entrySet()) {
                AsstActTypeInfo key = (AsstActTypeInfo)entry.getKey();
                if (!attribute.equals(key.getAsstHGAttribute())) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public void actionSelectModeChange_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            AsstAccountUtils asstAccount = this.getParameters().getAsstAccount();
            if (asstAccount == null) continue;
            ArrayList asstActTypeList = asstAccount.getAsstActTypeList();
            for (AsstActTypeUtils acctActType : asstActTypeList) {
                ICell cell = row.getCell(acctActType.getAsstHGAttribute());
                if (this.cbxItemSelectMode.getSelectedIndex() == 0) {
                    KDTDefaultCellEditor asstComboCellEditor = (KDTDefaultCellEditor)this.comboBoxController.get(acctActType.getAsstHGAttribute());
                    Object value = cell.getValue();
                    cell.setEditor((ICellEditor)asstComboCellEditor);
                    if (value == null || !(value instanceof IObjectValue)) continue;
                    IObjectValue info = (IObjectValue)value;
                    IObjectValue asstItem = this.searchAsstItem(acctActType.getAsstHGAttribute(), "id", info.get("id"));
                    cell.setValue((Object)asstItem);
                    continue;
                }
                if (this.cbxItemSelectMode.getSelectedIndex() != 1) continue;
                KDTDefaultCellEditor asstF7CellEditor = (KDTDefaultCellEditor)this.f7Controller.get(acctActType.getAsstHGAttribute());
                cell.setEditor((ICellEditor)asstF7CellEditor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.curSheet.getBook().getUndoManager().startGroup();
        try {
            Map tableValues = this.collectTableValue();
            MultiDynaItemFillHandle handle = new MultiDynaItemFillHandle(this.curSheet, this.getBasePoint(), (Component)((Object)this));
            handle.initVar(this.attribute2AsstActTypeMap, this.asstActTypeAttribeMap2NumberMap, this.asstActTypeNumber2AttribeMap, this.preValueMap, this.preFormulaMap);
            handle.fillSheet(tableValues);
        }
        finally {
            this.curSheet.getBook().getUndoManager().endGroup();
        }
        this.getUIWindow().close();
        this.destroyWindow();
    }

    private Map collectTableValue() throws DynamicEnumException {
        int confirm;
        int rowCount = this.tblMain.getRowCount();
        OneToManyMap result = new OneToManyMap();
        ArrayList attributeList = this.getParameters().getAsstAccount().getAsstActTypeList();
        HashSet<String> attributeSet = new HashSet<String>();
        ArrayList<AsstActTypeUtils> attributeListCopy = new ArrayList<AsstActTypeUtils>();
        for (int j = 0; j < attributeList.size(); ++j) {
            AsstActTypeUtils asstType = (AsstActTypeUtils)attributeList.get(j);
            if (attributeSet.contains(asstType.getAsstHGAttribute())) continue;
            attributeSet.add(asstType.getAsstHGAttribute());
            attributeListCopy.add(asstType);
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        boolean allHasNull = false;
        HashMap<String, Integer> repeateMap = new HashMap<String, Integer>();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean hasNull = false;
            StringBuffer repeateSB = new StringBuffer();
            for (AsstActTypeUtils asstActTypeUtils : attributeListCopy) {
                ICell cell = row.getCell(asstActTypeUtils.getAsstHGAttribute());
                Object value = cell.getValue();
                if (value != null && value instanceof IObjectValue) {
                    tempMap.put(asstActTypeUtils.getAsstHGAttribute(), value);
                    repeateSB.append(((IObjectValue)value).get("id")).append("@!@");
                    continue;
                }
                hasNull = true;
                allHasNull = true;
                break;
            }
            if (!hasNull) {
                Integer rowIndex = (Integer)row.getCell(INDEX_COL_KEY).getValue();
                if (repeateMap.get(repeateSB.toString()) != null) {
                    throw new DynamicEnumException(DynamicEnumException.ASSTACTITEM_REPEATED, new Object[]{repeateMap.get(repeateSB.toString()), rowIndex});
                }
                repeateMap.put(repeateSB.toString(), rowIndex);
            }
            if (hasNull) continue;
            for (Map.Entry entry : tempMap.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
            tempMap.clear();
        }
        if (allHasNull && (confirm = MsgBox.showConfirm2((Component)((Object)this), (String)new DynamicEnumException(DynamicEnumException.NOT_OBJECT_VALUE).getMessage())) != 0) {
            this.abort();
        }
        return result;
    }

    private void verify() {
    }

    private int getMaxColIndex(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = this.getItemFormula(cell);
        return itemCellObj != null;
    }

    private ItemFormula getItemFormula(Cell cell) {
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public ArrayList getBasePointList() {
        if (this.basePointList == null) {
            this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
        }
        if (this.basePointList == null) {
            this.basePointList = new ArrayList();
        }
        return this.basePointList;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addRow();
    }

    private IRow addRow() {
        this.tblMain.checkParsed();
        IRow row = this.tblMain.addRow();
        AsstAccountUtils asstAccount = this.getParameters().getAsstAccount();
        if (asstAccount == null) {
            return row;
        }
        int newRowIndex = (this.getParameters().getPosition() == 2 ? this.getBasePoint().y : this.getBasePoint().y + 1) + this.tblMain.getRowCount() + 1;
        ICell indexCell = row.getCell(this.getIndexColName());
        indexCell.setValue((Object)new Integer(newRowIndex));
        indexCell.getStyleAttributes().setLocked(true);
        ArrayList asstActTypeList = asstAccount.getAsstActTypeList();
        for (AsstActTypeUtils asstActType : asstActTypeList) {
            KDTDefaultCellEditor cellEditor;
            ICell cell = row.getCell(asstActType.getAsstHGAttribute());
            KDTDefaultCellEditor comBoEditor = (KDTDefaultCellEditor)this.comboBoxController.get(asstActType.getAsstHGAttribute());
            if (comBoEditor != null) {
                KDComboBox comBoBox = (KDComboBox)comBoEditor.getComponent();
                if (comBoBox.getItemCount() > 0) {
                    cell.getStyleAttributes().setLocked(false);
                } else {
                    cell.getStyleAttributes().setLocked(true);
                }
            } else {
                cell.getStyleAttributes().setLocked(true);
            }
            if (this.cbxItemSelectMode.getSelectedIndex() == 0) {
                cellEditor = comBoEditor;
                cell.setEditor((ICellEditor)cellEditor);
                continue;
            }
            if (this.cbxItemSelectMode.getSelectedIndex() != 1) continue;
            cellEditor = (KDTDefaultCellEditor)this.f7Controller.get(asstActType.getAsstHGAttribute());
            cell.setEditor((ICellEditor)cellEditor);
        }
        return row;
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.moveDownTableRows(this.tblMain);
        this.refreshIndexRow();
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.moveUpTableRows(this.tblMain);
        this.refreshIndexRow();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.removeTableRows(this.tblMain);
        this.refreshIndexRow();
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        DynamicTemplateUtility.InsertTableRows(this.tblMain);
        this.refreshIndexRow();
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 800, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 800, 600));
        this.tblMain.setBounds(new Rectangle(10, 39, 780, 517));
        this.add((Component)this.tblMain, new KDLayout.Constraints(10, 39, 780, 517, 15));
        this.kDLabelContainer1.setBounds(new Rectangle(7, 12, 460, 19));
        this.add((Component)this.kDLabelContainer1, new KDLayout.Constraints(7, 12, 460, 19, 5));
        this.btnOK.setBounds(new Rectangle(634, 569, 73, 21));
        this.add((Component)this.btnOK, new KDLayout.Constraints(634, 569, 73, 21, 10));
        this.btnCancel.setBounds(new Rectangle(717, 569, 73, 21));
        this.add((Component)this.btnCancel, new KDLayout.Constraints(717, 569, 73, 21, 10));
        this.btnAddLine.setBounds(new Rectangle(660, 12, 22, 19));
        this.add((Component)this.btnAddLine, new KDLayout.Constraints(660, 12, 22, 19, 9));
        this.btnRemove.setBounds(new Rectangle(714, 12, 22, 19));
        this.add((Component)this.btnRemove, new KDLayout.Constraints(714, 12, 22, 19, 9));
        this.btnMoveUp.setBounds(new Rectangle(741, 12, 22, 19));
        this.add((Component)this.btnMoveUp, new KDLayout.Constraints(741, 12, 22, 19, 9));
        this.btnMoveDown.setBounds(new Rectangle(768, 12, 22, 19));
        this.add((Component)this.btnMoveDown, new KDLayout.Constraints(768, 12, 22, 19, 9));
        this.btnInsertLine.setBounds(new Rectangle(687, 12, 22, 19));
        this.add((Component)this.btnInsertLine, new KDLayout.Constraints(687, 12, 22, 19, 9));
        this.kDLabelContainer1.setBoundEditor((JComponent)this.cbxItemSelectMode);
    }

    private class AsstItemComparator
    implements Comparator {
        private String fieldName;

        private AsstItemComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            if (!(arg0 instanceof IObjectValue)) {
                return -1;
            }
            if (!(arg1 instanceof IObjectValue)) {
                return 1;
            }
            Object o1 = ((IObjectValue)arg0).get(this.fieldName);
            Object o2 = ((IObjectValue)arg1).get(this.fieldName);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) {
                o1 = o1.toString();
                o2 = o2.toString();
            }
            Comparable vs0 = (Comparable)o1;
            Comparable vs1 = (Comparable)o2;
            return vs0.compareTo(vs1);
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }
}

