/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaItemDataFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiDynaSumRptCalculateGuideUI;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class MultiDynaSumRptCalculateGuideUI
extends AbstractMultiDynaSumRptCalculateGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiDynaSumRptCalculateGuideUI.class);
    private static final Pattern patternType = Pattern.compile(";");
    private static final Pattern patternItem = Pattern.compile("\\|");
    private static final Pattern pattern2Name = Pattern.compile("@!@");
    private Map basePointListMap;
    private Map sheet2AsstRowMap = new OneToManyMap();
    private KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
    private Map asstActTypeUtilsCache;
    private Map dynaKeyCache;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSheetComboBox();
        this.cacheDynaKey();
        this.cbkOnlyListCompany.setVisible(true);
        this.cbkOnlyListCompany.setEditable(true);
        this.cbkOnlyListCompany.setSelected(true);
        this.cmbSumType.removeItem((Object)MultiDynaSumTypeEnum.BYCSLACCOUNT);
        ReportDesignerUI processUI = (ReportDesignerUI)this.getUIContext().get("Owner");
        CslReportInfo report = (CslReportInfo)processUI.getBookProvider().getEditValue();
        if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.FIXED)) {
            this.cmbSumType.setSelectedItem((Object)MultiDynaSumTypeEnum.BYASSTACCOUNT);
            this.cmbSumType.setEnabled(false);
        }
    }

    private void cacheDynaKey() {
        this.dynaKeyCache = (Map)this.getUIContext().get("dynaKeyCache");
        if (this.dynaKeyCache == null) {
            this.dynaKeyCache = new HashMap();
        }
    }

    private List getDynaKeyList(String sheetName, Point basePoint) {
        Map sheetMap = (Map)this.dynaKeyCache.get(sheetName);
        if (sheetMap != null) {
            return (List)sheetMap.get(basePoint);
        }
        return null;
    }

    private void initSheetComboBox() {
        if (this.isSingleCalculate()) {
            this.cmbSheet.removeAllItems();
            this.cmbSheet.addItem((Object)this.curSheets.getActiveSheet().getSheetName());
        } else {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                this.cmbSheet.addItem((Object)sheet.getSheetName());
            }
        }
    }

    @Override
    public void actionAsstSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblAsst, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionAsstClear_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblAsst, (String)"select", (Boolean)Boolean.FALSE);
    }

    protected void dealWithBasePoint(Book book) throws BOSException {
        this.tblAsst.checkParsed();
        Map asstActTypeMap = this.queryAsstActType(book);
        if (this.isSingleCalculate()) {
            Sheet sheet = book.getActiveSheet();
            this.addAsstTable(sheet, asstActTypeMap);
        } else {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                this.addAsstTable(sheet, asstActTypeMap);
            }
        }
    }

    private void addAsstTable(Sheet sheet, Map asstActTypeMap) {
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeMap.get(asstActTypeUtil.asstHGAttribute);
                if (asstActTypeInfo == null) continue;
                IRow row = this.tblAsst.addRow();
                row.setUserObject((Object)asstActTypeInfo);
                ICell cell = row.getCell("sheetname");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)sheet.getSheetName());
                CellReference ref = new CellReference(point.y, point.x);
                cell = row.getCell("basepoint");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)ref.toString());
                cell = row.getCell("asstacttype");
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)asstActTypeInfo.getName());
                cell = row.getCell("select");
                cell.getStyleAttributes().setLocked(false);
                cell.setEditor((ICellEditor)this.selectEditor);
                cell.setValue((Object)Boolean.TRUE);
                this.sheet2AsstRowMap.put(sheet.getSheetName(), row);
            }
        }
    }

    private Map queryAsstActType(Book book) throws BOSException {
        Set attributeSet = new HashSet();
        if (this.isSingleCalculate()) {
            Sheet sheet = book.getActiveSheet();
            attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
        } else {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attributeSet, CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            asstActTypeMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo);
        }
        return asstActTypeMap;
    }

    private Set collectAsstActTypeAttribute(Set attributeSet, Sheet sheet) {
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            if (asstAccount == null || asstAccount.getAsstActTypeList() == null) continue;
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                attributeSet.add(asstActTypeUtil.asstHGAttribute);
            }
        }
        return attributeSet;
    }

    private List getBasePointList(String sheetName) {
        if (this.basePointListMap == null) {
            this.basePointListMap = new HashMap();
            if (this.isSingleCalculate()) {
                Sheet sheet = this.curSheets.getActiveSheet();
                ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                this.basePointListMap.put(sheet.getSheetName(), list);
            } else {
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet sheet = this.curSheets.getSheet(i);
                    ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                    this.basePointListMap.put(sheet.getSheetName(), list);
                }
            }
        }
        return (List)this.basePointListMap.get(sheetName);
    }

    private boolean isSingleCalculate() {
        Map ownerContext = ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext();
        Boolean isCalcSinglePage = (Boolean)ownerContext.get("KEY_CALCULATESINGLEPAGE");
        return isCalcSinglePage == null ? false : isCalcSinglePage;
    }

    @Override
    public void actionSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFirstOnload()) {
            return;
        }
        if (this.isSingleCalculate()) {
            return;
        }
        this.tblAsst.removeRows();
        if (this.cmbSheet.getSelectedIndex() == 0) {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                this.addRow(sheet.getSheetName());
            }
        } else {
            String sheetName = (String)this.cmbSheet.getSelectedItem();
            this.addRow(sheetName);
        }
    }

    @Override
    public void actionSumTypeChange_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYASSTACCOUNT) {
            this.tblAsst.setEnabled(false);
            int rowCount = this.tblAsst.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAsst.getRow(i);
                row.getCell("select").setValue((Object)Boolean.TRUE);
            }
            this.btnAsstClear.setEnabled(false);
            this.btnAsstSelectAll.setEnabled(false);
            this.cbkOnlyListCompany.setEnabled(false);
        } else {
            this.tblAsst.setEnabled(true);
            this.btnAsstClear.setEnabled(true);
            this.btnAsstSelectAll.setEnabled(true);
            this.cbkOnlyListCompany.setEnabled(true);
        }
    }

    private void addRow(String sheetName) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList != null && rowList.size() > 0) {
            for (IRow row : rowList) {
                this.tblAsst.addRow(this.tblAsst.getRowCount(), row);
            }
        }
    }

    protected Map getTableMap(DynaSumMethodEnum selectedItem, boolean onlyList, boolean isShowTotal, boolean isOnlyListCompany, Sheet sheet) {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            return SumHelper.scanDynaTable((Sheet)sheet, (DynaSumMethodEnum)selectedItem, (boolean)onlyList, (boolean)isShowTotal, (boolean)isOnlyListCompany);
        }
        Map dynaTable = SumHelper.scanDynaTable((Sheet)sheet, (DynaSumMethodEnum)selectedItem, (boolean)onlyList, (boolean)isShowTotal, (boolean)isOnlyListCompany);
        Map dynaKeyMap = (Map)this.dynaKeyCache.get(sheet.getSheetName());
        for (Map.Entry entry2 : dynaTable.entrySet()) {
            Point basePoint = (Point)entry2.getKey();
            List dynaKeyList = (List)dynaKeyMap.get(basePoint);
            Map areaMap = (Map)entry2.getValue();
            HashMap<Point, ItemFormula> newFormulaMap = new HashMap<Point, ItemFormula>();
            if (dynaKeyList != null) {
                DynaParameters parameters = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
                Map formulasMap = (Map)areaMap.get("formulas");
                for (Map.Entry entry3 : formulasMap.entrySet()) {
                    Point point = (Point)entry3.getKey();
                    ItemFormula itemFormula = (ItemFormula)entry3.getValue();
                    int row = parameters.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
                    for (String dynaKey : dynaKeyList) {
                        ItemFormula newItemFormula = (ItemFormula)itemFormula.clone();
                        newItemFormula.setDItemNumber(dynaKey);
                        newFormulaMap.put(new Point(point.x, row++), newItemFormula);
                    }
                }
            }
            areaMap.put("formulas", newFormulaMap);
        }
        return dynaTable;
    }

    protected Map calcMultiDynaSumRpt(String reportID, List companyList, Map tableValues) throws EASBizException, BOSException {
        Map asstActTypeMap = this.collectAsstActTypeMap();
        MultiDynaSumTypeEnum sumType = this.getSumType();
        return CSLReportCalculatorFactory.getRemoteInstance().calculateMultiDynaSumRpt(reportID, companyList, asstActTypeMap, tableValues, sumType, this.cbkOnlyListCompany.isSelected());
    }

    private MultiDynaSumTypeEnum getSumType() {
        MultiDynaSumTypeEnum sumType = (MultiDynaSumTypeEnum)((Object)this.cmbSumType.getSelectedItem());
        return sumType;
    }

    private Map collectAsstActTypeMap() {
        Map result = this.getSelectedAsstActTypeList();
        HashMap asstActTypeResultMap = new HashMap();
        for (Map.Entry entry : result.entrySet()) {
            List list = (List)entry.getValue();
            AsstActTypeCollection asstActTypeCollection = new AsstActTypeCollection();
            for (AsstActTypeInfo info : list) {
                asstActTypeCollection.add(info);
            }
            asstActTypeResultMap.put(entry.getKey(), asstActTypeCollection);
        }
        return asstActTypeResultMap;
    }

    private Map getSelectedAsstActTypeList(String sheetName) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return new HashMap();
        }
        StringBuffer key = new StringBuffer();
        OneToManyMap result = new OneToManyMap();
        for (IRow row : rowList) {
            if (this.getSumType() != MultiDynaSumTypeEnum.BYASSTACCOUNT && !Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            key.setLength(0);
            Sheet sheet = this.curSheets.getSheet(sheetName);
            AsstActTypeInfo info = (AsstActTypeInfo)row.getUserObject();
            CellReference cellReference = new CellReference((String)row.getCell("basepoint").getValue());
            key.append(sheet.getID()).append("|").append(cellReference.getCol()).append("|").append(cellReference.getRow());
            result.put(key.toString(), info);
        }
        return result;
    }

    private List getSelectedAsstActTypeList(String sheetName, Point basePoint) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return new ArrayList();
        }
        StringBuffer key = new StringBuffer();
        ArrayList<AsstActTypeInfo> result = new ArrayList<AsstActTypeInfo>();
        for (IRow row : rowList) {
            if (this.getSumType() != MultiDynaSumTypeEnum.BYASSTACCOUNT && !Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            key.setLength(0);
            AsstActTypeInfo info = (AsstActTypeInfo)row.getUserObject();
            CellReference cellReference = new CellReference((String)row.getCell("basepoint").getValue());
            if (basePoint.x != cellReference.getCol() || basePoint.y != cellReference.getRow()) continue;
            result.add(info);
        }
        return result;
    }

    private Map getSelectedAsstActTypeList() {
        if (this.isSingleCalculate()) {
            return this.getSelectedAsstActTypeList(this.curSheets.getActiveSheet().getSheetName());
        }
        HashMap result = new HashMap();
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            result.putAll(this.getSelectedAsstActTypeList(this.curSheets.getSheet(i).getSheetName()));
        }
        return result;
    }

    protected void fillMultiSumData(DynaParameters param, Point basePoint, Sheet sheet, Map valueMap, int selectedSize) throws EASBizException, BOSException {
        List selectedAsstActTypeList = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return;
        }
        int maxCol = this.getMaxColIndex(sheet, basePoint);
        List mapedItemList = this.getItemFormulaList(sheet, basePoint, maxCol);
        int asstColCount = 0;
        asstColCount = this.fillHeadAsstItem(sheet, param, basePoint, selectedAsstActTypeList, maxCol);
        this.fillHeadItemFormula(sheet, basePoint, mapedItemList, asstColCount, maxCol);
        List itemList = this.getFormulaItemListFromMap(mapedItemList);
        if (valueMap == null || valueMap.size() == 0) {
            this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), 0);
            this.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1, asstColCount, maxCol);
            param.setDefaultCounter(0);
            this.saveBasePointCell(sheet, basePoint, param);
        } else {
            int rowCount = this.fillData(param, sheet, basePoint, itemList, valueMap, asstColCount, maxCol);
            this.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1 + rowCount, asstColCount, maxCol);
            param.setDefaultCounter(rowCount);
            this.saveBasePointCell(sheet, basePoint, param);
            int startRow = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
            int endRow = startRow + rowCount;
            this.mergeCell(sheet, basePoint.x, basePoint.x + asstColCount - 1, startRow, endRow);
        }
    }

    private void mergeCell(Sheet sheet, int startCol, int endCol, int startRow, int endRow) {
        if (!this.chkMergeCell.isSelected()) {
            return;
        }
        for (int col = startCol; col <= endCol; ++col) {
            int beginRow = startRow;
            Variant value = null;
            for (int row = startRow; row <= endRow; ++row) {
                Cell cell = sheet.getCell(row, col, false);
                Variant cellValue = null;
                if (cell != null) {
                    cellValue = cell.getValue();
                }
                if (cellValue == null && row != endRow) continue;
                if (value == null) {
                    value = cellValue;
                    continue;
                }
                if (row != endRow && value.equals(cellValue)) continue;
                if (row - beginRow > 1) {
                    if (col != startCol) {
                        Range preRange = sheet.getRange(beginRow, col - 1, row - 1, col - 1);
                        Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(preRange.getBlock(0), false, true);
                        if (!cellsIterator.hasNext() && row - beginRow > 1) {
                            Range range = sheet.getRange(beginRow, col, row - 1, col);
                            range.setIgnoreProtected(true);
                            range.merge();
                        } else {
                            while (cellsIterator.hasNext()) {
                                int row1;
                                Cell cell2 = cellsIterator.next();
                                CellBlock block = sheet.getMergeBlock(cell2);
                                int n = block == null ? cell2.getRow() : (row1 = beginRow > block.getRow() ? beginRow : block.getRow());
                                int row2 = block == null ? cell2.getRow() : (row - 1 < block.getRow2() ? row - 1 : block.getRow2());
                                Range range = sheet.getRange(row1, col, row2, col);
                                range.setIgnoreProtected(true);
                                range.merge();
                            }
                        }
                    } else {
                        Range range = sheet.getRange(beginRow, col, row - 1, col);
                        range.setIgnoreProtected(true);
                        range.merge();
                    }
                }
                beginRow = row;
                value = cellValue;
            }
        }
    }

    private List getFormulaItemListFromMap(List mapedItemList) {
        ArrayList itemList = new ArrayList(mapedItemList.size());
        for (Map map : mapedItemList) {
            itemList.add(map.get("formulas"));
        }
        return itemList;
    }

    private int fillData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, Map valueMap, int asstColCount, int oldMaxCol) throws EASBizException, BOSException {
        List selectedAsstActType = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int startRowIndex = basePoint.y + sumLine + 1;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            List companyList = this.initCompanyList();
            Set dynaKeySet = (Set)valueMap.get("KEY_ALL_MULTIDYNAKEY");
            List dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActType, dynaKeySet.iterator());
            valueMap.remove("KEY_ALL_MULTIDYNAKEY");
            int realRowCount = 0;
            for (Map orgMap : valueMap.values()) {
                realRowCount += orgMap.size();
            }
            this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
            for (OrgUnitInfo orgUnit : companyList) {
                Map orgValueMap = (Map)valueMap.get(orgUnit.getId().toString());
                if (orgValueMap == null) continue;
                int filledCount = this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, orgUnit, orgValueMap, startRowIndex, asstColCount, oldMaxCol);
                startRowIndex += filledCount;
            }
            this.fillCompanyIDsToSheet(sheet);
            return realRowCount;
        }
        List dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActType, valueMap.keySet().iterator());
        int realRowCount = dynaItemList.size();
        this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
        this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, null, valueMap, startRowIndex, asstColCount, oldMaxCol);
        this.fillCompanyIDsToSheet(sheet);
        return realRowCount;
    }

    private void fillCompanyIDsToSheet(Sheet sheet) {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            sheet.removeUserObject("COMPANY_NUMBER");
        } else {
            ArrayList<String> companyIDList = new ArrayList<String>();
            for (int i = 0; i < this.tblCompany.getRowCount(); ++i) {
                IRow row = this.tblCompany.getRow(i);
                if (!row.getCell(1).getValue().equals(Boolean.TRUE)) continue;
                OrgUnitInfo company = (OrgUnitInfo)row.getCell(4).getValue();
                companyIDList.add(company.getId().toString());
            }
            sheet.setUserObject("COMPANY_NUMBER", companyIDList);
        }
    }

    private void saveBasePointCell(Sheet sheet, Point basePoint, DynaParameters param) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell(range, param);
    }

    private int doFillItemAndData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, List dynaItemList, List asstActTypeList, OrgUnitInfo curCompany, Map values, int startRowIndex, int asstColCount, int oldMaxCol) {
        int startItemColIndex = basePoint.x + asstColCount;
        int curRowIndex = startRowIndex;
        int newMaxCol = startItemColIndex + itemList.size() - 1;
        int count = 0;
        for (int i = 0; i < dynaItemList.size(); ++i) {
            int asstIndex = 0;
            int itemIndex = 0;
            int startColIndex = basePoint.x;
            DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(i);
            String dItemKey = dynaKeyItem.toString();
            String dItem = dynaKeyItem.getDynaKey();
            if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                if (values.get(dItemKey) == null) continue;
                Range range = sheet.getRange(curRowIndex, startColIndex);
                range.setIgnoreProtected(true);
                range.setFormula(null);
                range.setUserObject("ITEM", null);
                range.setValue(new Variant((Object)curCompany.getName()));
                ++startColIndex;
                ++asstIndex;
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", (Object)curCompany.getId().toString());
                }
            } else {
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", null);
                }
            }
            int x = startColIndex;
            while (x <= newMaxCol) {
                if (x < startItemColIndex) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList.get(this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT ? asstIndex - 1 : asstIndex);
                    String asstActTypeNumber = asstActTypeInfo.getNumber();
                    String itemNumber = dynaKeyItem.getItemNumber(asstActTypeNumber);
                    String itemName = dynaKeyItem.getItemName(asstActTypeNumber);
                    int colCount = this.fillAsstItem(param, sheet, itemNumber, itemName, asstActTypeInfo, x, curRowIndex);
                    x += colCount;
                    ++asstIndex;
                    continue;
                }
                ItemFormula itemFormula = (ItemFormula)itemList.get(itemIndex);
                this.fillItem(param, sheet, dItemKey, dItem, itemFormula, values, x, curRowIndex, itemIndex);
                ++x;
                ++itemIndex;
            }
            this.clearExtraRange(sheet, curRowIndex, oldMaxCol, newMaxCol);
            ++count;
            ++curRowIndex;
        }
        return count;
    }

    private int fillAsstItem(DynaParameters param, Sheet sheet, String itemNumber, String itemName, AsstActTypeInfo asstActTypeInfo, int x, int y) {
        Range range;
        int count = 0;
        AsstActTypeUtils asstActType = this.getAsstActTypeUtils(param, asstActTypeInfo);
        if (!StringUtils.isEmpty((String)asstActType.properityName)) {
            range = sheet.getRange(y, x++);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemNumber));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.properityAlias)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.dynaProperty)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        return count;
    }

    private void fillItem(DynaParameters param, Sheet sheet, String dItemKey, String dItem, ItemFormula itemFormula, Map values, int x, int y, int colIndex) {
        Range range = sheet.getRange(y, x);
        range.setIgnoreProtected(true);
        if (itemFormula != null) {
            range.setFormula(null);
            this.fillDItemFormula(range, itemFormula, dItem);
            this.fillValue(range, values, itemFormula, dItemKey);
        } else {
            range.setUserObject("ITEM", null);
            range.setValue(Variant.nullVariant);
            range.setFormula(null);
        }
    }

    private void fillDItemFormula(Range range, ItemFormula itemFormula, String dItemNumber) {
        String dItemFormula = this.constructDItemFormula(itemFormula, dItemNumber);
        range.setUserObject("ITEM", (Object)new ItemFormula(dItemFormula));
    }

    private String constructDItemFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void fillValue(Range range, Map valueMap, ItemFormula itemFormula, String dItemKey) {
        Map item2ValueMap;
        if (valueMap != null && (item2ValueMap = (Map)valueMap.get(dItemKey)) != null) {
            DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((String)itemFormula.getDataElementNumber());
            Object value = item2ValueMap.get(itemFormula.getItemNumber() + "@!@" + dataElementInfo.getInterSeq() + "@!@" + itemFormula.getValueType());
            if (value != null) {
                if (itemFormula.getValueType() != 3) {
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)"BigDecimal Cast Error: ", (Throwable)e);
                    }
                }
                range.setValue(new Variant(value));
                return;
            }
        }
        if (itemFormula.getValueType() == 3) {
            range.setValue(Variant.nullVariant);
        } else {
            range.setValue(Variant.zeroVariant);
        }
    }

    private AsstActTypeUtils getAsstActTypeUtils(DynaParameters param, AsstActTypeInfo asstActTypeInfo) {
        Map<String, AsstActTypeUtils> map;
        String paramKey = param.toString();
        if (this.asstActTypeUtilsCache == null) {
            this.asstActTypeUtilsCache = new HashMap();
            map = new HashMap();
            this.asstActTypeUtilsCache.put(paramKey, map);
            for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
                map.put(asstutil.asstHGAttribute, asstutil);
            }
        } else {
            map = (HashMap)this.asstActTypeUtilsCache.get(paramKey);
            if (map == null) {
                map = new HashMap();
                this.asstActTypeUtilsCache.put(paramKey, map);
                for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
                    map.put(asstutil.asstHGAttribute, asstutil);
                }
            }
        }
        map = (Map)this.asstActTypeUtilsCache.get(paramKey);
        return (AsstActTypeUtils)map.get(asstActTypeInfo.getAsstHGAttribute());
    }

    private void adjustRowCount(DynaParameters param, Sheet sheet, Point basePoint, int asstColCount, int oldRowCount, int realRowCount) {
        if (realRowCount > oldRowCount) {
            this.addSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        } else if (realRowCount < oldRowCount) {
            this.removeSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        }
        if (realRowCount == 0) {
            return;
        }
        int startRow = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
        Range range = sheet.getRange(startRow, basePoint.x, startRow + realRowCount - 1, basePoint.x + asstColCount - 1);
        range.merge();
        MergeBlocks merger = sheet.getMerger(false);
        merger.remove((SortedCellBlockArray)range);
    }

    private void addSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + oldMaxRowCount + 1 + sumLine;
        int y2 = y + rowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.NOSTYLE);
    }

    private void removeSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + rowCount + 1 + sumLine;
        int y2 = y + oldMaxRowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.delete();
    }

    private List analyzeDynaKey(Sheet sheet, Point basePoint, List asstActTypeList, Iterator iterator) {
        ArrayList<DynaKeyItem> result = new ArrayList<DynaKeyItem>();
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                result.add(item);
            }
            MultiKeyComparator multiKeyComparator = new MultiKeyComparator();
            multiKeyComparator.setAsstActTypeList(asstActTypeList);
            Collections.sort(result, multiKeyComparator);
        } else {
            HashMap<String, DynaKeyItem> dynaKeyMap = new HashMap<String, DynaKeyItem>();
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                dynaKeyMap.put(item.getDynaKey(), item);
            }
            List formerDynaKeyList = this.getDynaKeyList(sheet.getSheetName(), basePoint);
            if (formerDynaKeyList != null) {
                MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
                for (String formerDyKey : formerDynaKeyList) {
                    Object item = dynaKeyMap.get(formerDyKey = multiDynaItem.sortDynaKey(formerDyKey));
                    if (item == null) continue;
                    result.add((DynaKeyItem)item);
                }
            }
        }
        return result;
    }

    private List initCompanyList() throws EASBizException, BOSException {
        Vector companys = this.getSelectedCompanys();
        List result = new ArrayList(companys);
        if (this.cbkOnlyListCompany.isSelected()) {
            ArrayList<String> companyIDList = new ArrayList<String>();
            for (OrgUnitInfo info : result) {
                companyIDList.add(info.getId().toString());
            }
            String orgTreeId = null;
            if (this.curReport.getOrgTree() == null) {
                RptReceivedInfo received = RptReceivedFactory.getRemoteInstance().getRptReceivedInfo("select orgTree where report='" + this.curReport.getId().toString() + "'");
                orgTreeId = received.getOrgTree().getId().toString();
            } else {
                orgTreeId = this.curReport.getOrgTree().getId().toString();
            }
            result = MultiDynaItemDataFacadeFactory.getRemoteInstance().getLeafCompanys(companyIDList, orgTreeId);
        }
        ObjectValueComparator comparator = new ObjectValueComparator();
        comparator.setFieldName("longnumber");
        Collections.sort(result, comparator);
        return result;
    }

    private void fillSumLine(DynaParameters param, Sheet sheet, Point basePoint, List itemList, int row, int asstColCount, int oldMaxCol) {
        if (!param.isIncludeSum()) {
            return;
        }
        int sumCellRow = param.getPosition() == 2 ? row : basePoint.y + 1;
        this.fillSumTitle(param, sheet, basePoint, sumCellRow, asstColCount);
        int Count = itemList.size();
        int col = basePoint.x + asstColCount;
        if (row == basePoint.y + 1) {
            this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
            return;
        }
        int i = 0;
        while (i < Count) {
            ItemFormula itemFormula = (ItemFormula)itemList.get(i);
            if (itemFormula.getValueType() != 3) {
                String endCellName;
                String startCellName;
                Range sumCell;
                if (param.getPosition() == 1) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    startCellName = Location.getCellName((int)(basePoint.y + 1 + 1), (int)col);
                    endCellName = Location.getCellName((int)row, (int)col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                } else if (param.getPosition() == 2) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    startCellName = Location.getCellName((int)(basePoint.y + 1), (int)col);
                    endCellName = Location.getCellName((int)(row - 1), (int)col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                }
            }
            ++i;
            ++col;
        }
        Row sumRow = sheet.getRow(sumCellRow, false);
        if (sumRow != null) {
            sumRow.setUserObject("COMPANY_NUMBER", null);
        }
        this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
    }

    private void fillSumTitle(DynaParameters param, Sheet table, Point basePoint, int row, int asstCount) {
        if (!param.isIncludeSum()) {
            return;
        }
        Point sumPoint = new Point();
        sumPoint.x = basePoint.x;
        sumPoint.y = row;
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
        for (int i = 0; i < asstCount; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
            range.setFormula(null);
            range.setValue(new Variant((Object)"--"));
        }
    }

    private void fillHeadItemFormula(Sheet sheet, Point basePoint, List itemFormulaList, int asstColCount, int maxCol) {
        int col = basePoint.x + asstColCount;
        for (Map map : itemFormulaList) {
            ItemFormula itemFormula = (ItemFormula)map.get("formulas");
            Variant value = (Variant)map.get("KEY_DITEM_NAME");
            String formula = (String)map.get("funtion_formula");
            Range range = sheet.getRange(basePoint.y, col++);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setValue(value);
            range.setFormula(formula);
        }
        this.clearExtraRange(sheet, basePoint.y, maxCol, col - 1);
    }

    private void clearExtraRange(Sheet sheet, int row, int oldMaxCol, int curMaxCol) {
        if (curMaxCol < oldMaxCol) {
            for (int i = curMaxCol + 1; i <= oldMaxCol; ++i) {
                Range range = sheet.getRange(row, i);
                this.clearRange(range);
            }
        }
    }

    private void clearRange(Range range) {
        range.setIgnoreProtected(true);
        range.setValue(Variant.nullVariant);
        range.setUserObject("ITEM", null);
        range.setFormula(null);
    }

    private int fillHeadAsstItem(Sheet sheet, DynaParameters parameters, Point basePoint, List selectedAsstActTypeList, int maxCol) {
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return 0;
        }
        int dv = 0;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            Range cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Company")));
            ++dv;
        }
        for (AsstActTypeInfo asstActTypeInfo : selectedAsstActTypeList) {
            Range cell;
            AsstActTypeUtils acctType = this.getAsstActTypeUtils(parameters, asstActTypeInfo);
            if (acctType == null) continue;
            if (!StringUtils.isEmpty((String)acctType.properityName)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityName));
                ++dv;
            }
            if (!StringUtils.isEmpty((String)acctType.properityAlias)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityAlias));
                ++dv;
            }
            if (StringUtils.isEmpty((String)acctType.dynaProperty)) continue;
            cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setFormula(null);
            if (dv != 0) {
                cell.setUserObject("ITEM", null);
            }
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private List getItemFormulaList(Sheet sheet, Point basePoint, int maxCol) {
        ArrayList list = new ArrayList();
        for (int j = basePoint.x + 1; j <= maxCol; ++j) {
            Range range = sheet.getRange(basePoint.y, j);
            ItemFormula f = SumHelper.getFormula((Range)range);
            if (f == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formulas", f);
            map.put("KEY_DITEM_NAME", range.getValue());
            map.put("funtion_formula", range.getFormula());
            list.add(map);
        }
        return list;
    }

    private int getMaxColIndex(Sheet curSheet, Point basePoint) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > basePoint.x; --i) {
            Cell cell = curSheet.getCell(basePoint.y, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private class DynaKeyItem {
        private Map typeNumberMap;
        private String[] itemNumber;
        private String[] itemName;

        DynaKeyItem(String dynaKey) {
            String[] typeItem = patternType.split(dynaKey);
            this.typeNumberMap = new HashMap();
            this.itemNumber = new String[typeItem.length];
            this.itemName = new String[typeItem.length];
            for (int j = 0; j < typeItem.length; ++j) {
                String[] eachItem = patternItem.split(typeItem[j]);
                this.typeNumberMap.put(eachItem[0], new Integer(j));
                String[] split = pattern2Name.split(eachItem[1]);
                this.itemNumber[j] = split[0];
                this.itemName[j] = split[1];
            }
        }

        String getItemNumber(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemNumber[seq];
            }
            return null;
        }

        String getItemName(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemName[seq];
            }
            return null;
        }

        String getDynaKey() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }

        public String toString() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq] + "@!@" + this.itemName[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }
    }

    private class MultiKeyComparator
    implements Comparator {
        private List asstActTypeNumberList = new ArrayList();

        private MultiKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            DynaKeyItem key1 = (DynaKeyItem)o1;
            DynaKeyItem key2 = (DynaKeyItem)o2;
            for (String typeNumber : this.asstActTypeNumberList) {
                String item2;
                String item1 = key1.getItemNumber(typeNumber);
                int compareTo = item1.compareTo(item2 = key2.getItemNumber(typeNumber));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 0;
        }

        public void setAsstActTypeList(List asstActTypeList) {
            this.asstActTypeNumberList.clear();
            for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
                this.asstActTypeNumberList.add(asstActTypeInfo.getNumber());
            }
        }
    }
}

