/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.DynamicEnumException;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiDynaTemplateWizardUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.client.IWizardUI;
import com.kingdee.eas.fi.gr.dynamic.client.SumPositionEnum;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaProperty;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.client.AsstGroupChooserPromptForOneRow;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MultiDynaTemplateWizardUI
extends AbstractMultiDynaTemplateWizardUI
implements IWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiDynaTemplateWizardUI.class);
    protected static final int COL_ID = 0;
    protected static final int COL_ITEM_NUMBER = 1;
    protected static final int COL_ITEM_NAME = 2;
    protected static final int COL_DATAELEMENT = 3;
    protected static final int COL_VALUETYPE = 4;
    protected static final int COL_YEAR = 5;
    protected static final int COL_PERIOD = 6;
    private Map viewAttributeMap = new HashMap();
    private KDTDefaultCellEditor checkBoxCellEditor = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
    private KDTDefaultCellEditor asstComboCellEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox());
    private KDTDefaultCellEditor asstF7CellEditor = new KDTDefaultCellEditor((IKDEditor)new KDBizPromptBox());
    private static final int BY_COMBOBOX = 0;
    private static final int BY_F7 = 1;
    private ArrayList dynaItemList = new ArrayList();
    private Point basePoint;
    private int preSpreadStyle = -1;
    private ArrayList basePointList = null;
    private Sheet curSheet = null;
    private DynaParameters parameters = new DynaParameters();
    private boolean isModify;
    private boolean isCancel = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCurSheet();
        this.initBasePointList();
        this.initParameters();
        this.initControl();
        this.initAsstTable();
        this.tblAsst.getColumn("asstActType").getStyleAttributes().setHided(false);
        this.tblAsst.getColumn("fillNumber").getStyleAttributes().setHided(false);
        this.tblAsst.getColumn("fillName").getStyleAttributes().setHided(false);
        this.tblAsst.getColumn("fillAttribute").getStyleAttributes().setHided(true);
        this.kDTDynaItem.checkParsed();
        this.kDTDynaItem.getColumn("year").getStyleAttributes().setHided(true);
        this.kDTDynaItem.getColumn("period").getStyleAttributes().setHided(true);
    }

    private void initParameters() {
        this.setModify(this.getUIContext().get("isModify") != null);
        if (this.isModify()) {
            this.parameters = this.getPreDynaParam();
            this.setPreSpreadStyle(this.parameters.getSpreadStyle());
        } else {
            this.parameters = new DynaParameters();
        }
    }

    private void initControl() throws BOSException {
        this.kDContainer1.setContainerType(1);
        this.kDContainer2.setContainerType(1);
        this.kDContainer3.setContainerType(1);
        SpinnerNumberModel defaultCounterModel = new SpinnerNumberModel(10, 1, 1000, 1);
        this.kDSDefaultCounter.setModel((SpinnerModel)defaultCounterModel);
        if (this.isModify()) {
            this.kdrVertical.setEnabled(false);
            this.kdrAppend.setEnabled(false);
            this.kdrVertical.setSelected(true);
            this.initItemTable();
            this.kDSDefaultCounter.setValue((Object)new Integer(this.parameters.getDefaultCounter()));
        } else if (this.getBasePointList().size() == 0) {
            this.kdrAppend.setEnabled(false);
            this.kdrVertical.setSelected(true);
        } else {
            Point point = (Point)this.getBasePointList().get(0);
            DynaParameters tempPara = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet.getRange(point.y, point.x));
            this.setPreSpreadStyle(tempPara.getSpreadStyle());
            this.kdrAppend.setSelected(true);
        }
        this.kdCheckIsIncluseSum.setSelected(this.parameters.isIncludeSum());
        if (this.parameters.isIncludeSum()) {
            this.kDCSumPosition.setEnabled(true);
            if (this.parameters.getPosition() == 1) {
                this.kDCSumPosition.setSelectedItem((Object)SumPositionEnum.LEFT_UP);
            } else {
                this.kDCSumPosition.setSelectedItem((Object)SumPositionEnum.RIGHT_DOWN);
            }
        } else {
            this.kDCSumPosition.setEnabled(false);
            this.kDCSumPosition.setSelectedItem(null);
        }
        this.kDSDefaultCounter.setValue((Object)new Integer(this.parameters.getDefaultCounter()));
    }

    private DynaParameters getPreDynaParam() {
        Point basePoint = this.getBasePoint();
        DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, basePoint.y, basePoint.x);
        return param;
    }

    private void initItemTable() throws BOSException {
        int i;
        Point basePoint = this.getBasePoint();
        int colCount = this.getColCount(this.curSheet, basePoint.y, basePoint.x);
        HashSet<String> itemNumberSet = new HashSet<String>();
        ArrayList<ItemFormula> formulaList = new ArrayList<ItemFormula>();
        for (int i2 = basePoint.x + 1; i2 <= colCount; ++i2) {
            ItemFormula itemCellObj = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(basePoint.y, i2, false));
            if (itemCellObj == null || itemCellObj.getItemNumber() == null || itemCellObj.getItemNumber().length() == 0) continue;
            formulaList.add(itemCellObj);
            itemNumberSet.add(itemCellObj.getItemNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", itemNumberSet, CompareType.INCLUDE));
        RPTItemCollection itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(view);
        HashMap<String, RPTItemInfo> number2InfoMap = new HashMap<String, RPTItemInfo>();
        for (i = 0; i < itemCollection.size(); ++i) {
            number2InfoMap.put(itemCollection.get(i).getNumber(), itemCollection.get(i));
        }
        for (i = 0; i < formulaList.size(); ++i) {
            ItemFormula dItem = (ItemFormula)formulaList.get(i);
            RPTItemInfo rptItemInfo = (RPTItemInfo)number2InfoMap.get(dItem.getItemNumber());
            DataElementInfo dataElement = DataElementProvider.getDataElementInfo((String)dItem.getDataElementNumber());
            ValueTypeEnum valueType = ValueTypeEnum.getEnum((int)dItem.getValueType());
            int year = dItem.getYearOffSet();
            int period = dItem.getPeriodOffSet();
            this.bindInfoToTable(rptItemInfo, dataElement, valueType, year, period);
        }
    }

    private void bindInfoToTable(RPTItemInfo rptInfo, DataElementInfo dataElem, ValueTypeEnum valueType, int year, int period) {
        this.kDTDynaItem.checkParsed();
        IRow row = this.kDTDynaItem.addRow();
        row.getCell(0).setUserObject((Object)rptInfo.getId().toString());
        row.getCell(1).setUserObject((Object)rptInfo);
        row.getCell(2).setUserObject((Object)rptInfo.getName());
        row.getCell(3).setUserObject((Object)dataElem);
        row.getCell(4).setUserObject((Object)valueType);
        row.getCell(5).setUserObject((Object)new Integer(year));
        row.getCell(6).setUserObject((Object)new Integer(period));
        row.getCell(0).setValue((Object)rptInfo.getId().toString());
        row.getCell(1).setValue((Object)rptInfo);
        row.getCell(2).setValue((Object)rptInfo.getName());
        row.getCell(3).setValue((Object)dataElem);
        row.getCell(4).setValue((Object)valueType);
        row.getCell(5).setValue((Object)new Integer(year));
        row.getCell(6).setValue((Object)new Integer(period));
    }

    private ArrayList getBasePointList() {
        return this.basePointList;
    }

    private void initBasePointList() {
        this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
    }

    private void initCurSheet() {
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        if (this.curSheet == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TableIsNull"));
            SysUtil.abort();
        }
    }

    private void initAsstTable() throws BOSException, EASBizException {
        this.tblAsst.getStyleAttributes().setLocked(false);
        this.tblAsst.getActionMap().remove("Paste");
        this.tblAsst.getActionMap().remove("Copy");
        this.tblAsst.getActionMap().remove("Cut");
        this.tblAsst.checkParsed();
        this.tblAsst.getColumn("fillName").getStyleAttributes().setHided(true);
        this.tblAsst.getColumn("fillNumber").getStyleAttributes().setHided(true);
        KDComboBox asstActTypeComboBox = (KDComboBox)this.asstComboCellEditor.getComponent();
        asstActTypeComboBox.removeAllItems();
        KDBizPromptBox asstActTypeF7 = (KDBizPromptBox)this.asstF7CellEditor.getComponent();
        AsstActTypeCollection typeCollection = null;
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultQueryName"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        typeCollection = iAsstActType.getAsstActTypeCollection(viewInfo);
        boolean hasAsstActPermssion = false;
        try {
            hasAsstActPermssion = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), "bd_accaux_asstActType_view");
        }
        catch (EASBizException e1) {
            hasAsstActPermssion = false;
        }
        if (hasAsstActPermssion && typeCollection != null && typeCollection.size() > 0) {
            for (AsstActTypeInfo element : typeCollection) {
                asstActTypeComboBox.addItem((Object)element);
            }
        }
        asstActTypeF7.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstActTypeQuery");
        asstActTypeF7.setFilterInfoProducer((IFilterInfoProducer)new NullFilterInfoProducer());
        asstActTypeF7.setCommitFormat("$number$;$name$");
        asstActTypeF7.setDisplayFormat("$name$");
        asstActTypeF7.setEditFormat("$number$");
        if (this.isModify() && this.parameters.getDynaItemSource() == 1) {
            AsstAccountUtils asstAccount = this.parameters.getAsstAccount();
            if (asstAccount == null) {
                return;
            }
            HashSet<String> attSet = new HashSet<String>();
            for (AsstActTypeUtils asstActType : asstAccount.getAsstActTypeList()) {
                attSet.add(asstActType.getAsstHGAttribute());
            }
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
            viewInfo.getSelector().add(new SelectorItemInfo("defaultQueryName"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attSet, CompareType.INCLUDE));
            if (filterInfo != null) {
                filterInfo.mergeFilter(filter, "AND");
            } else {
                filterInfo = filter;
            }
            viewInfo.setFilter(filterInfo);
            typeCollection = iAsstActType.getAsstActTypeCollection(viewInfo);
            HashMap<String, AsstActTypeInfo> asstmap = new HashMap<String, AsstActTypeInfo>();
            for (int i = 0; i < typeCollection.size(); ++i) {
                asstmap.put(typeCollection.get(i).getAsstHGAttribute(), typeCollection.get(i));
            }
            for (AsstActTypeUtils asstActType : asstAccount.getAsstActTypeList()) {
                IRow row = this.addAsstActTypeRow();
                row.getCell("asstActType").setValue(asstmap.get(asstActType.asstHGAttribute));
                row.getCell("fillNumber").setValue((Object)(!StringUtils.isEmpty((String)asstActType.properityName) ? 1 : 0));
                row.getCell("fillName").setValue((Object)(!StringUtils.isEmpty((String)asstActType.properityAlias) ? 1 : 0));
                if (!DynamicTemplateUtility.isBaseAsstActType(asstActType.asstHGAttribute)) continue;
                row.getCell("promtAssistantSubType").getStyleAttributes().setLocked(false);
                String asstHgAttribute = asstActType.getAsstHGAttribute();
                if (StringUtils.isEmpty((String)asstHgAttribute)) continue;
                if (row.getCell("promtAssistantSubType").getEditor() == null) {
                    row.getCell("promtAssistantSubType").setEditor((ICellEditor)this.getEditorByGroupType(asstHgAttribute, asstActType.getAssistantSubType()));
                }
                row.getCell("promtAssistantSubType").setValue((Object)asstActType.getAssistantSubType());
            }
        }
        this.tblAsst.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                if (0 == colIndex) {
                    MultiDynaTemplateWizardUI.this.tblAsstEditStopped(e);
                }
            }
        });
    }

    private void tblAsstEditStopped(KDTEditEvent e) {
        Object value = e.getValue();
        if (value != null && value.equals(e.getOldValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        if (value != null && value instanceof AsstActTypeInfo) {
            AsstActTypeInfo actTypeInfo = (AsstActTypeInfo)value;
            String asstHgAttribute = actTypeInfo.getAsstHGAttribute();
            if (DynamicTemplateUtility.isBaseAsstActType(asstHgAttribute)) {
                this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").getStyleAttributes().setLocked(false);
                if (!value.equals(e.getOldValue())) {
                    this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").setValue(null);
                }
                this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").setEditor((ICellEditor)this.getEditorByGroupType(asstHgAttribute, null));
            } else {
                this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").setValue(null);
                this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").getStyleAttributes().setLocked(true);
            }
        } else {
            this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").setValue(null);
            this.tblAsst.getRow(rowIndex).getCell("promtAssistantSubType").getStyleAttributes().setLocked(true);
        }
    }

    private KDTDefaultCellEditor getEditorByGroupType(String asstHgAttribute, Object InitData) {
        AsstGroupChooserPromptForOneRow prompt = new AsstGroupChooserPromptForOneRow((IUIObject)this);
        if ("customer".equals(asstHgAttribute)) {
            prompt.setGroupType(1);
        } else if ("provider".equals(asstHgAttribute)) {
            prompt.setGroupType(2);
        } else if ("material".equals(asstHgAttribute)) {
            prompt.setGroupType(3);
        }
        if (InitData != null) {
            prompt.setInitData(InitData);
        }
        KDBizPromptBox promtAssistantSubTypeKdComboBox = new KDBizPromptBox();
        promtAssistantSubTypeKdComboBox.setEditFormat("$number$");
        promtAssistantSubTypeKdComboBox.setDisplayFormat("$number$ - $name$");
        promtAssistantSubTypeKdComboBox.setCommitFormat("$number$");
        promtAssistantSubTypeKdComboBox.setHistoryRecordName("groupPromptBox");
        promtAssistantSubTypeKdComboBox.setSelector((KDPromptSelector)prompt);
        return new KDTDefaultCellEditor((IKDEditor)promtAssistantSubTypeKdComboBox);
    }

    @Override
    protected void checkIsIncluseSum_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdCheckIsIncluseSum.isSelected()) {
            this.kDCSumPosition.setEnabled(true);
            if (this.parameters.getPosition() == 1) {
                this.kDCSumPosition.setSelectedItem((Object)SumPositionEnum.LEFT_UP);
            } else {
                this.kDCSumPosition.setSelectedItem((Object)SumPositionEnum.RIGHT_DOWN);
            }
        } else {
            this.kDCSumPosition.setEnabled(false);
            this.kDCSumPosition.setSelectedItem(null);
        }
    }

    private void bindingDynaItemListFromTable(KDTable table) {
        table.getDataRequestManager().setDataRequestMode(0);
        int count = table.getRowCount();
        this.clearDynaHeadItem();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = new DynaHeadItem();
            r = table.getRow(i);
            this.bindInfoFromRow(dyna, r);
            this.addDynaHeadItem(dyna);
        }
    }

    private void bindInfoFromRow(DynaHeadItem dyna, IRow iRow) {
        dyna.rptItem = (RPTItemInfo)iRow.getCell(1).getUserObject();
        dyna.dataElement = (DataElementInfo)iRow.getCell(3).getUserObject();
        dyna.valueType = (ValueTypeEnum)iRow.getCell(4).getValue();
        dyna.year = (Integer)iRow.getCell(5).getValue();
        dyna.period = (Integer)iRow.getCell(6).getValue();
    }

    @Override
    protected void kbtnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnAddNew_actionPerformed(e);
        this.bindingDynaItemListFromTable(this.kDTDynaItem);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"DynaHeadItemList", (Object)this.getDynaItemList());
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.dynamic.client.AddDynaItemUI", (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.bindingDynaItemListToTable(this.kDTDynaItem);
    }

    private void bindingDynaItemListToTable(KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        table.getDataRequestManager().setDataRequestMode(0);
        int count = this.getDynaItemList().size();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = (DynaHeadItem)this.getDynaItemList().get(i);
            r = table.addRow();
            this.bindInfoToRow(dyna, r);
        }
    }

    private void bindInfoToRow(DynaHeadItem dyna, IRow iRow) {
        iRow.getCell(1).setValue((Object)dyna.rptItem.getNumber());
        iRow.getCell(1).setUserObject((Object)dyna.rptItem);
        iRow.getCell(2).setValue((Object)dyna.rptItem.getName());
        iRow.getCell(3).setValue((Object)dyna.dataElement.getName());
        iRow.getCell(3).setUserObject((Object)dyna.dataElement);
        iRow.getCell(4).setValue((Object)dyna.valueType);
        iRow.getCell(5).setValue((Object)new Integer(dyna.year));
        iRow.getCell(6).setValue((Object)new Integer(dyna.period));
    }

    @Override
    protected void kbtnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnMoveUp_actionPerformed(e);
        this.moveUp(this.kDTDynaItem);
    }

    private void moveUp(KDTable table) throws EASBizException {
        DynamicTemplateUtility.moveUpTableRows(table);
    }

    @Override
    protected void kbtnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnMoveDown_actionPerformed(e);
        this.moveDown(this.kDTDynaItem);
    }

    private void moveDown(KDTable table) throws EASBizException {
        DynamicTemplateUtility.moveDownTableRows(table);
    }

    @Override
    protected void kbtnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnDelete_actionPerformed(e);
        this.removeRows(this.kDTDynaItem);
    }

    private void removeRows(KDTable table) throws EASBizException {
        DynamicTemplateUtility.removeTableRows(table);
    }

    @Override
    protected void kbtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.isCancel = false;
        this.curSheet.getBook().getUndoManager().startGroup();
        this.curSheet.getBook().getUndoManager().enable(false);
        try {
            this.fillSheet(this.curSheet);
        }
        finally {
            this.curSheet.getBook().getUndoManager().enable(true);
            this.curSheet.getBook().getUndoManager().endGroup();
        }
        this.getUIWindow().close();
        this.destroyWindow();
    }

    private void verifyInput() throws DynamicEnumException {
        List asstActTypeList;
        if (this.tblAsst.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"SourceBaseDataNotNull"));
            SysUtil.abort();
        }
        if (this.tblAsst.getRowCount() > 8) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Asst_Count_LargerThan8"));
            SysUtil.abort();
        }
        if ((asstActTypeList = this.getAsstActTypeList()).size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"SourceBaseDataNotNull"));
            SysUtil.abort();
        }
        HashSet<String> checkSet = new HashSet<String>();
        for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
            if (checkSet.contains(asstActTypeInfo.getAsstHGAttribute())) {
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"AsstActType_Repeat"), asstActTypeInfo.getDescription()));
                SysUtil.abort();
                continue;
            }
            checkSet.add(asstActTypeInfo.getAsstHGAttribute());
        }
        checkSet.clear();
        for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
            if (!StringUtils.isEmpty((String)asstActTypeInfo.getName()) || !StringUtils.isEmpty((String)asstActTypeInfo.getNumber())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"AsstActType_ShowType"), asstActTypeInfo.getDescription()));
            SysUtil.abort();
        }
    }

    private void fillSheet(Sheet curSheet) {
        Point basePoint = null;
        int spreadStyle = this.getSpreadStyle();
        this.saveControlData(spreadStyle);
        if (spreadStyle == 2) {
            basePoint = this.countBasePoint(this.getPreSpreadStyle(), this.isModify());
            if (this.isModify()) {
                this.clearCell(basePoint, true);
            }
        } else if (this.getBasePointList().size() > 0) {
            basePoint = this.getBasePoint();
            this.clearCell(basePoint, this.isModify());
        } else {
            basePoint = this.getBasePoint();
        }
        if (this.getDynaItemList().size() > 0) {
            int asstColCount = this.constructAsstAccount(this.curSheet, basePoint);
            this.constructDynaHead(this.curSheet, basePoint, asstColCount);
            this.saveBasePointCell(this.curSheet, basePoint);
            this.constructSumLine(this.curSheet, basePoint, asstColCount);
        }
        ArrayList<Object> assList = new ArrayList<Object>();
        int tblAsstRows = this.tblAsst.getRowCount();
        for (int i = 0; i < tblAsstRows; ++i) {
            assList.add(this.tblAsst.getRow(i).getCell("asstActType").getValue());
        }
        curSheet.getRange(basePoint.x, basePoint.y).setUserObject("asstActType", assList);
        DynamicTemplateUtility.saveParametersToCell(curSheet.getRange(basePoint.x, basePoint.y), assList);
    }

    private int constructAsstAccount(Sheet curSheet, Point basePoint) {
        int actTypeColCount = this.parameters.getAsstAccount().getAsstActTypeList().size();
        int dv = 0;
        for (int i = 0; i < actTypeColCount; ++i) {
            Range cell;
            AsstActTypeUtils acctType = (AsstActTypeUtils)this.parameters.getAsstAccount().getAsstActTypeList().get(i);
            if (!StringUtils.isEmpty((String)acctType.properityName)) {
                cell = curSheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setValue(new Variant((Object)acctType.properityName));
                ++dv;
            }
            if (!StringUtils.isEmpty((String)acctType.properityAlias)) {
                cell = curSheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setValue(new Variant((Object)acctType.properityAlias));
                ++dv;
            }
            if (StringUtils.isEmpty((String)acctType.dynapropertyName)) continue;
            cell = curSheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private void constructSumLine(Sheet table, Point basePoint, int asstCount) {
        Point sumPoint = new Point();
        if (!this.kdCheckIsIncluseSum.isSelected()) {
            return;
        }
        int offset = 0;
        if (this.parameters.getPosition() == 1) {
            offset = 0;
        } else if (this.parameters.getPosition() == 2) {
            offset = this.parameters.getDefaultCounter();
        }
        if (this.parameters.getSpreadStyle() == 0) {
            sumPoint.x = basePoint.x;
            sumPoint.y = basePoint.y + 1 + offset;
        }
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
        for (int i = 0; i < asstCount - 1; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setValue(new Variant((Object)"--"));
        }
    }

    private void saveBasePointCell(Sheet table, Point basePoint) {
        Range range = table.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell(range, this.parameters);
        DynamicTemplateUtility.saveParametersToCell(range, this.viewAttributeMap);
    }

    private void constructDynaHead(Sheet table, Point basePoint, int asstColCount) {
        int Count = this.getDynaItemList().size();
        for (int i = 0; i < Count; ++i) {
            String endCellName;
            String startCellName;
            Range sumCell;
            Range range = table.getRange(basePoint.y, i + basePoint.x + asstColCount);
            DynaHeadItem dynaItem = (DynaHeadItem)this.getDynaItemList().get(i);
            this.constructHeadCell(range, dynaItem);
            if (dynaItem.getValueType() == ValueTypeEnum.TXT || !this.parameters.isIncludeSum()) continue;
            if (this.parameters.getPosition() == 1) {
                sumCell = table.getRange(basePoint.y + 1, i + basePoint.x + asstColCount);
                startCellName = Location.getCellName((int)(basePoint.y + 1 + 1), (int)(i + basePoint.x + asstColCount));
                endCellName = Location.getCellName((int)(basePoint.y + 1 + this.parameters.getDefaultCounter()), (int)(i + basePoint.x + asstColCount));
                sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                continue;
            }
            if (this.parameters.getPosition() != 2) continue;
            sumCell = table.getRange(basePoint.y + 1 + this.parameters.getDefaultCounter(), i + basePoint.x + asstColCount);
            startCellName = Location.getCellName((int)(basePoint.y + 1), (int)(i + basePoint.x + asstColCount));
            endCellName = Location.getCellName((int)(basePoint.y + 1 + this.parameters.getDefaultCounter() - 1), (int)(i + basePoint.x + asstColCount));
            sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
        }
    }

    private void constructHeadCell(Range curCell, DynaHeadItem dynaItem) {
        if (dynaItem == null) {
            return;
        }
        curCell.setIgnoreProtected(true);
        curCell.setValue(new Variant((Object)dynaItem.getDisplayName()));
        curCell.setUserObject("ITEM", (Object)new ItemFormula(dynaItem.toString()));
    }

    private Point countBasePoint(int spreadStyle, boolean isModify) {
        if (isModify) {
            return DynamicTemplateUtility.getLastPoint(this.getBasePointList());
        }
        Point point = DynamicTemplateUtility.getLastPoint(this.getBasePointList());
        Rectangle rec = DynamicTemplateUtility.getRectangle(this.curSheet, point);
        if (spreadStyle == 0) {
            return new Point(point.x, point.y + rec.height + 2);
        }
        return this.initBasePoint(this.curSheet);
    }

    private void saveControlData(int spreadStyle) {
        if (spreadStyle != 2) {
            this.parameters.setSpreadStyle(spreadStyle);
        } else {
            this.parameters.setSpreadStyle(this.getPreSpreadStyle());
        }
        this.bindingDynaItemListFromTable(this.kDTDynaItem);
        this.parameters.setIncludeSum(this.kdCheckIsIncluseSum.isSelected());
        if (this.parameters.isIncludeSum() || this.parameters.isGrade() && this.parameters.getDynaItemSource() == 0) {
            this.parameters.setPosition(Integer.parseInt(((SumPositionEnum)((Object)this.kDCSumPosition.getSelectedItem())).getValue()));
        } else {
            this.parameters.setPosition(-1);
        }
        int defaultCounter = (Integer)this.kDSDefaultCounter.getValue();
        this.parameters.setMaxCounter(defaultCounter > this.parameters.getDefaultCounter() ? defaultCounter : this.parameters.getDefaultCounter());
        this.parameters.setDefaultCounter((Integer)this.kDSDefaultCounter.getValue());
        int dynaItemSource = this.getDynaItemSource();
        this.parameters.setDynaItemSource(dynaItemSource);
        if (dynaItemSource == 1) {
            List asstActTypeList = this.getAsstActTypeList();
            ArrayList<AsstActTypeUtils> asstActTypeUtilList = new ArrayList<AsstActTypeUtils>();
            for (AsstActTypeInfo element : asstActTypeList) {
                DynaProperty dy = (DynaProperty)element.get("fillAttribute");
                String promtAssistantSubTypeValue = (String)element.get("assistantSubType");
                AsstActTypeUtils asstActTypeUtils = dy == null ? new AsstActTypeUtils(element.getNumber(), element.getName(), element.getAsstHGAttribute()) : new AsstActTypeUtils(element.getNumber(), element.getName(), element.getAsstHGAttribute(), dy.getProperty(), dy.getName());
                if (!StringUtils.isEmpty((String)promtAssistantSubTypeValue)) {
                    asstActTypeUtils.setAssistantSubType(promtAssistantSubTypeValue);
                }
                asstActTypeUtilList.add(asstActTypeUtils);
            }
            this.parameters.setAsstAccount(new AsstAccountUtils(asstActTypeUtilList));
        }
    }

    private List getAsstActTypeList() {
        int asstActTypeCount = this.tblAsst.getRowCount();
        if (asstActTypeCount <= 0) {
            return new ArrayList();
        }
        ArrayList<AsstActTypeInfo> result = new ArrayList<AsstActTypeInfo>(asstActTypeCount);
        for (int i = 0; i < asstActTypeCount; ++i) {
            IRow row = this.tblAsst.getRow(i);
            ICell cell = row.getCell("asstActType");
            Object value = cell.getValue();
            if (value == null || !(value instanceof AsstActTypeInfo)) continue;
            AsstActTypeInfo primValue = (AsstActTypeInfo)value;
            AsstActTypeInfo info = new AsstActTypeInfo();
            info.setId(primValue.getId());
            info.setDescription(primValue.getName());
            info.setAsstHGAttribute(primValue.getAsstHGAttribute());
            if (Boolean.TRUE.equals(row.getCell("fillNumber").getValue())) {
                info.setNumber(primValue.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Number"));
            } else {
                info.setNumber("");
            }
            if (Boolean.TRUE.equals(row.getCell("fillName").getValue())) {
                info.setName(primValue.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Name"));
            } else {
                info.setName("");
            }
            DynaProperty dy = (DynaProperty)row.getCell("fillAttribute").getValue();
            if (dy != null) {
                dy = dy.copy();
                dy.setName(primValue.getName() + dy.getName());
            }
            this.viewAttributeMap.put(row.getCell("asstActType").getValue(), row.getCell("fillAttribute").getValue());
            info.put("fillAttribute", (Object)dy);
            Object promtAssistantSubTypeValue = row.getCell("promtAssistantSubType").getValue();
            if (promtAssistantSubTypeValue != null && !"".equals(promtAssistantSubTypeValue)) {
                info.put("assistantSubType", promtAssistantSubTypeValue);
            }
            result.add(info);
        }
        return result;
    }

    private void clearCell(Point basePoint, boolean isModify) {
        if (isModify) {
            int y1 = this.getColCount(this.curSheet, basePoint.y, basePoint.x);
            this.doClearCell(basePoint.y, basePoint.x, basePoint.y + this.parameters.getMaxCounter() + 1, y1);
        } else {
            this.doClearCell(0, 0, this.curSheet.getMaxRowIndex(), this.curSheet.getMaxColIndex());
        }
    }

    private void doClearCell(int row, int col, int row2, int col2) {
        Sheet.ICellsIterator it = this.curSheet.getCellsIterator(row, col, row2, col2, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            cell.setValue(Variant.nullVariant);
            cell.setUserObject("ITEM", null);
            cell.setFormula(null);
        }
    }

    private int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private Point getBasePoint() {
        if (this.basePoint != null) {
            return this.basePoint;
        }
        if (this.isModify()) {
            Point point = new Point(this.curSheet.getActiveCol(), this.curSheet.getActiveRow());
            this.basePoint = DynamicTemplateUtility.getBasePoint(this.curSheet, point, this.basePointList);
            if (this.basePoint == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"46_MulMnsTmpGuide_ChooseItemsUI"));
                SysUtil.abort();
            }
        } else {
            this.basePoint = this.getBasePointList() == null || this.getBasePointList().size() == 0 ? this.initBasePoint(this.curSheet) : (Point)this.getBasePointList().get(0);
        }
        return this.basePoint;
    }

    private Point initBasePoint(Sheet table) {
        Point point = new Point(0, 0);
        point.y = table.getActiveRow();
        point.x = table.getActiveCol();
        return point;
    }

    @Override
    public void actionAddAsst_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblAsst.getRowCount() == 8) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Asst_Count_LargerThan8"));
            SysUtil.abort();
        }
        this.addAsstActTypeRow();
    }

    private IRow addAsstActTypeRow() {
        this.tblAsst.checkParsed();
        IRow row = this.tblAsst.addRow();
        ICell cell = row.getCell("asstActType");
        cell.getStyleAttributes().setLocked(false);
        if (this.cmboxAsstSelectMode.getSelectedIndex() == 0) {
            cell.setEditor((ICellEditor)this.asstComboCellEditor);
        } else if (this.cmboxAsstSelectMode.getSelectedIndex() == 1) {
            cell.setEditor((ICellEditor)this.asstF7CellEditor);
        }
        cell = row.getCell("fillNumber");
        cell.getStyleAttributes().setLocked(false);
        cell.setValue((Object)Boolean.FALSE);
        cell.setEditor((ICellEditor)this.checkBoxCellEditor);
        cell = row.getCell("fillName");
        cell.getStyleAttributes().setLocked(false);
        cell.setValue((Object)Boolean.TRUE);
        cell.setEditor((ICellEditor)this.checkBoxCellEditor);
        cell = row.getCell("fillAttribute");
        cell.getStyleAttributes().setLocked(true);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox()));
        return row;
    }

    @Override
    public void actionAsstSelectModeChange_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblAsst.getRowCount();
        block0: for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblAsst.getRow(i);
            ICell cell = row.getCell("asstActType");
            if (this.cmboxAsstSelectMode.getSelectedIndex() == 0) {
                KDComboBox comBox = (KDComboBox)this.asstComboCellEditor.getComponent();
                Object value = cell.getValue();
                cell.setEditor((ICellEditor)this.asstComboCellEditor);
                if (value == null || !(value instanceof AsstActTypeInfo)) continue;
                AsstActTypeInfo asstActtypeInfo = (AsstActTypeInfo)value;
                int count = comBox.getItemCount();
                for (int j = 0; j < count; ++j) {
                    AsstActTypeInfo asstActtypeInfo2;
                    if (!(comBox.getItemAt(j) instanceof AsstActTypeInfo) || (asstActtypeInfo2 = (AsstActTypeInfo)comBox.getItemAt(j)).getNumber() == null || !asstActtypeInfo2.getNumber().equals(asstActtypeInfo.getNumber())) continue;
                    comBox.setSelectedIndex(j);
                    cell.setValue((Object)asstActtypeInfo2);
                    continue block0;
                }
                continue;
            }
            if (this.cmboxAsstSelectMode.getSelectedIndex() != 1) continue;
            cell.setEditor((ICellEditor)this.asstF7CellEditor);
        }
    }

    @Override
    public void actionUpAsst_actionPerformed(ActionEvent e) throws Exception {
        this.moveUp(this.tblAsst);
    }

    @Override
    public void actionDownAsst_actionPerformed(ActionEvent e) throws Exception {
        this.moveDown(this.tblAsst);
    }

    @Override
    public void actionRemoveAsst_actionPerformed(ActionEvent e) throws Exception {
        this.removeRows(this.tblAsst);
    }

    @Override
    protected void kbtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
        this.destroyWindow();
    }

    public ArrayList getDynaItemList() {
        return this.dynaItemList;
    }

    public void clearDynaHeadItem() {
        this.dynaItemList.clear();
    }

    public void addDynaHeadItem(DynaHeadItem item) {
        this.dynaItemList.add(item);
    }

    public int getSpreadStyle() {
        if (this.kdrVertical.isSelected()) {
            return 0;
        }
        if (this.kdrAppend.isSelected()) {
            return 2;
        }
        return -1;
    }

    public int getDynaItemSource() {
        return 1;
    }

    public int getPreSpreadStyle() {
        return this.preSpreadStyle;
    }

    public void setPreSpreadStyle(int preSpreadStyle) {
        this.preSpreadStyle = preSpreadStyle;
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    @Override
    protected void tblAsst_editStopped(KDTEditEvent e) throws Exception {
        super.tblAsst_editStopped(e);
    }

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    private class NullFilterInfoProducer
    implements IFilterInfoProducer {
        private NullFilterInfoProducer() {
        }

        public FilterInfo getFilterInfo() {
            return DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        }

        public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        }

        public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
        }
    }
}

