/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiInterItemDataConditionUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import org.apache.log4j.Logger;

public class MultiInterItemDataConditionUI
extends AbstractMultiInterItemDataConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiInterItemDataConditionUI.class);
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        }
    }

    private void fillDataToUI() {
        String toCurrencyId;
        CurrencyInfo currencyInfo;
        int j;
        String fromCurrencyId;
        this.clearUI();
        this.comboCurrency.removeAllItems();
        this.comboTargetCurrency.removeAllItems();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboCurrency.addItem((Object)this.selectAll);
        this.comboCurrency.setSelectedIndex(0);
        this.comboTargetCurrency.addItem((Object)this.selectAll);
        this.comboTargetCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.pp.setObject("allCurrency", (Object)currencyCollection);
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.comboCurrency.addItems(currencyCollection.toArray());
            this.comboTargetCurrency.addItems(currencyCollection.toArray());
        }
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.comboCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("toCurrency") && (toCurrencyId = this.pp.getString("toCurrency")) != null) {
            for (j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                currencyInfo = (CurrencyInfo)this.comboTargetCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(toCurrencyId)) continue;
                this.comboTargetCurrency.setSelectedIndex(j);
                break;
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (this.pp.containsKey("company") && this.pp.getObject("company") != null) {
            String companyId = (String)this.pp.getObject("company");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizPrmtCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public RptProperties getCustomCondition() {
        try {
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        if (this.bizPrmtCompany.getValue() != null && this.bizPrmtCompany.getValue() instanceof String) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"70_MultiInterItemDataConditionUI"));
            SysUtil.abort();
        }
        this.pp.setString("company", this.bizPrmtCompany.getValue() == null ? null : ((OrgUnitInfo)this.bizPrmtCompany.getValue()).getId().toString());
        this.pp.setString("fromCurrency", this.comboCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        this.pp.setString("toCurrency", this.comboTargetCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.comboTargetCurrency.getSelectedItem()).getId().toString());
        return this.pp;
    }

    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    public Object getParam() {
        return this.getCustomCondition();
    }

    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    private void clearUI() {
        this.bizPrmtCompany.setValue(null);
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboTargetCurrency.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }
}

