/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyRelationshipsFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiMnsRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MultiMnsRptProcessUI
extends AbstractMultiMnsRptProcessUI {
    private static final Logger logger = Logger.getLogger(MultiMnsRptProcessUI.class);
    protected CslReportInfo curReport;
    private OrgTreeInfo orgTree;
    private OrgUnitInfo parentCompany;
    private Map basePointListMap = null;
    private Map asstActTypeUtilsCache;
    protected Book curSheets = this.getBook();
    private Map sheet2AsstRowMap = new OneToManyMap();
    protected KDTable tblAsst;
    private boolean isFirst = true;
    private int fillNumber = 1;
    private List arrAddRow = new ArrayList();
    private Map signMap = new HashMap();
    private boolean isDebitOrCredit = true;
    private boolean isMergeCell = false;
    private static final Pattern patternType = Pattern.compile(";");
    private static final Pattern patternItem = Pattern.compile("\\|");
    private static final Pattern pattern2Name = Pattern.compile("@!@");
    private Map dynaKeyCache;
    private int asstColCount = 0;
    private List mapedItemList = null;
    private List itemList = null;
    private int maxCol = 0;
    private int rowCon = 0;
    private List arrOld = new ArrayList();

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.calculateSheet(e);
    }

    public void actionCalculateSelectedSheet_actionPerformed(ActionEvent e) throws Exception {
        this.calculateSheet(e);
    }

    private void calculateSheet(ActionEvent e) throws EASBizException, BOSException, Exception {
        this.isFirst = true;
        this.curReport = this.getCslReportProvider().getCSLlReportInfo();
        this.orgTree = this.curReport.getOrgTree();
        this.parentCompany = this.curReport.getOrgUnit();
        List companylist = this.initCompanyList(this.orgTree, this.parentCompany);
        this.curSheets = this.getBook();
        Map asstActTypeMaps = this.queryAsstActType(this.curSheets);
        if (this.isSingleCalculate()) {
            Sheet sheet = this.curSheets.getActiveSheet();
            this.addAsstTable(sheet, asstActTypeMaps);
        } else {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                this.addAsstTable(sheet, asstActTypeMaps);
            }
        }
        Map asstActTypeMap = this.collectAsstActTypeMap(asstActTypeMaps);
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, Map> tableValues = new HashMap<String, Map>();
        for (int i = 0; i < 1; ++i) {
            Sheet table = this.curSheets.getSheet(i);
            String sheetID = table.getID();
            if (!table.isEnableCalculation()) continue;
            Map tableMap = this.scanDynaTable(table, null, true, true, true);
            if (table != null) {
                tables.put(table.getID(), table);
                tableValues.put(table.getID(), tableMap);
            }
            MultiDynaSumTypeEnum sumTypeEnum = MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT;
            Map map = CSLReportCalculatorFactory.getRemoteInstance().calculateMnsMultiRpt(this.curReport.getId().toString(), companylist, asstActTypeMap, tableValues, sumTypeEnum, true);
            Map sumResult = (Map)map.get("individMap");
            Map debitMap = (Map)map.get("debitMap");
            Map creditMap = (Map)map.get("creditMap");
            Map sheetMap = (Map)sumResult.get(sheetID);
            Map sheetMap1 = (Map)debitMap.get(sheetID);
            Map sheetMap2 = (Map)creditMap.get(sheetID);
            Object[] basePointArray = this.sortByPosistion(table, sheetMap.keySet());
            DynaParameters param = null;
            Point basePoint = null;
            Map sMap = new HashMap();
            Map sMap1 = new HashMap();
            Map sMap2 = new HashMap();
            int selectedSize = 0;
            for (int n = basePointArray.length - 1; n >= 0; --n) {
                basePoint = (Point)basePointArray[n];
                param = DynamicTemplateUtility.getDynaParameters(table, basePoint);
                if (param == null) continue;
                selectedSize = companylist.size();
                sMap = (Map)sheetMap.get(basePoint);
                sMap1 = (Map)sheetMap1.get(basePoint);
                sMap2 = (Map)sheetMap2.get(basePoint);
            }
            ArrayList twoList = new ArrayList();
            for (int cc = 0; cc < companylist.size(); ++cc) {
                Iterator it = sMap.keySet().iterator();
                while (it.hasNext()) {
                    if (!it.next().toString().equals(companylist.get(cc).toString())) continue;
                    twoList.add(companylist.get(cc));
                }
            }
            StringBuffer lossInfo = new StringBuffer();
            ICompanyOrgUnit iOrg = CompanyOrgUnitFactory.getRemoteInstance();
            StringBuffer sid = new StringBuffer();
            for (int si = 0; si < twoList.size(); ++si) {
                if (si < twoList.size() - 1) {
                    sid.append("'").append(twoList.get(si)).append("',");
                    continue;
                }
                sid.append("'").append(twoList.get(si)).append("'");
            }
            String oql = " where id in (" + sid.toString() + ")";
            CompanyOrgUnitCollection coms = iOrg.getCompanyOrgUnitCollection(oql);
            for (int co = 0; co < coms.size(); ++co) {
                lossInfo.append(coms.get(co).getName()).append("\n");
            }
            this.isMergeCell = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"78_MultiMnsRptProcessUI"), (String)lossInfo.toString()) == 0;
            int yVarible = this.fillMultiSumData(param, basePoint, table, sMap, selectedSize, companylist, basePoint);
            this.isFirst = false;
            Point baseP = basePoint;
            if (basePoint != null) {
                baseP = new Point(basePoint.x, basePoint.y + yVarible);
            }
            this.isDebitOrCredit = true;
            if (param != null) {
                param.setDefaultCounter(yVarible);
            }
            int y1Varible = this.fillMultiSumData(param, basePoint, table, sMap1, selectedSize, companylist, baseP);
            Point baseP1 = baseP;
            if (baseP != null) {
                baseP1 = new Point(baseP.x, baseP.y + y1Varible);
            }
            this.isDebitOrCredit = false;
            if (param != null) {
                param.setDefaultCounter(y1Varible);
            }
            this.fillMultiSumData(param, basePoint, table, sMap2, selectedSize, companylist, baseP1);
        }
        super.actionCalculateSelectedSheet_actionPerformed(e);
        this.sheet2AsstRowMap.clear();
        this.fillNumber = 1;
        this.arrAddRow.clear();
        this.signMap.clear();
    }

    private List initCompanyList(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        ArrayList<BOSUuid> companyIdlist = new ArrayList<BOSUuid>();
        if (orgTreeInfo == null || parentCompanyInfo == null) {
            return companyIdlist;
        }
        OrgUnitCollection units = this.getOrgUnits(orgTreeInfo, parentCompanyInfo);
        if (units != null && units.size() > 0) {
            for (OrgUnitInfo info : units) {
                if (info == null) continue;
                companyIdlist.add(info.getId());
            }
        }
        return companyIdlist;
    }

    private OrgUnitCollection getOrgUnits(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        IOrgUnitCommon orgUtil = null;
        try {
            orgUtil = OrgUnitCommonFactory.getRemoteInstance();
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        OrgUnitCollection units = null;
        boolean isByLevel = true;
        CSLContextHelper.getSysParamanager().refreshParams();
        int i = CSLContextHelper.getSysParamanager().getMergeType();
        if (i == -1) {
            throw new SumRptException(SumRptException.PLEASE_SET_SYSPARAMS);
        }
        isByLevel = i != 0;
        try {
            units = isByLevel ? orgUtil.getUnionDebtChildren(parentCompanyInfo, orgTreeInfo) : orgUtil.getUnionDebtAllOrgUnit(parentCompanyInfo, orgTreeInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"79_MultiMnsRptProcessUI"), (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"79_MultiMnsRptProcessUI"), (Throwable)e);
        }
        int elimMethod = Integer.parseInt(CSLSysParamanager.getSysParamValue((OrgTreeInfo)this.orgTree, (String)"GR_CSL_ELIMMETHOD_001"));
        if (elimMethod == 2) {
            units = RelatedPartyRelationshipsFactory.getRemoteInstance().getHKRelationOrgUnits(units);
        }
        return units;
    }

    private Map collectAsstActTypeMap(Map assMap) {
        Map result = assMap;
        HashMap<String, AsstActTypeCollection> asstActTypeResultMap = new HashMap<String, AsstActTypeCollection>();
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            boolean isFindBasePosition = false;
            int rowCount = this.curSheets.getSheet(i).getRows().getMaxIntMark() + 1;
            int columnCount = this.curSheets.getSheet(i).getCols().getMaxIntMark() + 1;
            ArrayList<String> xylist = new ArrayList<String>();
            for (int ii = 0; ii < rowCount; ++ii) {
                for (int j = 0; j < columnCount; ++j) {
                    if (!DynamicTemplateUtility.isBasePointCell(this.curSheets.getSheet(i), ii, j)) continue;
                    isFindBasePosition = true;
                    xylist.add(Integer.toString(j));
                    xylist.add(Integer.toString(ii));
                    break;
                }
                if (isFindBasePosition) break;
            }
            String key = null;
            if (xylist.size() != 0 && this.curSheets.getSheet(i).getID() != null) {
                key = this.curSheets.getSheet(i).getID().toString() + "|" + xylist.get(0).toString() + "|" + xylist.get(1).toString();
            }
            ArrayList<String> list = new ArrayList<String>();
            Iterator iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next().toString();
                list.add(s.substring(s.indexOf("=") + 1));
            }
            iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                AsstActTypeCollection asstActTypeCollection = new AsstActTypeCollection();
                for (int a = 0; a < list.size(); ++a) {
                    AsstActTypeInfo info = null;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    filter.getFilterItems().add(new FilterItemInfo("name", list.get(a), CompareType.INCLUDE));
                    AsstActTypeCollection asstActTypeCollections = null;
                    try {
                        asstActTypeCollections = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
                    }
                    catch (BOSException e) {
                        this.handleException((Exception)((Object)e));
                    }
                    if (asstActTypeCollections != null) {
                        info = asstActTypeCollections.get(0);
                    }
                    asstActTypeCollection.add(info);
                }
                if (key == null) continue;
                asstActTypeResultMap.put(key, asstActTypeCollection);
            }
        }
        return asstActTypeResultMap;
    }

    private Map getSelectedAsstActTypeList() {
        if (this.isSingleCalculate()) {
            return this.getSelectedAsstActTypeList(this.curSheets.getActiveSheet().getSheetName());
        }
        HashMap result = new HashMap();
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            result.putAll(this.getSelectedAsstActTypeList(this.curSheets.getSheet(i).getSheetName()));
        }
        return result;
    }

    private boolean isSingleCalculate() {
        Map ownerContext = ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext();
        Boolean isCalcSinglePage = (Boolean)ownerContext.get("KEY_CALCULATESINGLEPAGE");
        return isCalcSinglePage == null ? false : isCalcSinglePage;
    }

    private Map getSelectedAsstActTypeList(String sheetName) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return new HashMap();
        }
        StringBuffer key = new StringBuffer();
        OneToManyMap result = new OneToManyMap();
        for (IRow row : rowList) {
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            key.setLength(0);
            Sheet sheet = this.curSheets.getSheet(sheetName);
            AsstActTypeInfo info = (AsstActTypeInfo)row.getUserObject();
            CellReference cellReference = new CellReference((String)row.getCell("basepoint").getValue());
            key.append(sheet.getID()).append("|").append(cellReference.getCol()).append("|").append(cellReference.getRow());
            result.put(key.toString(), info);
        }
        return result;
    }

    private Map scanDynaTable(Sheet table, DynaSumMethodEnum method, boolean isOnlyList, boolean isShowTotal, boolean isOnlyListCompany) {
        HashMap result = new HashMap();
        ArrayList pointList = DynamicTemplateUtility.getBasePointList(table);
        int n = pointList.size();
        for (int i = 0; i < n; ++i) {
            ItemFormula f;
            int j;
            int m;
            Point basePoint = (Point)pointList.get(i);
            HashMap<Point, ItemFormula> formulasMap = new HashMap<Point, ItemFormula>();
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(table, basePoint);
            param.setOnlyList(isOnlyList);
            if (param.isGrade()) {
                param.setShowTotal(false);
                param.setOnlyListCompany(false);
            } else {
                param.setShowTotal(isShowTotal);
                param.setOnlyListCompany(isOnlyListCompany);
            }
            if (param.getSpreadStyle() == 1) {
                m = table.getRows().getMaxIntMark();
                for (j = basePoint.y + 1; j <= m; ++j) {
                    f = MultiMnsRptProcessUI.getFormula(table.getRange(j, basePoint.x));
                    if (f == null) continue;
                    formulasMap.put(new Point(basePoint.x, j), f);
                }
            } else {
                m = table.getCols().getMaxIntMark();
                for (j = basePoint.x + 1; j <= m; ++j) {
                    f = MultiMnsRptProcessUI.getFormula(table.getRange(basePoint.y, j));
                    if (f == null) continue;
                    formulasMap.put(new Point(j, basePoint.y), f);
                }
            }
            HashMap<String, Object> areaMap = new HashMap<String, Object>();
            areaMap.put("param", param.toString());
            areaMap.put("formulas", formulasMap);
            result.put(basePoint, areaMap);
        }
        return result;
    }

    public static ItemFormula getFormula(Range range) {
        ItemFormula f = (ItemFormula)range.getUserObject("ITEM");
        if (f == null || !f.isValidity()) {
            return null;
        }
        return f;
    }

    private void addAsstTable(Sheet sheet, Map asstActTypeMap) {
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeMap.get(asstActTypeUtil.asstHGAttribute);
                if (asstActTypeInfo == null) continue;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("sheetname", sheet.getSheetName());
                CellReference ref = new CellReference(point.y, point.x);
                rowMap.put("basepoint", ref.toString());
                rowMap.put("asstacttype", asstActTypeInfo.getName());
                rowMap.put("asstactTypeID", asstActTypeInfo.getId());
                rowMap.put("select", Boolean.TRUE);
                this.sheet2AsstRowMap.put(sheet.getSheetName(), rowMap);
            }
        }
    }

    private List getBasePointList(String sheetName) {
        if (this.basePointListMap == null) {
            this.basePointListMap = new HashMap();
            if (this.isSingleCalculate()) {
                Sheet sheet = this.curSheets.getActiveSheet();
                ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                this.basePointListMap.put(sheet.getSheetName(), list);
            } else {
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    Sheet sheet = this.curSheets.getSheet(i);
                    ArrayList list = DynamicTemplateUtility.getBasePointList(sheet);
                    this.basePointListMap.put(sheet.getSheetName(), list);
                }
            }
        }
        return (List)this.basePointListMap.get(sheetName);
    }

    private Map queryAsstActType(Book book) throws BOSException {
        Set attributeSet = new HashSet();
        if (this.isSingleCalculate()) {
            Sheet sheet = book.getActiveSheet();
            attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
        } else {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                attributeSet = this.collectAsstActTypeAttribute(attributeSet, sheet);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attributeSet, CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            asstActTypeMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo);
        }
        return asstActTypeMap;
    }

    private Set collectAsstActTypeAttribute(Set attributeSet, Sheet sheet) {
        List list = this.getBasePointList(sheet.getSheetName());
        for (int j = 0; list != null && j < list.size(); ++j) {
            Point point = (Point)list.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, point);
            AsstAccountUtils asstAccount = param.getAsstAccount();
            if (asstAccount == null || asstAccount.getAsstActTypeList() == null) continue;
            for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                attributeSet.add(asstActTypeUtil.asstHGAttribute);
            }
        }
        return attributeSet;
    }

    protected int fillMultiSumData(DynaParameters param, Point basePoint, Sheet sheet, Map valueMap, int selectedSize, List companylist, Point nextBasePoint) throws EASBizException, BOSException {
        int baseVarible = 0;
        List selectedAsstActTypeList = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return baseVarible;
        }
        this.maxCol = this.getMaxColIndex(sheet, basePoint);
        this.mapedItemList = this.getItemFormulaList(sheet, basePoint, this.maxCol);
        this.asstColCount = this.fillHeadAsstItem(sheet, param, basePoint, selectedAsstActTypeList, this.maxCol);
        this.fillHeadItemFormula(sheet, basePoint, this.mapedItemList, this.asstColCount, this.maxCol, valueMap);
        this.itemList = this.getFormulaItemListFromMap(this.mapedItemList);
        if (valueMap == null || valueMap.size() < 1) {
            valueMap.remove("KEY_ALL_MULTIDYNAKEY");
            int realRowCount = 0;
            for (Map orgMap : valueMap.values()) {
                realRowCount += orgMap.size();
            }
            this.adjustRowCount(param, sheet, nextBasePoint, this.asstColCount, realRowCount, param.getDefaultCounter());
            this.fillSumLine(param, sheet, nextBasePoint, this.itemList, nextBasePoint.y + 1, this.asstColCount, this.maxCol, this.rowCon);
            this.saveBasePointCell(sheet, nextBasePoint, param);
        } else {
            int rowCount;
            this.rowCon = rowCount = this.fillData(param, sheet, nextBasePoint, this.itemList, valueMap, this.asstColCount, this.maxCol, companylist);
            baseVarible = rowCount + 1;
            this.fillSumLine(param, sheet, nextBasePoint, this.itemList, nextBasePoint.y + 1 + rowCount, this.asstColCount, this.maxCol, this.rowCon);
            if (this.fillNumber == 4) {
                Point tPoint = new Point(nextBasePoint.x, nextBasePoint.y + 1);
                this.fillLastSumLine(param, sheet, tPoint, this.itemList, tPoint.y + 1 + rowCount, this.asstColCount, this.maxCol);
            }
            param.setDefaultCounter(rowCount);
            this.saveBasePointCell(sheet, basePoint, param);
            int startRow = param.getPosition() == 1 ? nextBasePoint.y + 2 : nextBasePoint.y + 1;
            int endRow = startRow + rowCount;
            if (this.isMergeCell) {
                this.mergeCell(sheet, basePoint.x, basePoint.x + this.asstColCount - 1, startRow, endRow);
            }
        }
        return baseVarible;
    }

    private List getSelectedAsstActTypeList(String sheetName, Point basePoint) {
        List rowList = (List)this.sheet2AsstRowMap.get(sheetName);
        if (rowList == null || rowList.size() == 0) {
            return new ArrayList();
        }
        StringBuffer key = new StringBuffer();
        ArrayList<AsstActTypeInfo> result = new ArrayList<AsstActTypeInfo>();
        for (Map row : rowList) {
            CellReference cellReference;
            if (!Boolean.TRUE.equals(row.get("select"))) continue;
            key.setLength(0);
            AsstActTypeInfo info = null;
            try {
                if (row.get("asstactTypeID") != null) {
                    info = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK((BOSUuid)row.get("asstactTypeID")));
                }
            }
            catch (EASBizException e) {
                super.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
            if (basePoint.x != (cellReference = new CellReference((String)row.get("basepoint"))).getCol() || basePoint.y != cellReference.getRow()) continue;
            result.add(info);
        }
        return result;
    }

    private int getMaxColIndex(Sheet curSheet, Point basePoint) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > basePoint.x; --i) {
            Cell cell = curSheet.getCell(basePoint.y, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private List getItemFormulaList(Sheet sheet, Point basePoint, int maxCol) {
        ArrayList list = new ArrayList();
        for (int j = basePoint.x + 1; j <= maxCol; ++j) {
            Range range = sheet.getRange(basePoint.y, j);
            ItemFormula f = SumHelper.getFormula((Range)range);
            if (f == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formulas", f);
            map.put("KEY_DITEM_NAME", range.getValue());
            map.put("funtion_formula", range.getFormula());
            list.add(map);
        }
        return list;
    }

    private int fillHeadAsstItem(Sheet sheet, DynaParameters parameters, Point basePoint, List selectedAsstActTypeList, int maxCol) {
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return 0;
        }
        int dv = 0;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            Range cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Company")));
            ++dv;
        }
        for (AsstActTypeInfo asstActTypeInfo : selectedAsstActTypeList) {
            Range cell;
            AsstActTypeUtils acctType = this.getAsstActTypeUtils(parameters, asstActTypeInfo);
            if (acctType == null) continue;
            if (!StringUtils.isEmpty((String)acctType.properityName)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityName));
                ++dv;
            }
            if (!StringUtils.isEmpty((String)acctType.properityAlias)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityAlias));
                ++dv;
            }
            if (StringUtils.isEmpty((String)acctType.dynaProperty)) continue;
            cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setFormula(null);
            if (dv != 0) {
                cell.setUserObject("ITEM", null);
            }
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private void fillHeadItemFormula(Sheet sheet, Point basePoint, List itemFormulaList, int asstColCount, int maxCol, Map result) {
        int col = basePoint.x + asstColCount;
        for (Map map : itemFormulaList) {
            ItemFormula itemFormula = (ItemFormula)map.get("formulas");
            Variant value = (Variant)map.get("KEY_DITEM_NAME");
            String formula = (String)map.get("funtion_formula");
            Range range = sheet.getRange(basePoint.y, col++);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setValue(value);
            range.setUserObject("dc", result.get("dc"));
            range.setFormula(formula);
        }
        this.clearExtraRange(sheet, basePoint.y, maxCol, col - 1);
    }

    private List getFormulaItemListFromMap(List mapedItemList) {
        ArrayList itemList = new ArrayList(mapedItemList.size());
        for (Map map : mapedItemList) {
            itemList.add(map.get("formulas"));
        }
        return itemList;
    }

    private void adjustRowCount(DynaParameters param, Sheet sheet, Point basePoint, int asstColCount, int oldRowCount, int realRowCount) {
        if (realRowCount > oldRowCount) {
            this.addSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        } else if (realRowCount < oldRowCount) {
            this.removeSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        }
        if (realRowCount == 0) {
            return;
        }
        int startRow = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
        Range range = sheet.getRange(startRow, basePoint.x, startRow + realRowCount - 1, basePoint.x + asstColCount - 1);
        range.merge();
        MergeBlocks merger = sheet.getMerger(false);
        merger.remove((SortedCellBlockArray)range);
    }

    private void fillSumLine(DynaParameters param, Sheet sheet, Point basePoint, List itemList, int row, int asstColCount, int oldMaxCol, int rowCount) {
        int i;
        if (!param.isIncludeSum()) {
            return;
        }
        int sumCellRow = param.getPosition() == 2 ? row : basePoint.y + 1;
        this.fillSumTitle(param, sheet, basePoint, sumCellRow, asstColCount);
        int Count = itemList.size();
        int col = basePoint.x + asstColCount;
        if (row == basePoint.y + 1) {
            i = 0;
            while (i < Count) {
                ItemFormula itemFormula = (ItemFormula)itemList.get(i);
                if (itemFormula.getValueType() != 3) {
                    Range sumCell = sheet.getRange(sumCellRow, col);
                    String startCellName = Location.getCellName((int)(basePoint.y + 1), (int)col);
                    String endCellName = Location.getCellName((int)(row - 1), (int)col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("0.00");
                }
                ++i;
                ++col;
            }
        } else {
            i = 0;
            while (i < Count) {
                ItemFormula itemFormula = (ItemFormula)itemList.get(i);
                if (itemFormula.getValueType() != 3) {
                    String endCellName;
                    String startCellName;
                    Range sumCell;
                    if (param.getPosition() == 1) {
                        sumCell = sheet.getRange(sumCellRow, col);
                        startCellName = Location.getCellName((int)(basePoint.y + 1 + 1), (int)col);
                        endCellName = Location.getCellName((int)row, (int)col);
                        sumCell.setUserObject("ITEM", null);
                        sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                    } else if (param.getPosition() == 2) {
                        sumCell = sheet.getRange(sumCellRow, col);
                        startCellName = Location.getCellName((int)(basePoint.y + 1), (int)col);
                        endCellName = Location.getCellName((int)(row - 1), (int)col);
                        sumCell.setUserObject("ITEM", null);
                        sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                    }
                }
                ++i;
                ++col;
            }
        }
        this.arrAddRow.add(Integer.toString(rowCount + 1));
        Row sumRow = sheet.getRow(sumCellRow, false);
        if (sumRow != null) {
            sumRow.setUserObject("COMPANY_NUMBER", null);
        }
        this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
    }

    private void saveBasePointCell(Sheet sheet, Point basePoint, DynaParameters param) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell(range, param);
    }

    private int fillData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, Map valueMap, int asstColCount, int oldMaxCol, List companylist) throws EASBizException, BOSException {
        List selectedAsstActType = null;
        if (this.isFirst) {
            selectedAsstActType = this.getSelectedAsstActTypeList(sheet.getSheetName(), basePoint);
            for (int j = 0; j < selectedAsstActType.size(); ++j) {
                this.arrOld.add(selectedAsstActType.get(j));
            }
        } else {
            selectedAsstActType = this.arrOld;
        }
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int startRowIndex = basePoint.y + sumLine + 1;
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            List companyList = this.initCompanyList(companylist);
            Set dynaKeySet = (Set)valueMap.get("KEY_ALL_MULTIDYNAKEY");
            List dynaItemList = null;
            dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActType, dynaKeySet.iterator());
            valueMap.remove("KEY_ALL_MULTIDYNAKEY");
            int realRowCount = 0;
            for (Map orgMap : valueMap.values()) {
                realRowCount += orgMap.size();
            }
            this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
            for (OrgUnitInfo orgUnit : companyList) {
                Map orgValueMap = (Map)valueMap.get(orgUnit.getId().toString());
                if (orgValueMap == null) continue;
                int filledCount = this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, orgUnit, orgValueMap, startRowIndex, asstColCount, oldMaxCol);
                startRowIndex += filledCount;
            }
            this.fillCompanyIDsToSheet(sheet, companylist);
            return realRowCount;
        }
        List dynaItemList = this.analyzeDynaKey(sheet, basePoint, selectedAsstActType, valueMap.keySet().iterator());
        int realRowCount = dynaItemList.size();
        this.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
        this.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, null, valueMap, startRowIndex, asstColCount, oldMaxCol);
        this.fillCompanyIDsToSheet(sheet, companylist);
        return realRowCount;
    }

    private void mergeCell(Sheet sheet, int startCol, int endCol, int startRow, int endRow) {
        for (int col = startCol; col <= endCol; ++col) {
            int beginRow = startRow;
            Variant value = null;
            for (int row = startRow; row <= endRow; ++row) {
                Cell cell = sheet.getCell(row, col, false);
                Variant cellValue = null;
                if (cell != null) {
                    cellValue = cell.getValue();
                }
                if (cellValue == null && row != endRow) continue;
                if (value == null) {
                    value = cellValue;
                    continue;
                }
                if (row != endRow && value.equals(cellValue)) continue;
                if (row - beginRow > 1) {
                    if (col != startCol) {
                        Range preRange = sheet.getRange(beginRow, col - 1, row - 1, col - 1);
                        Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(preRange.getBlock(0), false, true);
                        if (!cellsIterator.hasNext() && row - beginRow > 1) {
                            Range range = sheet.getRange(beginRow, col, row - 1, col);
                            range.setIgnoreProtected(true);
                            range.merge();
                        } else {
                            while (cellsIterator.hasNext()) {
                                int row1;
                                Cell cell2 = cellsIterator.next();
                                CellBlock block = sheet.getMergeBlock(cell2);
                                int n = block == null ? cell2.getRow() : (row1 = beginRow > block.getRow() ? beginRow : block.getRow());
                                int row2 = block == null ? cell2.getRow() : (row - 1 < block.getRow2() ? row - 1 : block.getRow2());
                                Range range = sheet.getRange(row1, col, row2, col);
                                range.setIgnoreProtected(true);
                                range.merge();
                            }
                        }
                    } else {
                        Range range = sheet.getRange(beginRow, col, row - 1, col);
                        range.setIgnoreProtected(true);
                        range.merge();
                    }
                }
                beginRow = row;
                value = cellValue;
            }
        }
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private MultiDynaSumTypeEnum getSumType() {
        MultiDynaSumTypeEnum sumType = MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT;
        return sumType;
    }

    private AsstActTypeUtils getAsstActTypeUtils(DynaParameters param, AsstActTypeInfo asstActTypeInfo) {
        Map<String, AsstActTypeUtils> map;
        String paramKey = param.toString();
        if (this.asstActTypeUtilsCache == null) {
            this.asstActTypeUtilsCache = new HashMap();
            map = new HashMap();
            this.asstActTypeUtilsCache.put(paramKey, map);
            for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
                map.put(asstutil.asstHGAttribute, asstutil);
            }
        } else {
            map = (HashMap)this.asstActTypeUtilsCache.get(paramKey);
            if (map == null) {
                map = new HashMap();
                this.asstActTypeUtilsCache.put(paramKey, map);
                for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
                    map.put(asstutil.asstHGAttribute, asstutil);
                }
            }
        }
        map = (Map)this.asstActTypeUtilsCache.get(paramKey);
        return (AsstActTypeUtils)map.get(asstActTypeInfo.getAsstHGAttribute());
    }

    private void clearExtraRange(Sheet sheet, int row, int oldMaxCol, int curMaxCol) {
        if (curMaxCol < oldMaxCol) {
            for (int i = curMaxCol + 1; i <= oldMaxCol; ++i) {
                Range range = sheet.getRange(row, i);
                this.clearRange(range);
            }
        }
    }

    private void addSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + oldMaxRowCount + 1 + sumLine;
        int y2 = y + rowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.NOSTYLE);
    }

    private void removeSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + rowCount + 1 + sumLine;
        int y2 = y + oldMaxRowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.delete();
    }

    private void fillSumTitle(DynaParameters param, Sheet table, Point basePoint, int row, int asstCount) {
        if (!param.isIncludeSum()) {
            return;
        }
        Point sumPoint = new Point();
        sumPoint.x = basePoint.x;
        sumPoint.y = row;
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        if (this.fillNumber == 1) {
            range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"47_MulMnsTmpGuide_ShowResultUI")));
        }
        if (this.fillNumber == 2) {
            range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"48_MulMnsTmpGuide_ShowResultUI")));
        }
        if (this.fillNumber == 3) {
            range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"49_MulMnsTmpGuide_ShowResultUI")));
        }
        if (this.fillNumber == 4) {
            range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"50_MulMnsTmpGuide_ShowResultUI")));
        }
        for (int i = 0; i < asstCount; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
            range.setFormula(null);
            range.setValue(new Variant((Object)"--"));
        }
        ++this.fillNumber;
        Range ranSty = table.getRange(sumPoint.y, 0, sumPoint.y, table.getMaxColIndex());
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(new Color(255, 255, 160));
        ranSty.setStyle(sa, sa);
    }

    private List initCompanyList(List companylist) throws EASBizException, BOSException {
        List result = new ArrayList(companylist);
        String orgTreeID = CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString();
        ArrayList<String> companyIDList = new ArrayList<String>();
        for (int i = 0; i < companylist.size(); ++i) {
            OrgUnitInfo info = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK((BOSUuid)companylist.get(i)));
            companyIDList.add(info.getId().toString());
        }
        result = MultiInterCheckageFacadeFactory.getRemoteInstance().getOrgBoundLeafCompanys(companyIDList, orgTreeID);
        ObjectValueComparator comparator = new ObjectValueComparator();
        comparator.setFieldName("longnumber");
        Collections.sort(result, comparator);
        return result;
    }

    private List analyzeDynaKey(Sheet sheet, Point basePoint, List asstActTypeList, Iterator iterator) {
        ArrayList<DynaKeyItem> result = new ArrayList<DynaKeyItem>();
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                result.add(item);
            }
            MultiKeyComparator multiKeyComparator = new MultiKeyComparator();
            multiKeyComparator.setAsstActTypeList(asstActTypeList);
            Collections.sort(result, multiKeyComparator);
        } else {
            HashMap<String, DynaKeyItem> dynaKeyMap = new HashMap<String, DynaKeyItem>();
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                dynaKeyMap.put(item.getDynaKey(), item);
            }
            List formerDynaKeyList = this.getDynaKeyList(sheet.getSheetName(), basePoint);
            if (formerDynaKeyList != null) {
                MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
                for (String formerDyKey : formerDynaKeyList) {
                    Object item = dynaKeyMap.get(formerDyKey = multiDynaItem.sortDynaKey(formerDyKey));
                    if (item == null) continue;
                    result.add((DynaKeyItem)item);
                }
            }
        }
        return result;
    }

    private int doFillItemAndData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, List dynaItemList, List asstActTypeList, OrgUnitInfo curCompany, Map values, int startRowIndex, int asstColCount, int oldMaxCol) {
        int startItemColIndex = basePoint.x + asstColCount;
        int curRowIndex = startRowIndex;
        int newMaxCol = startItemColIndex + itemList.size() - 1;
        int count = 0;
        Map itemValMap = this.getItemValMap(param, dynaItemList, asstActTypeList);
        for (int i = 0; i < dynaItemList.size(); ++i) {
            int asstIndex = 0;
            int itemIndex = 0;
            int startColIndex = basePoint.x;
            DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(i);
            String dItemKey = dynaKeyItem.toString();
            String dItem = dynaKeyItem.getDynaKey();
            if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                if (values.get(dItemKey) == null) continue;
                Range range = sheet.getRange(curRowIndex, startColIndex);
                range.setIgnoreProtected(true);
                range.setFormula(null);
                range.setUserObject("ITEM", null);
                range.setValue(new Variant((Object)curCompany.getName()));
                ++startColIndex;
                ++asstIndex;
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", (Object)curCompany.getId().toString());
                }
            } else {
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", null);
                }
            }
            int x = startColIndex;
            while (x <= newMaxCol) {
                if (x < startItemColIndex) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList.get(this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT ? asstIndex - 1 : asstIndex);
                    AsstActTypeUtils asstActType = this.getAsstActTypeUtils(param, asstActTypeInfo);
                    String asstActTypeNumber = asstActTypeInfo.getNumber();
                    String asstActTypeName = asstActTypeInfo.getName();
                    String itemNumber = dynaKeyItem.getItemNumber(asstActTypeNumber);
                    String key = asstActTypeInfo.getBOSType().toString() + "!" + dynaKeyItem.getItemNumber(asstActTypeNumber);
                    String itemName = "";
                    if (itemValMap.containsKey(key)) {
                        itemName = itemValMap.get(key).toString();
                    }
                    int colCount = this.fillAsstItem(param, sheet, itemNumber, itemName, asstActTypeInfo, x, curRowIndex);
                    x += colCount;
                    ++asstIndex;
                    continue;
                }
                ItemFormula itemFormula = (ItemFormula)itemList.get(itemIndex);
                this.fillItem(param, sheet, dItemKey, dItem, itemFormula, values, x, curRowIndex, itemIndex);
                ++x;
                ++itemIndex;
            }
            this.clearExtraRange(sheet, curRowIndex, oldMaxCol, newMaxCol);
            ++count;
            ++curRowIndex;
        }
        return count;
    }

    private Map getItemValMap(DynaParameters param, List dynaItemList, List asstActTypeList) {
        HashMap<String, String> itemValMap = new HashMap<String, String>();
        for (int i = 0; i < asstActTypeList.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList.get(i);
            AsstActTypeUtils asstActType = this.getAsstActTypeUtils(param, asstActTypeInfo);
            MetaDataPK pk = new MetaDataPK(asstActTypeInfo.getDefaultQueryName());
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            if ("numberandname".equalsIgnoreCase(asstActType.dynaProperty)) {
                sic.add("name");
                sic.add("number");
            } else {
                sic.add(asstActType.dynaProperty);
            }
            ev.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < dynaItemList.size(); ++j) {
                DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(j);
                String dItemKey = dynaKeyItem.toString();
                String dItem = dynaKeyItem.getDynaKey();
                numberSet.add(dynaKeyItem.getItemNumber(asstActTypeInfo.getNumber()));
            }
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            try {
                IRowSet rs = exec.executeQuery();
                while (rs.next()) {
                    String key = asstActTypeInfo.getBOSType().toString() + "!" + rs.getString("number");
                    String val = "";
                    val = "numberandname".equalsIgnoreCase(asstActType.dynaProperty) ? rs.getString("number") + "-" + rs.getString("name") : (rs.getString(asstActType.getDynaProperty()).equals("false") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"87_DynaRangeUI") : (rs.getString(asstActType.getDynaProperty()).equals("true") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"86_DynaRangeUI") : rs.getString(asstActType.getDynaProperty())));
                    itemValMap.put(key, val);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
            }
        }
        return itemValMap;
    }

    private void fillCompanyIDsToSheet(Sheet sheet, List companylist) {
        if (this.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            sheet.removeUserObject("COMPANY_NUMBER");
        } else {
            ArrayList<String> companyIDList = new ArrayList<String>();
            for (int i = 0; i < companylist.size(); ++i) {
                IRow row = (IRow)companylist.get(i);
                if (!row.getCell(1).getValue().equals(Boolean.TRUE)) continue;
                OrgUnitInfo company = (OrgUnitInfo)row.getCell(4).getValue();
                companyIDList.add(company.getId().toString());
            }
            sheet.setUserObject("COMPANY_NUMBER", companyIDList);
        }
    }

    private void clearRange(Range range) {
        range.setIgnoreProtected(true);
        range.setValue(Variant.nullVariant);
        range.setFormula(null);
    }

    private List getDynaKeyList(String sheetName, Point basePoint) {
        Map sheetMap = (Map)this.dynaKeyCache.get(sheetName);
        if (sheetMap != null) {
            return (List)sheetMap.get(basePoint);
        }
        return null;
    }

    private int fillAsstItem(DynaParameters param, Sheet sheet, String itemNumber, String itemName, AsstActTypeInfo asstActTypeInfo, int x, int y) {
        Range range;
        int count = 0;
        AsstActTypeUtils asstActType = this.getAsstActTypeUtils(param, asstActTypeInfo);
        if (!StringUtils.isEmpty((String)asstActType.properityName)) {
            range = sheet.getRange(y, x++);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemNumber));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.properityAlias)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.dynaProperty)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        return count;
    }

    private void fillItem(DynaParameters param, Sheet sheet, String dItemKey, String dItem, ItemFormula itemFormula, Map values, int x, int y, int colIndex) {
        Range range = sheet.getRange(y, x);
        range.setIgnoreProtected(true);
        if (itemFormula != null) {
            range.setFormula(null);
            this.fillDItemFormula(range, itemFormula, dItem);
            this.fillValue(range, values, itemFormula, dItemKey);
        } else {
            range.setUserObject("ITEM", null);
            range.setValue(Variant.nullVariant);
            range.setFormula(null);
        }
    }

    private void cacheDynaKey() {
        this.dynaKeyCache = (Map)this.getUIContext().get("dynaKeyCache");
        if (this.dynaKeyCache == null) {
            this.dynaKeyCache = new HashMap();
        }
    }

    private void fillDItemFormula(Range range, ItemFormula itemFormula, String dItemNumber) {
        String dItemFormula = this.constructDItemFormula(itemFormula, dItemNumber);
        range.setUserObject("ITEM", (Object)new ItemFormula(dItemFormula));
    }

    private void fillValue(Range range, Map valueMap, ItemFormula itemFormula, String dItemKey) {
        Map item2ValueMap;
        if (valueMap != null && (item2ValueMap = (Map)valueMap.get(dItemKey)) != null) {
            DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((String)itemFormula.getDataElementNumber());
            String valueKey = itemFormula.getItemNumber() + "@!@" + dataElementInfo.getInterSeq() + "@!@" + itemFormula.getValueType();
            Object value = item2ValueMap.get(valueKey);
            if (value != null) {
                if (itemFormula.getValueType() != 3) {
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)"BigDecimal Cast Error: ", (Throwable)e);
                    }
                }
                range.setValue(new Variant(value));
                Object dcItem = item2ValueMap.get("dc" + valueKey);
                if (dcItem != null && !dcItem.equals("5")) {
                    if (range.getName().split("\\d").length > 1) {
                        this.signMap.put(range.getName().split("\\d")[1].toString().substring(range.getName().split("\\d")[1].indexOf("!") + 1), dcItem);
                    } else {
                        this.signMap.put(range.getName().split("\\d")[0].toString().substring(range.getName().split("\\d")[0].indexOf("!") + 1), dcItem);
                    }
                }
                return;
            }
        }
        if (itemFormula.getValueType() == 3) {
            range.setValue(Variant.nullVariant);
        } else {
            range.setValue(Variant.zeroVariant);
        }
    }

    private String constructDItemFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private Object[] sortByPosistion(Sheet table, Set set) {
        set.remove("asstActTypeCollection");
        Object[] basePointArray = set.toArray();
        if (basePointArray.length > 0) {
            Point basePoint = (Point)basePointArray[0];
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(table, basePoint.y, basePoint.x);
            if (param != null) {
                if (param.getSpreadStyle() == 1) {
                    Arrays.sort(basePointArray, new PointXComparator());
                } else {
                    Arrays.sort(basePointArray, new PointYComparator());
                }
            }
        }
        return basePointArray;
    }

    private void fillLastSumLine(DynaParameters param, Sheet sheet, Point basePoint, List itemList, int row, int asstColCount, int oldMaxCol) {
        if (!param.isIncludeSum()) {
            return;
        }
        int sumCellRow = param.getPosition() == 2 ? row : basePoint.y + 1;
        this.fillSumTitle(param, sheet, basePoint, sumCellRow, asstColCount);
        int Count = itemList.size();
        int col = basePoint.x + asstColCount;
        if (row < basePoint.y + 1) {
            this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
            return;
        }
        int i = 0;
        while (i < Count) {
            ItemFormula itemFormula = (ItemFormula)itemList.get(i);
            if (itemFormula.getValueType() != 3) {
                String endCellName;
                String startCellName;
                int t;
                int k;
                Range sumCell;
                int ct;
                int sum = 0;
                StringBuffer str = new StringBuffer();
                if (param.getPosition() == 1) {
                    ct = 0;
                    sumCell = null;
                    k = this.arrAddRow.size() - 1;
                    t = 1;
                    while (k >= 0) {
                        sumCell = sheet.getRange(sumCellRow, col);
                        startCellName = Location.getCellName((int)(sumCellRow - ct - t), (int)col);
                        ct = ct + Integer.parseInt(this.arrAddRow.get(k).toString()) + 1;
                        if (k == this.arrAddRow.size() - 1) {
                            str.append("=sum(" + startCellName);
                        } else {
                            if (this.signMap.get(startCellName.split("\\d")).equals("1") && this.isDebitOrCredit) {
                                str.append("+" + startCellName);
                            }
                            if (this.signMap.get(startCellName.split("\\d")).equals("0") && !this.isDebitOrCredit) {
                                str.append("-" + startCellName);
                            }
                        }
                        endCellName = Location.getCellName((int)row, (int)col);
                        sum += Integer.parseInt(sumCell.getValue().toString());
                        sumCell.setUserObject("ITEM", null);
                        --k;
                        --t;
                    }
                    if (sumCell != null) {
                        sumCell.setFormula(str.append(")").toString());
                    }
                    ct = 0;
                } else if (param.getPosition() == 2) {
                    ct = 0;
                    sumCell = null;
                    k = this.arrAddRow.size() - 1;
                    t = 1;
                    while (k >= 0) {
                        sumCell = sheet.getRange(sumCellRow, col);
                        startCellName = Location.getCellName((int)(sumCellRow - ct - t), (int)col);
                        ct = ct + Integer.parseInt(this.arrAddRow.get(k).toString()) + 1;
                        if (k == this.arrAddRow.size() - 1 && this.signMap.get(startCellName.split("\\d")[0]) != null) {
                            if (this.signMap.get(startCellName.split("\\d")[0]).equals("0")) {
                                str.append("=(" + startCellName);
                            }
                            if (this.signMap.get(startCellName.split("\\d")[0]).equals("1")) {
                                str.append("=(-" + startCellName);
                            }
                        }
                        if (k == this.arrAddRow.size() - 2 && this.signMap.get(startCellName.split("\\d")[0]) != null) {
                            if (this.signMap.get(startCellName.split("\\d")[0]).equals("0")) {
                                str.append("-" + startCellName);
                            }
                            if (this.signMap.get(startCellName.split("\\d")[0]).equals("1")) {
                                str.append("+" + startCellName);
                            }
                        }
                        if (k == this.arrAddRow.size() - 3) {
                            str.append("+" + startCellName);
                        }
                        endCellName = Location.getCellName((int)(row - 1), (int)col);
                        sumCell.setUserObject("ITEM", null);
                        --k;
                        --t;
                    }
                    str.append(")");
                    if (sumCell != null) {
                        if (!str.toString().startsWith("=(") || !str.toString().endsWith(")")) {
                            sumCell.setFormula("=" + str.toString().split("\\p{Punct}")[1]);
                        } else {
                            sumCell.setFormula(str.toString());
                        }
                    }
                    ct = 0;
                }
            }
            ++i;
            ++col;
        }
        Row sumRow = sheet.getRow(sumCellRow, false);
        if (sumRow != null) {
            sumRow.setUserObject("COMPANY_NUMBER", null);
        }
        this.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
    }

    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    private class MultiKeyComparator
    implements Comparator {
        private List asstActTypeNumberList = new ArrayList();

        private MultiKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            DynaKeyItem key1 = (DynaKeyItem)o1;
            DynaKeyItem key2 = (DynaKeyItem)o2;
            for (String typeNumber : this.asstActTypeNumberList) {
                String item2;
                String item1 = key1.getItemNumber(typeNumber);
                int compareTo = item1.compareTo(item2 = key2.getItemNumber(typeNumber));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 0;
        }

        public void setAsstActTypeList(List asstActTypeList) {
            this.asstActTypeNumberList.clear();
            for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
                this.asstActTypeNumberList.add(asstActTypeInfo.getNumber());
            }
        }
    }

    private class DynaKeyItem {
        private Map typeNumberMap;
        private String[] itemNumber;
        private String[] itemName;

        DynaKeyItem(String dynaKey) {
            String[] typeItem = patternType.split(dynaKey);
            this.typeNumberMap = new HashMap();
            this.itemNumber = new String[typeItem.length];
            this.itemName = new String[typeItem.length];
            for (int j = 0; j < typeItem.length; ++j) {
                String[] eachItem = patternItem.split(typeItem[j]);
                this.typeNumberMap.put(eachItem[0], new Integer(j));
                String[] split = pattern2Name.split(eachItem[1]);
                this.itemNumber[j] = split[0];
                this.itemName[j] = split[1];
            }
        }

        String getItemNumber(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemNumber[seq];
            }
            return null;
        }

        String getItemName(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemName[seq];
            }
            return null;
        }

        String getDynaKey() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }

        public String toString() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq] + "@!@" + this.itemName[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }
    }
}

