/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.dynainnerexch;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SheetStyleFiller {
    private static Map<String, SheetRowColorRecorder> sheetStyleMap = new Hashtable<String, SheetRowColorRecorder>();
    private static SheetStyleFiller fillter;

    public static synchronized SheetStyleFiller me() {
        if (fillter == null) {
            fillter = new SheetStyleFiller();
        }
        return fillter;
    }

    private synchronized SheetRowColorRecorder getStyleRecorder(String reportId) {
        if (!sheetStyleMap.containsKey(reportId)) {
            sheetStyleMap.put(reportId, new SheetRowColorRecorder());
        }
        return sheetStyleMap.get(reportId);
    }

    public void addRowPosition(String reportId, String sheetId, int basePointSortIndex, int startRow, int startRowCol, int endRow, int endRowCol, Color color) {
        this.getStyleRecorder(reportId).add(sheetId, basePointSortIndex, startRow, startRowCol, endRow, endRowCol, color);
    }

    public void fillColorOnRow(String reportId, Book book) {
        Set<Map.Entry<String, List<Position>>> entrySet = this.getStyleRecorder(reportId).getEntry();
        StyleAttributes sa = Styles.getEmptySA();
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        for (Map.Entry<String, List<Position>> entry : entrySet) {
            String sheetId = entry.getKey();
            Sheet sheet = book.getSheetByID(sheetId);
            if (sheet == null) continue;
            ArrayList pointList = DynamicTemplateUtility.getBasePointList(sheet);
            Object[] basePointArray = pointList.toArray();
            if (basePointArray.length > 0) {
                Point basePoint = (Point)basePointArray[0];
                DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(sheet, basePoint.y, basePoint.x);
                if (param != null) {
                    if (param.getSpreadStyle() == 1) {
                        Arrays.sort(basePointArray, new PointXComparator());
                    } else {
                        Arrays.sort(basePointArray, new PointYComparator());
                    }
                }
            }
            List<Position> postList = entry.getValue();
            for (Position p : postList) {
                int basePointY = ((Point)basePointArray[p.basePointSortIndex]).y;
                int basePointX = ((Point)basePointArray[p.basePointSortIndex]).x;
                sheet.getRange(basePointY + p.startRow, basePointX + p.startCol, basePointY + p.endRow, basePointX + p.endCol).getStyle(sa, saInnerBorder);
                sa.setBackground(p.color);
                sheet.getRange(basePointY + p.startRow, basePointX + p.startCol, basePointY + p.endRow, basePointX + p.endCol).setStyle(sa, saInnerBorder);
            }
        }
        sheetStyleMap.remove(reportId);
    }

    class Position {
        int basePointSortIndex;
        int startRow;
        int startCol;
        int endRow;
        int endCol;
        Color color;

        Position(int basePointSortIndex, int startRow, int startCol, int endRow, int endCol, Color color) {
            this.basePointSortIndex = basePointSortIndex;
            this.startRow = startRow;
            this.startCol = startCol;
            this.endRow = endRow;
            this.endCol = endCol;
            this.color = color;
        }
    }

    public class SheetRowColorRecorder {
        private Map<String, List<Position>> postMap = new HashMap<String, List<Position>>();

        public void add(String sheetId, int basePointSortIndex, int startRow, int startRowCol, int endRow, int endRowCol, Color color) {
            if (!this.postMap.containsKey(sheetId)) {
                this.postMap.put(sheetId, new ArrayList());
            }
            this.postMap.get(sheetId).add(new Position(basePointSortIndex, startRow, startRowCol, endRow, endRowCol, color));
        }

        public Set<Map.Entry<String, List<Position>>> getEntry() {
            return this.postMap.entrySet();
        }
    }
}

