/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.DeleteRange;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class ClearUpBook {
    protected static final Logger logger = Logger.getLogger(ClearUpBook.class);
    Book book = null;
    boolean isRptAutoWeave = false;

    public ClearUpBook(Book book, boolean isRptAutoWeave) {
        this.book = book;
        this.isRptAutoWeave = isRptAutoWeave;
    }

    public void removeZeroAndSortDynaItem(RptSrcTypeEnum srcTypeEnum, boolean isAutoFill) throws Exception {
        this.removeZeroAndSortDynaItem(srcTypeEnum, isAutoFill, true);
    }

    public void removeZeroAndSortDynaItem(RptSrcTypeEnum srcTypeEnum, boolean isAutoFill, boolean isRemoveZero) throws Exception {
        Sheet sheet = null;
        Sheet currSheet = this.book.getActiveSheet();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            sheet = this.book.getSheet(i);
            if (isRemoveZero) {
                this.removeZeroDynamicRow(sheet, srcTypeEnum, isAutoFill);
            }
            this.sortEveryDynamicItemBySheet(sheet);
            sheet.setSelected(false);
        }
        this.book.setActiveSheet(currSheet);
    }

    public void removeZeroRowAndFillDigit(Sheet sheet) throws Exception {
        ArrayList basePointList = this.getBasePointBySheet(sheet);
        this.removeZeroRow(basePointList, sheet, true);
        this.autoFillDigit(basePointList, sheet, false);
    }

    public void removeZeroRow(Sheet sheet) throws Exception {
        ArrayList basePointList = this.getBasePointBySheet(sheet);
        this.removeZeroRow(basePointList, sheet, false);
    }

    public void removeZeroAndSortDynaItem(Book book, boolean isRptAutoWeave, RptSrcTypeEnum srcTypeEnum, boolean isAutoFill) throws Exception {
        this.book = book;
        this.isRptAutoWeave = isRptAutoWeave;
        this.removeZeroAndSortDynaItem(srcTypeEnum, isAutoFill);
    }

    public void removeZeroDynamicRow(Sheet sheet, RptSrcTypeEnum srcTypeEnum, boolean isAutoFill) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        this.book.getUndoManager().startGroup();
        this.removeZeroDynamicRow(basePointList, sheet, false, srcTypeEnum, isAutoFill, false);
        this.book.getUndoManager().endGroup();
    }

    public void removeZeroDynamicRow(ArrayList basePointList, Sheet sheet, RptSrcTypeEnum srcTypeEnum, boolean isAutoFill) {
        this.removeZeroDynamicRow(basePointList, sheet, false, srcTypeEnum, isAutoFill, false);
    }

    public void hideZeroDynamicRow(Sheet sheet, RptSrcTypeEnum srcTypeEnum, boolean isAutoFill) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        this.book.getUndoManager().startGroup();
        this.removeZeroDynamicRow(basePointList, sheet, false, srcTypeEnum, isAutoFill, true);
        this.book.getUndoManager().endGroup();
    }

    private void removeZeroDynamicRow(ArrayList basePointList, Sheet sheet, boolean checkUnCalFormula, RptSrcTypeEnum srcTypeEnum, boolean isAutoFill, boolean isHideRow) {
        sheet.getBook().getUndoManager().enable(false);
        boolean isListener = DynaItemListener.getisListener();
        DynaItemListener.setListener(false);
        boolean isCslDynaRpt = srcTypeEnum.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || srcTypeEnum.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || srcTypeEnum.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || srcTypeEnum.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT);
        for (int i = 0; i < basePointList.size(); ++i) {
            Point p = (Point)DynamicTemplateUtility.getBasePointList(sheet).get(i);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, p);
            int spreadStyle = param.getSpreadStyle();
            boolean isVertical = spreadStyle == 0;
            DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo(sheet.getRange(p.y, p.x));
            Range sqlRang = sheet.getRange(p.y, p.x);
            String sqlParam = (String)sqlRang.getUserObject("sqlText");
            if (param.getDynaItemSource() == 0 && !param.isGrade() && isAutoFill && sqlParam == null) continue;
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
            int rowCount = param.getDefaultCounter();
            int deleted = 0;
            int beforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
            Cell sumCell = null;
            int rowIndex = 0;
            DeleteRange deleteRange = null;
            int maxCol = sheet.getMaxColIndex();
            int maxRow = sheet.getMaxRowIndex();
            int headStart = (isVertical ? p.x : p.y) + 1;
            int headEnd = (isVertical ? maxCol : maxRow) + 1;
            boolean isAllText = true;
            int maxIndex = -1;
            for (int j = headEnd; j >= headStart; --j) {
                Cell cell = sheet.getCell(isVertical ? p.y : j, isVertical ? j : p.x, true);
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                if (item == null) continue;
                if (maxIndex == -1) {
                    maxIndex = j;
                }
                if (item.getValueType() == 3) continue;
                isAllText = false;
                break;
            }
            for (int x = rowCount; x > 0; --x) {
                int index;
                Sheet.ICellsIterator it = null;
                rowIndex = x + beforeSumFormulaCount;
                it = isVertical ? (srcTypeEnum.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) ? sheet.getCellsIterator(rowIndex + p.y, p.x + param.getAsstAccount().getAsstActTypeList().size(), rowIndex + p.y, maxIndex, false, true) : sheet.getCellsIterator(rowIndex + p.y, p.x + 1, rowIndex + p.y, maxIndex, false, true)) : sheet.getCellsIterator(p.y + 1, rowIndex + p.x, maxIndex, rowIndex + p.x, false, true);
                boolean isDelRow = true;
                while (it.hasNext()) {
                    String grade;
                    DItemGradeEntryInfo find;
                    ItemFormula itemFormula;
                    Cell cell = it.next();
                    ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                    if (item == null) {
                        if (this.canRemove(cell, checkUnCalFormula, srcTypeEnum, x == 1, isVertical, p, sheet, isAllText)) continue;
                        isDelRow = false;
                        break;
                    }
                    if (item.isBasePoint()) {
                        isDelRow = false;
                        break;
                    }
                    if (item != null) {
                        Variant value = cell.getValue();
                        if (isAllText) {
                            if (!value.isNull() && !StringUtils.isEmpty((String)value.toString())) {
                                isDelRow = false;
                                break;
                            }
                        } else {
                            if (item.getValueType() == 3) {
                                isDelRow = true;
                                continue;
                            }
                            if (!(value.isNull() || value.isEmpty() || value.compareTo((Object)Variant.zeroBigDecimal) == 0 || StringUtils.isEmpty((String)cell.getText()) || "0".equals(cell.getText()))) {
                                isDelRow = false;
                                break;
                            }
                        }
                    }
                    if (!this.canRemove(cell, checkUnCalFormula, srcTypeEnum, x == 1, isVertical, p, sheet, isAllText)) {
                        isDelRow = false;
                        break;
                    }
                    if (gradeInfo == null || isCslDynaRpt || (sumCell = isVertical ? sheet.getCell(cell.getRow(), p.x, false) : sheet.getCell(p.y, cell.getCol(), false)) == null || (itemFormula = UserObjectHelper.getItemFormula((Cell)sumCell)) == null || (find = gradeInfo.find(grade = itemFormula.getExt("GRADE_NUMBER"))) == null) continue;
                    isDelRow = false;
                    break;
                }
                if (isDelRow && param.isGrade() && gradeInfo != null) {
                    if (!isCslDynaRpt) {
                        isDelRow = this.notRemoveLastLine4Grade(sheet, p, param, gradeInfo, isDelRow, rowIndex, maxCol, maxRow);
                    }
                } else if (isDelRow && !param.isGrade() && x == 1 && rowCount == deleted + 1) {
                    boolean isShowNumber = param.getDynaItemShowType() == 1;
                    this.clearLastLine(sheet, p, rowIndex, maxCol, maxRow, spreadStyle, isShowNumber);
                    isDelRow = false;
                }
                if (!isDelRow) continue;
                int n = index = isVertical ? rowIndex + p.y : rowIndex + p.x;
                if (deleteRange == null) {
                    deleteRange = new DeleteRange(index, index);
                } else {
                    deleteRange.add(new DeleteRange(index, index));
                }
                if (x > rowCount) continue;
                ++deleted;
            }
            if (deleted <= 0) continue;
            if (!isHideRow) {
                this.removeDeleteRange(sheet, deleteRange, spreadStyle);
                param.setDefaultCounter(param.getDefaultCounter() - deleted);
                DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(p.y, p.x)), param);
                int[] sumFormulaIndex = indexHandle.getSumRangeIndex(isVertical);
                int count = this.getItemFormulaCount(isVertical, sheet, p);
                for (int j = 1; j <= count; ++j) {
                    int index = isVertical ? p.x + j : p.y + j;
                    indexHandle.setSumFormulaByIndex(sumFormulaIndex, isVertical, index);
                }
                continue;
            }
            this.hideRange(sheet, deleteRange, spreadStyle);
        }
        this.reviseBadFormula(sheet);
        DynaItemListener.setListener(isListener);
        sheet.getBook().getUndoManager().enable(true);
    }

    private int getItemFormulaCount(boolean vertical, Sheet sheet, Point basePoint) {
        if (vertical) {
            return this.getColCount(sheet, basePoint);
        }
        return this.getRowCount(sheet, basePoint);
    }

    private int getFirstItemFormulaRow(Sheet sheet, Point basePoint) {
        int height = sheet.getMaxRowIndex();
        for (int i = basePoint.y + 1; i <= height; ++i) {
            Cell cell = sheet.getCell(i, basePoint.x, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return basePoint.y + 1;
    }

    private int getRowCount(Sheet sheet, Point basePoint) {
        int height;
        for (int i = height = sheet.getMaxRowIndex(); i > basePoint.y; --i) {
            Cell cell = sheet.getCell(i, basePoint.x, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i - basePoint.y;
        }
        return 1;
    }

    private int getFirstItemFormulaCol(Sheet sheet, Point basePoint) {
        int width = sheet.getMaxColIndex();
        for (int i = basePoint.x + 1; i <= width; ++i) {
            Cell cell = sheet.getCell(basePoint.y, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return basePoint.x + 1;
    }

    private int getColCount(Sheet sheet, Point basePoint) {
        int width;
        for (int i = width = sheet.getMaxColIndex(); i > basePoint.x; --i) {
            Cell cell = sheet.getCell(basePoint.y, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i - basePoint.x;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private boolean notRemoveLastLine4Grade(Sheet sheet, Point p, DynaParameters param, DItemGradeInfo gradeInfo, boolean isDelRow, int rowIndex, int maxCol, int maxRow) {
        List entries = null;
        if (isDelRow && param.isGrade() && gradeInfo != null) {
            entries = DynamicTemplateUtility.getOrderEntries(sheet, gradeInfo, p, param);
            Range range = null;
            int spreadStyle = param.getSpreadStyle();
            range = spreadStyle == 0 ? sheet.getRowRange(rowIndex + p.y, rowIndex + p.y) : sheet.getColRange(rowIndex + p.x, rowIndex + p.x);
            DItemGradeEntryInfo entryInfo = DynamicTemplateUtility.findGradeBeforeDeleteRange(sheet, range, entries, p, param);
            boolean bl = isDelRow = entryInfo == null || entryInfo.getDetailCount() > 1;
            if (entryInfo != null && !isDelRow) {
                boolean isShowNumber = param.getDynaItemShowType() == 1;
                this.clearLastLine(sheet, p, rowIndex, maxCol, maxRow, spreadStyle, isShowNumber);
            }
            if (isDelRow && entryInfo != null) {
                DynamicTemplateUtility.saveDiff(sheet, gradeInfo, entryInfo.getGrade(), -1);
            }
            return isDelRow;
        }
        return false;
    }

    private void clearLastLine(Sheet sheet, Point p, int rowIndex, int maxCol, int maxRow, int spreadStyle, boolean isShowNumber) {
        Range range = spreadStyle == 0 ? UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(rowIndex + p.y, isShowNumber ? p.x - 1 : p.x, rowIndex + p.y, maxCol)) : UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(isShowNumber ? p.y - 1 : p.y, rowIndex + p.x, maxRow, rowIndex + p.x));
        range.setValue(Variant.nullVariant);
        range.setUserObject("ITEM", null);
        range.setUserObject("0", null);
        range.setUserObject("1", null);
        range.setFormula(null);
    }

    private boolean canRemove(Cell cell) {
        if (cell.hasFormula()) {
            if (this.getBookProperties().isRemoveException() && !cell.getValue().isNull() && (cell.getValue().isError() || cell.getValue().isString())) {
                return true;
            }
            if (!cell.getValue().isNull() && cell.getValue().compareTo((Object)CslConstant.BGZERO) != 0) {
                return false;
            }
        } else if (cell.getValue().getValue() instanceof BigDecimal && ((BigDecimal)cell.getValue().getValue()).compareTo(CslConstant.BGZERO) != 0) {
            return false;
        }
        return true;
    }

    private boolean canRemove(Cell cell, boolean checkUnCalFormula, RptSrcTypeEnum srcTypeEnum, boolean isFirstRow, boolean isRow, Point basePoint, Sheet sheet, boolean isAllText) {
        ItemFormula item = UserObjectHelper.getItemFormula((Cell)sheet.getCell(isRow ? basePoint.y : cell.getRow(), isRow ? cell.getCol() : basePoint.x, true));
        if (!isAllText && item != null && item.getValueType() == 3) {
            return true;
        }
        Variant cellValue = cell.getValue();
        if (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)srcTypeEnum) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)srcTypeEnum) || RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)srcTypeEnum) || RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE.equals((Object)srcTypeEnum) || RptSrcTypeEnum.DYNACSLELIMREPORT.equals((Object)srcTypeEnum) || RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE.equals((Object)srcTypeEnum)) {
            if (isAllText ? !cellValue.isNull() && !StringUtils.isEmpty((String)cellValue.toString()) : !cellValue.isNull() && cellValue.compareTo((Object)CslConstant.BGZERO) != 0) {
                return false;
            }
        } else if (cell.hasFormula()) {
            if (checkUnCalFormula && cell.getValue().isNull()) {
                return false;
            }
            if (cell.getFormula() != null && cell.getFormula().indexOf("@") > 0 && isFirstRow) {
                return cell.getFormula().indexOf("=sqlGetData") > -1 && cell.getFormula().indexOf("{@}") > 0;
            }
            if (isAllText ? !cellValue.isNull() && !StringUtils.isEmpty((String)cellValue.toString()) : !cellValue.isNull() && cellValue.compareTo((Object)CslConstant.BGZERO) != 0 && !StringUtils.isEmpty((String)cell.getText()) && !"0".equals(cell.getText()) && !cell.getValue().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private void reviseBadFormula(Sheet sheet) {
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            String formula = cell.getFormula();
            if (StringUtils.isEmpty((String)formula) || formula.trim().length() < 1 || formula.trim().charAt(0) != '=') continue;
            formula = StringUtils.replace((String)formula, (String)"#REF!+", (String)"");
            formula = StringUtils.replace((String)formula, (String)"+#REF!", (String)"");
            formula = StringUtils.replace((String)formula, (String)"#REF!", (String)"0");
            Variant v = cell.getValue();
            cell.setFormula(formula);
            cell.setValue(v);
        }
    }

    protected BookProperties getBookProperties() {
        BookProperties p = BookProperties.loadFromBook((Book)this.book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(this.book);
        }
        return p;
    }

    public void sortEveryDynamicItemBySheet(Sheet sheet) throws Exception {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            Point basePoint = (Point)basePointList.get(i);
            if (basePoint == null) continue;
            int left = basePoint.x;
            int top = basePoint.y;
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
            int defaultCounter = param.getDefaultCounter();
            if (defaultCounter == 0) continue;
            if (!OrderByEnum.NONE.equals((Object)param.getOrderBy())) {
                OrderByEnum orderRule = param.getOrderBy();
                int value = orderRule.getValue();
                if (!param.isGrade() || param.getDynaItemSource() != 0) {
                    boolean xx;
                    DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
                    int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
                    int afterDynaItemCount = indexHandle.getAfterDynaItemSumRangeCount();
                    int firstItemFormulaIndex = 0;
                    int endItemFormulaIndex = 0;
                    int startRow = top + beforeDynaItemCount + 1;
                    int endRow = top + beforeDynaItemCount + defaultCounter;
                    int startCol = left + beforeDynaItemCount + 1;
                    int endCol = left + beforeDynaItemCount + defaultCounter;
                    this.book.setActiveSheet(sheet);
                    Protection protection = sheet.getSheetOption().getProtection(false);
                    String proPass = null;
                    boolean willProtect = false;
                    if (protection != null && protection.isProtected()) {
                        proPass = protection.getEncryptedPassword();
                        protection.setPassword(proPass);
                        protection.stop(proPass);
                        willProtect = true;
                    }
                    int[] keys = new int[1];
                    boolean[] orders = new boolean[]{value == 2};
                    if (param.getSpreadStyle() == 0) {
                        firstItemFormulaIndex = this.getFirstItemFormulaCol(sheet, basePoint);
                        endItemFormulaIndex = left + this.getColCount(sheet, basePoint);
                        keys[0] = param.getOrderRow() + firstItemFormulaIndex - 1;
                        UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(startRow, endRow)).setHidden(false, true);
                        xx = UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(startRow, endRow)).sort(keys, orders, true, false);
                        if (beforeDynaItemCount > 0) {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(top + 1, firstItemFormulaIndex, top + beforeDynaItemCount, endItemFormulaIndex)).calc(true);
                        }
                        if (afterDynaItemCount > 0) {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(endRow + 1, firstItemFormulaIndex, endRow + afterDynaItemCount, endItemFormulaIndex)).calc(true);
                        }
                    } else {
                        firstItemFormulaIndex = this.getFirstItemFormulaRow(sheet, basePoint);
                        endItemFormulaIndex = top + this.getRowCount(sheet, basePoint);
                        keys[0] = param.getOrderRow() + firstItemFormulaIndex - 1;
                        UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(startCol, endCol)).setHidden(false, false);
                        xx = UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(startCol, endCol)).sort(keys, orders, false, false);
                        if (beforeDynaItemCount > 0) {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(firstItemFormulaIndex, left + 1, endItemFormulaIndex, left + beforeDynaItemCount)).calc(true);
                        }
                        if (afterDynaItemCount > 0) {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(firstItemFormulaIndex, endCol + 1, endItemFormulaIndex, endCol + afterDynaItemCount)).calc(true);
                        }
                    }
                    logger.info((Object)("\n" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"14_BaseReportDesignerUI") + xx));
                    if (willProtect) {
                        protection.startWithEncryptedPassword(proPass);
                    }
                }
            }
            this.setFillLineNumberRangeHiddenForBasePoint(basePoint, sheet);
        }
    }

    public void setFillLineNumberRangeHiddenForSheet(Sheet sheet) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            Point basePoint = (Point)basePointList.get(i);
            if (basePoint == null) continue;
            this.setFillLineNumberRangeHiddenForBasePoint(basePoint, sheet);
        }
    }

    public void setFillLineNumberRangeHiddenForBasePoint(Point basePoint, Sheet sheet) {
        DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
        int defaultCounter = param.getDefaultCounter();
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int fillLineNumber = param.getFillLineNumber();
        boolean needHide = true;
        if (OrderByEnum.NONE.equals((Object)param.getOrderBy()) || fillLineNumber == -1 || fillLineNumber >= defaultCounter) {
            fillLineNumber = defaultCounter;
            needHide = false;
        }
        if (param.getSpreadStyle() == 0) {
            int noShowStartRow = basePoint.y + indexHandle.getBeforeDynaItemSumRangeCount() + 1 + fillLineNumber;
            int endRow = basePoint.y + indexHandle.getBeforeDynaItemSumRangeCount() + defaultCounter;
            UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(basePoint.y + indexHandle.getBeforeDynaItemSumRangeCount() + 1, endRow)).setHidden(false, true);
            if (needHide) {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(noShowStartRow, endRow)).setHidden(true, true);
            }
        } else if (param.getSpreadStyle() == 1) {
            int noShowStartCol = basePoint.x + indexHandle.getBeforeDynaItemSumRangeCount() + 1 + fillLineNumber;
            int endCol = basePoint.x + indexHandle.getBeforeDynaItemSumRangeCount() + defaultCounter;
            UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(basePoint.x + indexHandle.getBeforeDynaItemSumRangeCount() + 1, endCol)).setHidden(false, false);
            if (needHide) {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(noShowStartCol, endCol)).setHidden(true, false);
            }
        }
    }

    private void sortGradeEveryDynamicItemBySheet(Sheet sheet, Point basepoint) {
        if (basepoint == null) {
            return;
        }
        DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basepoint);
        if (param.isGrade() && param.getDynaItemSource() == 0) {
            OrderByEnum orderRule;
            int value;
            DItemGradeEntryInfo entry;
            ItemFormula item;
            Sheet.RowsIterator it;
            DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo(sheet.getRange(basepoint.y, basepoint.x));
            ArrayList<Point> pos_array = new ArrayList<Point>();
            if (param.getSpreadStyle() == 0) {
                it = sheet.getRowsIterator(basepoint.y + 1, basepoint.y + param.getDefaultCounter(), false);
                while (it.hasNext()) {
                    Row r = it.next();
                    item = UserObjectHelper.getItemFormula((Cell)r.getCell(basepoint.x, false));
                    if (item == null || (entry = gradeInfo.find(item.getExt("GRADE_NUMBER"))) == null) continue;
                    pos_array.add(new Point(basepoint.x, r.getRow()));
                }
            } else {
                it = sheet.getColsIterator(basepoint.x + 1, basepoint.x + param.getDefaultCounter(), false);
                while (it.hasNext()) {
                    Column col = it.next();
                    item = UserObjectHelper.getItemFormula((Cell)sheet.getCell(basepoint.y, col.getCol(), false));
                    if (item == null || (entry = gradeInfo.find(item.getExt("GRADE_NUMBER"))) == null) continue;
                    pos_array.add(new Point(col.getCol(), basepoint.y));
                }
            }
            if (param.getOrderBy() != null && (value = (orderRule = param.getOrderBy()).getValue()) != 1) {
                boolean order = value == 2;
                boolean[] orders = new boolean[]{order};
                int[] keys = new int[1];
                this.book.setActiveSheet(sheet);
                for (int x = 0; x < pos_array.size(); ++x) {
                    boolean xx;
                    int rangB;
                    int rangA;
                    Point now = (Point)pos_array.get(x);
                    Point next = null;
                    if (x + 1 != pos_array.size()) {
                        next = (Point)pos_array.get(x + 1);
                    }
                    if (param.getSpreadStyle() == 0) {
                        if (next == null) {
                            rangA = now.y + 1;
                            rangB = param.getDefaultCounter() + basepoint.y;
                        } else {
                            if (next.y - 1 == now.y) continue;
                            rangA = now.y + 1;
                            rangB = next.y - 1;
                        }
                        if (rangB - rangA <= 0) continue;
                        keys[0] = param.getOrderRow() + basepoint.x;
                        xx = UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(rangA, rangB)).sort(keys, orders, true, false);
                    } else {
                        if (next == null) {
                            rangA = now.x + 1;
                            rangB = param.getDefaultCounter() + basepoint.x;
                        } else {
                            if (next.x - 1 == now.x) continue;
                            rangA = now.x + 1;
                            rangB = next.x - 1;
                        }
                        if (rangB - rangA <= 0) continue;
                        keys[0] = param.getOrderRow() + basepoint.y - 1;
                        xx = UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(rangA, rangB)).sort(keys, orders, false, false);
                    }
                    logger.info((Object)("\n" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"14_BaseReportDesignerUI") + xx));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeZeroRow(ArrayList basePointList, Sheet sheet, boolean isInterOrExch) {
        ReportVariables variables = this.getVariables();
        VariableEntry variableEntry = variables.get("SheetClass", sheet.getSheetName());
        if (variableEntry != null && variableEntry.getIntValue(1) == 1) {
            return;
        }
        int i = basePointList.size() - 1;
        while (i >= 0) {
            Point p = (Point)basePointList.get(i);
            int spreadStyle = 0;
            Range range = null;
            int maxCol = sheet.getMaxColIndex();
            int maxRow = sheet.getMaxRowIndex();
            int rowCount = spreadStyle == 0 ? maxRow - p.y : maxCol - p.x;
            DeleteRange deleteRange = null;
            boolean isFirstRowNull = false;
            for (int x = rowCount; x > 0; --x) {
                int index;
                range = spreadStyle == 0 ? sheet.getRange(x + p.y, p.x, x + p.y, maxCol) : sheet.getRange(p.y, x + p.x, maxRow, x + p.x);
                Sheet.ICellsIterator it = sheet.getBook().getRangeCellsIterator(range, false, true);
                boolean isDelRow = true;
                if (it.hasNext()) {
                    boolean isCompanyCol = true;
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                        if (isCompanyCol) {
                            if (item == null) {
                                isDelRow = false;
                                break;
                            }
                            isCompanyCol = false;
                        }
                        if (item == null) {
                            if (this.canRemove(cell)) continue;
                            isDelRow = false;
                            break;
                        }
                        if (item.isBasePoint()) {
                            isDelRow = false;
                        } else {
                            if (this.canRemove(cell)) continue;
                            isDelRow = false;
                        }
                        break;
                    }
                } else {
                    isDelRow = false;
                }
                if (!isDelRow) continue;
                int n = index = spreadStyle == 0 ? x + p.y : x + p.x;
                if (x == 1) {
                    Protection pro = sheet.getSheetOption().getProtection(false);
                    String proPass = null;
                    boolean willProtect = false;
                    try {
                        if (pro != null && pro.isProtected()) {
                            proPass = pro.getEncryptedPassword();
                            pro.setPassword(proPass);
                            pro.stop(proPass);
                            willProtect = true;
                        }
                        if (isInterOrExch) {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(index, p.x)).setValue(null);
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(index, p.x)).setUserObject("ITEM", null);
                            for (int n2 = p.x + 1; n2 <= maxCol; ++n2) {
                                Object formula = sheet.getRange(p.y, n2).getUserObject("FormulaExp");
                                if (formula == null) continue;
                                UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(index, n2)).setFormula(formula.toString());
                            }
                        } else {
                            UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(index, index)).clear(true, false, true, new String[0]);
                        }
                        isFirstRowNull = true;
                        if (!willProtect) continue;
                    }
                    catch (Throwable throwable) {
                        if (willProtect) {
                            pro.startWithEncryptedPassword(proPass);
                        }
                        throw throwable;
                    }
                    pro.startWithEncryptedPassword(proPass);
                    continue;
                }
                if (deleteRange == null) {
                    deleteRange = new DeleteRange(index, index);
                    continue;
                }
                deleteRange.add(new DeleteRange(index, index));
            }
            this.removeDeleteRange(sheet, deleteRange, spreadStyle);
            if (isFirstRowNull) {
                Cell cell = null;
                cell = spreadStyle == 0 ? sheet.getCell(2 + p.y, p.x, true) : sheet.getCell(p.y, 2 + p.x, true);
                if (UserObjectHelper.getItemFormula((Cell)cell) != null) {
                    if (spreadStyle == 0) {
                        UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(p.y + 1, p.y + 1)).delete();
                    } else {
                        UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(p.x + 1, p.x + 1)).delete();
                    }
                }
            }
            --i;
        }
        return;
    }

    private void removeDeleteRange(Sheet sheet, DeleteRange deleteRange, int spreadStyle) {
        boolean isRowRange = spreadStyle == 0;
        DeleteRange deleteRange2 = deleteRange = deleteRange == null ? null : deleteRange.first;
        while (deleteRange != null) {
            logger.info((Object)("removeDeleteRange," + sheet.getSheetName() + ":" + deleteRange.begin + " " + deleteRange.end));
            if (isRowRange) {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(deleteRange.begin, deleteRange.end)).delete();
            } else {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(deleteRange.begin, deleteRange.end)).delete();
            }
            deleteRange = deleteRange.next;
        }
    }

    private void hideRange(Sheet sheet, DeleteRange hideRange, int spreadStyle) {
        boolean isRowRange = spreadStyle == 0;
        DeleteRange deleteRange = hideRange = hideRange == null ? null : hideRange.first;
        while (hideRange != null) {
            logger.info((Object)("removeDeleteRange," + sheet.getSheetName() + ":" + hideRange.begin + " " + hideRange.end));
            Range range = UserObjectHelper.getUnprotectedRange((Range)(isRowRange ? sheet.getRowRange(hideRange.begin, hideRange.end) : sheet.getColRange(hideRange.begin, hideRange.end)));
            if (range != null && range.getHidden() != null) {
                range.setHidden(range.getHidden() == false, true);
            }
            hideRange = hideRange.next;
        }
    }

    protected ReportVariables getVariables() {
        ReportVariables v = ReportVariables.loadFromBook((Book)this.book);
        if (v == null) {
            v = new ReportVariables();
            v.storeToBook(this.book);
        }
        return v;
    }

    private ArrayList getBasePointBySheet(Sheet sheet) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        Point firstPoint = new Point(iPosLeft, iPosTop);
        ArrayList<Point> basePointList = new ArrayList<Point>();
        basePointList.add(firstPoint);
        return basePointList;
    }

    public void insertDigitCol(Sheet sheet) throws Exception {
        ArrayList basePointList = this.getBasePointBySheet(sheet);
        this.autoFillDigit(basePointList, sheet, true);
    }

    public void fillDigitCol(Sheet sheet) throws Exception {
        ArrayList basePointList = this.getBasePointBySheet(sheet);
        this.autoFillDigit(basePointList, sheet, false);
    }

    protected void autoFillDigit(ArrayList basePointList, Sheet sheet, boolean isOnlyInsert) throws Exception {
        if (!this.getBookProperties().isAutoFillDigit()) {
            return;
        }
        try {
            for (int i = basePointList.size() - 1; i >= 0; --i) {
                int rowCount;
                Point p = (Point)basePointList.get(i);
                boolean spreadStyle = false;
                boolean isVertical = !spreadStyle;
                Range range = null;
                if (isVertical ? p.x - 1 < 0 : p.y - 1 < 0) {
                    UserObjectHelper.getUnprotectedRange((Range)(isVertical ? sheet.getColRange(0, 0) : sheet.getRowRange(0, 0))).insert(false, InsertType.FLLOW_DOWN_STYLE);
                    for (int k = 0; k <= (isVertical ? sheet.getMaxRowIndex() : sheet.getMaxColIndex()); ++k) {
                        sheet.getCell(isVertical ? k : 0, isVertical ? 0 : k, true).setSSA(sheet.getCell(isVertical ? k : 1, isVertical ? 1 : k, true).getSSA());
                    }
                    if (isOnlyInsert) {
                        return;
                    }
                    if (isVertical) {
                        ++p.x;
                    } else {
                        ++p.y;
                    }
                }
                for (int x = rowCount = isVertical ? sheet.getMaxRowIndex() - p.y : sheet.getMaxColIndex() - p.x; x > 0; --x) {
                    if (isVertical) {
                        if (!isOnlyInsert) {
                            range = sheet.getRange(x + p.y, p.x);
                            if (range == null || range.getUserObject("ITEM") == null || StringUtils.isEmpty((String)((ItemFormula)range.getUserObject("ITEM")).getExt("16"))) continue;
                            range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(x + p.y, p.x - 1 < 0 ? 0 : p.x - 1));
                        }
                    } else if (!isOnlyInsert) {
                        range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(p.y - 1 < 0 ? 0 : p.y - 1, x + p.x));
                    }
                    if (isOnlyInsert || range == null) continue;
                    Variant val = new Variant();
                    val.setInt(x);
                    range.setValue(val);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"15_BaseReportDesignerUI"), e);
        }
    }

    public void removeNullLine(Sheet curSheet) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList(curSheet);
        if (null == basePointList || basePointList.size() == 0) {
            return;
        }
        Point basePoint = (Point)basePointList.get(0);
        DynaParameters param = DynamicTemplateUtility.getDynaParameters(curSheet, basePoint);
        boolean templateisVertical = param.getSpreadStyle() == 0;
        Object[] basePoints = basePointList.toArray();
        if (templateisVertical) {
            Arrays.sort(basePoints, new PointYComparator());
        } else {
            Arrays.sort(basePoints, new PointXComparator());
        }
        Variant cellValue = null;
        Range cell = null;
        boolean bResult = false;
        for (int j = basePoints.length - 1; j >= 0; --j) {
            bResult = false;
            basePoint = (Point)basePoints[j];
            param = DynamicTemplateUtility.getDynaParameters(curSheet, basePoint);
            if (param.getDefaultCounter() <= 0) continue;
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, curSheet, true, true);
            int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
            int row = 0;
            int col = 0;
            int endRow = 0;
            int endCol = 0;
            if (templateisVertical) {
                col = basePoint.x;
                row = basePoint.y + beforeDynaItemCount + 1;
                endRow = param.getDefaultCounter() + beforeDynaItemCount;
            } else {
                row = basePoint.y;
                col = basePoint.x + beforeDynaItemCount + 1;
                endCol = beforeDynaItemCount + param.getDefaultCounter();
            }
            boolean isNoFillData = true;
            for (int i = templateisVertical ? row : col; i <= (templateisVertical ? endRow : endCol); ++i) {
                cell = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(templateisVertical ? i : row, templateisVertical ? col : i));
                cellValue = cell.getValue();
                if (cellValue == null || cellValue.toString().trim().equals("")) continue;
                isNoFillData = false;
                break;
            }
            cell = templateisVertical ? UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row, col)) : UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row, col));
            cellValue = cell.getValue();
            if (isNoFillData || cellValue != null && !cellValue.toString().trim().equals("")) continue;
            Range range = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(basePoint.y, basePoint.x));
            DynaParameters dynaParameters = DynamicTemplateUtility.getDynaParameters(curSheet, basePoint);
            if (dynaParameters.getDefaultCounter() <= 1) continue;
            if (templateisVertical) {
                int colDel = basePoint.y + beforeDynaItemCount;
                bResult = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(colDel, colDel)).delete();
                logger.info((Object)("remove the row" + curSheet.getRowRange(colDel, colDel)));
            } else {
                int rowDel = basePoint.x + beforeDynaItemCount;
                bResult = UserObjectHelper.getUnprotectedRange((Range)curSheet.getColRange(rowDel, rowDel)).delete();
                logger.info((Object)("remove the row" + curSheet.getColRange(rowDel, rowDel)));
            }
            if (!bResult) continue;
            dynaParameters.setDefaultCounter(dynaParameters.getDefaultCounter() - 1);
            DynamicTemplateUtility.saveParametersToCell(range, dynaParameters);
        }
    }

    public void hideBasePointRow(Sheet sheet, Point basePoint, boolean isShow) {
        DynaParameters param;
        if (basePoint != null && (param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint)) != null) {
            boolean isVertical;
            boolean bl = isVertical = param.getSpreadStyle() == 0;
            if (isVertical) {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(basePoint.y, basePoint.y)).setHidden(!isShow, true);
            } else {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(basePoint.x, basePoint.x)).setHidden(!isShow, false);
            }
        }
    }
}

