/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.PeriodHandler;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DyaItemFormulaParse {
    private static Logger LOGGER = Logger.getLogger((String)"com.kingdee.eas.fi.gr.dynamic.fill.DyaItemFormulaParse");
    private Map<String, List<FormulaFilterInfo>> table_formulaFilters = new HashMap<String, List<FormulaFilterInfo>>();
    private Map<String, List<FormulaFilterInfo>> acctCashFormulaMap = new HashMap<String, List<FormulaFilterInfo>>();
    private Map<String, Map<String, List<FormulaFilterInfo>>> acctFormulasGroupMap = new HashMap<String, Map<String, List<FormulaFilterInfo>>>();
    private Map<String, Map<String, List<FormulaFilterInfo>>> acctCashFormulasGroupMap = new HashMap<String, Map<String, List<FormulaFilterInfo>>>();
    private boolean isSingDyna = false;
    protected List formulaList;
    protected Map<String, String> formulaMap = null;
    protected Set<String> handleFormulaIds = new HashSet<String>();
    protected OrgUnitInfo company;
    protected int baseStartYear = 0;
    protected int baseStartPeriod = 0;
    protected int baseEndYear = 0;
    protected int baseEndPeriod = 0;
    protected boolean isMergeByFiscalPeriod;
    protected PeriodCollection periodColl;
    protected boolean isAccordFillItem = true;
    protected ReportVariables reportVariables;
    protected IReportPropertyAdapter adapter;
    protected String sheetName;
    protected String companyId;
    protected Context _ctx = null;
    protected Map<String, List<String>> asstTypeNumber_value = null;
    protected Integer Period_Type = 3;
    protected boolean isAsstActTypeSame = true;
    protected Map asstActTypeNumber2AttribeMap = null;
    protected int maxPeriod = -1;
    protected Set<String> asstActTypeNumberSet = new HashSet<String>();
    public Set<String> handleFormulas = new HashSet<String>();

    public Set<String> getAsstActTypeNumberSet() {
        return this.asstActTypeNumberSet;
    }

    public boolean isAsstActTypeSame() {
        return this.isAsstActTypeSame;
    }

    public Map<String, List<String>> getAsstTypeMap() {
        if (this.asstTypeNumber_value == null) {
            this.asstTypeNumber_value = new HashMap<String, List<String>>();
        }
        return this.asstTypeNumber_value;
    }

    public DyaItemFormulaParse(Context _ctx, List formulaList, ReportVariables reportVariables, IReportPropertyAdapter adapter, String sheetName, OrgUnitInfo company, Map asstActTypeNumber2AttribeMap) {
        this(_ctx, formulaList, reportVariables, adapter, sheetName, company);
        this.asstActTypeNumber2AttribeMap = asstActTypeNumber2AttribeMap;
    }

    public DyaItemFormulaParse(Context _ctx, List formulaList, ReportVariables reportVariables, IReportPropertyAdapter adapter, String sheetName, OrgUnitInfo company, boolean isSingDyna) {
        this(_ctx, formulaList, reportVariables, adapter, sheetName, company);
        this.isSingDyna = isSingDyna;
    }

    public DyaItemFormulaParse(Context _ctx, List formulaList, ReportVariables reportVariables, IReportPropertyAdapter adapter, String sheetName, OrgUnitInfo company) {
        this.handleFormulas.add("ACCT");
        this.handleFormulas.add("ACCTAC");
        this.handleFormulas.add("ACCTCASH");
        this.handleFormulas.add("INCASHFLOW");
        this.handleFormulas.add("AGE");
        this.formulaList = formulaList;
        this.reportVariables = reportVariables;
        this.adapter = adapter;
        this.sheetName = sheetName;
        this.company = company;
        this._ctx = _ctx;
        if (this.company == null) {
            this.company = _ctx != null ? (OrgUnitInfo)_ctx.get((Object)OrgType.Company) : SysContext.getSysContext().getCurrentFIUnit();
        }
        this.companyId = this.company.getId().toString();
        this.init();
    }

    public Map<String, List<FormulaFilterInfo>> getTable_formulaFilters() {
        return this.table_formulaFilters;
    }

    public void setTable_formulaFilters(Map<String, List<FormulaFilterInfo>> table_formulaFilters) {
        this.table_formulaFilters = table_formulaFilters;
    }

    private void init() {
        if (this.reportVariables == null || this.adapter == null) {
            this.isAccordFillItem = false;
        }
        this.isMergeByFiscalPeriod = CSLParamUtil.isMergeByFiscalPeriod((Context)this._ctx);
        this.Period_Type = new Integer(DyaItemFormulaParse.getInt(this.adapter.getReportProperty("PeriodType"), 3));
        int variableStartYear = 0;
        int variableStartPeriod = 0;
        int variableEndYear = 0;
        int variableEndPeriod = 0;
        if (this.reportVariables != null) {
            variableStartYear = this.reportVariables.getIntValue("StartYear", this.sheetName, 0);
            variableStartPeriod = this.reportVariables.getIntValue("StartPeriod", this.sheetName, 0);
            variableEndYear = this.reportVariables.getIntValue("EndYear", this.sheetName, 0);
            variableEndPeriod = this.reportVariables.getIntValue("EndPeriod", this.sheetName, 0);
        }
        this.baseStartYear = DyaItemFormulaParse.getInt(this.adapter.getReportProperty("Report.Year"), variableStartYear);
        this.baseStartPeriod = DyaItemFormulaParse.getInt(this.adapter.getReportProperty("Report.Period"), variableStartPeriod);
        this.baseEndYear = DyaItemFormulaParse.getInt(this.adapter.getReportProperty("Report.Year"), variableEndYear);
        this.baseEndPeriod = DyaItemFormulaParse.getInt(this.adapter.getReportProperty("Report.Period"), variableEndPeriod);
        if (variableStartYear > 0) {
            this.baseStartYear = variableStartYear;
        }
        if (variableStartPeriod > 0) {
            this.baseStartPeriod = variableStartPeriod;
        }
        if (variableEndYear > 0) {
            this.baseEndYear = variableEndYear;
        }
        if (variableEndPeriod > 0) {
            this.baseEndPeriod = variableEndPeriod;
        }
        try {
            this.periodColl = FiscalPeriodHelper.getPeriodCollection((Context)this._ctx, (String)this.companyId);
            int isSupportAdjustPeriod = DyaItemFormulaParse.getInt(this.adapter.getReportProperty("SupportAdjustPeriodData"), -1);
            if (isSupportAdjustPeriod != -1 && isSupportAdjustPeriod == 1 && this.baseEndPeriod == 12) {
                CompanyOrgUnitInfo companyInfo = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.NONE, this.companyId, this._ctx);
                this.maxPeriod = PeriodUtils.getMaxPeriodNumber((Context)this._ctx, (int)this.baseEndYear, (String)companyInfo.getId().toString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"init error", (Throwable)e);
        }
    }

    public void formulaParse(Sheet curSheet) {
        if (!this.isAccordFillItem) {
            return;
        }
        if ((this.formulaList == null || this.formulaList.isEmpty()) && (this.formulaMap == null || this.formulaMap.isEmpty())) {
            return;
        }
        if (this.formulaMap != null && !this.formulaMap.isEmpty()) {
            this.formulaParse(curSheet, this.formulaMap);
            return;
        }
        this.removeDuble(this.formulaList);
        String orgType = null;
        RptSheetParamInfo rptSheetParamInfo = null;
        rptSheetParamInfo = this._ctx != null ? VariablesHelper.variables2SheetParams((ReportVariables)this.reportVariables, (String)curSheet.getSheetName(), (boolean)true, (Context)this._ctx) : VariablesHelper.variables2SheetParams((ReportVariables)this.reportVariables, (String)curSheet.getSheetName(), (boolean)true, null);
        boolean isIsIncludingUnposted = rptSheetParamInfo.isIsIncludingUnposted();
        for (int i = 0; i < this.formulaList.size(); ++i) {
            String formulaExpr = (String)this.formulaList.get(i);
            if (formulaExpr == null || !formulaExpr.trim().startsWith("=")) continue;
            ArrayList celleformulaExprList = new ArrayList();
            ExcelFormulaPaserHelper.expandExpress((String)formulaExpr, (Sheet)curSheet, celleformulaExprList, this.handleFormulas);
            this.removeDuble(celleformulaExprList);
            Iterator iter = celleformulaExprList.iterator();
            while (iter.hasNext()) {
                orgType = OrgType.Company.getName();
                FormulaHint hint = (FormulaHint)iter.next();
                this.handleHint(this._ctx, hint, orgType, isIsIncludingUnposted, null);
            }
        }
    }

    public void formulaParse(Sheet curSheet, Map<String, String> formulaMap) {
        this.removeDuble(formulaMap);
        String orgType = null;
        RptSheetParamInfo rptSheetParamInfo = null;
        rptSheetParamInfo = this._ctx != null ? VariablesHelper.variables2SheetParams((ReportVariables)this.reportVariables, (String)curSheet.getSheetName(), (boolean)true, (Context)this._ctx) : VariablesHelper.variables2SheetParams((ReportVariables)this.reportVariables, (String)curSheet.getSheetName(), (boolean)true, null);
        boolean isIsIncludingUnposted = rptSheetParamInfo.isIsIncludingUnposted();
        for (String formulaId : formulaMap.keySet()) {
            String formulaExpr = formulaMap.get(formulaId);
            if (formulaExpr == null || !formulaExpr.trim().startsWith("=")) continue;
            ArrayList celleformulaExprList = new ArrayList();
            ExcelFormulaPaserHelper.expandExpress((String)formulaExpr, (Sheet)curSheet, celleformulaExprList, this.handleFormulas);
            this.removeDuble(celleformulaExprList);
            Iterator iter = celleformulaExprList.iterator();
            while (iter.hasNext()) {
                orgType = OrgType.Company.getName();
                FormulaHint hint = (FormulaHint)iter.next();
                this.handleHint(this._ctx, hint, orgType, isIsIncludingUnposted, formulaId);
            }
        }
    }

    protected void handleHint(Context ctx, FormulaHint hint, String orgType, boolean isIsIncludingUnposted, String formulaId) {
        String accountNumber;
        FormulaFilterInfo filterInfo = null;
        String key = null;
        if (hint.name.equalsIgnoreCase("ACCT")) {
            String accountNumber2 = hint.params[1];
            if (!StringUtils.isEmpty((String)accountNumber2)) {
                filterInfo = new FormulaFilterInfo();
                filterInfo.setFormulaId(formulaId);
                if (this.setFormulaFilterInfo(filterInfo, accountNumber2, hint.params[0], hint.params[7], hint.params[3], hint.params[4], hint.params[5], hint.params[6], hint.params[2], hint)) {
                    if (hint.params.length >= 9) {
                        orgType = this.getOrgType(hint.params[8]);
                    }
                    key = this.getBalTableName(orgType, filterInfo.getCurrency(), hint.params[2], isIsIncludingUnposted);
                    this.putFilter(key, filterInfo, this.getResultMap(hint.name));
                }
            }
        } else if (hint.name.equalsIgnoreCase("ACCTAC")) {
            String accountNumber3 = hint.params[2];
            if (!StringUtils.isEmpty((String)accountNumber3)) {
                filterInfo = new FormulaFilterInfo();
                filterInfo.setFormulaId(formulaId);
                if (this.setFormulaFilterInfo(filterInfo, accountNumber3, hint.params[0], hint.params[8], hint.params[4], hint.params[5], hint.params[6], hint.params[7], hint.params[3], hint)) {
                    key = this.getBalTableName(orgType, filterInfo.getCurrency(), hint.params[3], isIsIncludingUnposted);
                    this.putFilter(key, filterInfo, this.getResultMap(hint.name));
                }
            }
        } else if (hint.name.equalsIgnoreCase("ACCTCASH")) {
            if (!StringUtils.isEmpty((String)hint.params[6])) {
                filterInfo = new FormulaFilterInfo();
                filterInfo.setFormulaId(formulaId);
                if (this.setFormulaFilterInfo(filterInfo, hint.params[6], hint.params[0], hint.params[2], hint.params[3], hint.params[4], hint.params[3], hint.params[5], hint.params[1], hint)) {
                    CashTypeEnum cashType = hint.params[1] == null ? null : CashTypeEnum.getEnum((String)hint.params[1].toUpperCase());
                    key = cashType == null || !CashTypeEnum.AS.equals((Object)cashType) && !CashTypeEnum.AZ.equals((Object)cashType) ? "1" : "0";
                    this.putFilter(key, filterInfo, this.getResultMap(hint.name));
                }
            }
        } else if (hint.name.equalsIgnoreCase("AGE") && !StringUtils.isEmpty((String)(accountNumber = hint.params[1]))) {
            filterInfo = new FormulaFilterInfo();
            filterInfo.setFormulaId(formulaId);
            if (this.setFormulaFilterInfo(filterInfo, accountNumber, hint.params[0], hint.params[2], "0", "0", "0", "0", "Y", hint)) {
                key = this.getBalTableName(orgType, filterInfo.getCurrency(), "Y", isIsIncludingUnposted);
                this.putFilter(key, filterInfo, this.getResultMap(hint.name));
            }
        }
    }

    protected Map getResultMap(String hintName) {
        if (hintName.equalsIgnoreCase("ACCTCASH") || hintName.equalsIgnoreCase("INCASHFLOW")) {
            return this.isSingDyna ? this.acctCashFormulasGroupMap : this.acctCashFormulaMap;
        }
        return this.isSingDyna ? this.acctFormulasGroupMap : this.table_formulaFilters;
    }

    protected void putFilter(String balTableName, FormulaFilterInfo filterInfo, Map map) {
        if (this.isSingDyna) {
            ArrayList<FormulaFilterInfo> filters;
            HashMap<String, ArrayList<FormulaFilterInfo>> filterMap = (HashMap<String, ArrayList<FormulaFilterInfo>>)map.get(filterInfo.getAsstactTypeNumber());
            if (filterMap == null) {
                filterMap = new HashMap<String, ArrayList<FormulaFilterInfo>>();
                map.put(filterInfo.getAsstactTypeNumber(), filterMap);
            }
            if ((filters = (ArrayList<FormulaFilterInfo>)filterMap.get(balTableName)) == null) {
                filters = new ArrayList<FormulaFilterInfo>();
                filterMap.put(balTableName, filters);
            }
            filters.add(filterInfo);
        } else {
            ArrayList<FormulaFilterInfo> filters = (ArrayList<FormulaFilterInfo>)map.get(balTableName);
            if (filters == null) {
                filters = new ArrayList<FormulaFilterInfo>();
                map.put(balTableName, filters);
            }
            filters.add(filterInfo);
        }
    }

    private String getOrgType(String orgType) {
        try {
            return OrgType.getEnum((String)orgType).getName();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"OrgType.getEnum(orgType) error", (Throwable)ex);
            return OrgType.Company.getName();
        }
    }

    private void removeDuble(List formulaList) {
        HashSet<String> tmpMap = new HashSet<String>();
        for (int i = formulaList.size() - 1; i >= 0; --i) {
            if (tmpMap.contains(formulaList.get(i).toString())) {
                formulaList.remove(i);
                continue;
            }
            tmpMap.add(formulaList.get(i).toString());
        }
        tmpMap.clear();
    }

    private void removeDuble(Map<String, String> formulaMap) {
        HashSet<String> tmpMap = new HashSet<String>();
        HashSet<String> removeKey = new HashSet<String>();
        for (String formulaId : formulaMap.keySet()) {
            if (tmpMap.contains(formulaMap.get(formulaId))) {
                removeKey.add(formulaMap.get(formulaId));
                continue;
            }
            tmpMap.add(formulaMap.get(formulaId));
        }
        for (String formulaId : removeKey) {
            formulaMap.remove(formulaId);
        }
        removeKey.clear();
        tmpMap.clear();
    }

    protected boolean setFormulaAccount(FormulaFilterInfo filterInfo, String accountAsstNumber, FormulaHint hint) throws Exception {
        if (!StringUtils.isEmpty((String)accountAsstNumber)) {
            String[] accountAsstNumbers = accountAsstNumber.split("\\|");
            if (this.isSingDyna && !this.initAccountAssts(filterInfo, accountAsstNumbers, hint)) {
                return false;
            }
            if (hint.name.equalsIgnoreCase("ACCTCASH")) {
                String cashFlowNumber = accountAsstNumbers[0];
                filterInfo.setCashFlowNumber(cashFlowNumber);
            } else {
                this.parseAsstAct(accountAsstNumber);
                accountAsstNumber = accountAsstNumbers[0];
                String[] accounts = accountAsstNumber.split(":");
                if (accounts.length > 1) {
                    filterInfo.setStartAccount(accounts[0]);
                    filterInfo.setEndAccount(accounts[1]);
                } else {
                    filterInfo.setStartAccount(accountAsstNumber);
                    filterInfo.setEndAccount(accountAsstNumber);
                }
            }
        }
        return true;
    }

    protected boolean initAccountAssts(FormulaFilterInfo filterInfo, String[] accountAssts, FormulaHint hint) throws Exception {
        for (int i = 1; i <= (accountAssts.length - 1) / 2; ++i) {
            String asstType = accountAssts[i * 2 - 1];
            String asstValue = accountAssts[i * 2];
            if (StringUtils.isEmpty((String)asstValue) || asstValue.trim().indexOf("@") < 0 || StringUtils.isEmpty((String)asstType)) continue;
            filterInfo.setAsstactTypeNumber(asstType);
            return true;
        }
        return false;
    }

    protected boolean setFormulaFilterInfo(FormulaFilterInfo filterInfo, String accountNumber, String orgUnitNumber, String currencyNumber, String startYear, String startPeriod, String endYear, String endPeriod, String periodType, FormulaHint hint) {
        try {
            if (!this.setFormulaAccount(filterInfo, accountNumber, hint)) {
                return false;
            }
            if (!StringUtils.isEmpty((String)orgUnitNumber)) {
                filterInfo.setCompanyNumber(orgUnitNumber);
            } else {
                filterInfo.setCompanyNumber(this.company.getNumber());
            }
            if (!StringUtils.isEmpty((String)currencyNumber)) {
                filterInfo.setCurrency(currencyNumber);
            } else {
                filterInfo.setCurrency(this.getCurrencyNubmer());
            }
            filterInfo.setPeriodType(periodType);
            int[] startYearPeriod = this.getYearAndPeriod(Integer.parseInt(startYear), Integer.parseInt(startPeriod), true);
            int[] endYearPeriod = this.getYearAndPeriod(Integer.parseInt(endYear), Integer.parseInt(endPeriod), false);
            filterInfo.setStartYear(String.valueOf(startYearPeriod[0]));
            filterInfo.setStartPeriod(String.valueOf(startYearPeriod[1]));
            filterInfo.setEndYear(String.valueOf(endYearPeriod[0]));
            if (this.maxPeriod != -1 && endYearPeriod[0] == this.baseEndYear && endYearPeriod[1] == this.baseEndPeriod) {
                filterInfo.setEndPeriod(String.valueOf(this.maxPeriod));
            } else {
                filterInfo.setEndPeriod(String.valueOf(endYearPeriod[1]));
            }
            this.handleFormulaIds.add(filterInfo.getFormulaId());
        }
        catch (Exception ex) {
            LOGGER.error((Object)"setFormulaFilterInfo error.", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected void parseAsstAct(String accountNumber) {
        if (!StringUtils.isEmpty((String)accountNumber)) {
            if (this.asstActTypeNumber2AttribeMap != null) {
                boolean isEmpt;
                if (!DynamicTemplateUtility.isInclude(accountNumber)) {
                    return;
                }
                String[] arr = accountNumber.split("\\|");
                String asstType = null;
                String asstValue = null;
                List<String> values = null;
                List<String> tmpValues = null;
                HashMap<String, List<String>> tpmAsstTypeNumber_value = null;
                boolean bl = isEmpt = this.asstTypeNumber_value == null;
                if (isEmpt) {
                    this.asstTypeNumber_value = new HashMap<String, List<String>>();
                } else {
                    if (this.asstTypeNumber_value.isEmpty()) {
                        return;
                    }
                    tpmAsstTypeNumber_value = new HashMap<String, List<String>>();
                }
                for (int i = 1; i <= (arr.length - 1) / 2; ++i) {
                    asstType = arr[i * 2 - 1];
                    asstValue = arr[i * 2];
                    if (!this.asstActTypeNumber2AttribeMap.containsKey(asstType)) continue;
                    values = this.asstTypeNumber_value.get(asstType);
                    if (isEmpt) {
                        if (values == null) {
                            values = new ArrayList<String>();
                        }
                        if (!(asstValue = asstValue.substring(asstValue.lastIndexOf("#") + 1)).trim().equals("@") && !values.contains(asstValue)) {
                            values.add(asstValue);
                        }
                        if (asstValue.indexOf(":") >= 0) continue;
                        this.asstTypeNumber_value.put(asstType, values);
                        continue;
                    }
                    if (values != null && !values.isEmpty()) {
                        tmpValues = (ArrayList)tpmAsstTypeNumber_value.get(asstType);
                        if (tmpValues == null) {
                            tmpValues = new ArrayList();
                        }
                        if (!(asstValue = asstValue.substring(asstValue.lastIndexOf("#") + 1)).trim().equals("@") && !tmpValues.contains(asstValue) && values.contains(asstValue)) {
                            tmpValues.add(asstValue);
                        }
                        tpmAsstTypeNumber_value.put(asstType, tmpValues);
                        continue;
                    }
                    asstValue = asstValue.substring(asstValue.lastIndexOf("#") + 1);
                    if (values == null || !asstValue.trim().equals("@") || (tmpValues = (List)tpmAsstTypeNumber_value.get(asstType)) != null) continue;
                    tmpValues = new ArrayList();
                    tpmAsstTypeNumber_value.put(asstType, tmpValues);
                }
                if (!isEmpt) {
                    this.asstTypeNumber_value.clear();
                    this.asstTypeNumber_value = tpmAsstTypeNumber_value;
                }
            } else {
                String[] arr = accountNumber.split("\\|");
                String asstType = null;
                String asstValue = null;
                if (this.asstTypeNumber_value == null) {
                    this.asstTypeNumber_value = new HashMap<String, List<String>>();
                }
                if (!this.asstTypeNumber_value.isEmpty() && this.asstTypeNumber_value.size() != (arr.length - 1) / 2) {
                    this.isAsstActTypeSame = false;
                }
                List<String> values = null;
                boolean isEmpt = this.asstTypeNumber_value.isEmpty();
                for (int i = 1; i <= (arr.length - 1) / 2; ++i) {
                    asstType = arr[i * 2 - 1];
                    asstValue = arr[i * 2];
                    if (asstValue.trim().equals("@")) {
                        this.asstActTypeNumberSet.add(asstType);
                    }
                    if (!isEmpt && !this.asstTypeNumber_value.containsKey(asstType)) {
                        this.isAsstActTypeSame = false;
                    }
                    if ((values = this.asstTypeNumber_value.get(asstType)) == null) {
                        values = new ArrayList<String>();
                    }
                    if (!asstValue.trim().equals("@") && !values.contains(asstValue)) {
                        values.add(asstValue);
                    }
                    this.asstTypeNumber_value.put(asstType, values);
                }
            }
        }
    }

    protected int[] getYearAndPeriod(int year, int period, boolean isStart) {
        int[] yearAndPeriod = null;
        PeriodHandler periodHandler = new PeriodHandler();
        int baseYear = isStart ? this.baseStartYear : this.baseEndYear;
        int basePeriod = isStart ? this.baseStartPeriod : this.baseEndPeriod;
        yearAndPeriod = periodHandler.action(year, period, baseYear, basePeriod, RptPeriodTypeEnum.getEnum((int)this.Period_Type), this.periodColl, this.isMergeByFiscalPeriod);
        if (this.Period_Type != null && this.Period_Type != 3) {
            yearAndPeriod = FiscalPeriodHelper.getYearAndFirstOrLastPeriodNumber((PeriodCollection)this.periodColl, (int)yearAndPeriod[0], (int)yearAndPeriod[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.Period_Type), (boolean)this.isMergeByFiscalPeriod, (boolean)isStart);
        }
        return yearAndPeriod;
    }

    private static int getInt(Object value, int defaultValue) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public boolean isAccordFillItem() {
        return this.isAccordFillItem;
    }

    public String getCurrencyNubmer() {
        String currency = this.reportVariables.getStringValue("Currency", this.sheetName);
        if (StringUtils.isEmpty((String)currency)) {
            return (String)this.adapter.getReportProperty("Currency.Number");
        }
        return currency;
    }

    public String getBalTableName(String orgType, String currencyNumber, String balType, boolean isIncludingUnPosted) {
        if (OrgType.ProfitCenter.getName().equalsIgnoreCase(orgType)) {
            if (!isIncludingUnPosted) {
                if ("GLC".equals(currencyNumber)) {
                    if (RptUtil.findString((String)balType, (String)",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                        return "T_PCA_PcAssistBalance_5R";
                    }
                    return "T_PCA_PcAssistBalance_5L";
                }
                if ("GRC".equals(currencyNumber)) {
                    if (RptUtil.findString((String)balType, (String)",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                        return "T_PCA_PcAssistBalance_5L";
                    }
                    return "T_PCA_PcAssistBalance_5R";
                }
                return "T_PCA_PcAssistBalance_5F";
            }
            if ("GLC".equals(currencyNumber)) {
                if (RptUtil.findString((String)balType, (String)",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_PCA_PcAssistBalance_1R";
                }
                return "T_PCA_PcAssistBalance_1L";
            }
            if ("GRC".equals(currencyNumber)) {
                if (RptUtil.findString((String)balType, (String)",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_PCA_PcAssistBalance_1L";
                }
                return "T_PCA_PcAssistBalance_1R";
            }
            return "T_PCA_PcAssistBalance_1F";
        }
        if (!isIncludingUnPosted) {
            if ("GLC".equals(currencyNumber)) {
                if (RptUtil.findString((String)balType, (String)",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AssistBalance_5R";
                }
                return "T_GL_AssistBalance_5L";
            }
            if ("GRC".equals(currencyNumber)) {
                if (RptUtil.findString((String)balType, (String)",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AssistBalance_5L";
                }
                return "T_GL_AssistBalance_5R";
            }
            return "T_GL_AssistBalance_5F";
        }
        if ("GLC".equals(currencyNumber)) {
            if (RptUtil.findString((String)balType, (String)",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                return "T_GL_AssistBalance_1R";
            }
            return "T_GL_AssistBalance_1L";
        }
        if ("GRC".equals(currencyNumber)) {
            if (RptUtil.findString((String)balType, (String)",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                return "T_GL_AssistBalance_1L";
            }
            return "T_GL_AssistBalance_1R";
        }
        return "T_GL_AssistBalance_1F";
    }

    public Map<String, List<FormulaFilterInfo>> getAcctCashFormulaMap() {
        return this.acctCashFormulaMap;
    }

    public Map<String, Map<String, List<FormulaFilterInfo>>> getAcctFormulasGroupMap() {
        return this.acctFormulasGroupMap;
    }

    public Map<String, Map<String, List<FormulaFilterInfo>>> getAcctCashFormulasGroupMap() {
        return this.acctCashFormulasGroupMap;
    }

    public Set<String> getHandleFormulaIds() {
        return this.handleFormulaIds;
    }
}

