/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.fill.DynaItemBeforeFill;
import com.kingdee.eas.fi.gr.dynamic.fill.IFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GradeFillDynaItem
implements IFillDynaItem {
    private static final Logger logger = Logger.getLogger(GradeFillDynaItem.class);
    private static final long serialVersionUID = -5419844443886982916L;
    private final Sheet sheet;
    private final Point point;
    private boolean isLeftUp = true;
    private boolean isVertical = true;
    private final DynaParameters param;
    private FillRange range;
    private DItemGradeInfo gradeInfo;
    private List datas;
    private boolean cover;
    private Map filledItems = new HashMap();
    private final Point activePoint;
    private RptSheetSytleInheritParam styleParam;
    private String grade = "";
    private Point _base = null;
    private boolean isShowNumber = false;
    private int maxFillSize = 2000;

    public GradeFillDynaItem(DynaItemBeforeFill dynaItemBeforeFill) throws Exception {
        this.sheet = dynaItemBeforeFill.getCurSheet();
        this.activePoint = dynaItemBeforeFill.getActivePoint();
        this.maxFillSize = dynaItemBeforeFill.getMaxFillSize();
        int left = dynaItemBeforeFill.getLeft();
        int top = dynaItemBeforeFill.getTop();
        this.param = dynaItemBeforeFill.getParam();
        this.isShowNumber = this.param.getDynaItemShowType() == 1;
        this.point = new Point(left, top);
        this.isLeftUp = this.param.getPosition() == 1;
        this.isVertical = this.param.getSpreadStyle() == 0;
        this.gradeInfo = dynaItemBeforeFill.getGradeInfo();
        this.initParm();
        dynaItemBeforeFill.setGrade(this.grade);
    }

    private void initParm() throws Exception {
        int end;
        int start;
        int selectRowOrCol = this.isVertical ? this.activePoint.y : this.activePoint.x;
        int startRowOrCol = this.isVertical ? this.point.y : this.point.x;
        int endRowOrCol = startRowOrCol + this.param.getDefaultCounter();
        if (selectRowOrCol <= startRowOrCol || selectRowOrCol > endRowOrCol) {
            throw new EASBizException(new NumericExceptionSubItem("4", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange")));
        }
        this.range = this.investigate();
        int base = 0;
        int n = base = this.cover ? this.range.startPos : this.range.lastDetail;
        ItemFormula item = UserObjectHelper.getItemFormula((Range)this.sheet.getRange(this.isVertical ? (this.isLeftUp ? this.range.startPos : this.range.endPos) : this.point.y, this.isVertical ? this.point.x : (this.isLeftUp ? this.range.startPos : this.range.endPos)));
        if (item != null) {
            this.grade = item.getExt("GRADE_NUMBER");
        }
        int pos = 0 + base + 1;
        int row = this.isVertical ? pos : this.point.y;
        int col = this.isVertical ? this.point.x : pos;
        Point _point = new Point(col, row);
        this._base = DynamicTemplateUtility.getBasePoint(this.sheet, _point, DynamicTemplateUtility.getBasePointList(this.sheet));
        if (this._base == null) {
            if (this.isVertical) {
                --_point.y;
            } else {
                --_point.x;
            }
            this._base = DynamicTemplateUtility.getBasePoint(this.sheet, _point, DynamicTemplateUtility.getBasePointList(this.sheet));
        }
        if (!this.isVertical) {
            start = this._base.y + 1;
            end = this.sheet.getRows().getMaxIntMark() + 1;
        } else {
            start = this._base.x + 1;
            end = this.sheet.getCols().getMaxIntMark() + 1;
        }
        for (int i = start; i <= end; ++i) {
            String rptFormula;
            String tempFormula = null;
            int srcRowIndex = -1;
            int srcColIndex = -1;
            if (this.gradeInfo != null) {
                tempFormula = this.gradeInfo.getTempFormuma(this.grade + "---" + i);
                String indexTemp = this.gradeInfo.getTempFormulaIndexMap(this.grade + "---" + i);
                if (indexTemp != null) {
                    String[] indexs = indexTemp.split(",");
                    srcRowIndex = Integer.parseInt(indexs[0]);
                    srcColIndex = Integer.parseInt(indexs[1]);
                }
            }
            Cell cell = null;
            if (this.isVertical) {
                cell = this.sheet.getCell(this.range.startPos + 1, i, true);
                if (this.range.startPos == this.point.y && this.gradeInfo != null) {
                    this.gradeInfo.setTempFormula(this.grade + "---" + i, null);
                }
            } else {
                cell = this.sheet.getCell(i, this.range.startPos + 1, true);
                if (this.gradeInfo != null && this.range.startPos == this.point.x) {
                    this.gradeInfo.setTempFormula(this.grade + "---" + i, null);
                }
            }
            if (!StringUtils.isEmpty((String)(rptFormula = cell.getFormula())) && rptFormula.indexOf("@") >= 0) {
                rptFormula = DynamicTemplateUtility.handleDySpecialStr(cell, rptFormula);
            }
            if (this.gradeInfo != null && rptFormula != null && (StringUtils.isEmpty((String)tempFormula) || rptFormula.indexOf("@") >= 0)) {
                this.gradeInfo.setTempFormula(this.grade + "---" + i, rptFormula);
                this.gradeInfo.setTempFormulaIndexMap(this.grade + "---" + i, cell.getRow() + "," + cell.getCol());
                continue;
            }
            if (this.gradeInfo == null || StringUtils.isEmpty((String)tempFormula)) continue;
            if (rptFormula != null) {
                ItemFormula itemFormula;
                Expression expression;
                boolean isHavSpecialExpr;
                boolean isIncludeExceRef = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)this.sheet, (String)tempFormula);
                if (!isIncludeExceRef && (isHavSpecialExpr = ExcelFormulaPaserHelper.isHavSpecialExpr((Expression)(expression = ExcelFormulaPaserHelper.parse((String)tempFormula)))) && ExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)expression)) {
                    isIncludeExceRef = true;
                }
                if (isIncludeExceRef && (itemFormula = UserObjectHelper.getItemFormula((Cell)cell)) != null && itemFormula.getDItemNumber() != null) {
                    String ditemNumber = itemFormula.getDItemNumber();
                    int lastIndex = ditemNumber.lastIndexOf("!");
                    if (lastIndex > 0) {
                        ditemNumber = ditemNumber.substring(lastIndex + 1);
                    }
                    tempFormula = rptFormula.replace(ditemNumber, "@");
                    srcRowIndex = cell.getRow();
                    srcColIndex = cell.getCol();
                }
            }
            if (srcRowIndex != -1 && srcColIndex != -1) {
                tempFormula = DynamicTemplateUtility.offerFormula(tempFormula, this.sheet, srcRowIndex, srcColIndex, cell.getRow(), cell.getCol());
            }
            this.gradeInfo.setTempFormula(this.grade + "---" + i, tempFormula);
            this.gradeInfo.setTempFormulaIndexMap(this.grade + "---" + i, cell.getRow() + "," + cell.getCol());
        }
    }

    @Override
    public void setFillData(List fillData) {
        this.datas = fillData;
    }

    @Override
    public void prepare() throws Exception {
        Point inheriPoint = null;
        int interitCol = this.isVertical ? this.point.x : this.range.startPos;
        int interitRow = this.isVertical ? this.range.startPos : this.point.y;
        inheriPoint = new Point(interitCol, interitRow);
        int needSize = this.datas.size();
        if (!this.cover) {
            HashMap<Object, String> gradeItems = new HashMap<Object, String>();
            for (int i = this.range.startPos; i <= this.range.lastDetail; ++i) {
                int tempCol = this._base.x;
                if (this.sheet.getCell(i + 1, tempCol, true).getValue().getValue() instanceof String) {
                    gradeItems.put(((String)this.sheet.getCell(i + 1, tempCol, true).getValue().getValue()).trim(), "");
                    continue;
                }
                gradeItems.put(this.sheet.getCell(i + 1, tempCol, true).getValue().getValue(), "");
            }
            AsstActObject ditem = null;
            for (int k = needSize - 1; k >= 0; --k) {
                ditem = (AsstActObject)this.datas.get(k);
                if (!gradeItems.containsKey(ditem.getName())) continue;
                this.datas.remove(k);
            }
            this.filledItems.put(this.grade, gradeItems);
        }
        needSize = this.datas.size();
        int start = this.cover ? this.range.startPos : this.range.lastDetail;
        int gulf = this.range.endPos - start - (this.range.endPos == start ? 0 : 1);
        int diff = needSize - gulf;
        InsertType type = InsertType.NOSTYLE;
        if (diff > 0) {
            boolean isListener = DynaItemListener.getisListener();
            DynaItemListener.setListener(false);
            if (this.isVertical) {
                Range r = this.sheet.getRowRange(this.range.endPos, this.range.endPos + diff - 1);
                UserObjectHelper.getUnprotectedRange((Range)r).insert(true, type);
            } else {
                Range r = this.sheet.getColRange(this.range.endPos, this.range.endPos + diff - 1);
                UserObjectHelper.getUnprotectedRange((Range)r).insert(false, type);
            }
            DynamicTemplateUtility.saveDiff(this.sheet, this.gradeInfo, this.grade, diff);
            DynaItemListener.setListener(isListener);
            this.adjust(diff);
        } else if (diff < 0 && this.cover) {
            boolean isListener = DynaItemListener.getisListener();
            DynaItemListener.setListener(false);
            for (int i = 0; i < 0 - diff; ++i) {
                int j = start + needSize + 1;
                Range r = this.isVertical ? this.sheet.getRowRange(j, j) : this.sheet.getColRange(j, j);
                UserObjectHelper.getUnprotectedRange((Range)r).delete();
                DynamicTemplateUtility.textGradeAfterDeleteRange(this.sheet, r);
            }
            DynaItemListener.setListener(isListener);
            this.adjust(diff);
        }
        if (this.styleParam == null) {
            this.styleParam = new RptSheetSytleInheritParam();
        }
        if (this.isVertical) {
            this.styleParam.setStandardPoint(inheriPoint);
            if (this.cover) {
                this.styleParam.setStartRow(inheriPoint.y + 2);
                this.styleParam.setExistRow(0);
            } else {
                this.styleParam.setStartRow(this.range.lastDetail - this.range.startPos > 0 ? start + 1 : start + 2);
                this.styleParam.setExistRow(this.range.lastDetail - this.range.startPos);
            }
            this.styleParam.setEndRow(start + needSize);
            this.styleParam.setStartColumn(this.isShowNumber ? inheriPoint.x - 1 : inheriPoint.x);
            this.styleParam.setEndColumn(this.sheet.getCols().getMaxIntMark());
        } else {
            this.styleParam.setStandardPoint(inheriPoint);
            if (this.cover) {
                this.styleParam.setStartColumn(inheriPoint.x + 2);
                this.styleParam.setExistRow(0);
            } else {
                this.styleParam.setStartColumn(inheriPoint.x == start ? start + 2 : start + 1);
                this.styleParam.setExistCol(this.range.lastDetail - this.range.startPos);
            }
            this.styleParam.setStartRow(this.isShowNumber ? inheriPoint.y - 1 : inheriPoint.y);
            this.styleParam.setEndRow(this.sheet.getRows().getMaxIntMark());
            this.styleParam.setEndColumn(start + needSize);
        }
        this.styleParam.setVerticalInherit(this.isVertical);
        this.styleParam.setGradeFill(true);
        this.styleParam.setGrade(this.grade);
        this.styleParam.setGradeInfo(this.gradeInfo);
    }

    private void adjust(int diff) {
        this.range.endPos += diff;
        this.param.setDefaultCounter(this.param.getDefaultCounter() + diff);
        DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.point.y, this.point.x)), this.param);
    }

    private boolean isLeaf(List list, AsstActObject obj) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                AsstActObject obj2 = (AsstActObject)list.get(i);
                if (obj == obj2 || !(obj2.getLongNumber() + "!").startsWith(obj.getLongNumber() + "!")) continue;
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"is Leaf error", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill() throws EASBizException, BOSException {
        if (this.datas == null) {
            return;
        }
        logger.info((Object)"fillTextGradeItem--start");
        int base = 0;
        int n = base = this.cover ? this.range.startPos : this.range.lastDetail;
        ItemFormula item = UserObjectHelper.getItemFormula((Range)this.sheet.getRange(this.isVertical ? (this.isLeftUp ? this.range.startPos : this.range.endPos) : this.point.y, this.isVertical ? this.point.x : (this.isLeftUp ? this.range.startPos : this.range.endPos)));
        if (item == null) {
            return;
        }
        String grade = item.getExt("GRADE_NUMBER");
        if (grade == null) {
            return;
        }
        DItemGradeEntryInfo parentGrade = this.gradeInfo.find(grade);
        int index = 0;
        Map gradeItems = (Map)this.filledItems.get(grade);
        ArrayList basePointListForFill = DynamicTemplateUtility.getBasePointList(this.sheet);
        for (int i = 0; i < this.datas.size(); ++i) {
            try {
                DynaItemListener.setAutoFillTextGradeSum(true);
                AsstActObject ditem = (AsstActObject)this.datas.get(i);
                if (!ditem.isBizUnit() || !this.cover && gradeItems != null && gradeItems.containsKey(ditem.getName())) continue;
                boolean isLeaf = true;
                if (ditem.isSelfAsstActaiatem() && this.param.isGrade() && this.param.getDynaItemSource() == 0) {
                    isLeaf = this.isLeaf(this.datas, ditem);
                    if (!isLeaf) continue;
                    ditem.setLeaf(isLeaf);
                }
                int pos = index + base + 1;
                Range range = UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.isVertical ? pos : this.point.y, this.isVertical ? this.point.x : pos));
                DynaItemListener.autoFillFormula(this.sheet, this.isVertical ? pos : this.point.y, this.isVertical ? this.point.x : pos, ditem.getLongNumber() == null ? ditem.getNumber() : ditem.getLongNumber(), ditem.getNumber(), index, grade, false, basePointListForFill);
                DynaItemListener.setExeFlag(false);
                range.setValue(new Variant((Object)(parentGrade.getIdentBlank() + parentGrade.getParentIndentBlank() + ditem.getName())));
                ItemFormula a = UserObjectHelper.getItemFormula((Range)range, (boolean)true);
                a.putExt("GRADE_NUMBER", parentGrade.getGrade() + ".D");
            }
            finally {
                DynaItemListener.setExeFlag(true);
                DynaItemListener.setAutoFillTextGradeSum(true);
            }
            ++index;
        }
        if (this.getStyleParam().isVerticalInherit() && this.getStyleParam().getStartRow() < this.getStyleParam().getEndRow() + 1 || !this.getStyleParam().isVerticalInherit() && this.getStyleParam().getStartColumn() < this.getStyleParam().getEndColumn() + 1) {
            StyleDecoratorHeightOrWidth sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
            if (!this.cover) {
                if (this.getStyleParam().isVerticalInherit()) {
                    this.getStyleParam().setEndRow(this.getStyleParam().getEndRow() - this.datas.size() + index);
                } else {
                    this.getStyleParam().setEndColumn(this.getStyleParam().getEndColumn() - this.datas.size() + index);
                }
            }
            sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
            sytleInherit.regionInheritStyleByDefaultPoint(this.sheet, this.getStyleParam());
        }
        DynamicTemplateUtility.autoAdjustGradeSum(this.sheet, this.param, this.point, this.activePoint);
        logger.info((Object)"fillTextGradeItem--end");
    }

    private FillRange investigate() {
        FillRange r = new FillRange();
        r.startPos = this.findStartPos(this.activePoint, this.point);
        r.endPos = this.findEndPos(this.activePoint, this.point);
        r.lastDetail = this.findLastDetail(r.startPos, r.endPos);
        if (r.startPos == r.endPos && r.endPos == r.lastDetail) {
            Point active = new Point(this.activePoint);
            if (this.isVertical) {
                active.y = this.param.getPosition() == 2 ? --active.y : ++active.y;
            } else {
                active.x = this.param.getPosition() == 2 ? --active.x : ++active.x;
            }
            r.endPos = this.findEndPos(active, this.point);
            r.startPos = this.findStartPos(active, this.point);
            r.lastDetail = this.findLastDetail(r.startPos, r.endPos);
            if (r.endPos == r.startPos) {
                if (!this.isLeftUp) {
                    ++r.endPos;
                } else {
                    --r.startPos;
                }
            }
        } else if (r.startPos == r.endPos) {
            if (!this.isLeftUp) {
                --r.startPos;
            } else {
                ++r.endPos;
            }
        }
        return r;
    }

    private int findLastDetail(int start, int end) {
        int pos = start;
        for (int i = start; i < end; ++i) {
            DItemGradeEntryInfo info;
            String grade;
            ItemFormula item = UserObjectHelper.getItemFormula((Range)this.sheet.getRange(this.isVertical ? i : this.point.y, this.isVertical ? this.point.x : i));
            if (item == null || (grade = item.getExt("GRADE_NUMBER")) == null || (info = this.gradeInfo.findParent(grade)) == null) continue;
            pos = i;
        }
        return pos;
    }

    private int findEndPos(Point active, Point base) {
        int pos;
        ItemFormula item;
        int i;
        int col = active.x;
        int row = active.y;
        UserObjectHelper.getItemFormula((Range)this.sheet.getRange(21, 0));
        for (i = pos = this.isVertical ? row : col; i <= this.param.getDefaultCounter() + (this.isVertical ? this.point.y : this.point.x) && !this.isSumLineOrEnd(item = UserObjectHelper.getItemFormula((Range)this.sheet.getRange(this.isVertical ? i : base.y, this.isVertical ? base.x : i))); ++i) {
        }
        return i;
    }

    private int findStartPos(Point active, Point base) {
        int pos;
        ItemFormula item;
        int i;
        int col = active.x;
        int row = active.y;
        for (i = pos = this.isVertical ? row : col; i > 0 && !this.isSumLineOrEnd(item = UserObjectHelper.getItemFormula((Range)this.sheet.getRange(this.isVertical ? i : this.point.y, this.isVertical ? this.point.x : i))); --i) {
        }
        return i;
    }

    private boolean isSumLineOrEnd(ItemFormula item) {
        if (item == null) {
            return false;
        }
        if (item.isBasePoint()) {
            return true;
        }
        String grade = item.getExt("GRADE_NUMBER");
        if (grade == null) {
            return false;
        }
        DItemGradeEntryInfo info = this.gradeInfo.find(grade);
        return info != null;
    }

    public String getGrade(int row, int col) {
        Cell cell = this.sheet.getCell(row, col, false);
        if (cell == null) {
            return null;
        }
        return this.getGrade(UserObjectHelper.getItemFormula((Cell)cell));
    }

    public String getGrade(ItemFormula item) {
        if (item == null) {
            return null;
        }
        return item.getExt("GRADE_NUMBER");
    }

    public RptSheetSytleInheritParam getStyleParam() {
        return this.styleParam;
    }

    @Override
    public void setCoverRecord(boolean isCoverRecord) {
        this.cover = isCoverRecord;
    }

    @Override
    public int getAppendSize() {
        return 0;
    }

    class FillRange {
        int startPos;
        int endPos;
        int lastDetail;

        FillRange() {
        }
    }
}

