/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.fill.DynaItemBeforeFill;
import com.kingdee.eas.fi.gr.dynamic.fill.IFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class NormalFillDynaItem
implements IFillDynaItem {
    private static final Logger logger = Logger.getLogger(NormalFillDynaItem.class);
    private static final long serialVersionUID = 2646841890973957344L;
    protected Sheet curSheet = null;
    private int top;
    private int left;
    private int rowCount;
    private int colCount;
    private int spreadStyle;
    private DynaParameters param;
    private static final String fomula_Cell_Key = "fomula_Cell_Key";
    private static final String fomula_Cell_Key_Str = "fomula_Cell_Key_Str";
    private ArrayList basePointList = null;
    private Point activePoint = null;
    private int appendSize;
    private boolean isGenerateDyItemFormula = true;
    private boolean isRptCover = false;
    private int lastRow = -1;
    private int lastCol = -1;
    private boolean isIncludeOtherDC = false;
    private String curView = "0";
    private boolean isReport = false;
    private String rptDataCollectNumber = "ACTUALDATA";
    private DynaItemBeforeFill dynaItemBeforeFill;
    private int maxFillSize = 2000;
    private boolean isCoverRecord;
    private List fillData;
    private DynaRptBasePointIndexHandle indexHandle = null;
    private int formulaStartIndex = 0;
    private int[] sumFormulaRangeIndex = null;

    @Override
    public int getAppendSize() {
        return this.appendSize;
    }

    public void setAppendSize(int appendSize) {
        this.appendSize = appendSize;
    }

    public NormalFillDynaItem(DynaItemBeforeFill dynaItemBeforeFill, boolean isIncludeOtherDC, String curView, String rptDataCollectNumber) {
        this.dynaItemBeforeFill = dynaItemBeforeFill;
        this.isIncludeOtherDC = isIncludeOtherDC;
        this.curView = curView;
        this.rptDataCollectNumber = rptDataCollectNumber;
    }

    private boolean isSumItem(int index) {
        for (int i = 0; i < this.sumFormulaRangeIndex.length - 1; ++i) {
            if (this.sumFormulaRangeIndex[i] != index) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepare() {
        this.curSheet = this.dynaItemBeforeFill.getCurSheet();
        this.isGenerateDyItemFormula = NewRptUtil.isGenerateDyItemFormula((Book)this.curSheet.getBook());
        this.activePoint = this.dynaItemBeforeFill.getActivePoint();
        this.maxFillSize = this.dynaItemBeforeFill.getMaxFillSize();
        this.left = this.dynaItemBeforeFill.getLeft();
        this.top = this.dynaItemBeforeFill.getTop();
        this.param = this.dynaItemBeforeFill.getParam();
        this.spreadStyle = this.param.getSpreadStyle();
        Point basePoint = new Point(this.left, this.top);
        this.indexHandle = new DynaRptBasePointIndexHandle(this.param, basePoint, this.curSheet, true, this.isReport);
        this.isRptCover = this.dynaItemBeforeFill.getIsRptCover();
        if (this.spreadStyle == 0) {
            this.colCount = this.getColCount();
            this.sumFormulaRangeIndex = this.indexHandle.getSumRangeIndex(true);
            this.rowCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
        } else {
            this.rowCount = this.getRowCount();
            this.sumFormulaRangeIndex = this.indexHandle.getSumRangeIndex(false);
            this.colCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
        }
        this.formulaStartIndex = this.sumFormulaRangeIndex[4];
        this.lastRow = -1;
        this.lastCol = -1;
    }

    private void locationRange() throws EASBizException, BOSException {
        this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
        if (this.basePointList.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_BasePointIsNull")));
        }
        Point basePoint = this.dynaItemBeforeFill.initBasePoint(this.curSheet, this.basePointList, this.activePoint);
        this.left = basePoint.x;
        this.top = basePoint.y;
        this.param = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, this.top, this.left);
        this.spreadStyle = this.param.getSpreadStyle();
        if (this.spreadStyle == 0) {
            this.colCount = this.getColCount();
            this.rowCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
        } else {
            this.rowCount = this.getRowCount();
            this.colCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
        }
    }

    @Override
    public void setFillData(List fillData) {
        this.fillData = fillData;
    }

    @Override
    public void fill() throws EASBizException, BOSException {
        if (this.fillData == null) {
            return;
        }
        int itemCount = this.getItemCount(this.fillData);
        try {
            logger.info((Object)"fillNormalItem--start");
            if (this.fillData.size() <= this.maxFillSize) {
                this.fillNormalItem(this.fillData, true);
            } else {
                ArrayList list = new ArrayList(this.maxFillSize);
                int size = this.fillData.size();
                for (int i = 0; i < size; ++i) {
                    if (i % this.maxFillSize == 0 && i > 0) {
                        this.fillNormalItem(list, i == this.maxFillSize);
                        list.clear();
                    }
                    list.add(this.fillData.get(i));
                    if (i != size - 1) continue;
                    this.fillNormalItem(list, false);
                }
                list.clear();
            }
            if (this.param.getDynaItemSource() != 0 && this.param.isGrade()) {
                this.locationRange();
                this.refreshExcelFormula(itemCount);
                this.grade();
            }
            logger.info((Object)"fillNormalItem--end");
        }
        catch (SyntaxErrorException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void fillNormalItem(List fillDataListOld, boolean isFirstFill) throws SyntaxErrorException {
        boolean isCoverRecord = this.isCoverRecord && isFirstFill;
        boolean isType = this.param.isGrade() && this.param.getDynaItemSource() == 1;
        int dynaItemSource = this.param.getDynaItemSource();
        ArrayList<AsstActObject> fillDataList = new ArrayList<AsstActObject>();
        for (int i = 0; i < fillDataListOld.size(); ++i) {
            AsstActObject ditemInfo = (AsstActObject)fillDataListOld.get(i);
            if (!this.isRptCover && !ditemInfo.isBizUnit() && (this.param.getDynaItemSource() != 1 || !this.param.isGrade())) continue;
            boolean isLeaf = true;
            if (ditemInfo.isSelfAsstActaiatem() && !isType) {
                isLeaf = CslRptUtil.isLeaf((List)fillDataListOld, (AsstActObject)ditemInfo);
                if (!isLeaf) continue;
                ditemInfo.setLeaf(isLeaf);
            }
            fillDataList.add(ditemInfo);
        }
        int itemCount = this.getItemCount(fillDataList);
        if (itemCount <= 0) {
            return;
        }
        HashMap<String, String> names = new HashMap<String, String>();
        if (!isFirstFill) {
            if (this.spreadStyle == 0) {
                this.rowCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
            } else {
                this.colCount = this.param.getDefaultCounter() + 1 + this.indexHandle.getSumRangeCount();
            }
        }
        if (this.spreadStyle == 0) {
            int i;
            ArrayList<AsstActObject> items = fillDataList;
            int row = this.rowCount + this.top - 1;
            for (int col = 0; col < this.colCount; ++col) {
                names.put(row + ":" + col, this.curSheet.getRange(row, col).getName(false, false, true));
            }
            for (int j = this.left + 1; j < this.left + this.colCount; ++j) {
                if (this.isReport) {
                    this.setAutoFillFormulaToHeadCell(j, true, this.rptDataCollectNumber);
                    continue;
                }
                this.setAutoFillFormulaToHeadCell(j, true, "ACTUALDATA");
                if (!this.isIncludeOtherDC) continue;
                this.setAutoFillFormulaToHeadCell(j, true, "BUDGETDATA");
            }
            int lastRow = -1;
            if (!isCoverRecord) {
                this.lastRow = lastRow = this.clearTotalLine(items);
                itemCount = items.size();
                this.setAppendSize(itemCount + this.getAppendSize());
                if (itemCount > 0) {
                    this.insertRowRange(lastRow + 1, itemCount - 1);
                }
            } else {
                int noSumCount;
                if (this.rowCount > 1) {
                    int endRow = this.top + this.rowCount - 1 - this.indexHandle.getAfterDynaItemSumRangeCount();
                    this.clearRange(this.top + this.indexHandle.getBeforeDynaItemSumRangeCount() + 1, this.left, endRow, this.left + this.colCount - 1);
                }
                if ((noSumCount = this.param.getDefaultCounter()) < itemCount) {
                    int count = itemCount - noSumCount - 1;
                    this.insertRowRange(this.top + this.indexHandle.getBeforeDynaItemSumRangeCount() + 1, count);
                } else if (noSumCount > itemCount) {
                    int deletCount = noSumCount - itemCount;
                    int startRow = this.top + this.indexHandle.getBeforeDynaItemSumRangeCount() + 2;
                    UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRowRange(startRow, startRow + deletCount - 1)).delete(true);
                }
                lastRow = this.top + this.indexHandle.getBeforeDynaItemSumRangeCount();
            }
            int firstRowCol = lastRow;
            if (dynaItemSource != 0) {
                for (i = 1; i <= itemCount; ++i) {
                    AsstActObject ditemInfo = (AsstActObject)items.get(i - 1);
                    Range basePointCell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(lastRow + 1, this.left));
                    Range showNumberCell = this.left - 1 >= 0 ? UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(lastRow + 1, this.left - 1)) : null;
                    this.insertDItemName(basePointCell, showNumberCell, ditemInfo, this.param);
                    for (int j = this.left + 1; j < this.left + this.colCount; ++j) {
                        if (this.isReport) {
                            boolean isAc = this.rptDataCollectNumber.equals("ACTUALDATA");
                            this.autoFillFormula(j, lastRow, firstRowCol, ditemInfo, items, isType, true, isAc, true);
                            continue;
                        }
                        this.autoFillFormula(j, lastRow, firstRowCol, ditemInfo, items, isType, true, true, true);
                        if (!this.isIncludeOtherDC) continue;
                        this.autoFillFormula(j, lastRow, firstRowCol, ditemInfo, items, isType, true, false, true);
                    }
                    ++lastRow;
                }
            }
            this.param.setDefaultCounter(lastRow - this.top - this.indexHandle.getBeforeDynaItemSumRangeCount());
            for (i = this.left + 1; i < this.left + this.colCount; ++i) {
                Object itemCellObj;
                Range cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(this.top, i));
                if (cell == null || (itemCellObj = cell.getUserObject("ITEM")) == null || !(itemCellObj instanceof ItemFormula) || ((ItemFormula)itemCellObj).getValueType() == 3) continue;
                this.sumFormulaRangeIndex = this.indexHandle.getNewSumRangeIndex(this.param, true);
                this.indexHandle.setSumFormulaByIndex(this.sumFormulaRangeIndex, true, i);
                CellBlock cb = CellBlock.getNewCellBlock((int)this.sumFormulaRangeIndex[0], (int)i, (int)this.sumFormulaRangeIndex[0], (int)i);
                String refersto = Sheet.getBlockA1Name((CellBlock)cb, (boolean)true);
                String name = (String)names.get(this.rowCount + this.top - 1 + ":" + i);
                if (name == null) continue;
                Range range = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(this.sumFormulaRangeIndex[0], i));
                range.setName(name, refersto);
            }
        } else if (this.spreadStyle == 1) {
            int i;
            ArrayList<AsstActObject> items = fillDataList;
            int row = 0;
            int col = this.colCount + 1;
            while (row < this.rowCount) {
                names.put(++row + ":" + col, this.curSheet.getRange(row, col).getName(false, false, true));
            }
            if (!isCoverRecord) {
                this.setAppendSize(items.size());
            }
            for (int j = this.top + 1; j < this.top + this.rowCount; ++j) {
                if (this.isReport) {
                    this.setAutoFillFormulaToHeadCell(j, false, this.rptDataCollectNumber);
                    continue;
                }
                this.setAutoFillFormulaToHeadCell(j, false, "ACTUALDATA");
                if (!this.isIncludeOtherDC) continue;
                this.setAutoFillFormulaToHeadCell(j, false, "BUDGETDATA");
            }
            int lastCol = -1;
            if (!isCoverRecord) {
                this.lastCol = lastCol = this.clearTotalLine(items);
                itemCount = items.size();
                int count = itemCount;
                if (count > 0) {
                    this.insertColRange(lastCol + 1, count - 1);
                }
            } else {
                int noSumCount;
                if (this.colCount > 1) {
                    int endCol = this.left + this.colCount - 1 - this.indexHandle.getAfterDynaItemSumRangeCount();
                    this.clearRange(this.top, this.left + this.indexHandle.getBeforeDynaItemSumRangeCount() + 1, this.top + this.rowCount - 1, endCol);
                }
                if ((noSumCount = this.param.getDefaultCounter()) < itemCount) {
                    int count = itemCount - noSumCount - 1;
                    this.insertColRange(this.left + this.indexHandle.getBeforeDynaItemSumRangeCount() + 1, count);
                } else if (noSumCount > itemCount) {
                    int deletCount = noSumCount - itemCount;
                    int startCol = this.left + this.indexHandle.getBeforeDynaItemSumRangeCount() + 2;
                    UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getColRange(startCol, startCol + deletCount - 1)).delete(true);
                }
                lastCol = this.left + this.indexHandle.getBeforeDynaItemSumRangeCount();
            }
            int firstRowCol = lastCol;
            if (dynaItemSource != 0) {
                for (i = 1; i <= itemCount; ++i) {
                    AsstActObject ditemInfo = (AsstActObject)items.get(i - 1);
                    Range basePointCell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(this.top, lastCol + 1));
                    Range showNumberCell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(this.top - 1, lastCol + 1));
                    this.insertDItemName(basePointCell, showNumberCell, ditemInfo, this.param);
                    for (int j = this.top + 1; j < this.top + this.rowCount; ++j) {
                        if (this.isReport) {
                            boolean isAc = this.rptDataCollectNumber.equals("ACTUALDATA");
                            this.autoFillFormula(j, lastCol, firstRowCol, ditemInfo, items, isType, false, isAc, false);
                            continue;
                        }
                        this.autoFillFormula(j, lastCol, firstRowCol, ditemInfo, items, isType, false, true, false);
                        if (!this.isIncludeOtherDC) continue;
                        this.autoFillFormula(j, lastCol, firstRowCol, ditemInfo, items, isType, false, false, false);
                    }
                    ++lastCol;
                }
            }
            this.param.setDefaultCounter(lastCol - this.left - this.indexHandle.getBeforeDynaItemSumRangeCount());
            for (i = this.top + 1; i < this.top + this.rowCount; ++i) {
                Object itemCellObj;
                Range cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(i, this.left));
                if (cell == null || (itemCellObj = cell.getUserObject("ITEM")) == null || !(itemCellObj instanceof ItemFormula) || ((ItemFormula)itemCellObj).getValueType() == 3) continue;
                this.sumFormulaRangeIndex = this.indexHandle.getNewSumRangeIndex(this.param, false);
                this.indexHandle.setSumFormulaByIndex(this.sumFormulaRangeIndex, false, i);
                CellBlock cb = CellBlock.getNewCellBlock((int)i, (int)this.sumFormulaRangeIndex[0], (int)i, (int)this.sumFormulaRangeIndex[0]);
                String refersto = Sheet.getBlockA1Name((CellBlock)cb, (boolean)true);
                String name = (String)names.get(i + ":" + (this.colCount + 1));
                if (name == null) continue;
                cell.setName(name, refersto);
            }
        }
        names.clear();
        DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(this.top, this.left)), this.param);
    }

    private void setAutoFillFormulaToHeadCell(int curRowCol, boolean isRow, String dataCollectNumber) {
        int firstColIndex;
        boolean isAc = dataCollectNumber == null ? true : dataCollectNumber.equals("ACTUALDATA");
        int rowIndex = isRow ? this.top : curRowCol;
        int colIndex = isRow ? curRowCol : this.left;
        String formula = null;
        int firstRowIndex = isRow ? this.formulaStartIndex : curRowCol;
        int n = firstColIndex = isRow ? curRowCol : this.formulaStartIndex;
        if (this.curSheet.getRange(firstRowIndex, firstColIndex).getUserObject("isGradeAndNotManual") != null && ((String)this.curSheet.getRange(firstRowIndex, firstColIndex).getUserObject("isGradeAndNotManual")).equals("Y")) {
            Object[] tempFormulas = this.getTempFormulaObject(this.curSheet.getRange(rowIndex, colIndex), isAc);
            String tempFormula = (String)tempFormulas[0];
            if (!StringUtils.isEmpty((String)tempFormula) && this.param.getDynaItemSource() != 0 && this.param.isGrade() && UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex)).getUserObject(fomula_Cell_Key_Str) != null) {
                String str = (String)UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex)).getUserObject(fomula_Cell_Key_Str);
                String[] area = str.split(",");
                int srcRow = Integer.valueOf(area[0]);
                int srcCol = Integer.valueOf(area[1]);
                UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex)).setUserObject(fomula_Cell_Key, (Object)new Integer[]{srcRow, srcCol});
                try {
                    String[] indexs;
                    if (tempFormulas[3] != null && !StringUtils.isEmpty((String)(formula = DynamicTemplateUtility.offerFormula(tempFormula, this.curSheet, Integer.valueOf((indexs = tempFormulas[3].toString().split(","))[0].trim()), Integer.valueOf(indexs[1].trim()), rowIndex, colIndex)))) {
                        this.setTempFormula(this.curSheet.getRange(rowIndex, colIndex), formula, isAc);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"isHavSpecialExpr error.", (Throwable)e);
                }
            }
        } else {
            if (!this.canSetFormula()) {
                return;
            }
            if (!this.isReport) {
                formula = isAc ? (String)this.curSheet.getCell(firstRowIndex, firstColIndex, true).getUserObjectValue("0") : (String)this.curSheet.getCell(firstRowIndex, firstColIndex, true).getUserObjectValue("1");
                if (!StringUtils.isEmpty((String)this.curView) && (isAc && this.curView.equals("0") || !isAc && this.curView.equals("1"))) {
                    formula = this.curSheet.getCell(firstRowIndex, firstColIndex, true).getFormula();
                }
            } else {
                formula = this.curSheet.getCell(firstRowIndex, firstColIndex, true).getFormula();
            }
            if (!StringUtils.isEmpty((String)formula)) {
                if (this.param.getDynaItemSource() != 0 && this.param.isGrade()) {
                    UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex)).setUserObject(fomula_Cell_Key, (Object)new Integer[]{firstRowIndex, firstColIndex});
                    UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex)).setUserObject(fomula_Cell_Key_Str, (Object)(firstRowIndex + "," + firstColIndex));
                }
                formula = CslRptUtil.replaceParamToChar((String)formula);
                formula = DynamicTemplateUtility.handleDySpecialStr(this.curSheet.getCell(firstRowIndex, firstColIndex, true), formula);
                if (formula.indexOf("@") >= 0) {
                    this.setTempFormula(this.curSheet.getRange(rowIndex, colIndex), formula, isAc);
                } else {
                    Object[] tempFormulas = this.getTempFormulaObject(this.curSheet.getRange(rowIndex, colIndex), isAc);
                    String fomula2 = (String)tempFormulas[0];
                    if (fomula2 == null) {
                        this.setTempFormula(this.curSheet.getRange(rowIndex, colIndex), formula, isAc);
                    } else {
                        fomula2 = CslRptUtil.replaceParamToChar((String)fomula2);
                        try {
                            String[] indexs;
                            if (tempFormulas[3] != null && !StringUtils.isEmpty((String)(fomula2 = DynamicTemplateUtility.offerFormula(fomula2, this.curSheet, Integer.valueOf((indexs = tempFormulas[3].toString().split(","))[0].trim()), Integer.valueOf(indexs[1].trim()), rowIndex, colIndex)))) {
                                this.setTempFormula(this.curSheet.getRange(rowIndex, colIndex), fomula2, isAc);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"isHavSpecialExpr error.", (Throwable)e);
                        }
                    }
                }
                Range curRang = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex));
                curRang.setUserObject("isNotFomulaSet", (Object)"false");
            } else {
                Range curRang = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowIndex, colIndex));
                curRang.setUserObject("isNotFomulaSet", (Object)"true");
            }
        }
    }

    private void setTempFormula(Range rang, String fomula, boolean isAC) {
        if (rang != null) {
            String formulaKey = "tempFomula";
            if (!isAC) {
                formulaKey = "tempBGFomula";
            }
            Range curRang = UserObjectHelper.getUnprotectedRange((Range)rang);
            curRang.setUserObject(formulaKey, (Object)fomula);
            if (fomula != null) {
                curRang.setUserObject("isInclude@", (Object)(fomula.indexOf("@") >= 0 ? 1 : 0));
                boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)this.curSheet, (String)fomula);
                curRang.setUserObject("isExcelFunction", (Object)isExcelFunction);
                boolean isHavSpecialExpr = DynamicTemplateUtility.isExcelFormula(fomula);
                if (isHavSpecialExpr) {
                    curRang.setUserObject("isHavSpecialExpr", (Object)(curRang.getBlock(0).getRow() + "," + curRang.getBlock(0).getCol()));
                } else {
                    curRang.setUserObject("isHavSpecialExpr", null);
                }
            }
        }
    }

    private void insertRowRange(int site, int range) {
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRowRange(site, site + range)).insert(true, InsertType.NOSTYLE);
    }

    private void insertColRange(int site, int range) {
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getColRange(site, site + range)).insert(true, InsertType.NOSTYLE);
    }

    private int clearTotalLine(List items) {
        int result;
        block17: {
            block16: {
                result = -1;
                if (this.spreadStyle != 0) break block16;
                if (this.top < 0 || this.top > this.curSheet.getMaxRowIndex()) {
                    return result;
                }
                result = this.top + this.indexHandle.getBeforeDynaItemSumRangeCount();
                int index = -1;
                for (int i = this.left + 1; i < this.left + this.colCount; ++i) {
                    if (!this.hasFormula(this.curSheet.getCell(this.top, i, false))) continue;
                    index = i;
                    break;
                }
                if (index <= 0) break block17;
                int rowSite = this.top + 1;
                for (int i = this.top + 1; i < this.top + this.rowCount; ++i) {
                    Range cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(rowSite, index));
                    if (this.isSumItem(i)) {
                        ++rowSite;
                        continue;
                    }
                    if (this.hasFormula(cell)) {
                        result = rowSite;
                        this.adjustItems(UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange((SortedCellBlockArray)cell)), items);
                    } else if (this.curSheet.getRange(rowSite, this.left).getValue().isNull()) {
                        this.removeRow(rowSite, this.left);
                        continue;
                    }
                    ++rowSite;
                }
                break block17;
            }
            if (this.spreadStyle == 1) {
                int index = -1;
                if (this.left < 0 || this.left > this.curSheet.getMaxColIndex()) {
                    return result;
                }
                result = this.left + this.indexHandle.getBeforeDynaItemSumRangeCount();
                for (int i = this.top + 1; i < this.top + this.rowCount; ++i) {
                    if (!this.hasFormula(this.curSheet.getCell(i, this.left, false))) continue;
                    index = i;
                    break;
                }
                if (index > 0) {
                    int colSite = this.left + 1;
                    for (int i = this.left + 1; i < this.left + this.colCount; ++i) {
                        Range cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(index, colSite));
                        if (this.isSumItem(i)) {
                            ++colSite;
                            continue;
                        }
                        if (this.hasFormula(cell)) {
                            result = colSite;
                            this.adjustItems(cell, items);
                        } else if (this.curSheet.getRange(this.top, colSite).getValue().isNull()) {
                            this.removeCol(this.top, colSite);
                            continue;
                        }
                        ++colSite;
                    }
                }
            }
        }
        return result;
    }

    private void removeCol(int rowSite, int colSite) {
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getColRange(colSite, colSite)).delete();
    }

    private void removeRow(int rowSite, int colSite) {
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRowRange(rowSite, rowSite)).delete();
    }

    private void adjustItems(Range cell, List items) {
        String number = null;
        number = this.isGenerateDyItemFormula ? ((ItemFormula)cell.getUserObject("ITEM")).getDItemNumber() : this.getDitem(cell);
        if (number != null) {
            for (int i = 0; i < items.size(); ++i) {
                AsstActObject obj = (AsstActObject)items.get(i);
                String number1 = obj.getNumber();
                if (obj.isMultiLevel()) {
                    number1 = obj.getLongNumber();
                }
                if (!number.equals(number1)) continue;
                items.remove(i--);
            }
        }
    }

    private void clearRange(int top, int left, int bottom, int right) {
        StyleAttributes sa;
        Range range = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(top, left, bottom < top ? top : bottom, right < left ? left : right));
        if (range != null) {
            range.setValue(Variant.nullVariant);
            range.setUserObject("ITEM", null);
            range.setUserObject("0", null);
            range.setUserObject("1", null);
            range.setUserObject("isGradeAndNotManual", null);
            range.setUserObject("6", null);
            range.setFormula(null);
        }
        if ((sa = Styles.getEmptySA()) != null) {
            sa.setPattern(Pattern.None);
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    private int getItemCount(List fillDataList) {
        int itemCount = this.param.getDynaItemSource() == 0 ? this.param.getDefaultCounter() : fillDataList.size();
        return itemCount;
    }

    private void grade() {
        block19: {
            block18: {
                int i;
                if (this.spreadStyle != 0) break block18;
                int index = -1;
                Sheet.ICellsIterator it = this.curSheet.getCellsIterator(this.top, this.left + 1, this.top, this.left + this.colCount, false, true);
                while (it.hasNext()) {
                    Cell cell = it.next();
                    ItemFormula uo = (ItemFormula)cell.getUserObjectValue("ITEM");
                    if (uo == null) continue;
                    index = cell.getCol();
                    break;
                }
                if (index <= 0) break block19;
                ArrayList<String> numbers = new ArrayList<String>();
                for (i = this.top + 1; i < this.top + this.rowCount; ++i) {
                    Cell cell = this.curSheet.getCell(i, index, false);
                    if (cell == null) {
                        numbers.add("");
                        continue;
                    }
                    ItemFormula itemf = (ItemFormula)cell.getUserObjectValue("ITEM");
                    if (itemf != null) {
                        numbers.add(itemf.getDItemNumber());
                        continue;
                    }
                    numbers.add("");
                }
                for (i = 1; i <= numbers.size(); ++i) {
                    int parentSite;
                    String number = (String)numbers.get(i - 1);
                    if (StringUtils.isEmpty((String)number) || (parentSite = this.getParentSite(number, numbers)) < 0) continue;
                    int row = this.top + parentSite + 1;
                    for (int k = this.left + 1; k < this.left + this.colCount; ++k) {
                        Cell headRptCell;
                        if (!this.hasFormula(this.curSheet.getCell(this.top + parentSite + 1, k, false)) || ((ItemFormula)(headRptCell = this.curSheet.getCell(this.top, k, true)).getUserObjectValue("ITEM")).getValueType() == 3) continue;
                        Cell cell = this.curSheet.getCell(row, k, true);
                        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(cell));
                        if (cell.getUserObject("isGradeAndNotManual") == null) {
                            cell.setFormula(null);
                        }
                        String expression = cell.getFormula();
                        String cellName = Location.getCellName((int)(this.top + i), (int)k);
                        cell.setUserObject("isGradeAndNotManual", (Object)"Y");
                        if (StringUtils.isEmpty((String)expression)) {
                            cell.setFormula("=" + cellName);
                            continue;
                        }
                        if (expression.toLowerCase().indexOf(cellName.toLowerCase()) >= 1) continue;
                        cell.setFormula(expression + "+" + cellName);
                    }
                }
                break block19;
            }
            if (this.spreadStyle == 1) {
                int index = -1;
                for (int i = this.top + 1; i < this.top + this.rowCount; ++i) {
                    if (!this.hasFormula(this.curSheet.getCell(i, this.left, false))) continue;
                    index = i;
                    break;
                }
                if (index > 0) {
                    int i;
                    ArrayList<String> numbers = new ArrayList<String>();
                    for (i = this.left + 1; i < this.left + this.colCount; ++i) {
                        Cell cell = this.curSheet.getCell(index, i, false);
                        if (cell == null) {
                            numbers.add("");
                            continue;
                        }
                        ItemFormula itemf = (ItemFormula)cell.getUserObjectValue("ITEM");
                        if (itemf != null) {
                            numbers.add(itemf.getDItemNumber());
                            continue;
                        }
                        numbers.add("");
                    }
                    for (i = 1; i <= numbers.size(); ++i) {
                        int parentSite;
                        String number = (String)numbers.get(i - 1);
                        if (StringUtils.isEmpty((String)number) || (parentSite = this.getParentSite(number, numbers)) < 0) continue;
                        for (int k = this.top + 1; k < this.top + this.rowCount; ++k) {
                            ItemFormula headRptCell;
                            if (!this.hasFormula(this.curSheet.getCell(k, this.left, false)) || (headRptCell = (ItemFormula)this.curSheet.getCell(k, this.left, true).getUserObjectValue("ITEM")).getValueType() == 3) continue;
                            Cell cell = this.curSheet.getCell(k, this.left + parentSite + 1, true);
                            UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(cell));
                            if (cell.getUserObject("isGradeAndNotManual") == null) {
                                cell.setFormula(null);
                            }
                            String expression = cell.getFormula();
                            String cellName = Location.getCellName((int)k, (int)(this.left + i));
                            cell.setUserObject("isGradeAndNotManual", (Object)"Y");
                            if (StringUtils.isEmpty((String)expression)) {
                                cell.setFormula("=" + cellName);
                                continue;
                            }
                            if (expression.toLowerCase().indexOf(cellName.toLowerCase()) >= 1) continue;
                            cell.setFormula(expression + "+" + cellName);
                        }
                    }
                }
            }
        }
    }

    private void insertDItemName(Range basePointCell, Range showNumberCell, AsstActObject obj, DynaParameters param) {
        basePointCell = UserObjectHelper.getUnprotectedRange((Range)basePointCell);
        boolean isShowNumber = false;
        if (showNumberCell != null) {
            showNumberCell = UserObjectHelper.getUnprotectedRange((Range)showNumberCell);
            isShowNumber = param.getDynaItemShowType() == 1;
        }
        String name = obj.getName();
        String number = obj.getNumber();
        if (this.isRptCover || param.getDynaItemSource() != 1 || !param.isGrade()) {
            basePointCell.setValue(new Variant((Object)name));
            if (isShowNumber) {
                showNumberCell.setValue(new Variant((Object)number));
            }
        } else if (obj.isMultiLevel()) {
            String[] numbers = obj.getLongNumber().split("!");
            String space = "";
            for (int j = 1; j < numbers.length; ++j) {
                space = space + "  ";
            }
            basePointCell.setValue(new Variant((Object)(space + name)));
            if (isShowNumber) {
                showNumberCell.setValue(new Variant((Object)(space + number)));
            }
        } else {
            if (isShowNumber) {
                showNumberCell.setValue(new Variant((Object)number));
            }
            basePointCell.setValue(new Variant((Object)name));
        }
        if (!this.isGenerateDyItemFormula) {
            String ditemNumber = obj.getLongNumber();
            if (!this.isRptCover && !obj.isMultiLevel()) {
                ditemNumber = obj.getNumber();
            }
            basePointCell.setUserObject("6", (Object)ditemNumber);
        }
    }

    private int getParentSite(String number, List numbers) {
        int result = -1;
        String tmp = "";
        for (int i = 0; i < numbers.size(); ++i) {
            String nowNum = (String)numbers.get(i);
            if (!number.startsWith(nowNum + "!") || tmp.length() >= nowNum.length()) continue;
            tmp = nowNum;
            result = i;
        }
        return result;
    }

    private boolean canSetFormula() {
        return this.param.getDefaultCounter() != 0;
    }

    private void autoFillFormula(int cutRowCol, int lastRowCol, int firstRowCol, AsstActObject ditemInfo, ArrayList items, boolean isType, boolean isRow, boolean isAC, boolean SpreadStyle_VERTICAL) {
        int firstColIndex;
        int topColIndex;
        int topRowIndex = isRow ? this.top : cutRowCol;
        Range cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(topRowIndex, topColIndex = isRow ? cutRowCol : this.left));
        if (cell == null) {
            return;
        }
        Object itemCellObj = cell.getUserObject("ITEM");
        if (itemCellObj == null || !(itemCellObj instanceof ItemFormula)) {
            return;
        }
        int firstRowIndex = isRow ? lastRowCol + 1 : cutRowCol;
        cell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(firstRowIndex, firstColIndex = isRow ? cutRowCol : lastRowCol + 1));
        if (cell == null) {
            return;
        }
        if (this.isGenerateDyItemFormula) {
            ItemFormula itemFormula = (ItemFormula)itemCellObj;
            String ditem = null;
            ditem = this.isRptCover ? this.constructFormula(itemFormula, ditemInfo.getLongNumber()) : this.constructFormula(itemFormula, ditemInfo.isMultiLevel() ? ditemInfo.getLongNumber() : ditemInfo.getNumber());
            cell.setUserObject("ITEM", (Object)new ItemFormula(ditem));
        } else {
            cell.setUserObject("6", (Object)1);
        }
        boolean canUpdate = this.canUpdate(cell, items, ditemInfo, isType, isAC);
        if (canUpdate) {
            String fomula = this.getFormula(topRowIndex, topColIndex, firstRowCol, lastRowCol, ditemInfo, isRow, isAC, SpreadStyle_VERTICAL, firstRowIndex, firstColIndex);
            if (fomula == null) {
                return;
            }
            if (this.isReport) {
                cell.setFormula(fomula);
            } else {
                cell.setUserObject(isAC ? "0" : "1", (Object)fomula);
                if (!StringUtils.isEmpty((String)this.curView) && (isAC && this.curView.equals("0") || !isAC && this.curView.equals("1"))) {
                    cell.setFormula(fomula);
                }
            }
        }
    }

    private String constructFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private boolean canUpdate(Range cell, ArrayList items, AsstActObject ditemInfo, boolean isType, boolean isAC) {
        boolean canUpdate = false;
        String cell_formula = this.getTempFormula(cell, isAC);
        if (cell_formula == null || cell_formula.trim().length() == 0) {
            canUpdate = true;
        }
        if (cell_formula != null && cell_formula.indexOf("@") >= 0) {
            canUpdate = true;
        }
        if (isType && !this.isRptCover && !CslRptUtil.isLeaf((List)items, (AsstActObject)ditemInfo)) {
            canUpdate = false;
        }
        return canUpdate;
    }

    private String getTempFormula(Range rang, boolean isAC) {
        if (rang != null) {
            String formulaKey = "tempFomula";
            if (!isAC) {
                formulaKey = "tempBGFomula";
            }
            String formul = (String)rang.getUserObject(formulaKey);
            return formul;
        }
        return null;
    }

    private Object[] getTempFormulaObject(Range rang, boolean isAC) {
        if (rang != null) {
            String formul;
            String formulaKey = "tempFomula";
            if (!isAC) {
                formulaKey = "tempBGFomula";
            }
            if (!StringUtils.isEmpty((String)(formul = (String)(rang = UserObjectHelper.getUnprotectedRange((Range)rang)).getUserObject(formulaKey)))) {
                Object isIncludeSpecal = rang.getUserObject("isInclude@");
                if (isIncludeSpecal == null) {
                    rang.setUserObject("isInclude@", (Object)(formul.indexOf("@") >= 0 ? 1 : 0));
                }
                if (rang.getUserObject("isExcelFunction") == null) {
                    boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)this.curSheet, (String)formul);
                    rang.setUserObject("isExcelFunction", (Object)isExcelFunction);
                }
            }
            return new Object[]{formul, rang.getUserObject("isInclude@"), rang.getUserObject("isExcelFunction"), rang.getUserObject("isHavSpecialExpr")};
        }
        return null;
    }

    private String getFormula(int topRowIndex, int topColIndex, int firstRowCol, int lastRowCol, AsstActObject ditemInfo, boolean isRow, boolean isAC, boolean SpreadStyle_VERTICAL, int rowIndex, int colIndex) {
        Range formulaTempRange = this.curSheet.getRange(topRowIndex, topColIndex);
        Object[] fomulas = this.getTempFormulaObject(formulaTempRange, isAC);
        String fomula = null;
        if (fomulas != null) {
            fomula = (String)fomulas[0];
        }
        if (fomula == null || fomula.trim().length() == 0 || fomula != null && !fomula.trim().startsWith("=") && !fomula.toLowerCase(Locale.ENGLISH).startsWith("sum")) {
            fomula = null;
        } else {
            boolean isSet;
            String number;
            block10: {
                number = null;
                int curRowIndex = isRow ? lastRowCol + 1 : this.top;
                int curColIndex = isRow ? this.left : lastRowCol + 1;
                Variant obj = this.curSheet.getRange(curRowIndex, curColIndex).getValue();
                try {
                    number = ditemInfo.getNumber();
                }
                catch (Throwable a) {
                    if (obj == null) break block10;
                    number = obj.toString().trim();
                }
            }
            boolean isIncludeSpecal = (Boolean)fomulas[1];
            boolean isExcelFunction = (Boolean)fomulas[2];
            if (number != null) {
                if (isIncludeSpecal) {
                    fomula = fomula.replaceAll("@", Matcher.quoteReplacement(number));
                } else if (isExcelFunction && firstRowCol != lastRowCol) {
                    fomula = null;
                }
            }
            boolean bl = isSet = formulaTempRange.getUserObject("isNotFomulaSet") != null && "true".equals(formulaTempRange.getUserObject("isNotFomulaSet").toString());
            if (isSet && fomula != null && fomulas.length >= 4 && fomulas[3] != null) {
                String[] indexs = fomulas[3].toString().split(",");
                fomula = DynamicTemplateUtility.offerFormula(fomula, this.curSheet, Integer.valueOf(indexs[0].trim()), Integer.valueOf(indexs[1].trim()), rowIndex, colIndex);
            }
        }
        return fomula;
    }

    private int getColCount() {
        int width;
        for (int i = width = this.curSheet.getMaxColIndex(); i > this.left; --i) {
            Cell cell = this.curSheet.getCell(this.top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i + 1 - this.left;
        }
        return 1;
    }

    private int getRowCount() {
        int height;
        for (int i = height = this.curSheet.getMaxRowIndex(); i > this.top; --i) {
            Cell cell = this.curSheet.getCell(i, this.left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i + 1 - this.top;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        if (itemCellObj != null) {
            return true;
        }
        return this.isHasDitem(this.curSheet.getRange(cell));
    }

    private boolean hasFormula(Range cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObject("ITEM");
        if (itemCellObj != null) {
            return true;
        }
        return this.isHasDitem(cell);
    }

    private boolean isHasDitem(Range cell) {
        String obj = this.getDitem(cell);
        return obj != null && !StringUtils.isEmpty((String)obj.toString());
    }

    private String getDitem(Range cell) {
        Object obj;
        boolean isvertical;
        Range range;
        if (!this.isGenerateDyItemFormula && (range = this.curSheet.getRange((isvertical = this.spreadStyle == 0) ? cell.getBlock(0).getRow() : this.top, isvertical ? this.left : cell.getBlock(0).getCol())) != null && (obj = range.getUserObject("6")) != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public void setCoverRecord(boolean isCoverRecord) {
        this.isCoverRecord = isCoverRecord;
    }

    private void refreshExcelFormula(int itemCount) throws EASBizException, BOSException {
        Method cellCopyMethod = null;
        for (Method method : Cell.class.getDeclaredMethods()) {
            if (!method.getName().equals("copyFrom")) continue;
            NewRptUtil.makeAccessible((Method)method);
            cellCopyMethod = method;
            break;
        }
        if (cellCopyMethod != null) {
            boolean isAc = this.isReport ? this.rptDataCollectNumber.equals("ACTUALDATA") : true;
            boolean isVertical = this.spreadStyle == 0;
            int startIndex = isVertical ? this.left + 1 : this.top + 1;
            int endIndex = isVertical ? this.left + this.colCount : this.top + this.rowCount;
            Range headRange = null;
            String curTempFormula = null;
            Cell firstRowCell = null;
            Object formulaPoint = null;
            int existRowCols = 0;
            int startRow = -1;
            int startCol = -1;
            if (!this.isCoverRecord) {
                if (isVertical) {
                    startRow = this.lastRow + 1;
                    existRowCols = this.lastRow - this.top;
                } else {
                    startCol = this.lastCol + 1;
                    existRowCols = this.lastCol - this.left;
                }
            }
            for (int k = startIndex; k < endIndex; ++k) {
                headRange = this.curSheet.getRange(isVertical ? this.top : k, isVertical ? k : this.left);
                if (headRange == null || StringUtils.isEmpty((String)(curTempFormula = this.getTempFormula(headRange, isAc)))) continue;
                firstRowCell = this.curSheet.getCell(isVertical ? this.top + 1 : k, isVertical ? k : this.left + 1, true);
                UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(firstRowCell));
                formulaPoint = headRange.getUserObject(fomula_Cell_Key);
                if (formulaPoint == null || !(formulaPoint instanceof Integer[])) continue;
                if (!this.isCoverRecord) {
                    if (isVertical) {
                        startCol = k;
                    } else {
                        startRow = k;
                    }
                    Cell cell = this.curSheet.getCell(isVertical ? startRow : k, isVertical ? k : startCol, true);
                    if (StringUtils.isEmpty((String)cell.getFormula())) {
                        cell.setFormula(curTempFormula);
                    }
                } else {
                    startRow = isVertical ? this.top + 2 : k;
                    int n = startCol = isVertical ? k : this.left + 2;
                }
                if (!StringUtils.isEmpty((String)firstRowCell.getFormula())) {
                    curTempFormula = firstRowCell.getFormula();
                }
                this.copyExcelFormulaToFirstRow(cellCopyMethod, curTempFormula, (Integer[])formulaPoint, firstRowCell);
                this.excelFormulaAutoFill(startRow, startCol, isVertical ? this.top + this.rowCount - 1 : k, isVertical ? k : this.left + this.colCount - 1, existRowCols, isVertical);
            }
        }
    }

    private void copyExcelFormulaToFirstRow(Method cellCopyMethod, String excelFormula, Integer[] formulaPoint, Cell firstRowCell) throws EASBizException, BOSException {
        if (formulaPoint != null && formulaPoint.length == 2) {
            if (formulaPoint[0].intValue() == firstRowCell.getRow() && formulaPoint[1].intValue() == firstRowCell.getCol()) {
                firstRowCell.setFormula(excelFormula);
                return;
            }
            Cell srcCell = this.curSheet.getCell(formulaPoint[0].intValue(), formulaPoint[1].intValue(), true);
            UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRange(srcCell));
            String srcFormula = srcCell.getFormula();
            Variant srcValue = srcCell.getValue();
            srcCell.setFormula(excelFormula);
            try {
                cellCopyMethod.invoke((Object)firstRowCell, srcCell, PasteMode.FORMULAS, false, null, false);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            srcCell.setFormula(srcFormula);
            srcCell.setValue(srcValue);
        }
    }

    private void excelFormulaAutoFill(int startRow, int startCol, int endRow, int endCol, int existRowCols, boolean isVertical) {
        StyleDecoratorFormula sytleInherit = new StyleDecoratorFormula();
        RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
        styleParam.setStartRow(startRow);
        styleParam.setEndRow(endRow);
        styleParam.setStartColumn(startCol);
        styleParam.setEndColumn(endCol);
        if (!this.isCoverRecord) {
            if (isVertical) {
                styleParam.setExistRow(existRowCols);
            } else {
                styleParam.setExistCol(existRowCols);
            }
        }
        styleParam.setInsertInherit(false);
        styleParam.setVerticalInherit(isVertical);
        styleParam.setGradeFill(false);
        styleParam.setStandardPoint(new Point(this.left, this.top));
        sytleInherit.regionInheritStyleByDefaultPoint(this.curSheet, styleParam);
    }
}

