/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.FormulaHandler;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;

public class FormulaUtils {
    public static boolean isNeedFillFormula(Sheet sheet, DynaParameters param, Point basePoint, int startRow, int startCol) {
        boolean isVertical = param.getSpreadStyle() == 0;
        boolean isLeftUp = param.getPosition() == 1;
        Point point = null;
        Point base = null;
        point = isVertical ? new Point(basePoint.x, startRow + 1) : new Point(startCol + 1, basePoint.y);
        base = DynamicTemplateUtility.getBasePoint(sheet, point, DynamicTemplateUtility.getBasePointList(sheet));
        if (base == null || base.equals(point)) {
            return false;
        }
        if (param.getDynaItemSource() == 0 && param.isGrade()) {
            DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo(sheet.getRange(basePoint.y, basePoint.x));
            if (gradeInfo == null) {
                return false;
            }
            DItemGradeEntryInfo branch = null;
            if (isVertical) {
                if (param.getPosition() == 1) {
                    for (int r = startRow + 1; r >= 0; --r) {
                        String grade;
                        ItemFormula item = UserObjectHelper.getItemFormula((Range)sheet.getRange(r, basePoint.x), (boolean)false);
                        if (item == null || (grade = item.getExt("GRADE_NUMBER")) == null || grade.indexOf(".D") >= 0) continue;
                        branch = gradeInfo.find(grade);
                        if (branch == null) {
                            return false;
                        }
                        if (!branch.isLeaf() && r == startRow) {
                            return false;
                        }
                        break;
                    }
                } else {
                    for (int r = startRow + 1; r <= sheet.getRows().getMaxIntMark(); ++r) {
                        String grade;
                        ItemFormula item = UserObjectHelper.getItemFormula((Range)sheet.getRange(r, basePoint.x), (boolean)false);
                        if (item == null || (grade = item.getExt("GRADE_NUMBER")).indexOf(".D") >= 0) continue;
                        branch = gradeInfo.find(grade);
                        if (branch == null) {
                            return false;
                        }
                        if (!branch.isLeaf() && r == startRow) {
                            return false;
                        }
                        break;
                    }
                }
            } else if (param.getPosition() == 1) {
                for (int c = startCol + 1; c >= 0; --c) {
                    String grade;
                    ItemFormula item = UserObjectHelper.getItemFormula((Range)sheet.getRange(basePoint.y, c), (boolean)false);
                    if (item == null || (grade = item.getExt("GRADE_NUMBER")).indexOf(".D") >= 0) continue;
                    branch = gradeInfo.find(grade);
                    if (branch == null) {
                        return false;
                    }
                    if (!branch.isLeaf() && c == startCol) {
                        return false;
                    }
                    break;
                }
            } else {
                for (int c = startCol + 1; c <= sheet.getCols().getMaxIntMark(); ++c) {
                    String grade;
                    ItemFormula item = UserObjectHelper.getItemFormula((Range)sheet.getRange(basePoint.y, c), (boolean)false);
                    if (item == null || (grade = item.getExt("GRADE_NUMBER")).indexOf(".D") >= 0) continue;
                    branch = gradeInfo.find(grade);
                    if (branch == null) {
                        return false;
                    }
                    if (!branch.isLeaf() && c == startCol) {
                        return false;
                    }
                    break;
                }
            }
        } else if (isVertical && isLeftUp && point.y == base.y + 2 || !isVertical && isLeftUp && point.x == base.x + 2) {
            return false;
        }
        return true;
    }

    public static void copyFormulaToNewLine(Sheet sheet, DynaParameters param, Point basePoint, int startRow, int startCol, int endRow, int endCol) {
        boolean isLeftUp;
        boolean isVertical = param.getSpreadStyle() == 0;
        boolean bl = isLeftUp = param.getPosition() == 1;
        if (isVertical) {
            int colCount = FormulaUtils.getColCount(sheet, basePoint.x, basePoint.y);
            for (int c = basePoint.x + 1; c < colCount; ++c) {
                FormulaUtils.autoFillFormula(sheet, startRow, c, endRow, endCol, isLeftUp, isVertical);
            }
        } else {
            int rowCount = FormulaUtils.getRowCount(sheet, basePoint.x, basePoint.y);
            for (int r = basePoint.y + 1; r < basePoint.y + rowCount; ++r) {
                FormulaUtils.autoFillFormula(sheet, r, startCol, endRow, endCol, isLeftUp, isVertical);
            }
        }
    }

    public static void autoFillFormula(Sheet sheet, int preRow, int preCol, int endRow, int endCol, boolean isLeftUp, boolean isVertical) {
        block9: {
            boolean isExcelFunction;
            String formula = null;
            formula = sheet.getCell(preRow, preCol, true).getFormula();
            Variant value = sheet.getCell(preRow, preCol, true).getValue();
            if (CslRptUtil.isBigDecimal((Object)value)) {
                formula = null;
            }
            if (null != formula && formula.trim().length() == 0) {
                formula = null;
            }
            if (!(isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)formula))) {
                formula = null;
            }
            if (formula == null) break block9;
            Range range = null;
            if (isVertical) {
                for (int r = preRow + 1; r <= endRow; ++r) {
                    range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(r, preCol));
                    if (range == null) {
                        return;
                    }
                    range.setFormula(formula);
                }
            } else {
                for (int c = preCol + 1; c <= endCol; ++c) {
                    range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(preRow, c));
                    if (range == null) {
                        return;
                    }
                    range.setFormula(formula);
                }
            }
        }
    }

    public static int getColCount(Sheet sheet, int left, int top) {
        int maxCol;
        for (int i = maxCol = sheet.getMaxColIndex(); i > left; --i) {
            Cell cell = sheet.getCell(top, i, false);
            if (cell == null || !FormulaUtils.hasFormula(cell)) continue;
            return i + 1;
        }
        return 1;
    }

    public static int getRowCount(Sheet sheet, int left, int top) {
        int maxRow;
        for (int i = maxRow = sheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = sheet.getCell(i, left, false);
            if (cell == null || !FormulaUtils.hasFormula(cell)) continue;
            return i + 1;
        }
        return 1;
    }

    public static boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private static boolean isExcelFormula(String formula, FormulaHandler handler) {
        if (!StringUtils.isEmpty((String)formula) && !StringUtils.isEmpty((String)formula.trim()) && formula.trim().charAt(0) == '=') {
            if (formula.trim().indexOf("(") > 0) {
                try {
                    Expression exp = ExcelFormulaPaserHelper.parse((String)formula);
                    ExcelFormulaPaserHelper.walk((Expression)exp, (IBreakableExpressionHandler)handler);
                    return handler.isExcelFormula();
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static Set getFormulaSet() {
        HashSet<String> formulaSet = new HashSet<String>();
        formulaSet.add("sum");
        formulaSet.add("if");
        formulaSet.add("and");
        formulaSet.add("abs");
        formulaSet.add("max");
        formulaSet.add("min");
        formulaSet.add("not");
        formulaSet.add("or");
        formulaSet.add("subtotal");
        formulaSet.add("sumif");
        return formulaSet;
    }
}

