/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.k3webservice;

import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.util.StringUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class K3WebServiceContext {
    private Map sdsnMapping = new HashMap(3);
    private String endPoint = null;
    private static K3WebServiceContext webServiceContext;

    private K3WebServiceContext() {
    }

    public static K3WebServiceContext getInstance() {
        if (webServiceContext == null) {
            webServiceContext = new K3WebServiceContext();
        }
        return webServiceContext;
    }

    public URL getEndPoint(String function) throws Exception {
        this.endPoint = UIConfig.getServer();
        if (this.endPoint == null || this.endPoint.trim().length() < 1) {
            this.endPoint = "192.168.18.155";
        }
        return new URL("http://" + this.endPoint + function);
    }

    public URL getK3FunctionEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/K3AccFunctions.asmx");
    }

    public URL getLoginEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/K3LoginService.asmx");
    }

    public URL getAISQueryEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/Public.asmx");
    }

    public void setEndPointURL(String endPoint) {
        this.endPoint = endPoint;
    }

    public Map getSdsnMapping() {
        return this.sdsnMapping;
    }

    public void setSdsnMapping(Map sdsnMapping) {
        this.sdsnMapping = sdsnMapping;
    }

    public String getSDSNByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return UIConfig.getUrl();
        }
        String sdsn = (String)this.sdsnMapping.get(name);
        if (StringUtils.isEmpty((String)sdsn)) {
            return UIConfig.getUrl();
        }
        return sdsn;
    }

    public void putSDSNByName(String name, String sdsn) {
        this.sdsnMapping.put(name, sdsn);
    }
}

