/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherOutputStream;
import com.kingdee.eas.fi.rpt.CheckStatusEnum;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyCfgUI;
import com.kingdee.eas.rptclient.gr.rptclient.ReportSelecterUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class UPFFile {
    private static String password = "gamania";
    private static ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.ExportResource");

    public static void exportReport(Object owner) throws Exception {
        int rt;
        HashMap map = UPFFile.getReportsAndPath(owner, false);
        if (map == null) {
            return;
        }
        String path = (String)map.get("PATH");
        CslReportCollection reports = (CslReportCollection)map.get("RPTS");
        if (!UPFFile.reportCheckedStatusNotice(owner, reports)) {
            return;
        }
        OrgUnitInfo org = UPFFile.getOrgUnitInfo();
        File file = new File(path + ".upf");
        if (file.exists() && (rt = MsgBox.showConfirm2New((Component)((Component)owner), (String)resHelper.getString("overWriterfile"))) != 0 && 0 != rt) {
            return;
        }
        UPFFile.exportReport(path, password, reports, org);
        UPFFile.setReportsCommit(reports);
        MsgBox.showInfo((String)resHelper.getString("CommitSucess"));
    }

    private static boolean reportCheckedStatusNotice(Object owner, CslReportCollection reports) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < reports.size(); ++i) {
            CslReportInfo info = reports.get(i);
            if (!info.getCheckedStatus().equals((Object)CheckStatusEnum.CHECKED)) continue;
            buf.append("[" + info.getName() + "]");
        }
        if (buf.length() > 0) {
            int rt = MsgBox.showConfirm2New((Component)((Component)owner), (String)(buf.toString() + resHelper.getString("HasCommitedAreYouAlseCommit")));
            return rt == 0 || 0 == rt;
        }
        return true;
    }

    public static void exportReportToFtp(Object owner) throws Exception {
        HashMap map = UPFFile.getReportsAndPath(owner, true);
        if (map == null) {
            return;
        }
        String path = (String)map.get("PATH");
        CslReportCollection reports = (CslReportCollection)map.get("RPTS");
        if (!UPFFile.reportCheckedStatusNotice(owner, reports)) {
            return;
        }
        OrgUnitInfo org = UPFFile.getOrgUnitInfo();
        UPFFile.exportReport(path, password, reports, org);
        String ip = UIConfig.getFTPIP();
        String userName = UIConfig.getFTPUser();
        String password = UIConfig.getFTPPassword();
        String upPath = UIConfig.getFTPUpPath();
        try {
            int rt;
            FTPUpDown ftp = new FTPUpDown(ip, "21", userName, password);
            String fileName = path.substring(path.lastIndexOf("\\"));
            if (ftp.isExistFile(upPath + fileName + ".UPF") && (rt = MsgBox.showConfirm2New((Component)((Component)owner), (String)resHelper.getString("GroupNotReceiveReCover"))) != 0 && 0 != rt) {
                return;
            }
            if (ftp.isExistFile(upPath + fileName + ".UPF.BAK") && (rt = MsgBox.showConfirm2New((Component)((Component)owner), (String)resHelper.getString("GroupReceiveedReCommit"))) != 0 && 0 != rt) {
                return;
            }
            ftp.uploadFile(path + ".UPF", upPath);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            MsgBox.showInfo((String)resHelper.getString("CommitFail"));
            return;
        }
        UPFFile.setReportsCommit(reports);
        MsgBox.showInfo((String)resHelper.getString("CommitSucess"));
    }

    private static void setReportsCommit(CslReportCollection reports) throws BOSException {
        if (reports == null || reports.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_EAS_Report SET FCheckedStatus=2 WHERE FID IN(");
        for (int i = 0; i < reports.size(); ++i) {
            if (i != 0) {
                sql.append(" , ");
            }
            sql.append("'" + reports.get(i).get("RPT-ID").toString() + "'");
        }
        sql.append(")");
        DbUtil.execute(sql.toString());
    }

    private static HashMap getReportsAndPath(Object owner, boolean isFTP) throws Exception {
        HashMap returnMap = new HashMap();
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"parentUI", owner);
        uiContext.put((Object)"returnMap", returnMap);
        if (isFTP) {
            uiContext.put((Object)"FTPMode", (Object)"FTPMode");
        } else {
            uiContext.put((Object)"FTPMode", null);
        }
        ReportSelecterUI window = (ReportSelecterUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)owner, ReportSelecterUI.class.getName(), (Map)uiContext);
        window.showWindow();
        if (returnMap.get("OK") != null) {
            return returnMap;
        }
        return null;
    }

    private static OrgUnitInfo getOrgUnitInfo() throws BOSException, SQLException {
        OrgUnitInfo info = new OrgUnitInfo();
        String[] values = CompanyCfgUI.getCompany();
        info.setName(values[1]);
        info.setNumber(values[0]);
        return info;
    }

    private static void exportReport(String path, String password, CslReportCollection reports, OrgUnitInfo orgUnit) throws Exception {
        if (!path.endsWith(".UPF") && !path.endsWith(".upf")) {
            path = path + ".UPF";
        }
        FileOutputStream f = new FileOutputStream(path);
        if (!StringUtils.isEmpty((String)password)) {
            f = new CipherOutputStream((OutputStream)f, password);
        }
        ZipOutputStream out = new ZipOutputStream(new DataOutputStream(f));
        try {
            UPFFile.writeOutputEntitys(reports, orgUnit, out);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            out.close();
        }
    }

    private static void writerDataEntity(String key, byte[] data, ZipOutputStream out) throws IOException {
        out.putNextEntry(new ZipEntry(key));
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            out.write(b);
        }
    }

    private static void writePublicDataEntity(OrgUnitInfo info, ZipOutputStream out) throws IOException {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("public");
        rootElement.addElement("companynumber").setText(info.getNumber() != null ? info.getNumber() : "");
        rootElement.addElement("companyName").setText(info.getName() != null ? info.getName() : "");
        rootElement.addElement("reportfile").setText("report.dat");
        String commitTime = RPTDateUtil.formateDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        rootElement.addElement("commitTime").setText(commitTime);
        UPFFile.writerDataEntity("public.dat", document.asXML().getBytes("UTF-8"), out);
    }

    private static void writerReportDataEntiry(CslReportCollection reports, ZipOutputStream out) throws UnsupportedEncodingException, IOException {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("report");
        Iterator it = reports.iterator();
        while (it.hasNext()) {
            Element row = rootElement.addElement("row");
            CslReportInfo report = (CslReportInfo)it.next();
            row.addElement("fnumber").setText(report.getNumber() != null ? report.getNumber() : "");
            row.addElement("fname").setText(report.getName() != null ? report.getName() : "");
            row.addElement("fdescription").setText(report.getDescription() != null ? report.getDescription() : "");
            row.addElement("fdata").setText(UPFFile.createFileName(report) + ".xml");
            row.addElement("comment").setText(UPFFile.createFileName(report) + ".comment");
            row.addElement("ftemplateid").setText(report.getTemplate() != null && report.getTemplate().getId() != null ? report.getTemplate().getId().toString() : "");
            row.addElement("fperiodtype").setText(Integer.toString(report.getPeriodType().getValue()));
            row.addElement("fsourcetype").setText(Integer.toString(report.getSourceType().getValue()));
            row.addElement("fyear").setText(Integer.toString(report.getYear()));
            row.addElement("fperiod").setText(Short.toString(report.getPeriod()));
            row.addElement("fcurrency").setText(report.getCurrency() != null ? report.getCurrency().getId().toString() : "");
            row.addElement("fcreator").setText(report.getCreator() != null && report.getCreator().getName() != null ? report.getCreator().getName() : "");
            row.addElement("fcreatetime").setText(report.getCreateTime() != null ? report.getCreateTime().toString() : "");
            row.addElement("flastupdateUser").setText(report.getLastUpdateUser() != null && report.getLastUpdateUser().getName() != null ? report.getLastUpdateUser().getName() : "");
            row.addElement("flastupdatetime").setText(report.getLastUpdateTime() != null ? report.getLastUpdateTime().toString() : "");
            row.addElement("fauditor").setText(report.getAuditor() != null && report.getAuditor().getName() != null ? report.getAuditor().getName() : "");
            row.addElement("fauditedtime").setText(report.getAuditTime() != null ? report.getAuditTime().toString() : "");
        }
        UPFFile.writerDataEntity("report.dat", document.asXML().getBytes("UTF-8"), out);
    }

    private static void writerReportDataFileEntitys(CslReportCollection reports, ZipOutputStream out) throws Exception {
        Iterator it = reports.iterator();
        while (it.hasNext()) {
            CslReportInfo report = (CslReportInfo)it.next();
            Book book = report.getBook();
            book.setCalculate(false);
            BookProperties properties = BookProperties.loadFromSpread(book);
            RptCheckExpTank expTank = properties.getOperationSchema().getExpTank();
            if (expTank != null && expTank.getExpressions() != null) {
                Collection exps = expTank.getExpressions();
                Iterator iter = exps.iterator();
                while (iter.hasNext()) {
                    String line;
                    RptCheckExpression exp = (RptCheckExpression)iter.next();
                    if (exp == null || (line = exp.getContent()) == null || line.trim().length() <= 0) continue;
                    try {
                        Expression e = ExcelFormulaPaserHelper.parse((String)line);
                        CheckExpChecker handler = new CheckExpChecker();
                        ExcelFormulaPaserHelper.walk((Expression)e, (IExpressionHandler)handler);
                        if (!handler.exists) continue;
                        iter.remove();
                    }
                    catch (Exception e) {}
                }
            }
            properties.restoreToSpread(book);
            String kdfName = UPFFile.createFileName(report) + ".xml";
            String pathName = new String(kdfName.getBytes("GB2312"), "UTF-8");
            UPFFile.writerDataEntity(pathName, IOHelper.packBook((Book)book), out);
            Document document = DocumentHelper.createDocument();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            Element rootElement = document.addElement("Book");
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                Element st = rootElement.addElement("Sheet");
                st.setAttributeValue("name", sheet.getSheetName());
                Sheet.ICellsIterator iter = sheet.getCellsIterator(null, false, true);
                while (iter.hasNext()) {
                    Cell cell = iter.next();
                    if (cell.getComment() == null) continue;
                    Element cl = st.addElement("Comment");
                    cl.setAttributeValue("cellRowIndex", Integer.toString(cell.getRow()));
                    cl.setAttributeValue("cellColIndex", Integer.toString(cell.getCol()));
                    Element item = cl.addElement("CommentItem");
                    item.setAttributeValue("Author", cell.getComment().getAuthor());
                    item.setAttributeValue("text", cell.getComment().getText());
                }
            }
            String commentName = UPFFile.createFileName(report) + ".comment";
            String commentpathName = new String(commentName.getBytes("GB2312"), "UTF-8");
            UPFFile.writerDataEntity(commentpathName, document.asXML().getBytes("UTF-8"), out);
        }
    }

    private static void writeOutputEntitys(CslReportCollection reports, OrgUnitInfo orgUnit, ZipOutputStream out) throws Exception {
        UPFFile.writePublicDataEntity(orgUnit, out);
        UPFFile.writerReportDataEntiry(reports, out);
        UPFFile.writerReportDataFileEntitys(reports, out);
    }

    private static String createFileName(CslReportInfo report) {
        return report.get("RPT-ID").toString();
    }

    private static class CheckExpChecker
    implements IExpressionHandler {
        boolean exists;

        private CheckExpChecker() {
        }

        public void handle(Expression e) {
            String funcionName;
            if (e instanceof FunctionExpr && ("ACCT".equalsIgnoreCase(funcionName = ((FunctionExpr)e).funcionName) || "ACCTEXT".equalsIgnoreCase(funcionName) || "ACCTCASH".equalsIgnoreCase(funcionName))) {
                this.exists = true;
            }
        }
    }
}

