/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.IReportVariableProvider;

public class DefaultBookChangeListener
implements BookChangeListener {
    private SpreadContext context;
    private IReportVariableProvider varialbeProvider;

    public DefaultBookChangeListener(SpreadContext context, IReportVariableProvider varialbeProvider) {
        this.context = context;
        this.varialbeProvider = varialbeProvider;
    }

    public void changed(BookChangeEvent e) {
        BookProperties bookProperties = BookProperties.loadFromSpread(this.context.getSpread().getBook());
        if (e.isSheetRemove()) {
            bookProperties.getOperationSchema().notifyDeleteSheet(e.getSheet().getSheetName());
        } else if (e.isSheetInsert()) {
            if (this.varialbeProvider != null) {
                this.varialbeProvider.initSheetDefaultVariable(e.getSheet().getSheetName(), bookProperties.getVariables());
            }
            bookProperties.getOperationSchema().notifyAddNewSheet(e.getSheet().getSheetName());
            e.getSheet().setID(BOSUuid.create((String)"RPTSHEET").toString());
        }
    }
}

