/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uiframe.client.AboutDlg;
import com.kingdee.eas.framework.client.AbstractCoreUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportActionManager;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class MenuManager {
    public static final String MENU_FILE = "File";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_VIEW = "View";
    public static final String MENU_INSERT = "Insert";
    public static final String MENU_STYLE = "Style";
    public static final String MENU_TOOL = "Tool";
    public static final String MENU_DATA = "Data";
    public static final String MENU_CALC = "Calculate";
    public static final String MENU_WINDOW = "Window";
    public static final String MENU_HELP = "Help";
    private SpreadContext _spreadContainer;
    private KDMenuBar _menuBar;
    private KDMenu _fileMenu;
    private KDMenu _editMenu;
    private KDMenu _viewMenu;
    private KDMenu _insertMenu;
    private KDMenu _styleMenu;
    private KDMenu _toolMenu;
    private KDMenu _dataMenu;
    private KDMenu _calcMenu;
    private KDMenu _windowMenu;
    private KDMenu _helpMenu;
    private ReportActionManager actionManager;

    MenuManager(SpreadContext ctx, ReportActionManager actionManager) {
        this._spreadContainer = ctx;
        this.actionManager = actionManager;
        this.initMenuBar();
    }

    public KDMenuBar createMenuBar() {
        return this._menuBar;
    }

    private KDMenuBar initMenuBar() {
        this._fileMenu = this.createFileMenu(MENU_FILE);
        this._editMenu = this.createEditMenu(MENU_EDIT);
        this._viewMenu = this.createViewMenu(MENU_VIEW);
        this._insertMenu = this.createInsertMenu(MENU_INSERT);
        this._styleMenu = this.createStyleMenu(MENU_STYLE);
        this._toolMenu = this.createToolMenu(MENU_TOOL);
        this._dataMenu = this.createDataMenu(MENU_DATA);
        this._calcMenu = this.createCalcMenu(MENU_CALC);
        this._windowMenu = this.createWindowMenu(MENU_WINDOW);
        this._helpMenu = this.createHelperMenu(MENU_HELP);
        this._menuBar = new KDMenuBar();
        this._menuBar.add((JMenu)this._fileMenu);
        this._menuBar.add((JMenu)this._editMenu);
        this._menuBar.add((JMenu)this._viewMenu);
        this._menuBar.add((JMenu)this._insertMenu);
        this._menuBar.add((JMenu)this._styleMenu);
        this._menuBar.add((JMenu)this._toolMenu);
        this._menuBar.add((JMenu)this._calcMenu);
        this._menuBar.add((JMenu)this._windowMenu);
        this._menuBar.add((JMenu)this._helpMenu);
        return this._menuBar;
    }

    public Component findMenuUsingPath(String path) {
        String[] paths = path.split("/");
        Object menu = this._menuBar;
        for (int i = 0; i < paths.length; ++i) {
            menu = this.match(paths[i], (Component)menu);
        }
        return menu;
    }

    private Component match(String name, Component menu) {
        if (menu instanceof JMenuBar) {
            JMenuBar menuBar = (JMenuBar)menu;
            for (int i = 0; i < menuBar.getComponentCount(); ++i) {
                if (!name.equalsIgnoreCase(menuBar.getMenu(i).getName())) continue;
                return menuBar.getMenu(i);
            }
        } else if (menu instanceof JMenu) {
            JMenu m = (JMenu)menu;
            for (int i = 0; i < m.getMenuComponentCount(); ++i) {
                if (!name.equalsIgnoreCase(m.getMenuComponent(i).getName())) continue;
                return m.getMenuComponent(i);
            }
        } else if (name.equalsIgnoreCase(menu.getName())) {
            return menu;
        }
        return null;
    }

    private KDMenuItem createBlankItem(String text, String name) {
        ActionWrapper action = new ActionWrapper(null);
        action.putValue("Name", text);
        KDMenuItem item = new KDMenuItem((Action)action);
        item.setName(name);
        return item;
    }

    private KDMenu createFileMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_FILE);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.12"));
        menu.setMnemonic('F');
        menu.add((JMenuItem)this.createBlankItem(ResourceHelper.getMenuResource("MenuManager.13"), ResourceHelper.getMenuResource("MenuManager.14")));
        menu.addSeparator(ResourceHelper.getMenuResource("MenuManager.15"));
        this.createMenuItem(new ActionWrapper(this.actionManager.getAction("Import")), ResourceHelper.getMenuResource("MenuManager.16"), "ImportFile", menu).setMnemonic('I');
        this.createMenuItem(new ActionWrapper(this.actionManager.getAction("Export")), ResourceHelper.getMenuResource("MenuManager.18"), "ExportFile", menu).setMnemonic('O');
        menu.addSeparator("ExportFileSeparator");
        menu.add((JMenuItem)this.createBlankItem(ResourceHelper.getMenuResource("MenuManager.21"), "saveFile"));
        JMenuItem saveItem = menu.add((JMenuItem)this.createBlankItem(ResourceHelper.getMenuResource("MenuManager.23"), "saveAs"));
        saveItem.setMnemonic('A');
        this.createMenuItem(this.actionManager.getSheetManagerAction(), ResourceHelper.getMenuResource("MenuManager.25"), "Sheet_Manager", menu).setMnemonic('M');
        menu.addSeparator("SaveAsSeparator");
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_PrintSetup_Wizzard")), ResourceHelper.getMenuResource("MenuManager.27"), "Show_PrintSetup_Wizzard", menu).setMnemonic('U');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_PrinPreview_Wizzard")), ResourceHelper.getMenuResource("MenuManager.28"), "Show_PrinPreview_Wizzard", menu).setMnemonic('V');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_Print_Wizzard")), ResourceHelper.getMenuResource("MenuManager.29"), "Show_Print_Wizzard", menu).setMnemonic('P');
        menu.addSeparator("PrintSeparator");
        this.createMenuItem(new ActionWrapper(this.actionManager.getAction("Exit")), ResourceHelper.getMenuResource("MenuManager.31"), "Exit", menu).setMnemonic('X');
        return menu;
    }

    private KDMenuItem createMenuItem(AbstractAction action, String text, String name, KDMenu menu) {
        KDMenuItem menuItem = new KDMenuItem((Action)action);
        menu.add((JMenuItem)menuItem);
        menuItem.setName(name);
        if (text != null) {
            menuItem.setText(text);
        }
        return menuItem;
    }

    private KDMenuItem createMenuItem(AbstractAction action, String text, String name, KDMenu menu, String keystrok, char mnemonic) {
        KDMenuItem menuItem = this.createMenuItem(action, text, name, menu);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keystrok));
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    private KDMenuItem createMenuItem(AbstractAction action, String text, String name, KDMenu menu, char mnemonic) {
        KDMenuItem menuItem = this.createMenuItem(action, text, name, menu);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    private KDCheckBoxMenuItem createCheckBoxMenuItem(AbstractAction action, String text, String name, KDMenu menu, char mnemonic) {
        KDCheckBoxMenuItem menuItem = new KDCheckBoxMenuItem((Action)action);
        action.putValue("Name", text);
        menu.add((JMenuItem)menuItem);
        menuItem.setName(name);
        menuItem.setMnemonic(mnemonic);
        menuItem.setText(text);
        return menuItem;
    }

    private KDMenu createEditMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_EDIT);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.33"));
        menu.setMnemonic('E');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Undo")), ResourceHelper.getMenuResource("MenuManager.34"), "Undo", menu, "control U", 'U');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Redo")), ResourceHelper.getMenuResource("MenuManager.36"), "Redo", menu, "control Y", 'R');
        menu.addSeparator("RedoSeparator");
        KDMenuItem createMenuItem2 = this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Cut")), ResourceHelper.getMenuResource("MenuManager.39"), "Cut", menu);
        createMenuItem2.setMnemonic('T');
        createMenuItem2.setAccelerator(KeyStroke.getKeyStroke("control x"));
        KDMenuItem createMenuItem = this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Copy")), ResourceHelper.getMenuResource("MenuManager.41"), "Copy", menu);
        createMenuItem.setMnemonic('C');
        createMenuItem.setAccelerator(KeyStroke.getKeyStroke("control C"));
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Paste")), ResourceHelper.getMenuResource("MenuManager.43"), "Paste", menu, "control V", 'P');
        menu.addSeparator("PasteSeparator");
        KDMenu clearMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.46"));
        clearMenu.setName("Clear");
        clearMenu.setMnemonic('A');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("CLEAR_CELL_ALL")), ResourceHelper.getMenuResource("MenuManager.48"), "CLEAR_CELL_ALL", clearMenu).setMnemonic('A');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("CLEAR_CELL_STYLE")), ResourceHelper.getMenuResource("MenuManager.49"), "CLEAR_CELL_STYLE", clearMenu).setMnemonic('F');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Clear_CellValue")), ResourceHelper.getMenuResource("MenuManager.50"), "Clear_CellValue", clearMenu, 'C');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Clear_Comment")), ResourceHelper.getMenuResource("MenuManager.51"), "Clear_Comment", clearMenu).setMnemonic('M');
        menu.add((JMenuItem)clearMenu);
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Delete_Cell")), ResourceHelper.getMenuResource("MenuManager.52"), "Delete_Cell", menu).setMnemonic('D');
        menu.addSeparator("DeleteCellSeparator");
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_Find_Wizzard")), ResourceHelper.getMenuResource("MenuManager.54"), "Show_Find_Wizzard", menu, "control F", 'F');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_Replace_Wizzard")), ResourceHelper.getMenuResource("MenuManager.56"), "Show_Replace_Wizzard", menu, "control H", 'E');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_Localize_Wizzard")), ResourceHelper.getMenuResource("MenuManager.58"), "Show_Localize_Wizzard", menu, "control G", 'G');
        return menu;
    }

    private KDMenu createViewMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_VIEW);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.61"));
        menu.setMnemonic('V');
        KDCheckBoxMenuItem formula = this.createCheckBoxMenuItem(new ActionWrapper(new FormualModeAction()), ResourceHelper.getMenuResource("MenuManager.62"), "ShowFormula", menu, 'F');
        KDCheckBoxMenuItem value = this.createCheckBoxMenuItem(new ActionWrapper(new NormalModeAction()), ResourceHelper.getMenuResource("MenuManager.64"), "ShowValue", menu, 'V');
        KDButtonGroup viewOption = new KDButtonGroup();
        viewOption.add((AbstractButton)formula);
        viewOption.add((AbstractButton)value);
        menu.addSeparator("ShowValueSeparator");
        this.createMenuItem(this.actionManager.getAction("Show_Scale_Wizzard"), ResourceHelper.getMenuResource("MenuManager.67"), "Show_Scale_Wizzard", menu);
        this.createMenuItem(this.actionManager.getReportSettingAction(), ResourceHelper.getMenuResource("MenuManager.150"), "REPORT_SETTING", menu).setMnemonic('S');
        return menu;
    }

    private KDMenu createInsertMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_INSERT);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.69"));
        menu.setMnemonic('I');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Insert_Cell"), ResourceHelper.getMenuResource("MenuManager.70"), "Insert_Cell", menu, 'E');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Insert_Row"), ResourceHelper.getMenuResource("MenuManager.71"), "Insert_Row", menu, 'R');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Insert_Col"), ResourceHelper.getMenuResource("MenuManager.72"), "Insert_Col", menu, 'C');
        KDMenu nameMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.73"));
        nameMenu.setName("name");
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Show_NameDefine_Wizzard"), ResourceHelper.getMenuResource("MenuManager.75"), "Show_NameDefine_Wizzard", nameMenu);
        menu.add((JMenuItem)nameMenu);
        return menu;
    }

    private KDMenu createStyleMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_STYLE);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.77"));
        menu.setMnemonic('O');
        KDMenuItem item = this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Show_Style_Wizzard"), ResourceHelper.getMenuResource("MenuManager.78"), "Show_Style_Wizzard", menu, "control 1", 'E');
        item.setText(ResourceHelper.getMenuResource("MenuManager.80"));
        KDMenu rowMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.81"));
        rowMenu.setName("Row");
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Resize_Row"), ResourceHelper.getMenuResource("MenuManager.83"), "Resize_Row", rowMenu, 'E');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Hide_Row"), ResourceHelper.getMenuResource("MenuManager.84"), "Hide_Row", rowMenu, 'H');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Hide_Row"), ResourceHelper.getMenuResource("MenuManager.85"), "Show_Row", rowMenu, 'U');
        menu.add((JMenuItem)rowMenu);
        KDMenu colMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.86"));
        colMenu.setName("column");
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Resize_Col"), ResourceHelper.getMenuResource("MenuManager.88"), "Resize_Col", colMenu, 'W');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Hide_Col"), ResourceHelper.getMenuResource("MenuManager.89"), "Hide_Col", colMenu, 'H');
        this.createMenuItem((AbstractAction)this._spreadContainer.getActionManager().getAction("Show_Col"), ResourceHelper.getMenuResource("MenuManager.90"), "Show_Col", colMenu, 'U');
        menu.add((JMenuItem)colMenu);
        return menu;
    }

    private KDMenu createToolMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_TOOL);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.92"));
        menu.setMnemonic('T');
        KDMenu protectMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.93"));
        protectMenu.setName("protect");
        protectMenu.setMnemonic('P');
        this.createMenuItem(this.actionManager.getAction("Sheet_Protection"), null, "Sheet_Protection", protectMenu, 'P');
        this.createMenuItem(this.actionManager.getAction("Book_Protection"), null, "Book_Protection", protectMenu, 'W');
        menu.add((JMenuItem)protectMenu);
        KDMenu checkMenu = new KDMenu(ResourceHelper.getMenuResource("MenuManager.98"));
        checkMenu.setName("check");
        checkMenu.setMnemonic('C');
        menu.add((JMenuItem)checkMenu);
        AbstractAction reportCheckWizardAction = this.actionManager.getReportCheckWizardAction();
        this.createMenuItem(reportCheckWizardAction, ResourceHelper.getMenuResource("MenuManager.100"), "Show_Check_Wizard", checkMenu, 'S');
        AbstractAction reportCheckAction = this.actionManager.getReportCheckAction();
        this.createMenuItem(reportCheckAction, ResourceHelper.getMenuResource("MenuManager.102"), "Check_Report", checkMenu, 'C');
        AbstractAction companyFillAction = this.actionManager.getCompanyFillAction();
        this.createMenuItem(companyFillAction, ResourceHelper.getMenuResource("MenuManager.104"), "CompanyFill", menu, 'F');
        return menu;
    }

    private KDMenu createDataMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName("data");
        menu.setText(ResourceHelper.getMenuResource("MenuManager.107"));
        menu.setMnemonic('D');
        return menu;
    }

    private KDMenu createCalcMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName("calculate");
        menu.setText(ResourceHelper.getMenuResource("MenuManager.110"));
        menu.setMnemonic('C');
        KDCheckBoxMenuItem item = this.createCheckBoxMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("SetAutoCalc")), ResourceHelper.getMenuResource("MenuManager.111"), "SetAutoCalc", menu, 'A');
        KDCheckBoxMenuItem item2 = this.createCheckBoxMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("SetManualCalc")), ResourceHelper.getMenuResource("MenuManager.112"), "SetManualCalc", menu, 'M');
        KDButtonGroup viewOption = new KDButtonGroup();
        viewOption.add((AbstractButton)item);
        viewOption.add((AbstractButton)item2);
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Calc_Book")), ResourceHelper.getMenuResource("MenuManager.113"), "Calc_Book", menu, "F9", 'W');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Calc_Sheet")), ResourceHelper.getMenuResource("MenuManager.114"), "Calc_Sheet", menu, "alt F9", 'S');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Calc_SelectedSheets")), ResourceHelper.getMenuResource("MenuManager.115"), "Calc_SelectedSheets", menu, "control F9", 'E');
        return menu;
    }

    private KDMenu createWindowMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_WINDOW);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.117"));
        menu.setMnemonic('W');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Freeze")), ResourceHelper.getMenuResource("MenuManager.118"), "Freeze", menu, 'F');
        this.createMenuItem(new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Unfreeze")), ResourceHelper.getMenuResource("MenuManager.119"), "Unfreeze", menu, 'U');
        return menu;
    }

    private KDMenu createHelperMenu(String name) {
        KDMenu menu = new KDMenu(name);
        menu.setName(MENU_HELP);
        menu.setText(ResourceHelper.getMenuResource("MenuManager.121"));
        menu.setMnemonic('H');
        ActionWrapper action = new ActionWrapper((Action)this._spreadContainer.getActionManager().getAction("Show_Help_Wizzard"));
        ActionAbout actionAbout = new ActionAbout();
        ResourceBundleHelper resHelper = new ResourceBundleHelper(AbstractCoreUI.class.getName());
        KDMenuItem menuItemAbout = new KDMenuItem((Action)actionAbout);
        menuItemAbout.setName("menuItemAbout");
        menuItemAbout.setText(resHelper.getString("menuItemAbout.text"));
        menu.add((JMenuItem)menuItemAbout);
        return menu;
    }

    private Component getInvokerComponent(ActionEvent e) {
        Container parent = ((Component)e.getSource()).getParent();
        if (parent instanceof JPopupMenu) {
            JPopupMenu pm = (JPopupMenu)parent;
            return pm.getInvoker();
        }
        JToolBar toolBar = (JToolBar)parent;
        return toolBar;
    }

    class NormalModeAction
    extends AbstractAction {
        NormalModeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            KDSpread spread = MenuManager.this._spreadContainer.getSpread();
            spread.getBook().getActiveSheet().getSheetOption().setCellDisplayMode(0);
        }
    }

    class FormualModeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        FormualModeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            KDSpread spread = MenuManager.this._spreadContainer.getSpread();
            spread.getBook().getActiveSheet().getSheetOption().setCellDisplayMode(1);
        }
    }

    class ActionWrapper
    extends AbstractAction {
        Action _innerAction;

        ActionWrapper(Action action) {
            this._innerAction = action;
        }

        public void actionPerformed(ActionEvent e) {
            if (this._innerAction == null) {
                MessageDialog.show(null, (Object)ResourceHelper.getMenuResource("MenuManager.122"));
            } else {
                this._innerAction.actionPerformed(e);
            }
        }
    }

    class ActionAbout
    extends AbstractAction {
        ActionAbout() {
        }

        public void actionPerformed(ActionEvent e) {
            Window win = ComponentUtil.getOwnerWindow((Component)MenuManager.this.getInvokerComponent(e));
            AboutDlg aboutDlg = null;
            aboutDlg = win instanceof Frame ? new AboutDlg((Frame)win) : new AboutDlg((Frame)null);
            aboutDlg.show();
        }
    }
}

