/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.NameEditUI;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.newrpt.client.designer.AbstractSheetManagerUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.ISheetManagerListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.NameEditUI;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.VariablesHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enum.Enum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SheetManagerUI
extends AbstractSheetManagerUI
implements ActionListener {
    private static final long serialVersionUID = 5986139307794401264L;
    private static final Logger logger = Logger.getLogger((Class)SheetManagerUI.class);
    private ReportVariables variables;
    private List sheets = new ArrayList(3);
    private int newSheetSuffix = 0;
    private KingdeeListModel sheetListModel = new KingdeeListModel();
    private ISheetManagerListener maintainListener;
    public static final int NONE = 0;
    public static final int INSERT_SHEET = 1;
    public static final int EDIT_SHEET = 2;
    public static final int DELETE_SHEET = 4;
    public static final int AJUST_SITE = 8;
    private static final String ADD_COMMAND = "add";
    private static final String REMOVE_COMMAND = "remove";
    private static final String RENAME_COMMAND = "rename";
    private static final String MOVEUP_COMMAND = "moveup";
    private static final String MOVEDOWN_COMMAND = "movedown";
    private static final String HIDE_COMMAND = "hide";
    private static final String LOCK_COMMAND = "lock";
    private static final String INSERTVAR_COMMAND = "insertvar";
    private static final String REMOVEVAR_COMMAND = "removevar";
    private static final String OK_COMMAND = "ok";
    private static final String CANCEL_COMMAND = "cancel";
    private static final String APPLY_COMMAND = "apply";

    public static SheetManagerUI createUI(Object owner, KDSpread spread) throws Exception {
        UIContext uiContext = new UIContext(owner);
        SheetManagerUI panel = (SheetManagerUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create(null, SheetManagerUI.class.getName(), (Map)uiContext);
        Book book = spread.getBook();
        int s = book.getSheetCount();
        BookProperties bookProperties = BookProperties.loadFromSpread(book);
        panel.setVariables(bookProperties.getVariables().copy());
        for (int i = 0; i < s; ++i) {
            String value;
            Sheet sheet = book.getSheet(i);
            SheetPropertyEntry e = new SheetPropertyEntry(sheet.getSheetName());
            VariableEntry entry = panel.variables.get("SheetClass", sheet.getSheetName());
            if (entry != null && (value = entry.getValue()) != null) {
                e.setSheetType((Enum)CSLReportGroupEnum.getEnum((int)Integer.parseInt(value)));
            }
            e.setHidden(sheet.getSheetOption().isHide());
            e.setLocked(sheet.getSheetOption().getProtection(true).isProtected());
            panel.sheets.add(e);
        }
        BookProtection pro = book.getProtection();
        if (pro.isProtected()) {
            panel.enableRUD(false);
        }
        panel.initUI();
        return panel;
    }

    private void setVariables(ReportVariables variables) {
        this.variables = variables;
    }

    private void initUI() {
        this.onLoad();
        this.cmbSheetType.addItems((Object[])CSLReportGroupEnum.getEnumList().toArray(new CSLReportGroupEnum[0]));
        this.initSheets();
        this.initEditButtons();
        this.lstSheets.setSelectedIndex(0);
        this.initVariables();
    }

    private void initVariables() {
        this.pnlContent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SheetManagerUI.this.pnlVariables == SheetManagerUI.this.pnlContent.getSelectedComponent()) {
                    SheetManagerUI.this.refreshViewType();
                    SheetPropertyEntry obj = SheetManagerUI.this.getSelectedSheet();
                    if (obj != null) {
                        SheetManagerUI.this.cmbViewType.setSelectedItem((Object)obj);
                    }
                }
            }
        });
        this.cmbViewType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SheetPropertyEntry ea = (SheetPropertyEntry)e.getItem();
                    SheetManagerUI.this.filterVariables(ea);
                }
            }
        });
        this.tblVariables.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
                IRow row = SheetManagerUI.this.tblVariables.getRow(e.getRowIndex());
                if (e.getColIndex() == 3) {
                    VariableEntry ve = (VariableEntry)row.getUserObject();
                    VariableEntry entry = SheetManagerUI.this.variables.get((String)e.getValue(), ve.getSheetName());
                    if (entry != null && entry != ve) {
                        MsgBox.showWarning((Component)SheetManagerUI.this.tblVariables, (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.0"));
                        e.setCancel(true);
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                IRow row = SheetManagerUI.this.tblVariables.getRow(e.getRowIndex());
                VariableEntry ve = (VariableEntry)row.getUserObject();
                if (e.getColIndex() == 2) {
                    ve.setDescription((String)e.getValue());
                } else if (e.getColIndex() == 3) {
                    ve.setName((String)e.getValue());
                } else if (e.getColIndex() == 4) {
                    ve.setValue((String)e.getValue());
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        SheetPropertyEntry ex = this.getSelectedSheet();
        this.filterVariables(ex);
    }

    private void filterVariables(SheetPropertyEntry ea) {
        ArrayList l = this.variables.getAllVariables();
        this.tblVariables.removeRows();
        int type = 0;
        if (ea == null) {
            type = 0;
        } else if (ea.isDummy) {
            if (ea.getSheetName().equalsIgnoreCase(ResourceHelper.getSheetManagerResource("SheetManagerUI.1"))) {
                type = 0;
            } else if (ea.getSheetName().equalsIgnoreCase(ResourceHelper.getSheetManagerResource("SheetManagerUI.2"))) {
                type = 1;
            }
        } else {
            type = 2;
        }
        for (int i = 0; i < l.size(); ++i) {
            VariableEntry e = (VariableEntry)l.get(i);
            if (!e.isVisible() || (type == 2 ? !ea.getSheetName().equalsIgnoreCase(e.getSheetName()) : type == 1 && e.getScope() != 1)) continue;
            IRow row = this.tblVariables.addRow();
            this.applyVariableEntryToRow(e, row);
        }
    }

    private void initSheets() {
        this.lstSheets.setModel((ListModel)this.sheetListModel);
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            this.sheetListModel.addElement((Object)e);
        }
        this.lstSheets.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SheetPropertyEntry ee = (SheetPropertyEntry)SheetManagerUI.this.lstSheets.getSelectedValue();
                if (ee == null) {
                    return;
                }
                SheetManagerUI.this.cmbSheetType.setSelectedItem((Object)ee.sheetType);
                SheetManagerUI.this.cbxHide.setSelected(ee.hidden);
            }
        });
        this.cmbSheetType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SheetManagerUI.this.getSelectedSheet().sheetType = (Enum)e.getItem();
                }
            }
        });
        this.lstSheets.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.lstSheets.setFocusTraversalKeysEnabled(false);
    }

    private SheetPropertyEntry getSelectedSheet() {
        int idx = this.lstSheets.getSelectedIndex();
        if (idx < 0) {
            return null;
        }
        if (idx >= this.sheetListModel.size()) {
            return null;
        }
        SheetPropertyEntry ee = (SheetPropertyEntry)this.sheetListModel.getElementAt(idx);
        return ee;
    }

    private void initEditButtons() {
        this.btnInsert.setActionCommand(ADD_COMMAND);
        this.btnEdit.setActionCommand(RENAME_COMMAND);
        this.btnDelete.setActionCommand(REMOVE_COMMAND);
        this.btnUp.setActionCommand(MOVEUP_COMMAND);
        this.btnDown.setActionCommand(MOVEDOWN_COMMAND);
        this.cbxHide.setActionCommand(HIDE_COMMAND);
        this.btnInsertVar.setActionCommand(INSERTVAR_COMMAND);
        this.btnRemoveVar.setActionCommand(REMOVEVAR_COMMAND);
        this.btnOK.setActionCommand(OK_COMMAND);
        this.btnCancel.setActionCommand(CANCEL_COMMAND);
        this.btnApply.setActionCommand(APPLY_COMMAND);
        this.btnInsert.addActionListener((ActionListener)this);
        this.btnEdit.addActionListener((ActionListener)this);
        this.btnDelete.addActionListener((ActionListener)this);
        this.btnUp.addActionListener((ActionListener)this);
        this.btnDown.addActionListener((ActionListener)this);
        this.cbxHide.addActionListener((ActionListener)this);
        this.btnInsertVar.addActionListener((ActionListener)this);
        this.btnRemoveVar.addActionListener((ActionListener)this);
        this.btnOK.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnApply.addActionListener((ActionListener)this);
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnInsertVar.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnRemoveVar.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    public void onLoad() {
        this.tblVariables.getSelectManager().setSelectMode(2);
        this.tblVariables.addColumns(5);
        IRow row = this.tblVariables.addHeadRow();
        row.getCell(0).setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.10"));
        row.getCell(1).setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.11"));
        row.getCell(2).setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.12"));
        row.getCell(3).setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.13"));
        row.getCell(4).setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.14"));
        this.tblVariables.getColumn(0).setWidth(50);
        this.tblVariables.getColumn(4).setWidth(80);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (ADD_COMMAND.equals(command)) {
            this.insertSheet();
        } else if (REMOVE_COMMAND.equals(command)) {
            this.removeSheet();
        } else if (RENAME_COMMAND.equals(command)) {
            this.renameSheet();
        } else if (HIDE_COMMAND.equals(command)) {
            SheetPropertyEntry selectedSheet = this.getSelectedSheet();
            if (!selectedSheet.isHidden() && this.isLastSheet()) {
                this.cbxHide.setSelected(false);
                MsgBox.showWarning((Component)((Object)this), (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.15"));
                return;
            }
            selectedSheet.setEdit();
            selectedSheet.hidden = this.cbxHide.isSelected();
        } else if (MOVEUP_COMMAND.equals(command)) {
            this.moveNode(-1);
        } else if (MOVEDOWN_COMMAND.equals(command)) {
            this.moveNode(1);
        } else if (INSERTVAR_COMMAND.equals(command)) {
            this.insertVar();
        } else if (REMOVEVAR_COMMAND.equals(command)) {
            this.removeVar();
        } else if (OK_COMMAND.equals(command)) {
            this.ok();
        } else if (CANCEL_COMMAND.equals(command)) {
            this.cancel();
        } else if (APPLY_COMMAND.equals(command)) {
            this.apply();
        }
    }

    private void apply() {
        if (this.maintainListener != null) {
            this.maintainListener.applySheets(this.sheets);
            this.maintainListener.applyVariables(this.variables);
        }
    }

    private void cancel() {
        this.disposeUIWindow();
    }

    private void ok() {
        this.apply();
        this.disposeUIWindow();
    }

    private void removeVar() {
        int idx = this.tblVariables.getSelectManager().getActiveRowIndex();
        if (idx < 0) {
            return;
        }
        VariableEntry e = (VariableEntry)this.tblVariables.getRow(idx).getUserObject();
        if (e.isReserved()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.16"));
            return;
        }
        if (!e.isEditable()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.17"));
            return;
        }
        this.variables.remove(e);
        this.tblVariables.removeRow(idx);
    }

    private void insertVar() {
        int idx = this.tblVariables.getSelectManager().getActiveRowIndex();
        VariableEntry oldValue = null;
        IRow row = null;
        if (idx < 0) {
            row = this.tblVariables.addRow();
        } else {
            oldValue = (VariableEntry)this.tblVariables.getRow(idx).getUserObject();
            row = this.tblVariables.addRow(++idx);
        }
        VariableEntry e = new VariableEntry();
        e.setReserved(false);
        e.setEditable(true);
        SheetPropertyEntry se = (SheetPropertyEntry)this.cmbViewType.getSelectedItem();
        if (se.isDummy) {
            e.setSheetName(null);
            e.setScope(1);
        } else {
            e.setSheetName(se.getSheetName());
            e.setScope(2);
        }
        this.applyVariableEntryToRow(e, row);
        if (oldValue != null) {
            int ix = this.variables.indexOf(oldValue);
            this.variables.add(ix, e);
        } else {
            this.variables.add(e);
        }
    }

    private void applyVariableEntryToRow(VariableEntry e, IRow row) {
        ICell cell = row.getCell(0, true);
        if (e.getScope() == 1) {
            cell.setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.18"));
        } else if (e.getScope() == 2) {
            cell.setValue((Object)ResourceHelper.getSheetManagerResource("SheetManagerUI.19"));
        }
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(1);
        cell.setValue((Object)e.getSheetName());
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(2);
        cell.setValue((Object)e.getDescription());
        cell = row.getCell(3);
        cell.setValue((Object)e.getName());
        if (e.isReserved()) {
            cell.getStyleAttributes().setLocked(true);
        }
        row.getCell(4).setValue((Object)e.getValue());
        row.setUserObject((Object)e);
        if (!e.isEditable()) {
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void enableRUD(boolean enable) {
        this.btnDown.setEnabled(enable);
        this.btnDelete.setEnabled(enable);
        this.btnEdit.setEnabled(enable);
        this.btnInsert.setEnabled(enable);
        this.btnUp.setEnabled(enable);
        this.cbxHide.setEnabled(enable);
    }

    private void renameSheet() {
        String sUIName = "com.kingdee.eas.rptclient.newrpt.client.designer.NameEditUI";
        UIContext uiContext = new UIContext((Object)this);
        String oldName = this.getSelectedSheet().getSheetName();
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("title", ResourceHelper.getSheetManagerResource("SheetManagerUI.22"));
        ht.put("label", ResourceHelper.getSheetManagerResource("SheetManagerUI.24"));
        ht.put("edit", oldName);
        ht.put("verify", Boolean.TRUE);
        uiContext.put((Object)"para", ht);
        try {
            NameEditUI sheetNameEditUI = (NameEditUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)this), sUIName, (Map)uiContext);
            sheetNameEditUI.setVerifyListener(new NameEditUI.VerifyListener(){

                public boolean verify(JComponent source, String name) {
                    int rs = this.varlidateName(name);
                    if (rs == 0) {
                        return true;
                    }
                    if (rs == 1) {
                        MsgBox.showWarning((Component)source, (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.28"));
                    } else if (rs == 2) {
                        MsgBox.showWarning((Component)source, (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.29"));
                    }
                    return false;
                }

                private int varlidateName(String name) {
                    if (name == null || name.length() < 1) {
                        return 1;
                    }
                    String regex = "(.*\\*.*)|(.*\\\\.*)|(.*\\?.*)|(.*\\/.*)|(.*\\[.*)|(.*\\].*)|(.*\\:.*)";
                    if (name.matches(regex)) {
                        return 1;
                    }
                    SheetPropertyEntry currentSheet = SheetManagerUI.this.getSelectedSheet();
                    for (int i = 0; i < SheetManagerUI.this.sheets.size(); ++i) {
                        SheetPropertyEntry ee = (SheetPropertyEntry)SheetManagerUI.this.sheets.get(i);
                        if (currentSheet == ee || (ee.operation & 4) == 4 || !ee.getSheetName().equalsIgnoreCase(name)) continue;
                        return 2;
                    }
                    return 0;
                }
            });
            sheetNameEditUI.showWindow();
            String action = (String)ht.get("action");
            if (action != null && action.equals(CANCEL_COMMAND)) {
                return;
            }
            SheetPropertyEntry selectedSheet = this.getSelectedSheet();
            this.variables.onRenameSheet(selectedSheet.getSheetName(), (String)ht.get("edit"));
            selectedSheet.setSheetName((String)ht.get("edit"));
            selectedSheet.setEdit();
            this.lstSheets.repaint();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
    }

    private void insertSheet() {
        SheetPropertyEntry e = this.getSelectedSheet();
        int location = -1;
        location = e != null ? this.lstSheets.getIndexOfElement((Object)e) : 0;
        SheetPropertyEntry e2 = new SheetPropertyEntry(this.getAppropriateSheetName(), 1);
        int idx2 = this.getSheetIndex(e);
        if (++location >= this.sheetListModel.size()) {
            this.sheetListModel.addElement((Object)e2);
            this.sheets.add(e2);
        } else {
            this.sheetListModel.add(location, (Object)e2);
            this.sheets.add(++idx2, e2);
        }
        VariablesHelper.initReportSheetReservedVariables(e2.getSheetName(), RptPeriodTypeEnum.MONTHLY, this.variables);
        this.lstSheets.setSelectedValue((Object)e2, true);
    }

    private void moveNode(int direction) {
        SheetPropertyEntry e = this.getSelectedSheet();
        int index = this.lstSheets.getIndexOfElement((Object)e);
        if (direction > 0 ? ++index >= this.sheetListModel.size() : --index < 0) {
            return;
        }
        this.sheetListModel.removeElement((Object)e);
        e.setAjust();
        this.sheetListModel.add(index, (Object)e);
        this.lstSheets.setSelectedValue((Object)e, true);
        int idx2 = this.getSheetIndex(e);
        if (direction > 0) {
            if (++idx2 >= this.sheets.size()) {
                return;
            }
            Object old = this.sheets.get(idx2);
            this.sheets.set(idx2, e);
            this.sheets.set(--idx2, old);
        } else {
            if (--idx2 < 0) {
                return;
            }
            Object old = this.sheets.get(idx2);
            this.sheets.set(idx2, e);
            this.sheets.set(++idx2, old);
        }
    }

    private SheetPropertyEntry removeSheet() {
        SheetPropertyEntry e = this.getSelectedSheet();
        if (this.isLastSheet() && (e == null || !e.hidden)) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceHelper.getSheetManagerResource("SheetManagerUI.35"));
            return null;
        }
        if (e == null) {
            return null;
        }
        e.setDelete();
        int i = this.lstSheets.getIndexOfElement((Object)e);
        this.sheetListModel.removeElement((Object)e);
        this.variables.onDeleteSheet(e.getSheetName());
        if (--i < 0) {
            i = 0;
        } else if (i >= this.sheetListModel.size()) {
            i = this.sheetListModel.size() - 1;
        }
        this.lstSheets.setSelectedIndex(i);
        return e;
    }

    private void refreshViewType() {
        this.cmbViewType.removeAllItems();
        SheetPropertyEntry sheetPropertyEntry = new SheetPropertyEntry(ResourceHelper.getSheetManagerResource("SheetManagerUI.36"));
        sheetPropertyEntry.isDummy = true;
        this.cmbViewType.addItem((Object)sheetPropertyEntry);
        SheetPropertyEntry sheetPropertyEntry2 = new SheetPropertyEntry(ResourceHelper.getSheetManagerResource("SheetManagerUI.37"));
        sheetPropertyEntry2.isDummy = true;
        this.cmbViewType.addItem((Object)sheetPropertyEntry2);
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4) continue;
            this.cmbViewType.addItem((Object)e);
        }
    }

    private boolean isLastSheet() {
        int count = 0;
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4 || e.hidden) continue;
            ++count;
        }
        return count < 2;
    }

    private int getSheetIndex(Object ee) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if (e != ee) continue;
            return i;
        }
        return -1;
    }

    private String getAppropriateSheetName() {
        String result = "Sheet" + ++this.newSheetSuffix;
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4 || !result.equalsIgnoreCase(e.getSheetName())) continue;
            result = "Sheet" + ++this.newSheetSuffix;
            i = -1;
        }
        return result;
    }

    public ISheetManagerListener getMaintainListener() {
        return this.maintainListener;
    }

    public void setMaintainListener(ISheetManagerListener maintainListener) {
        this.maintainListener = maintainListener;
    }

    public static class SheetPropertyEntry {
        private Enum sheetType;
        private boolean locked = false;
        private boolean hidden = false;
        private String sheetName = null;
        private String originalSheetName = null;
        private int operation = 0;
        private boolean isDummy = false;

        SheetPropertyEntry(String n) {
            this.sheetName = n;
            this.originalSheetName = n;
            this.sheetType = CSLReportGroupEnum.COMMON;
        }

        SheetPropertyEntry(String n, int op) {
            this(n);
            this.operation = op;
        }

        public String toString() {
            return this.sheetName;
        }

        public void setEdit() {
            this.operation |= 2;
        }

        public void setDelete() {
            this.operation |= 4;
        }

        public void setAjust() {
            this.operation |= 8;
        }

        public void setInsert() {
            this.operation |= 1;
        }

        public void setNone() {
            this.operation = 0;
        }

        public boolean edited() {
            return (this.operation & 2) == 2;
        }

        public boolean deleted() {
            return (this.operation & 4) == 4;
        }

        public boolean inserted() {
            return (this.operation & 1) == 1;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public boolean isDummy() {
            return this.isDummy;
        }

        public void setDummy(boolean isDummy) {
            this.isDummy = isDummy;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public int getOperation() {
            return this.operation;
        }

        public void setOperation(int operation) {
            this.operation = operation;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public Enum getSheetType() {
            return this.sheetType;
        }

        public void setSheetType(Enum sheetType) {
            this.sheetType = sheetType;
        }

        public String getOriginalSheetName() {
            return this.originalSheetName;
        }

        public void setOriginalSheetName(String originalSheetName) {
            this.originalSheetName = originalSheetName;
        }
    }
}

