/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.batch;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.rptclient.newrpt.designer.batch.BizFmlCalculater;
import com.kingdee.eas.rptclient.newrpt.designer.batch.FormulaRepository;
import java.util.Map;

public class ReportBatchCalculateProvider {
    private Context serverCtx;
    private FormulaRepository repository = null;
    private Map calculateContext;
    private Map calculators;

    public ReportBatchCalculateProvider(Context serverCtx, Map calculateContext) {
        this.serverCtx = serverCtx;
        this.calculateContext = calculateContext;
    }

    public ReportBatchCalculateProvider(Map calculateContext) {
        this(null, calculateContext);
    }

    public ReportBatchCalculateProvider(Context serverCtx) {
        this.serverCtx = serverCtx;
    }

    public void batchMethodQuery(String methodName, SortedParameterArray params) {
        try {
            Class clazz = this.getFmlCalcRepository().getFormulaCalculator(methodName);
            BizFmlCalculater calculater = (BizFmlCalculater)this.calculators.get(clazz);
            if (calculater == null) {
                calculater = this.getFormulaCalculator(clazz);
            }
            if (calculater != null) {
                calculater.batchMethodQuery(methodName, params);
            }
        }
        catch (Exception e) {
            FormulaRepository.getDefaultCalculator().batchMethodQuery(methodName, params);
        }
    }

    private BizFmlCalculater getFormulaCalculator(Class clazz) {
        if (clazz == null) {
            return FormulaRepository.getDefaultCalculator();
        }
        if (BizFmlCalculater.class.isAssignableFrom(clazz)) {
            try {
                BizFmlCalculater calc = (BizFmlCalculater)clazz.getConstructor(Map.class).newInstance(this.calculateContext);
                return calc;
            }
            catch (Throwable e) {
                return FormulaRepository.getDefaultCalculator(e.getMessage());
            }
        }
        return FormulaRepository.getDefaultCalculator("Provider " + clazz.getName() + " not extends from BizFmlCalculater");
    }

    public FormulaRepository getFmlCalcRepository() throws Exception {
        if (this.repository == null) {
            this.repository = new FormulaRepository();
        }
        return this.repository;
    }

    public boolean batchMethodQueryAll(Object[][] arg0) {
        return false;
    }
}

