/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.newrpt.client.designer.IControlledDialogListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.ISimpleDialog;
import com.kingdee.eas.rptclient.newrpt.designer.check.AbstractRptCheckUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.ICheckExpressionEdit;
import com.kingdee.eas.rptclient.newrpt.designer.check.IRptCheckListener;
import com.kingdee.eas.rptclient.newrpt.designer.check.RptCheckExpressionEditUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RptCheckUI
extends AbstractRptCheckUI {
    private ExpressionBank expBank;
    private RptCheckExpTank expTank = null;
    private RptCheckExpressionEditUI editor;
    private RptCheckExpression curExpression;
    private int foreland = 1;
    private IRptCheckListener rptCheckListener;
    private static final String defaultExpression = "A1=B1+C1";
    private DefaultKingdeeTreeNode lastPathComponent = null;
    private List allSheetsName;

    public static RptCheckUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            RptCheckUI ui = (RptCheckUI)fy.create(parent, RptCheckUI.class.getName(), ctx);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public RptCheckUI() throws Exception {
        this.initializeUI();
    }

    private void initializeUI() {
        this.expBank = new ExpressionBank();
        this.lstExpression.setModel((ListModel)this.expBank);
        this.lstExpression.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RptCheckExpression ep;
                String cnt = "";
                int index = RptCheckUI.this.lstExpression.getSelectedIndex();
                if (index != -1 && (ep = (RptCheckExpression)RptCheckUI.this.expBank.getElementAt(index)) != null) {
                    RptCheckUI.this.btnDelete.setEnabled(ep.isDeleteable());
                    cnt = ep.getContent();
                }
                RptCheckUI.this.txtContent.setText(cnt);
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptCheckUI.this.editExpression();
                }
            }
        };
        this.lstExpression.addMouseListener((MouseListener)ml);
        this.txtContent.addMouseListener((MouseListener)ml);
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.btnEdit.setText(null);
        this.btnEdit.setIcon(RptResourceHelper.getIcon("imgTbtn_edit"));
        this.txtContent.setEnabled(false);
        this.btnImport.setVisible(false);
        this.btnOutput.setVisible(false);
    }

    public void actionBtnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnAdd_actionPerformed(e);
        RptCheckExpression expr = new RptCheckExpression("\u65b0\u589e\u68c0\u67e5", defaultExpression);
        expr.setSheetName(this.getCurSheetName());
        this.editExpression(expr, true);
    }

    public RptCheckExpression[] createDefaultRptCheckExpression(int size) {
        RptCheckExpression[] eps = new RptCheckExpression[size];
        int i = 0;
        int base = this.getForeland();
        while (i < size) {
            eps[i] = new RptCheckExpression("\u65b0\u589e\u68c0\u67e5" + base, defaultExpression);
            eps[i].setSheetName(this.getCurSheetName());
            ++i;
            ++base;
        }
        return eps;
    }

    private String getCurSheetName() {
        DefaultKingdeeTreeNode nd;
        TreePath path = this.treSheets.getSelectionPath();
        if (path != null && (nd = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && nd.isLeaf()) {
            return nd.getText();
        }
        return null;
    }

    public int getForeland() {
        this.foreland = 0;
        for (int i = this.expBank.entrys.size() - 1; i >= 0; --i) {
            RptCheckExpression expr = (RptCheckExpression)this.expBank.entrys.get(i);
            int num = TableToolkit.parsePostfixNumber((String)expr.getName());
            if (this.foreland >= num) continue;
            this.foreland = num;
        }
        return ++this.foreland;
    }

    public void actionBtnEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnEdit_actionPerformed(e);
        this.editExpression();
    }

    public void actionBtnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDelete_actionPerformed(e);
        int index = this.lstExpression.getSelectedIndex();
        if (this.expBank.remove(index)) {
            if (index > 0) {
                --index;
            }
            if (index >= 0 && index < this.expBank.getSize()) {
                this.lstExpression.setSelectedIndex(index);
            }
        }
    }

    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    public void open(Object cookie, String title) {
        if (!this.loadExpressions((RptCheckExpTank)cookie)) {
            // empty if block
        }
        this.showWindow();
    }

    private boolean loadExpressions(RptCheckExpTank tank) {
        this.expTank = tank != null ? (RptCheckExpTank)tank.clone() : new RptCheckExpTank();
        if (this.allSheetsName == null) {
            String sheetList = this.getSheetList();
            if (sheetList == null) {
                return false;
            }
            this.loadSheetTree(sheetList.split(","));
        } else {
            this.loadSheetTree(this.allSheetsName.toArray(new String[0]));
        }
        this.treSheets.setSelectionPath(this.treSheets.getPathForRow(0));
        return true;
    }

    private void loadSheetTree(String[] shtList) {
        KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
        md.setRoot(null);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        this.treSheets.setRootVisible(false);
        DefaultKingdeeTreeNode entry = null;
        for (int i = 0; i < shtList.length; ++i) {
            entry = new DefaultKingdeeTreeNode();
            entry.setText(shtList[i]);
            root.add((MutableTreeNode)entry);
        }
        md.setRoot((TreeNode)root);
        this.treSheets.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultKingdeeTreeNode nd = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                RptCheckUI.this.loadSheetExpressions(nd.isLeaf() ? nd.getText() : null);
                RptCheckUI.this.lastPathComponent = nd;
            }
        });
    }

    void loadSheetExpressions(String sheetName) {
        this.expBank.clear();
        boolean isEditable = sheetName != null;
        this.btnAdd.setEnabled(isEditable);
        this.btnDelete.setEnabled(isEditable);
        this.btnEdit.setEnabled(isEditable);
        if (!isEditable) {
            return;
        }
        this.expTank.getSheetExpression(sheetName, (Collection)this.expBank.entrys);
        this.expBank.update();
        if (this.expBank.getSize() > 0) {
            this.lstExpression.setSelectedIndex(0);
        }
    }

    void editExpression() {
        int index = this.lstExpression.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.editExpression((RptCheckExpression)this.expBank.getElementAt(index), false);
    }

    void editExpression(RptCheckExpression expr, boolean isAddNew) {
        if (expr == null) {
            return;
        }
        if (this.editor == null) {
            try {
                this.getUIContext().put("Owner", this);
                this.editor = RptCheckExpressionEditUI.getUIInstance(this.getUIContext());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.editor.setCheckExpressionEdit(new CheckExpressionEdit(expr, isAddNew));
        if (!isAddNew) {
            this.curExpression = expr;
        }
        this.editor.setAddnew(isAddNew);
        this.editor.open();
    }

    public boolean checkExprName(String name) {
        boolean res = false;
        if (name == null || name.length() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"NeedSchemaName"));
        } else if (this.expBank.contains(name)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"SchemaNameExists"));
        } else {
            res = true;
        }
        return res;
    }

    void endWizard(boolean isOk) {
        this.disposeUIWindow();
        if (isOk) {
            this.rptCheckListener.restoreCheckExpTank(this.expTank);
        }
    }

    private String getSheetList() {
        String res = null;
        return res;
    }

    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        String path = this.getPathName(false);
        if (path != null) {
            File file = new File(path + ".txt");
            if (file.exists()) {
                int rt = 0;
                rt = SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("l2") ? MsgBox.showConfirm2((Component)((Object)this), (String)("\u68c0\u67e5\u65b9\u6848  " + path + ".txt" + " \u5728\u8be5\u76ee\u5f55\u4e0b\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f")) : MsgBox.showConfirm2((Component)((Object)this), (String)("\u6aa2\u67e5\u65b9\u6848  " + path + ".txt" + " \u5728\u8a72\u76ee\u9304\u4e0b\u5df2\u7d93\u5b58\u5728\uff0c\u662f\u5426\u8986\u84cb\uff1f"));
                if (2 == rt || rt == 1) {
                    return;
                }
                file.delete();
                file = new File(path + ".txt");
            }
            KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)md.getRoot();
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            int count = root.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode entry = (DefaultKingdeeTreeNode)root.getChildAt(i);
                String sheetName = entry.getText();
                writer.write("[" + sheetName + "]\r\n");
                ArrayList formulas = new ArrayList();
                this.expTank.getSheetExpression(sheetName, formulas);
                Iterator it = formulas.iterator();
                while (it.hasNext()) {
                    RptCheckExpression exp = (RptCheckExpression)it.next();
                    writer.write("    \u516c\u5f0f\u540d\u79f0=" + exp.getName() + "     \u516c\u5f0f\u5185\u5bb9=" + exp.getContent() + "\r\n");
                }
            }
            writer.close();
            if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("l2")) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5bfc\u51fa\u6210\u529f\uff01");
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5c0e\u51fa\u6210\u529f\uff01");
            }
        }
    }

    public void actioonImport_actionPerformed(ActionEvent e) throws Exception {
    }

    private HashMap getSheets(String path, ArrayList list) {
        Sheet sheet = null;
        HashMap<String, Sheet> map = new HashMap<String, Sheet>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            String line = in.readLine();
            while (line != null) {
                try {
                    line = line.trim();
                    if (line.startsWith("[") && line.endsWith("]")) {
                        String sheetName = line.substring(1, line.length() - 1).trim();
                        sheet = new Sheet();
                        sheet.sheetName = sheetName.trim();
                        if (list.contains(sheetName)) {
                            map.put(sheetName, sheet);
                        }
                    } else if (line.indexOf("\u516c\u5f0f\u540d\u79f0=") >= 0 && line.indexOf("\u516c\u5f0f\u5185\u5bb9=") >= 0) {
                        String name = line.substring(0, line.indexOf("\u516c\u5f0f\u5185\u5bb9="));
                        String content = line.substring(line.indexOf("\u516c\u5f0f\u5185\u5bb9="));
                        name = name.replaceAll("\u516c\u5f0f\u540d\u79f0=", "").trim();
                        content = content.replaceAll("\u516c\u5f0f\u5185\u5bb9=", "").trim();
                        if (sheet != null) {
                            sheet.checkItems.put(name, content);
                        }
                    }
                    line = in.readLine();
                }
                catch (Exception e) {}
            }
        }
        catch (FileNotFoundException e) {
            String msg = "";
            msg = SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("l2") ? "IO\u9519\u8bef " : "IO\u932f\u8aa4 ";
            MsgBox.showError((Component)((Object)this), (String)msg);
            return null;
        }
        catch (IOException e) {
            // empty catch block
        }
        return map;
    }

    private String getPathName(boolean isInMode) {
        String msg;
        String pathName = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PathFilter(isInMode));
        if (isInMode) {
            msg = "";
            msg = SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("l2") ? "\u5bfc\u5165 " : "\u5c0e\u5165 ";
            chooser.setDialogTitle(msg);
        } else {
            msg = "";
            msg = SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("l2") ? "\u5bfc\u51fa " : "\u5c0e\u51fa ";
            chooser.setDialogTitle(msg);
        }
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return pathName;
    }

    private void setSheetNames(List allSheetsName) {
        this.allSheetsName = allSheetsName;
    }

    public IRptCheckListener getRptCheckListener() {
        return this.rptCheckListener;
    }

    public void setRptCheckListener(IRptCheckListener rptCheckListener) {
        this.rptCheckListener = rptCheckListener;
        this.setSheetNames(rptCheckListener.loadSheetNames());
        this.expTank = rptCheckListener.loadRptCheckExpTank();
    }

    public void open() {
        this.loadExpressions(this.expTank);
        this.showWindow();
    }

    class CheckExpressionEdit
    implements ICheckExpressionEdit {
        private RptCheckExpression old = null;
        private final boolean isAddnew;

        CheckExpressionEdit(RptCheckExpression e, boolean isAddnew) {
            this.old = e;
            this.isAddnew = isAddnew;
        }

        public boolean checkIsExpNameDuplicate(String expName) {
            return RptCheckUI.this.checkExprName(expName);
        }

        public RptCheckExpression loadCheckExpression() {
            return (RptCheckExpression)this.old.clone();
        }

        public void restoreCheckExpression(RptCheckExpression exp) {
            if (this.isAddnew) {
                RptCheckUI.this.expTank.add(exp);
            } else {
                this.old.copyFrom(exp);
            }
            TreePath tp = RptCheckUI.this.treSheets.getSelectionPath();
            DefaultKingdeeTreeNode nd = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            RptCheckUI.this.loadSheetExpressions(nd.isLeaf() ? nd.getText() : null);
        }
    }

    private class Sheet {
        String sheetName;
        HashMap checkItems = new HashMap();

        private Sheet() {
        }
    }

    private class PathFilter
    extends FileFilter {
        private boolean modeIn;

        public PathFilter(boolean inMode) {
            this.modeIn = inMode;
        }

        public boolean accept(File arg0) {
            return arg0.getName().endsWith(".txt") || arg0.getName().endsWith(".txt");
        }

        public String getDescription() {
            return ".txt/.TXT";
        }
    }

    private class ExpressionBank
    extends AbstractListModel {
        public ArrayList entrys = new ArrayList(1);

        public boolean contains(String name) {
            if (name == null) {
                return false;
            }
            for (int i = this.entrys.size() - 1; i >= 0; --i) {
                RptCheckExpression expr = (RptCheckExpression)this.entrys.get(i);
                if (!name.equalsIgnoreCase(expr.getName())) continue;
                return true;
            }
            return false;
        }

        private void remove(String name) {
            if (name == null) {
                return;
            }
            for (int i = this.entrys.size() - 1; i >= 0; --i) {
                RptCheckExpression expr = (RptCheckExpression)this.entrys.get(i);
                if (!name.equalsIgnoreCase(expr.getName())) continue;
                this.remove(i);
                return;
            }
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.entrys.size());
        }

        public void update(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void clear() {
            this.fireIntervalRemoved(this, 0, this.entrys.size());
            this.entrys.clear();
        }

        public boolean add(RptCheckExpression exp) {
            if (exp == null) {
                return false;
            }
            RptCheckUI.this.expTank.add(exp);
            this.entrys.add(exp);
            int index = this.entrys.size() - 1;
            this.fireIntervalAdded(this, index, index);
            return true;
        }

        public boolean remove(int index) {
            if (index < 0 || index >= this.entrys.size()) {
                return false;
            }
            RptCheckUI.this.expTank.remove((RptCheckExpression)this.entrys.get(index));
            this.entrys.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return true;
        }

        public int getSize() {
            return this.entrys.size();
        }

        public Object getElementAt(int index) {
            return this.entrys.get(index);
        }
    }

    private class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        public Object getTrueController() {
            return RptCheckUI.this;
        }

        public void pilotSetout(ISimpleDialog source) {
        }

        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                if (((RptCheckExpressionEditUI)((Object)source)).isAddNew() && result != null) {
                    if (result instanceof RptCheckExpression) {
                        RptCheckUI.this.curExpression = (RptCheckExpression)result;
                        if (RptCheckUI.this.expBank.add(RptCheckUI.this.curExpression)) {
                            RptCheckUI.this.lstExpression.setSelectedIndex(RptCheckUI.this.expBank.getSize() - 1);
                        }
                    } else {
                        RptCheckExpression[] eps = (RptCheckExpression[])result;
                        for (int i = 0; i < eps.length; ++i) {
                            RptCheckUI.this.expBank.add(eps[i]);
                            RptCheckUI.this.curExpression = eps[i];
                        }
                        RptCheckUI.this.lstExpression.setSelectedIndex(RptCheckUI.this.expBank.getSize() - 1);
                    }
                } else {
                    RptCheckUI.this.curExpression.copyFrom((RptCheckExpression)result);
                    int index = ((RptCheckUI)RptCheckUI.this).expBank.entrys.indexOf(RptCheckUI.this.curExpression);
                    if (index != -1) {
                        RptCheckUI.this.expBank.update(index);
                        RptCheckUI.this.lstExpression.setSelectedIndex(index);
                        RptCheckUI.this.txtContent.setText(RptCheckUI.this.curExpression.getContent());
                    }
                }
            }
        }
    }
}

