/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.AbstractFormulaWizardUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardCompoundResult;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.ParamInductor;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptContextManager;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormula;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaComp;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaDataType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaParameter;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptResourceHelper;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.Validator;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.ValidatorResults;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FormulaWizardUI
extends AbstractFormulaWizardUI {
    private FormulaPickListener listeners;
    private String formulaLine;
    RptFormula formula;
    private ArrayList txtPrarms;
    private Point basePos = null;
    private RptContextManager context;
    private String formulaName2;
    private Map paramComponents = new HashMap(5);
    private Expression expression;
    private FunctionExpr editingExpress;
    private static final int LD_FAILED = 0;
    private static final int LD_OKEY = 1;
    private static final int LD_FINISH = 2;
    boolean isFirstTry = true;
    private static MouseListener paramHook = null;

    public static FormulaWizardUI creatFormulaWizard(Object parentUI) {
        try {
            return FormulaWizardUI.creatFormulaWizard(FormulaWizardUI.class.getName(), parentUI);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public static FormulaWizardUI creatFormulaWizard(String wizardUI, Object parentUI) throws Exception {
        String uiName = null;
        try {
            Class<?> clazz = Class.forName(wizardUI);
            uiName = FormulaWizardUI.class.isAssignableFrom(clazz) ? wizardUI : FormulaWizardUI.class.getName();
        }
        catch (Exception e) {
            uiName = FormulaWizardUI.class.getName();
        }
        IUIFactory createUIFactory = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
        FormulaWizardUI wiz = (FormulaWizardUI)createUIFactory.create((Component)parentUI, uiName, null);
        return wiz;
    }

    public void initUIContentLayout() {
        this.pnlTop.setBorder(BorderFactory.createEtchedBorder());
        super.initUIContentLayout();
    }

    public void open() {
        this.openFormula(this.listeners.pickFormulaLine());
    }

    public void open(String formulaName) {
        this.open(formulaName, null);
    }

    public void open(String formulaName, FunctionExpr hint) {
        this.formulaName2 = formulaName;
        int sta = 0;
        try {
            sta = this.loadFormula(formulaName, hint);
            ((KDDialog)this.getOwnerWindow()).setTitle(formulaName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "\u9519\u8bef", 0);
            e.printStackTrace();
            return;
        }
        this.onOpen();
        if (sta == 1) {
            this.showWizard();
        } else {
            this.endWizard(sta == 2);
        }
    }

    public void openFormula(String line) {
        FunctionExpr function = null;
        try {
            this.expression = ExcelFormulaPaserHelper.parse((String)line);
            this.editingExpress = function = ExcelFormulaPaserHelper.getOuterLastFunction((Expression)this.expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (function != null) {
            this.open(function.funcionName, function);
        }
    }

    protected void onOpen() {
    }

    private void showWizard() {
        this.showWindow();
    }

    public void setLocation(Point p) {
        this.basePos = p != null ? new Point(p) : null;
        super.setLocation(p);
    }

    public synchronized void setFormulaWizardListener(FormulaPickListener listener) {
        this.listeners = listener;
    }

    private void fireListenersReturnee(boolean isOk) {
        if (!isOk) {
            return;
        }
        this.listeners.setFormulaLine(this.formulaLine);
    }

    void endWizard(boolean isOk) {
        if (isOk) {
            FormulaWizardCompoundResult res = this.compound();
            if (!this.validateCompoundResult(res)) {
                return;
            }
            if (res.isOkey) {
                try {
                    if (!this.doValidate(res)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.formulaLine = res.formulaLine;
            if (this.editingExpress != null) {
                try {
                    FunctionExpr last = ExcelFormulaPaserHelper.getOuterLastFunction((String)this.formulaLine);
                    this.editingExpress.parameters = last.parameters;
                    this.formulaLine = this.expression.toString();
                }
                catch (Exception exception) {}
            }
        } else {
            this.formulaLine = null;
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(isOk);
    }

    private boolean doValidate(FormulaWizardCompoundResult res) throws Exception {
        Validator v = new Validator(this.formula, res);
        ValidatorResults results = new ValidatorResults();
        boolean valid = v.validate(results, this.context);
        if (!valid) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < results.getResults().size(); ++i) {
                String msg = (String)results.getResults().get(i);
                if (StringUtils.isEmpty((String)msg)) continue;
                sb.append(msg).append('\n');
            }
            if (!v.isStrict()) {
                return 0 == MsgBox.showConfirm2((Component)((Object)this), (String)sb.toString());
            }
            MsgBox.showWarning((Component)((Object)this), (String)sb.toString());
            return false;
        }
        return valid;
    }

    private int loadFormula(String name, FunctionExpr expr) throws Exception {
        boolean isOk;
        if (!this.getFormula(name)) {
            return 0;
        }
        Collection params = this.formula.getParameters();
        int num = params.size();
        boolean isDynamic = false;
        if (expr == null || !name.equalsIgnoreCase(expr.funcionName)) {
            expr = null;
        } else if (expr.parameters.size() > num) {
            if (((RptFormulaParameter)params.iterator().next()).repeatNum > 1) {
                isDynamic = true;
                num = expr.parameters.size();
            } else {
                expr = null;
            }
        }
        this.initContentPanel(num);
        boolean bl = isOk = isDynamic ? this.putParams((RptFormulaParameter)params.iterator().next(), expr) : this.putParams(params, expr);
        if (!isOk) {
            this.clearParams();
        } else {
            this.pnlTop.getViewport().getComponent(0).addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e != null) {
                        FormulaWizardUI.this.txtDescription.setText(FormulaWizardUI.this.formula.getDescription());
                    }
                }
            });
            this.txtDescription.setText(this.formula.getDescription());
            if (num < 1) {
                this.txtDescription.append("\n\u8be5\u51fd\u6570\u4e0d\u9700\u8981\u53c2\u6570\u3002");
            }
        }
        String ln = this.formula.getLocalName();
        ln = ln != null && !ln.equalsIgnoreCase(name) ? ln + " : " + name : name;
        return 1;
    }

    private boolean putParams(Collection params, FunctionExpr hint) {
        int id = 0;
        Iterator ls = params.iterator();
        while (ls.hasNext()) {
            RptFormulaParameter p = (RptFormulaParameter)ls.next();
            String iv = null;
            if (hint == null || hint.parameters == null || hint.parameters.size() <= id) {
                iv = "";
            } else {
                String string = iv = hint == null ? null : this.getExpressionString((Expression)hint.parameters.get(id++));
            }
            if (this.putParam(p, iv)) continue;
            return false;
        }
        return true;
    }

    private boolean putParams(RptFormulaParameter parameter, FunctionExpr hint) {
        for (int i = 0; i < hint.parameters.size(); ++i) {
            Expression ex = (Expression)hint.parameters.get(i);
            String l = this.getExpressionString(ex);
            if (this.putParam(parameter, l)) continue;
            return false;
        }
        return true;
    }

    private String getExpressionString(Expression ex) {
        String l = null;
        l = ex instanceof StringExpr ? ((StringExpr)ex).value : ex.toString();
        return l;
    }

    private Component initContentPanel(int paramNum) {
        this.txtPrarms = new ArrayList(paramNum);
        Dimension dm = this.pnlTop.getPreferredSize();
        dm.height = paramNum * 23 + 20;
        dm.width -= 20;
        JPanel pa = new JPanel();
        pa.setPreferredSize(dm);
        pa.setSize(dm);
        pa.setLayout(null);
        Dimension dm2 = new Dimension(dm);
        dm2.height += 5;
        dm2.width += 10;
        this.pnlTop.setPreferredSize(dm2);
        this.pnlTop.setSize(dm2);
        this.setSize(this.getWidth(), dm2.height + this.pnlBottom.getHeight() + 30);
        this.adjustBottomComp();
        this.validate();
        return this.pnlTop.getViewport().add(pa);
    }

    private void adjustBottomComp() {
        Rectangle bounds = this.pnlTop.getBounds();
        int y = bounds.y + bounds.height + 5;
        Rectangle bd = this.pnlBottom.getBounds();
        bd.y = y;
        this.pnlBottom.setBounds(bd);
    }

    private boolean getFormula(String name) throws Exception {
        RptFormulaComp comp = RptFormulaComp.getInstance();
        if (!comp.isLoaded()) {
            comp.load();
        }
        this.formula = comp.getFormula(name);
        return this.formula != null;
    }

    private boolean setDimension() {
        Dimension dm = new Dimension(this.pnlTop.getViewport().getComponent(0).getPreferredSize());
        int myHeight = this.pnlBottom.getPreferredSize().height + dm.height + 40;
        dm.height = this.getScreenDim().height > myHeight && this.getScreenDim().width > dm.width ? (dm.height += this.pnlBottom.getPreferredSize().height + 40) : this.getScreenDim().height - 80;
        dm.width = this.pnlBottom.getPreferredSize().width + 6;
        this.getOwnerWindow().setSize(dm.width, dm.height);
        this.adjustBottomComp();
        this.getOwnerWindow().validate();
        return true;
    }

    private void clearParams() {
        this.txtPrarms.clear();
    }

    private Dimension getScreenDim() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        return kit.getScreenSize();
    }

    private boolean validateCompoundResult(FormulaWizardCompoundResult target) {
        if (target == null) {
            return false;
        }
        if (target.isOkey) {
            return true;
        }
        String msg = RptResourceHelper.getString("rptformula-warn-compond") + target.infoLine + RptResourceHelper.getString("rptformula-warn-compond2");
        if (this.formula.isStrictRequired()) {
            MsgBox.showWarning((String)msg);
            return false;
        }
        int choose = JOptionPane.showConfirmDialog((Component)((Object)this), msg, "EAS<>K/3", 0, 3);
        return choose == 0;
    }

    private FormulaWizardCompoundResult compound() {
        FormulaWizardCompoundResult res = new FormulaWizardCompoundResult();
        if (this.formula == null) {
            return res;
        }
        StringBuffer line = new StringBuffer(128);
        StringBuffer info = new StringBuffer(128);
        line.append(this.formula.getName().toUpperCase());
        line.append("(");
        res.setFormulaName(this.formula.getName());
        boolean notInit = false;
        int size = this.txtPrarms == null ? 0 : this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            String val = this.getText(fld);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            res.put(p.getName(), this.getTrueText(fld));
            if (this.isNullValue(val)) {
                if (p.getRepeatNum() > 1) continue;
                if (p.isNeed()) {
                    res.isOkey = false;
                    info.append('\"');
                    info.append(p.getLocalName());
                    info.append("\", ");
                }
            }
            if (notInit) {
                if (!this.isNullValue(val) || !p.overleap) {
                    line.append(',');
                }
            } else {
                notInit = true;
            }
            line.append(val);
        }
        if (line.charAt(line.length() - 1) == ',') {
            line.deleteCharAt(line.length() - 1);
        }
        line.append(')');
        res.formulaLine = line.toString();
        if (!res.isOkey) {
            res.infoLine = info.toString();
        }
        return res;
    }

    private String getText(KDTextField fld) {
        String line = fld.getText();
        if (line == null || line.length() == 0 || !fld.isDirty()) {
            ParamInductor pi = ((Pilot)fld.getUserObject()).getInductor();
            if (pi != null) {
                line = pi.getText();
            }
            if (line == null) {
                return null;
            }
        }
        boolean needQuatation = true;
        StringBuffer tmp = new StringBuffer(line);
        if (((Pilot)fld.getUserObject()).isNeedQuotation() && needQuatation) {
            if (tmp.length() == 0) {
                tmp.append("\"\"");
            } else if (tmp.charAt(0) == '\"') {
                if (tmp.charAt(tmp.length() - 1) != '\"') {
                    tmp.append('\"');
                }
            } else {
                tmp.insert(0, '\"');
                tmp.append('\"');
            }
        }
        return tmp.toString();
    }

    private String getTrueText(KDTextField fld) {
        String line = fld.getText();
        if (line == null || line.length() == 0 || !fld.isDirty()) {
            ParamInductor pi = ((Pilot)fld.getUserObject()).getInductor();
            if (pi != null) {
                line = pi.getText();
            }
            if (line == null) {
                return null;
            }
        }
        return line;
    }

    private boolean isNullValue(String value) {
        return value == null || value.length() == 0 || "\"\"".equals(value);
    }

    boolean tryAppend(RptFormulaParameter p, Object source) {
        int size = this.txtPrarms.size();
        if (p == null || p.getRepeatNum() < 2 || size > 0 && !this.txtPrarms.get(size - 1).equals(source) || this.txtPrarms.size() >= p.getRepeatNum()) {
            if (this.isFirstTry) {
                this.setDimension();
                this.isFirstTry = false;
            }
            return false;
        }
        return this.appendParam(p, null);
    }

    private boolean appendParam(RptFormulaParameter p, String initValue) {
        JPanel pa = (JPanel)this.pnlTop.getViewport().getComponent(0);
        Dimension dm = pa.getPreferredSize();
        dm.height += 23;
        pa.setPreferredSize(dm);
        dm = this.pnlTop.getSize();
        dm.height += 23;
        this.pnlTop.setSize(dm);
        this.pnlTop.setPreferredSize(dm);
        return this.putParam(p, initValue) && this.setDimension();
    }

    private boolean putParam(RptFormulaParameter p, String initValue) {
        String n = p.getLocalName();
        if (p.getRepeatNum() > 1) {
            n = n + p.incRepeat();
        }
        if (initValue == null || initValue.length() < 1) {
            initValue = p.getDefaultValue();
            if (initValue != null && initValue.startsWith("%") && initValue.endsWith("%") && this.context == null) {
                initValue = "";
            }
        } else if (initValue.charAt(0) == ',') {
            initValue = initValue.substring(1);
        }
        if (p.type.equalsIgnoreCase("anytype")) {
            initValue = ParamInductor.formatAnytype(initValue);
        }
        JPanel panel = (JPanel)this.pnlTop.getViewport().getComponent(0);
        KDLabel lbl = new KDLabel();
        lbl.setText(n);
        lbl.setUnderline(true);
        lbl.setVerticalAlignment(3);
        lbl.setPreferredSize(new Dimension(120, 20));
        lbl.setBounds(new Rectangle(10, this.txtPrarms.size() * 23 + 10, 130, 20));
        panel.add((Component)lbl);
        KDTextField fld = new KDTextField();
        fld.setAutoscrolls(false);
        fld.setDocument((Document)new PlainDocument());
        fld.setPreferredSize(new Dimension(120, 20));
        fld.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
        fld.addFocusListener((FocusListener)new ParamListener());
        fld.setEnabledPopup(false);
        fld.setText(initValue);
        fld.setEnabled(p.enabled);
        if (p.isNeed()) {
            fld.setRequired(true);
        }
        Pilot plt = new Pilot(p, (JComponent)fld);
        fld.setUserObject((Object)plt);
        plt.init(panel);
        fld.setDirty(false);
        fld.setName(p.getName());
        panel.add((Component)fld);
        this.txtPrarms.add(fld);
        fld.addMouseListener(this.getParamHook());
        return true;
    }

    private MouseListener getParamHook() {
        if (paramHook == null) {
            paramHook = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    FormulaWizardUI.this.updateParamDescription(((Pilot)((KDTextField)e.getSource()).getUserObject()).getParam());
                }
            };
        }
        return paramHook;
    }

    void updateParamDescription(RptFormulaParameter param) {
        if (param != null) {
            this.txtDescription.setText(param.getDescription());
            this.txtDescription.setCaretPosition(0);
        }
    }

    private void getFormattedField(String var, Set value) {
        if (StringUtils.isEmpty((String)var)) {
            return;
        }
        StringBuffer name = new StringBuffer(15);
        boolean inParam = false;
        for (int i = 0; i < var.length(); ++i) {
            char c = var.charAt(i);
            if (c == '$') {
                if (inParam) {
                    inParam = false;
                    value.add(name.toString());
                    name = new StringBuffer(15);
                    continue;
                }
                inParam = true;
                continue;
            }
            if (!inParam) continue;
            name.append(c);
        }
    }

    public String getParam(String paramName) {
        if (paramName == null) {
            return null;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            return fld.getText();
        }
        return null;
    }

    public void setParam(String paramName, String value) {
        if (paramName == null) {
            return;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            fld.setText(value);
            ParamInductor.setControllerValue(((Pilot)fld.getUserObject()).inductor.getController(), value);
            return;
        }
    }

    public Object getParamObject(String paramName) {
        if (paramName == null) {
            return null;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            ParamInductor d = ((Pilot)fld.getUserObject()).getInductor();
            JComponent com = d == null ? null : d.getController();
            return com instanceof KDPromptBox ? ((KDPromptBox)com).getData() : fld.getText();
        }
        return null;
    }

    public JComponent getParamComponent(String paramName) {
        if (paramName == null) {
            return null;
        }
        return ((ParamInductor)this.paramComponents.get(paramName)).getController();
    }

    public JComponent getBaseParamComponent(String paramName) {
        if (paramName == null) {
            return null;
        }
        return ((ParamInductor)this.paramComponents.get(paramName)).getBaseComponent();
    }

    public void setRptContext(RptContextManager rptContext) {
        this.context = rptContext;
    }

    public RptContextManager getRptContext() {
        return this.context;
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(e != null && e.getSource() == this.btnOk);
    }

    public JPanel getParameterPane() {
        return (JPanel)this.pnlTop.getViewport().getComponent(0);
    }

    public Component getParamComponent(int index) {
        return this.getParameterPane().getComponent(index * 2 + 1);
    }

    public RptFormula getFormula() {
        return this.formula;
    }

    public void cancelCommand(ActionEvent e) {
        this.endWizard(false);
    }

    public void okCommand(ActionEvent e) {
        this.endWizard(true);
    }

    private class ParamListener
    implements FocusListener {
        private ParamListener() {
        }

        public void focusGained(FocusEvent e) {
            KDTextField source = (KDTextField)e.getSource();
            Pilot pilot = (Pilot)source.getUserObject();
            FormulaWizardUI.this.tryAppend(pilot.getParam(), e.getSource());
            FormulaWizardUI.this.updateParamDescription(pilot.getParam());
            pilot.show();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class Pilot {
        private RptFormulaParameter param;
        private JComponent holder;
        private ParamInductor inductor;
        private boolean isInit;

        public ParamInductor getInductor() {
            return this.inductor;
        }

        public RptFormulaParameter getParam() {
            return this.param;
        }

        public boolean isNeedQuotation() {
            if (this.inductor == null) {
                return ParamInductor.isString(RptFormulaComp.getInstance().getDataType(this.param.getType()));
            }
            return this.inductor.isString();
        }

        public void setController() {
            this.inductor = null;
        }

        public void setParam(RptFormulaParameter p) {
            this.param = p;
        }

        public Pilot(RptFormulaParameter p, JComponent h) {
            this.param = p;
            this.holder = h;
            this.inductor = null;
            this.isInit = true;
        }

        public String getString() {
            return ((KDTextField)this.holder).getText().trim();
        }

        public void init(JPanel container) {
            if (this.isInit) {
                RptFormulaDataType t = RptFormulaComp.getInstance().getDataType(this.param.getType());
                this.holder.setName(this.param.getName());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this);
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    container.add(this.inductor.getController());
                    this.inductor.getController().setVisible(false);
                    if (this.param.isNeed) {
                        this.setRequired(this.inductor.getController());
                    }
                    FormulaWizardUI.this.paramComponents.put(this.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
        }

        private void setRequired(Object obj) {
            try {
                Method method = obj.getClass().getMethod("setRequired", Boolean.TYPE);
                if (method != null) {
                    method.invoke(obj, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void show() {
            JPanel pan = (JPanel)this.holder.getParent();
            if (this.isInit) {
                RptFormulaDataType t = RptFormulaComp.getInstance().getDataType(this.param.getType());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this);
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    pan.add(this.inductor.getController());
                    FormulaWizardUI.this.paramComponents.put(this.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
            if (this.inductor != null) {
                this.holder.setNextFocusableComponent(this.inductor.getTrueController());
                this.inductor.show();
                this.holder.setVisible(false);
                pan.validate();
            }
        }

        public void show(Pilot pilot) {
            JPanel pan = (JPanel)this.holder.getParent();
            if (this.isInit) {
                RptFormulaDataType t = RptFormulaComp.getInstance().getDataType(this.param.getType());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this);
            }
            JComponent controller = this.inductor.getController();
            if (this.isInit) {
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    pan.add(controller);
                    FormulaWizardUI.this.paramComponents.put(pilot.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
            if (this.inductor != null) {
                this.holder.setNextFocusableComponent(this.inductor.getTrueController());
                this.inductor.show();
                this.holder.setVisible(false);
                pan.validate();
            }
        }
    }
}

