/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateConstant;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DataUpdateUtil {
    private static final Logger logger = Logger.getLogger(DataUpdateUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dbCleanUp(Connection conn, Statement st, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            finally {
                conn = null;
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            finally {
                st = null;
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            finally {
                rs = null;
            }
        }
    }

    public static void dbCleanUp(Statement st) {
        DataUpdateUtil.dbCleanUp(null, st, null);
    }

    public static void dbCleanUp(Connection conn) {
        DataUpdateUtil.dbCleanUp(conn, null, null);
    }

    public static void dbCleanUp(ResultSet rs) {
        DataUpdateUtil.dbCleanUp(null, null, rs);
    }

    public static boolean isColumnExistInTable(String tableName, String columnName, Connection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw new SQLException("hasColumnInTable(String tableName, String columnName, Connection conn).... conn is null or isClosed");
        }
        StringBuffer sql = new StringBuffer("select top 1 * from ");
        sql.append(tableName);
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        ResultSetMetaData rsmd = ps.executeQuery().getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String name = rsmd.getCatalogName(i);
            if (!columnName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void isTableExist(String tableName, Connection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw new SQLException(" DataUpdateUtil.isTableExist(String tableName, Connection conn) .... conn is null or conn is closed ");
        }
        String sql = "SELECT * FROM " + tableName;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DataUpdateUtil.dbCleanUp(null, st, null);
        }
    }

    public static int fileBatchCopy(List srcFiles) {
        return DataUpdateUtil.fileBatchCopy(srcFiles, true);
    }

    public static int fileBatchCopy(List srcFiles, boolean isRptInDataCollect) {
        int count = 0;
        int size = srcFiles.size();
        StringBuffer fileName = new StringBuffer();
        while (count < size) {
            File srcFile = (File)srcFiles.get(count);
            fileName.append(UIConfig.getShareFileUrl());
            fileName.append(File.separator);
            if (!isRptInDataCollect) {
                String srcFileName = srcFile.getName();
                int lastPointIndex = srcFileName.lastIndexOf(".xml");
                String subFileName = srcFileName.substring(0, lastPointIndex);
                fileName.append(subFileName);
                fileName.append("_");
                fileName.append("ACTUALDATA");
                fileName.append(".xml");
            } else {
                fileName.append(srcFile.getName());
            }
            File newFile = new File(fileName.toString());
            count = DataUpdateUtil.copyFile(srcFile, newFile) ? ++count : count;
            fileName.setLength(0);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copyFile(File srcFile, File newFile) {
        block9: {
            boolean bl;
            if (!srcFile.exists()) {
                logger.error((Object)("srcFile is not exist -- " + srcFile.getAbsolutePath()));
                return false;
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(srcFile);
                out = new FileOutputStream(newFile);
                byte[] b = new byte[8192];
                int count = 0;
                while ((count = in.read(b)) > 0) {
                    out.write(b, 0, count);
                }
                out.close();
                in.close();
                bl = true;
                CslRptUtil.close((Object)out);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                break block9;
            }
            catch (IOException e2) {
                logger.error((Object)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CslRptUtil.close(out);
                CslRptUtil.close((Object)in);
            }
            CslRptUtil.close((Object)in);
            return bl;
        }
        return false;
    }

    public static void removeFiles(File file) {
        if (file.isDirectory()) {
            File[] f = file.listFiles();
            for (int i = 0; i < f.length; ++i) {
                DataUpdateUtil.removeFiles(f[i]);
                f[i].delete();
            }
        } else {
            file.delete();
        }
    }

    public static String checkOldFileExist(String oldDB, String oldShareFile) throws EASBizException, NullPointerException {
        if (StringUtils.isEmpty((String)oldDB)) {
            throw new NullPointerException(" oldDB is null ");
        }
        if (StringUtils.isEmpty((String)oldShareFile)) {
            throw new NullPointerException(" oldShareFile is null ");
        }
        File file = new File(oldShareFile);
        if (!file.exists() || !file.isDirectory()) {
            String message = CslRptClientResourceHelper.getString("0_DataUpdateUtil");
            if (oldShareFile.equals(DataUpdateConstant.OLD_SHAREFILE_FOR_60)) {
                message = CslRptClientResourceHelper.getString("176_dataupdate_msg_1");
            } else if (oldShareFile.equals(DataUpdateConstant.OLD_SHAREFILE_FOR_53)) {
                message = CslRptClientResourceHelper.getString("177_dataupdate_msg_2");
            }
            throw new EASBizException(new NumericExceptionSubItem("1", message));
        }
        file = new File(oldDB);
        if (!file.exists() || file.isDirectory()) {
            if (oldDB.equals(DataUpdateConstant.OLD_DB_FOR_53) && (file = new File(DataUpdateConstant.OLD_SHAREFILE_FOR_53 + "eas-rptClientDB.mdb")).exists() && !file.isDirectory()) {
                return file.getAbsolutePath();
            }
            String message = oldDB;
            if (oldDB.equals(DataUpdateConstant.OLD_DB_FOR_60)) {
                message = CslRptClientResourceHelper.getString("178_dataupdate_msg_3");
            } else if (oldDB.equals(DataUpdateConstant.OLD_DB_FOR_53)) {
                message = CslRptClientResourceHelper.getString("179_dataupdate_msg_4");
            }
            throw new EASBizException(new NumericExceptionSubItem("1", CslRptClientResourceHelper.getString("1_DataUpdateUtil").concat("\r\n").concat(message)));
        }
        return oldDB;
    }

    public static Connection getOldConnection(String oldDB, String oldShareFile) throws EASBizException, NullPointerException, SQLException {
        String oldDBSite = DataUpdateUtil.checkOldFileExist(oldDB, oldShareFile);
        String url = "jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ=" + oldDBSite;
        String name = "admin";
        DbUtil.loadDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        Connection connOld = DbUtil.openDB(url, name, "");
        if (connOld.isClosed()) {
            connOld = DbUtil.openDB(url, name, "");
        }
        return connOld;
    }
}

