/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate;

import com.kingdee.eas.rptclient.dataupdate.base.AbstractDataOper;
import com.kingdee.eas.rptclient.dataupdate.vo.K3VO;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class K3DataOperImpl
extends AbstractDataOper {
    private static final Logger logger = Logger.getLogger(K3DataOperImpl.class);

    @Override
    protected boolean getValueOfVoList() {
        boolean flag = false;
        int voSize = this.voList.size();
        for (int i = 0; i < voSize; ++i) {
            try {
                K3VO vo = (K3VO)this.voList.get(i);
                this.ps.setString(1, vo.getId());
                this.ps.setString(2, vo.getServer());
                this.ps.setString(3, vo.getLoginId());
                this.ps.setString(4, vo.getUserId());
                this.ps.setString(5, vo.getPassword());
                this.ps.setString(6, vo.getCompanyNumber());
                this.ps.setInt(7, vo.getState());
                this.ps.setInt(8, vo.getDcIndex());
                this.ps.setInt(9, vo.getDcId());
                this.ps.setString(10, vo.getK3Url());
                this.ps.addBatch();
            }
            catch (SQLException e) {
                logger.error((Object)e);
                continue;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected String getInsertNewSql() {
        String sql = "insert into t_eas_k3setting (FId, FK3Server, FK3Name, FUserName, FPassword, ".concat(" FCompanyNumber, FState, FDcIndex, FDcId, Fk3Url) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return sql;
    }

    @Override
    protected String getQueryOldSql() {
        String sql = "select FId, FK3Server, FK3Name, FUserName, FPassword, FCompanyNumber, FState".concat(", FDcIndex, FDcId, Fk3Url from t_eas_k3setting");
        return sql;
    }

    @Override
    protected void putValueInVoList() throws SQLException {
        K3VO vo = new K3VO();
        vo.setId(this.rs.getString("FId"));
        vo.setServer(this.rs.getString("FK3Server"));
        vo.setLoginId(this.rs.getString("FK3Name"));
        vo.setUserId(this.rs.getString("FUserName"));
        vo.setPassword(this.rs.getString("FPassword"));
        vo.setCompanyNumber(this.rs.getString("FCompanyNumber"));
        vo.setState(this.rs.getInt("FState"));
        vo.setDcIndex(this.rs.getInt("FDcIndex"));
        vo.setDcId(this.rs.getInt("FDcId"));
        vo.setK3Url(this.rs.getString("Fk3Url"));
        this.voList.add(vo);
    }
}

