/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate;

import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateConstant;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateUtil;
import com.kingdee.eas.rptclient.dataupdate.base.AbstractDataOper;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ReportDataOperImpl
extends AbstractDataOper {
    private static final Logger logger = Logger.getLogger(ReportDataOperImpl.class);
    private List fileList = new ArrayList();
    private int fileCopyCount = 0;

    @Override
    public void writeNewData() {
        if (this.voList.isEmpty() || this.fileList.isEmpty()) {
            return;
        }
        super.writeNewData();
        if (this.getOperDataCount() > 0) {
            this.fileCopyCount = DataUpdateUtil.fileBatchCopy(this.fileList, false);
        }
    }

    private File getReportFile(ReportVO vo) {
        return new File(DataUpdateConstant.OLD_SHAREFILE_FOR_60.concat(this.getFileName(vo)));
    }

    public int getFileCopyCount() {
        return this.fileCopyCount;
    }

    @Override
    protected boolean getValueOfVoList() {
        boolean flag = false;
        int voSize = this.voList.size();
        for (int i = 0; i < voSize; ++i) {
            ReportVO vo = (ReportVO)this.voList.get(i);
            try {
                this.ps.setString(1, vo.getId());
                this.ps.setString(2, vo.getName());
                this.ps.setString(3, vo.getDescription() == null ? "" : vo.getDescription());
                this.ps.setString(4, vo.getTemplateID());
                this.ps.setInt(5, vo.getPeriodType().getValue());
                this.ps.setInt(6, vo.getYear());
                this.ps.setInt(7, vo.getPeriod());
                this.ps.setString(8, vo.getCreatorID());
                this.ps.setTimestamp(9, vo.getCreateTime());
                this.ps.setString(10, vo.getUpdateUserID());
                this.ps.setTimestamp(11, vo.getUpdateTime());
                this.ps.setString(12, vo.getAuditorID() == null ? "" : vo.getAuditorID());
                this.ps.setInt(13, vo.getSourceType());
                this.ps.setInt(14, vo.getDynaRpttype());
                this.ps.setString(15, vo.getCurrencyId());
                this.ps.setTimestamp(16, vo.getAuditedTime() == null ? null : vo.getAuditedTime());
                this.ps.setInt(17, vo.getAuditedStatus());
                this.ps.setInt(18, vo.getCheckedStatus());
                this.ps.setString(19, vo.getTemplateNumber());
                this.ps.setString(20, vo.getVersionNumber());
                this.ps.setString(21, vo.getCompanyNum());
                this.ps.addBatch();
            }
            catch (SQLException e) {
                logger.error((Object)e);
                continue;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected String getInsertNewSql() {
        return "insert into t_eas_report (FId, FName, FDescription, FTemplateID, FPeriodType, FYear, FPeriod, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FAuditorID, FSourceType, FDynaRpttype, FCurrencyID, FAuditedTime, FAuditedStatus, FCheckedStatus, FTemplateNumber, FVersionNumber, FCompanyNum) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    protected String getQueryOldSql() {
        return "select r.FId, r.FName, r.FDescription, r.FTemplateID, r.FPeriodType, r.FYear, r.FPeriod, r.FCreatorID, r.FCreateTime, r.FLastUpdateUserID, r.FLastUpdateTime, r.FAuditorID, r.FSourceType, r.FDynaRpttype, r.FCurrencyID, r.FAuditedTime, r.FAuditedStatus, r.FCheckedStatus, r.FTemplateNumber, r.FVersionNumber, r.FCompanyNum, c.FNumber from t_eas_report r inner join t_eas_currency c on c.FId = r.FCurrencyID and r.FCompanyNum = c.FCompanyNumber";
    }

    @Override
    protected void putValueInVoList() throws SQLException {
        ReportVO vo = new ReportVO();
        vo.setCompanyNum(this.rs.getString("FCompanyNum"));
        vo.setTemplateNumber(this.rs.getString("FTemplateNumber"));
        vo.setCurrencyNumber(this.rs.getString("FNumber"));
        vo.setSourceType(this.rs.getInt("FSourceType"));
        vo.setYear(this.rs.getInt("FYear"));
        vo.setPeriod(this.rs.getInt("FPeriod"));
        vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)this.rs.getInt("FPeriodType")));
        File rptFile = this.getReportFile(vo);
        if (!rptFile.exists()) {
            return;
        }
        vo.setId(this.rs.getString("FId"));
        vo.setName(this.rs.getString("FName"));
        vo.setDescription(this.rs.getString("FDescription"));
        vo.setTemplateID(this.rs.getString("FTemplateID"));
        vo.setCreatorID(this.rs.getString("FCreatorID"));
        vo.setCreateTime(this.rs.getTimestamp("FCreateTime"));
        vo.setUpdateUserID(this.rs.getString("FLastUpdateUserID"));
        vo.setUpdateTime(this.rs.getTimestamp("FLastUpdateTime"));
        vo.setAuditorID(this.rs.getString("FAuditorID"));
        vo.setDynaRpttype(this.rs.getInt("FDynaRpttype"));
        vo.setCurrencyId(this.rs.getString("FCurrencyID"));
        vo.setAuditedTime(this.rs.getTimestamp("FAuditedTime"));
        vo.setAuditedStatus(this.rs.getInt("FAuditedStatus"));
        vo.setCheckedStatus(this.rs.getInt("FCheckedStatus"));
        vo.setVersionNumber(this.rs.getString("FVersionNumber"));
        this.voList.add(vo);
        this.fileList.add(rptFile);
    }

    private String getFileName(ReportVO vo) {
        StringBuffer buf = new StringBuffer();
        buf.append(vo.getCompanyNum()).append("-");
        buf.append(vo.getTemplateNumber().trim()).append("-");
        buf.append(vo.getCurrencyNumber().trim()).append("-");
        buf.append(vo.getSourceType()).append("-");
        buf.append(vo.getYear()).append("-");
        buf.append(vo.getPeriod()).append("-");
        buf.append(vo.getPeriodType().getValue());
        buf.append(".xml");
        return buf.toString();
    }
}

