/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.dataupdate.Company53DataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.Currency53DataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateConstant;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateUtil;
import com.kingdee.eas.rptclient.dataupdate.FtpDataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.K3Data53OperImpl;
import com.kingdee.eas.rptclient.dataupdate.MailDataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.ReportData53OperImpl;
import com.kingdee.eas.rptclient.dataupdate.TemplateData53OperImpl;
import com.kingdee.eas.rptclient.dataupdate.UCMappingDataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.UserDataOperImpl;
import com.kingdee.eas.rptclient.dataupdate.base.AbstractUpdater;
import com.kingdee.eas.rptclient.dataupdate.base.IDataOper;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceFacade;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.AisInfo;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.tools.k3.K3Helper;
import com.kingdee.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Updater53To60DC
extends AbstractUpdater {
    private static final Logger logger = Logger.getLogger(Updater53To60DC.class);

    public Updater53To60DC(String oldDb, String oldShareFile) throws EASBizException, NullPointerException, SQLException {
        super(oldDb, oldShareFile);
    }

    @Override
    protected IDataOper createDataOper(String operTableName) {
        if (operTableName.equalsIgnoreCase("t_eas_company")) {
            return new Company53DataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_currency")) {
            return new Currency53DataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_user")) {
            return new UserDataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_ftp")) {
            return new FtpDataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_mail")) {
            return new MailDataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_user_company")) {
            return new UCMappingDataOperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_k3setting")) {
            return new K3Data53OperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_template")) {
            return new TemplateData53OperImpl();
        }
        if (operTableName.equalsIgnoreCase("t_eas_report")) {
            return new ReportData53OperImpl();
        }
        return null;
    }

    @Override
    protected void afterUpdate() {
        this.updateK3(this.loadK3());
    }

    private void updateK3(List k3List) {
        if (k3List.isEmpty()) {
            return;
        }
        String sql = "update t_eas_k3setting set FDcIndex = ? , FDcId = ?, Fk3Url = ? where fid = ?";
        PreparedStatement ps = null;
        try {
            ps = this.connNew.prepareStatement(sql);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return;
        }
        boolean flag = false;
        int size = k3List.size();
        for (int i = 0; i < size; ++i) {
            K3Helper k3 = (K3Helper)k3List.get(i);
            try {
                ps.setInt(1, k3.getDcIndex());
                ps.setInt(2, k3.getDcId());
                ps.setString(3, k3.getK3Url());
                ps.setString(4, BOSUuid.read((String)k3.getId()).toString());
                ps.addBatch();
            }
            catch (Exception e) {
                logger.error((Object)e);
                continue;
            }
            flag = true;
        }
        if (!flag) {
            return;
        }
        try {
            ps.executeBatch();
            ps.clearBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    private List loadK3() {
        ArrayList<K3Helper> k3List = new ArrayList<K3Helper>();
        String sql = "select FId, FK3Server, FK3Name, FUserName, FPassword from t_eas_k3setting";
        Statement st = null;
        ResultSet rs = null;
        try {
            DataUpdateUtil.dbCleanUp(this.connNew);
            this.connNew = DbUtil.getConnection();
            st = this.connNew.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                try {
                    K3Helper k = new K3Helper();
                    k.setId(rs.getString("FId"));
                    k.setServer(rs.getString("FK3Server"));
                    k.setK3Account(rs.getString("FK3Name"));
                    k.setUsername(rs.getString("FUserName"));
                    k.setPassword(rs.getString("FPassword"));
                    this.k3Login(k);
                    k3List.add(k);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return k3List;
    }

    private void k3Login(K3Helper k3) throws Exception {
        if (StringUtils.isEmpty((String)k3.getServer())) {
            throw new Exception(k3.getResx("ServerIsNull"));
        }
        if (StringUtils.isEmpty((String)k3.getUsername())) {
            throw new Exception(" k3 userName is null ");
        }
        if (StringUtils.isEmpty((String)k3.getK3Account())) {
            throw new Exception(" k3 account is null ");
        }
        int dcIndex = -1;
        UIConfig.setK3Ip(k3.getServer());
        AisInfo[] aisList = K3WebServiceFacade.queryAisInfo();
        for (int i = 0; i < aisList.length; ++i) {
            if (!aisList[i].getAisName().equals(k3.getK3Account())) continue;
            dcIndex = i;
            break;
        }
        if (dcIndex == -1) {
            throw new Exception(" dcIndex == -1 ");
        }
        AisInfo aisInfo = aisList[dcIndex];
        String loginString = K3WebServiceFacade.login(k3.getUsername(), k3.getPassword(), aisInfo.getAisID());
        if (StringUtils.isEmpty((String)loginString)) {
            throw new Exception(k3.getResx("LoginString_isnull"));
        }
        k3.parseLoginString(loginString);
        k3.setK3Url(loginString);
        k3.setDcId(aisInfo.getAisID());
        k3.setDcIndex(dcIndex);
    }

    @Override
    protected void initTables() {
        this.tables = new String[]{"t_eas_company", "t_eas_currency", "t_eas_user", "t_eas_user_company", "t_eas_mail", "t_eas_ftp", "t_eas_k3setting", "t_eas_template", "t_eas_report"};
    }

    public static void main(String[] args) {
        try {
            Updater53To60DC update = new Updater53To60DC(DataUpdateConstant.OLD_DB_FOR_53, DataUpdateConstant.OLD_SHAREFILE_FOR_53);
            update.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

