/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate.base;

import com.kingdee.eas.rptclient.dataupdate.DataUpdateUtil;
import com.kingdee.eas.rptclient.dataupdate.base.IDataOper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractDataOper
implements IDataOper {
    private static final Logger logger = Logger.getLogger(AbstractDataOper.class);
    protected Connection connOld;
    protected Connection connNew;
    protected Statement st;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected List voList = new ArrayList();
    private int operDataCount;

    @Override
    public int getOperDataCount() {
        return this.operDataCount;
    }

    @Override
    public void initConnection(Connection connOld, Connection connNew) throws SQLException {
        this.connNew = connNew;
        this.connOld = connOld;
        if (connOld == null || connOld.isClosed()) {
            throw new SQLException("UserDataOperImpl.initConnection(Connection connOld, Connection connNew)... connOld is null or closed");
        }
        if (connNew == null || connNew.isClosed()) {
            throw new SQLException("UserDataOperImpl.initConnection(Connection connOld, Connection connNew)... connNew is null or closed");
        }
    }

    protected void destroy() {
        DataUpdateUtil.dbCleanUp(null, this.st, this.rs);
        DataUpdateUtil.dbCleanUp(null, this.ps, null);
    }

    @Override
    public void loadOldData() {
        try {
            this.ps = this.connOld.prepareStatement(this.getQueryOldSql());
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            logger.error((Object)(this.getClass().getName() + e));
            return;
        }
        try {
            while (this.rs.next()) {
                this.putValueInVoList();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            this.destroy();
        }
    }

    @Override
    public void writeNewData() {
        if (this.voList.isEmpty()) {
            return;
        }
        try {
            this.ps = this.connNew.prepareStatement(this.getInsertNewSql());
            this.batchExecute(this.getValueOfVoList());
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    protected void batchExecute(boolean flag) {
        try {
            if (flag) {
                this.operDataCount = this.ps.executeBatch().length;
                this.ps.clearBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            this.destroy();
        }
    }

    protected abstract String getQueryOldSql();

    protected abstract String getInsertNewSql();

    protected abstract void putValueInVoList() throws SQLException;

    protected abstract boolean getValueOfVoList() throws SQLException;
}

