/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate.base;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateUtil;
import com.kingdee.eas.rptclient.dataupdate.base.IDataOper;
import com.kingdee.eas.rptclient.dataupdate.base.IDataUpdater;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class AbstractUpdater
implements IDataUpdater {
    private static final Logger logger = Logger.getLogger(AbstractUpdater.class);
    protected Connection connOld;
    protected Connection connNew;
    protected String[] tables;
    protected static final String[] ALL_TABLE = new String[]{"t_eas_company", "t_eas_currency", "t_eas_ftp", "t_eas_k3setting", "t_eas_mail", "t_eas_report", "t_eas_template", "t_eas_user", "t_eas_user_company", "t_eas_timeschedule", "t_eas_timeschedulelog", "t_eas_timecurrency", "t_eas_timetemplate"};

    public AbstractUpdater(String oldDb, String oldShareFile) throws EASBizException, NullPointerException, SQLException {
        this.initConnection(oldDb, oldShareFile);
        this.initTables();
    }

    @Override
    public void update() throws Exception {
        try {
            this.beforeUpdate();
            this.verify();
            this.removeAllData();
            this.updateData();
            this.afterUpdate();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.destory();
        }
    }

    protected void removeAllData() throws SQLException {
        if (this.tables == null) {
            return;
        }
        Statement st = null;
        try {
            st = this.connNew.createStatement();
            String strDel = "delete from ";
            int length = ALL_TABLE.length;
            for (int i = 0; i < length; ++i) {
                st.addBatch(strDel.concat(ALL_TABLE[i]));
            }
            st.executeBatch();
            DataUpdateUtil.removeFiles(new File(UIConfig.getShareFileUrl()));
        }
        catch (SQLException e) {
            throw new SQLException("removing old data error \r\n".concat(e.getMessage()));
        }
        finally {
            DataUpdateUtil.dbCleanUp(st);
        }
    }

    protected void initConnection(String oldDb, String oldShareFile) throws EASBizException, SQLException, NullPointerException {
        this.connNew = DbUtil.getConnection();
        this.connOld = DataUpdateUtil.getOldConnection(oldDb, oldShareFile);
    }

    protected void destory() {
        DataUpdateUtil.dbCleanUp(this.connOld);
        DataUpdateUtil.dbCleanUp(this.connNew);
    }

    protected final void verify() throws Exception {
        if (this.tables == null || this.tables.length < 1) {
            throw new Exception(" update tables is null ");
        }
        if (this.connOld == null || this.connOld.isClosed()) {
            throw new SQLException("UserDataOperImpl.initConnection(Connection connOld, Connection connNew)... connOld is null or closed");
        }
        if (this.connNew == null || this.connNew.isClosed()) {
            throw new SQLException("UserDataOperImpl.initConnection(Connection connOld, Connection connNew)... connNew is null or closed");
        }
    }

    protected void beforeUpdate() {
    }

    protected void afterUpdate() {
    }

    public String[] getTables() {
        return this.tables;
    }

    protected abstract IDataOper createDataOper(String var1);

    protected abstract void initTables();

    protected void updateData() {
        for (int i = 0; i < this.tables.length; ++i) {
            IDataOper op = this.createDataOper(this.tables[i]);
            if (op == null) continue;
            try {
                op.initConnection(this.connOld, this.connNew);
            }
            catch (Exception e) {
                logger.error((Object)e);
                continue;
            }
            op.loadOldData();
            op.writeNewData();
        }
    }
}

